META
key;value
description;District PB in Warszawa, Bemowo
country;Poland
unit;Warszawa
district;Bemowo
subunit;Bemowo
instance;2024
num_projects;74
num_votes;5951
budget;4868502
vote_type;approval
rule;greedy
date_begin;15.06.2023
date_end;30.06.2023
max_length;15
edition;10
language;pl
currency;PLN
comment;#1: The metadata regarding the age of voters shows very low values (starting from zero), indicating that one doesn't need to be an adult to vote: If a voter is under 13, they can vote with the consent of a parent or guardian. Hence, for example, age 0 likely corresponds to cases where parents/guardians are voting on behalf of their children. #2: Due to a voting system glitch, twelve voters mistakenly cast ballots for projects in two different districts, violating regulations. To align with city-wide results, we tagged these voters with the prefix 999999 and separated their ballots into two distinct votes. The final election outcome was not affected.
PROJECTS
project_id;cost;votes;name;category;target;selected;latitude;longitude
530;436000;2395;Wyznaczenie brakujących przejazdów rowerowych;public transit and roads;children,seniors;1;52.25717818068079;20.91977119445801
454;200000;2381;Zakup książek do placówek Biblioteki Publicznej w Dzielnicy Bemowo m.st. Warszawy;culture;children,seniors;1;52.24004759984364;20.91061597340495
1133;572000;2307;Kwitnące przystanki;public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.232000331578945;20.910261761639287
647;45000;2025;Letnie kino na Bemowie;culture,welfare,public space;seniors;1;52.23400263712427;20.909214139170366
76;400000;1876;100 ławek dla Bemowa;public space,urban greenery;children,seniors;1;52.245703218377216;20.92185974077438
103;170000;1827;Bezpłatna wypożyczalnia kajaków na Forcie Bema wakacje 2024;public space,sport;children,seniors;1;52.25595609632981;20.94038486458885
252;383800;1799;Targi śniadaniowe na Bemowie;culture,public space;children,seniors;1;52.24546765;20.918137742156112
1419;79000;1773;Ogródki miejskie - ul. Dywizjonu 303 i Park Górczewska.;education,environmental protection,urban greenery;children,seniors;1;52.236756101495665;20.899190624419543
141;522600;1748;Usprawnienia rowerowe na ul. Radiowej;public transit and roads,public space;children,seniors;1;52.256783600000006;20.90375020990483
473;163356;1718;Pływalnia dla każdego – bezpłatne pływanie dla dzieci i młodzieży;sport;children;1;52.258484;20.925486916538745
1246;12100;1589;Dzikie zapylacze wraz z siedliskami na Bemowie;environmental protection,public space,urban greenery;children,seniors;1;52.23536955;20.910343520445885
1201;60000;1574;Zakup e-booków, e-audoiobooków, e-prasy oraz gier planszowych do bemowskiej biblioteki;education,culture;children,seniors;1;52.23759170555556;20.913554234918884
142;81000;1556;Łączniki do drogi dla rowerów na Kocjana;public transit and roads,public space;children,seniors;1;52.24979115;20.890834044286166
1171;82800;1527;Rodzicu - reaguj na zdrowie psychiczne dziecka;education,welfare;;1;52.24093773125;20.911848910313925
1158;400000;1498;Park kieszonkowy;environmental protection,public space,urban greenery;children,seniors;1;52.23998949864272;20.91236400578055
1570;531680;1338;Bezpłatne warsztaty na Bemowie dla dorosłych, młodzieży i dzieci – potańcówki, kino plenerowe, wymiany książek, koncerty, warsztaty edukacyjne, rozwojowe, artystyczne i inne;education,culture,environmental protection;children,seniors;1;52.24233522243051;20.90157508850098
663;108588;1194;Zdrowe ciało - zdrowy duch ! Joga, Zumba, Pilates, Zdrowy kręgosłup, treningi biegowe, Aerial Fit (hula hoop);welfare,sport;;1;52.24546765;20.918137742156112
288;12000;1149;Defibrylator AED na Górcach;education,welfare;children,seniors;1;52.240908950000005;20.918730098936173
156;230000;1145;„Sensoryczna przystań” dla dzieci – bezpłatne zajęcia;education,sport;children;1;52.2609333;20.902604067839903
311;142000;1086;Po prostu prosty chodnik wzdłuż Górczewskiej;public transit and roads,public space;children,seniors;1;52.23981079798684;20.91891293027153
35;145900;994;Bezpłatne zajęcia sportowe dla mieszkańców Warszawy;sport;children,seniors;1;52.25351812886608;20.9214050429208
293;970000;992;Aktywna Rodzina - bezpłatne, rodzinne wejścia na Pływalnię wraz z modernizacją szatni mokrych i recepcji;sport;children,seniors;0;52.258484;20.925486916538745
209;296010;988;Irzykowe strefy sportu i relaksu;education,culture,environmental protection,public space,sport,urban greenery;children,seniors;0;52.2305757;20.90351968974737
1017;225500;967;Aktywni przez całe życie – bezpłatne wejścia na siłownię OSiR Bemowo;sport;seniors;0;52.257718100000005;20.930533384312227
377;509730;947;Rewitalizacja Boernerowa - przywrócenie historycznego miejsca spotkań mieszkańców.;education,public transit and roads,culture,environmental protection,welfare,public space,sport,urban greenery;children,seniors;0;52.266161359037824;20.90312004089356
866;9550;891;Bezpłatne spacery z przewodnikiem po Bemowie oraz zakup książek o tematyce varsavianistycznej do bemowskiej biblioteki;education,culture;children,seniors;1;52.2387333;20.91854367318799
81;540000;881;Kolejne książkomaty na Bemowie;education,culture,public space;children,seniors;0;52.24009707368955;20.916946784932772
1258;22000;879;Utworzenie ogrodu deszczowego na terenie SP 364;environmental protection,public space,urban greenery;children,seniors;1;52.2511693;20.928778629836657
202;79400;867;Babskie Bemowo edycja II;education,culture,sport;seniors;0;52.23069779722673;20.91022324147669
1014;25000;858;Nowy chodnik przy ul. Oławskiej 1;public transit and roads;children,seniors;1;52.26090825929272;20.926680564880375
1198;10200;804;„Podaj dalej” - wymiana książek w placówkach bemowskiej biblioteki;education,culture;children,seniors;1;52.232752001568144;20.916037559509277
492;21120;802;Bezpłatne warsztaty bajkoterapii dla dzieci w bibliotece;education,culture;children;1;52.236985319999995;20.911073769976163
639;121000;796;Między Nami – wsparcie psychologiczne w formie rozmów indywidualnych, spotkań grupowych i treningów relaksacji;education,welfare;seniors;0;;
479;970000;776;Bezpłatna siłownia z sauną na Pływalni „Pingwin”;sport;children;0;52.258484;20.925486916538745
1166;69741;767;Mural w mojej okolicy;education,culture,public space;children,seniors;0;52.2355187;20.91026777996472
1211;29112;754;Bezpłatne pływanie dla dzieci do 8 roku życia;sport;children;0;52.258484;20.925486916538745
75;395000;735;Kolejne wiaty autobusowe na Forcie Bema;public transit and roads,public space;children,seniors;0;52.25484001054616;20.934147834777836
944;75500;719;Bezpłatna wypożyczalnia zabawek i pomocy Montessori oraz bezpłatne warsztaty;education,culture,welfare,public space;children,seniors;0;52.24320665362935;20.9044361114502
1107;134500;719;Czytasz? Czytam! czyli Stare Bemowo bliżej Biblioteki Publicznej;education,culture;children,seniors;0;52.2581940138611;20.89851639320841
1099;39500;713;Bezpieczny Mieszkaniec kurs samoobrony;sport;;0;52.2257245;20.9131466
468;31100;707;Bezpłatne warsztaty dla dzieci wyrażania emocji przez sztukę;education,culture;children;0;52.26180522504042;20.923697948455814
1439;100000;705;Zadaszona wiata przystankowa ul. Dywizjonu 303 , Fort Blizne 04;public space;children,seniors;0;52.24680954911947;20.89975386848562
504;47800;690;Biblioteka otwarta dla osób ze szczególnymi potrzebami – rodzinne warsztaty dla osób z niepełnosprawnością;education,culture;children;0;52.26384186391026;20.930714607238773
292;81396;685;Fitness 40+50+60+;welfare,sport;seniors;0;52.257718100000005;20.930533384312227
188;24000;682;„Dzieciom na start- bezpłatne zajęcia z elementami integracji sensorycznej;education,sport;children;0;52.23311735;20.89978707297408
1138;26000;670;Inspirujące spotkania w bemowskiej bibliotece;education,culture;seniors;0;52.26390260241394;20.930843353271488
290;71060;659;Aqua Aerobic dla mieszkańców Bemowa;education,sport;seniors;0;52.258484;20.925486916538745
1541;30000;618;Zajęcia filmowe dla mieszkańców Bemowa i Warszawy w wieku od 16 lat (od pomysłu do realizacji);education,culture;seniors;0;52.22631440303382;20.915265083312992
775;25000;617;Bezpłatne warsztaty programowania i tworzenia stron internetowych dla młodzieży oraz seniorów;education,culture;seniors;0;52.23553126666667;20.91590950024863
157;151000;611;„Programuję na Bemowie” – edukacja XXI wieku dla dzieci;education;children;0;52.2609333;20.902604067839903
773;19500;603;Bezpłatne warsztaty druku 3D dla dzieci i młodzieży;education,culture;children;0;52.22656217613057;20.915136337280273
864;49000;581;Popieram naturę! - bezpłatne rodzinne eko-warsztaty w Bibliotece;education,culture;children,seniors;0;52.233129;20.91654472
1374;11500;524;Spacery socjalizacyjne z psami na Bemowie;education,environmental protection,welfare,public space;seniors;0;;
1104;65000;511;Przyjaźnie i wygodnie wokół szkoły 150;public space,sport,urban greenery;children,seniors;0;52.26174849888066;20.903709149861246
1157;10000;503;„Matura i co dalej? Warsztaty z doradztwa i rozwoju zawodowego dla uczniów szkół ponadpodstawowych”;education;;0;52.22690045;20.91854591571169
1260;11970;471;Upamiętnienie lotników na Bemowie;culture,public space;children,seniors;0;52.25602916753136;20.918273261562685
1004;26000;470;OSiR Bemowo dostępny dla każdego - pętle indukcyjne dla osób z niepełnosprawnością słuchu;sport;;0;52.257718100000005;20.930533384312227
152;121500;448;Diagnoza i trening słuchowy metodą typu tomatis w Szkole Podstawowej nr 341 Warszawa;education;children;0;52.25918935;20.9255189940694
1738;375000;446;Plenerowa Szkoła - żyjmy w zgodzie z naturą;education,environmental protection;children,seniors;0;52.22690045;20.91854591571169
289;221500;432;Fitness - Aktywni w grupie . Bezpłatne wejścia na treningi;education,welfare,sport;seniors;0;52.25810105000001;20.928010150425486
1023;52700;390;Na sportowo z Zumba Fitness;sport;seniors;0;52.257718100000005;20.930533384312227
1081;13950;390;Warsztat Fotograficzny dla początkujących 18+;education,culture;;0;52.22729655;20.90057037459208
1228;304400;371;Bezpłatne potańcówki dla seniorów w OSIR Bemowo;culture,sport;seniors;0;52.257718100000005;20.930533384312227
83;15000;370;Mała architektura - ul. Osmańczyka i ul. Obrońców Tobruku;public transit and roads,culture,public space;children,seniors;0;52.25899129708398;20.932796001434326
1207;201500;366;Aktywny wypoczynek z piłką plażowa w OSIR Bemowo z zagospodarowaniem terenu przy boiskach plażowych;sport;children,seniors;0;52.257718100000005;20.930533384312227
1300;40000;350;Tablice edukacyjne przy placu zabaw na terenie Fortu Bema;education,public space;children,seniors;0;52.25747108184606;20.934126377105716
183;304930;349;Upamiętnienie architektki osiedla Boernerowo -Wandy Boerner w 90 rocznicę powstania osiedla;education,public transit and roads,culture,environmental protection,public space,urban greenery;children,seniors;0;52.26526837598632;20.898227691650394
1740;35000;331;Dekoratornia-majsterkowanie seniorów w Bemowskiej Szopie;;seniors;0;52.2178347;20.915204740660457
843;15120;285;Zdrowie i witalność dla każdego - Slow Jogging bieganie z uśmiechem :);education,sport;seniors;0;52.24675274749401;20.91711502370079
1736;13200;283;Plenerowy klub aktywnego mieszkańca;sport;seniors;0;52.24328455;20.913766342768483
1734;25200;269;Zabawki mojego dzieciństwa-warsztaty z tworzenia tradycyjnych zabawek z drewna i innych materiałów naturalnych w Bemowskiej Szopie;;seniors;0;52.2178347;20.915204740660457
992;116966;255;Sąsiedzkie Bemowo – zajęcia, gry i zabawy na Górcach Starych;culture,welfare;children,seniors;0;52.24367197181494;20.90081538054004
294;39200;229;Zumba Gold - dla seniora 60+;welfare,sport;seniors;0;52.257718100000005;20.930533384312227
1737;27200;189;Modne Szycie- warsztaty projektowania i szycia odzieży codziennej dla seniorów;;seniors;0;52.2313575;20.91539931260504
VOTES
voter_id;vote;age;sex
7;639,1734,142,157,1171,1104,1107,156;48;F
9;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;32;M
34;1099,1740,1133,1158,156,473,292,1541,188,293,647,1014,377,454,866;41;M
35;152,156,1198,81,1104,504,1138,288,76,479,1201,647,1133,473,454;40;F
45;202,377,183;46;F
52;377;65;M
61;1439,75,81,83,252,76,103,1014;49;F
95;530,1099,639,202,290,1258,289,252,293,1419,1171,647,473,663,292;39;F
112;530,866,1166,103,1158,1570,1246,209,1138,202,76,1419,843,647;44;F
116;1258,81,83,1228,288,1211,1133,864,454,75,1300,252,103;42;F
136;1258,1736,157,209,202,76,188;36;F
139;188,1104,1258,209,202,76,156;45;M
155;1017,454,864,1260,156,377,473,142,530,188,1107,293,992,647,103;39;F
168;157,141,454,142,252,76,311,647,1570,1166,530,209;46;M
225;1138,252,76,311,1246,1201,141,1166,142,209;12;M
231;75;44;M
249;75,83,1300,1207,1570,35,152,1017,473;37;F
259;75,252,76,311,141,103,1014,1166,142,530;42;M
262;289,294,290,288,311,293,663,292,647;49;F
273;843;55;F
297;479,293,1419,1171,1201,141,647,1133,1158,1004,103,1014,454,142,530;39;M
309;289,294,290,288,311,293,647,663,292;51;M
347;289,294,290,288,311,293,647,663,292;14;M
356;76,1023,1099,1570,647,289,290,202,479,141,1133,103,35,663,530;38;F
361;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;41;F
419;454,1198,81,504,1138,468,775,944,1107,1201,773,492,864,866,1541;50;M
456;252,1246,1439,1419,141,647,1133,1158,103,530;37;M
458;1258,1374,1419,647,183,454,530,1246,141,1133;50;F
487;157,1104,252,1171,1107,156;42;F
499;1014,1211,1004,1260,473,81,504,288,944,188,1107,1201,152,454,866;47;M
509;142,141,530;47;M
543;1198,81,504,1138,468,775,944,1107,1201,773,647,864,454,866,1541;23;F
553;1107,479,293,1171,1201,1158,35,1014,288,311,141,1740,1133,473,530;40;M
561;1228,252,1374,76,1439,1419,1099,141,1133,1158,103,1260,377,142,530;48;F
576;289,290,1133,864,1541,1736,1198,1570,103,1017,866,252,35,663,1166;29;F
601;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;53;F
608;530,289,311,103,290,209,479,141,35,1014,1017,473;38;F
609;289,290,1023,1570,152,473,377,75,252,76,479,293,103,1014,1017;37;F
610;1104,1258,202,1201,647,1004,1014,530,252,311,1246,288,992,1133,103;35;F
619;866,1133,183,454,663,202,504,157,1104,1107,1171,156;45;F
628;1211,311,293,209,103,864,35,1017,473,1157,454,663;38;F
629;1171,992,1133,81,290,252,647,1570,103,35,1017,454,663,866,292;54;F
637;209,76,311,1419;34;F
639;142,454,1014,103,141,1246,81,252,479,1260,530;38;F
671;504,1228,81,1211,1738,492,647,1004,156,377,473,1157,663,1166,209;38;F
674;1246,647,103,377,1258,252,1374,1419,1133,1158,454;33;M
699;1158,103,530,1198,202,188,1171,647,152,156,1157,209;31;F
707;1201,1171,1014,1004,530,468,454,311,152,141,81,76,75;43;M
779;76,311,141,183,142,866,530,377;35;M
786;1736,157,775,1374,1211,188,1246,293,1419,1171,141,103,156,142,530;30;F
812;1104,156,142,1107,157,141;44;F
847;1023,1171,188,289,290,209,1211,202,293,1099,473,663,292,530;40;F
858;35,152,157,1258,289,294,288,1246,1419,773,103,473,454,1081,530;40;F
935;530,504,1419,1201,141,1107,454,647,81;41;M
964;1171,1023,1201,647,103,35,1541,209,76,1419,1133,473,1157,454,1166;39;F
1003;252,1737,1374,76,1246,311,1107,639,1419,1171,1570,647,1017,473,530;21;F
1026;647,81,504,1138,468,775,944,1107,1201,773,492,864,1541,454,866;56;F
1040;1138,252,1107,454,1201;29;F
1047;252,1198,81,504,1138,468,775,944,1107,1201,773,864,454,866,1541;28;F
1053;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;37;F
1075;252,1374,944,293,1439,141,1133,103,1260,377,183,473,142,530;33;F
1113;1439,81,75,252,76,311,1419,647,1133,1158,1014,454,1166,142,530;32;M
1133;1737,1138,1738,639,1439,1419,492,1133,454,142,252,288,1171,1201,647;38;F
1136;75,1228,252,288,1246,141,647,1570,1740,103,1014,1017,152,454,530;37;F
1138;864,530,1570,1738,1419,1158,81,1138,252,76,1246,1201,1133,103,454;34;F
1139;1736,157,290,209,1211,188,311,1171,773,647,1133,473,454,1166,1541;43;M
1149;1246,83,81,75,1300,252,479,293,1099,647,103,35,1014,1017,473;35;M
1176;142,75,209,1738,1246,1133,1158,377,454,530,1258,1207,1201,1014,152;44;F
1245;252,202,76,311,479,647,1133,1158,103,663,1166,1081;29;F
1280;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;36;F
1301;141,1133,530;34;M
1305;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;32;M
1322;209;38;M
1353;1104,775,1737,188,1738,311,1439,1023,35,1260,377,473,1166,142,292;40;M
1384;639,773,1099,1133,35,663,454,530,866,290,1171,1201,1734,864,473;40;F
1389;647,1014,1260,1157,866,292,75,83,1228,1300,252,1740,103,454,530;47;F
1416;1099,188,157,81,468,1737,944,202,639,1171,492,1158,454,663,530;37;F
1417;1201,843,775,294,473,83,252,75,290,1737,76,103,663,866,292;64;F
1422;209;34;F
1473;1258,75,1246,1439,1419,141,647,1133,1158,103,1014,454,142,866,530;39;F
1495;157,1104,1107,1171,156;55;F
1496;530,1014,81,1201,1104,1374,1211,76,1246,1419,141,1133,1158,377,473;26;F
1508;1014,1171,1107,1104,157,1439,141,663,142,530;40;F
1538;492,141,647,1158,1004,1014,377,142,75,157,252,311,1419,103,530;32;M
1545;1737,1736,1439,1419,1171,141,864,1014,1017,1258,288,1738,1099,1133,1158;38;M
1554;377;37;M
1589;252,288,202,1246,311,293,1171,141,1133,142,209,76,1419,473,454;42;F
1600;252,1207,202,479,293,141,103,156,1017,377,142;30;F
1608;289,454,156,1099,1246,202,504,157,290,252,288,1171,35,663,292;34;F
1631;1099,647,1740,1133,1004,103,864,152,473,1157,1166,142,292,1541,530;25;F
1633;1211,1004,103,1017,473,530,142,1133,141,1246,1738,1104,1258,75,156;36;F
1641;202,944,252,639,479,773,289,157,293,647,35,156,473,1104,1211;34;F
1658;75,1258,81,1300,76,639,293,1439,1419,1201,1133,1158,1260,454,530;31;F
1685;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;41;F
1698;289,288,1211,1171,1023,141,1570,35,152,156,1017,377,473,454,663;37;F
1712;294,1107,157,1171,773,866,1374,1158,1014,288,311,1439,141,142,530;44;M
1763;183,1260,1419,1439,639,188,76,1374,288,1107,1104,141,142,157,156;3;F
1764;775,252,1374,76,1419,773,647,1740,1133,103,156,663,142,1541,209;39;F
1779;1258,864,1201,992,1740,1133,1158,1004,152,1017,156,473,1157,454,866;41;M
1816;479,843,35,1541;49;F
1839;1201,647,864,468,1374,1246,639,1171,492,454,202,1211,843,473,663;58;F
1848;1258,311,479,1201,1158,1166,76,1246,1419,992,647,1133,103,454,530;44;M
1856;75,209,76,1419,141,647,1133,103,35,1260,377,663,1166,142,530;20;F
1861;157,479,1201,773,647,142,75,81,83,252,76,103,530,1014,141;50;M
1880;152,156,1158,647,76,468,504,1258,288,202,1246,639,1419,1133,530;36;F
1887;454,1246,209,1138,252,1211,1158,530,1419;37;F
1888;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;55;F
1909;775,1138,290,473,663,1081,142,1541,1246,479,293,1201,103,1017,454;18;F
1923;209,1211,639,293,1171,647,35,156,473;36;F
1928;209,773,1198,81,504,775,944,1107,1201,492,864,454,530,1541,866;38;M
1930;103,83,252;36;F
1950;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;66;F
1988;157,289,290,209,1207,1246,311,1439,1419,1201,1133,1004,1017,35,454;34;M
1992;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;68;M
2023;530,142,141,1207,293,35,209;40;M
2054;1198,81,504,468,1138,775,944,1107,1201,773,492,864,454,866,1541;65;F
2060;473,454,1166,1439,1133,75,209,76,311,1419,141,1158,1014,142,530;32;F
2070;1738;15;F
2072;1738;45;F
2102;530,1258,202,76,1246,1107,1201,141,1570,1014,1260,183,454,663,1166;64;F
2106;252,1207,293,1419,1171,1734,492,141,647,1570,1133,35,156,473,1081;35;F
2110;1107,479,1419,1201,992,1099,647,1158,103,1014,473,1157,454,1166,1541;14;M
2113;311,1099,647,473,663,142,530;36;F
2124;1198,81,504,1138,468,775,944,1107,1201,492,864,454,866,1541;44;M
2138;209,202,1201,492,1570,103,156,454,530;37;F
2177;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,530;5;F
2217;157,1104,188,1107,1171,141,1004,152,156,142;8;F
2246;35,294,290,288,202,1246,311,1099,454,292;66;F
2257;1541,81,311,76,141,647,1014,1133,103,473,454,142,530;43;F
2315;81,288,1133,377,141,103,454,530;44;M
2317;209,1258,75,252,1246,1439,1419,141,1133,1260,377,142;40;M
2330;252,1211,188,1246,293,1419,1201,1570,1133,103,35,156,473,454,142;41;M
2346;1171,1004,152,377,473,866,292,1198,288,492,843,156,1157,454,530;47;F
2363;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;71;F
2403;76,1419,1158,103,530,647,1166,209;36;F
2426;479,454,530,1541,81,252,1374,202,1107,1419,1201,647,103,663,1081;36;F
2459;663,468,1570,1133,157,1104,252,188,639,1419,1171,156,454,530,142;37;F
2480;81,1107,1133,1017,866,530,1201,454;32;M
2494;183,1198,1138,157,1104,468,188,1107,1171,1201,492,156,377,454,866;52;F
2495;142,530,252,141;41;M
2565;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;73;F
2574;83,289,639,843,103,1014,1017,473,1157,454,663,479,141,530;46;M
2579;76,252,209,479,293,1419,647,1570,103,35,1017,290,1133,473,1166;43;F
2589;290,288,1374,76,639,1099,647,1004,454,1081,866;35;F
2595;1133,35,663,292;48;F
2601;1419,1158,1258,1246,1133;44;F
2610;377,1133,1570,647,1201,1171,1419,1439,293,479,252,157,1104,1211,141;40;F
2631;1258,1157,1541,1171,1198,1138,468,1081,1419,1570,647,202,1201,454,76;26;F
2642;76,311,1419,647,1158,103,473,209;41;F
2648;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;70;M
2656;311,1439,1419,141,1158,1014,156,1166,142,530,252,76,1099,1740,1133;39;F
2688;252,1258,75,288,76,1246,311,1439,1419,1201,647,1133,1260,454,1166;34;M
2703;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;72;F
2709;290,1738,1419,1171,1201,773,1017,473,454,530,81,1246,293,1133,1158;40;F
2724;843;42;M
2752;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;67;M
2776;1158,1014,1246,1133,530,479,142,141,83;19;M
2788;311,1738,775,35,1260,663,864,252,479,1099,1014,473;14;F
2801;843;66;M
2802;1738,504,81,75,1198,1300,468,944,188,1201,492,864,152,156,454;36;F
2827;1300,157,81,504,1138,1246,1201,1133,864,1157,454,530;43;M
2856;81,1300,1107,1201,103,1166,142,530,75,1198,504,141,1014,377,454;42;F
2858;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;77;M
2859;1158,1260,377,454,663,1166,1198,252,1246,1201,183,866,1374,647,1133;43;F
2886;252,141,647,142,530;37;M
2891;293,843,1023,1099,647,1570,103,35,1017,473,663,289,290,292,209;40;F
2896;864,454,1228,1258,252,202,293,773,647,1133,103,1260,473,663,292;45;F
2902;202,639,1171,1099,1570,1158,288,1419,1201,141,647,1133,142,866,530;27;F
2910;157,294,209,76,647,1133,1158,103,473,454;49;M
2923;1419,152,156,663,530;38;F
2941;142,1198,75,1246,1014,530,454;39;M
2949;1198,81,1374,1107,1201,141,647,35,454,142,866,530;67;M
2954;292,35;28;F
2968;775,252;38;F
3029;1246,311,1014,75,1439,1260,1158,377,183,530,1419,252,1133,141,142;44;M
3042;1198,209,1738,1201,1260,454,142;43;F
3056;1736,81,1158,156,454,1166,1104,377,252,288,141,103,142,530,1107;39;M
3060;75,252,76,647,103,1081;48;M
3064;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;74;F
3067;866,141,1158,1258,289,468,1419,1201,454,1246,1133,1014,152,142,530;38;F
3125;1419,1014,83,530,75,252,76,1246,311,141,1133,1260,142,103,377;26;M
3166;1374,288,1246,76,647,1133,1260,156;37;M
3204;1736,1419,843,1734,377,1138,290,944,1246,1133,454,866;66;F
3210;1541,76,1246,1439,1419,1171,141;44;F
3239;1258,75,81,1300,288,1374,76,1246,1133,103,1260,1014,454,663,530;38;F
3245;504,944,1201,492,454,866;66;F
3283;252,1246,1439,1419,1201,141,647,1133,103,1260,156,473,142,530,1541;15;F
3308;1166,289,252,311,141,647,1570,1017,142,103,663,292,530,290,1099;51;F
3311;1198,252,202,293,1133,473,454,864,1158,1570,647,1201,76,1138,81;39;F
3313;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;28;M
3335;530,473,1014,103,1133,1570,1439,252,157,1104,1211,141,647,377,142;6;M
3341;468,944,992,773,1201,647,866,1541,1081,289,290,1171,492,1570,454;40;F
3382;1198,479,141,142,530,1133,1158,81,252,76,103;35;F
3448;1734,1740,103,292,157,775,1374,202,1171,773,1099,647,1570,35,473;40;F
3453;311,1439,1014,663,1133,1211,83,530,454,1201,103,479,1207,75,76;31;F
3457;1099,141,377,473,142,530;15;M
3466;81,468,775,944,773,864,866,1541,1198,504,1138,1107,1201,492,454;30;F
3470;1246,1439,773,473,1166,1107,156,1104,377,142,530;44;M
3475;293,647,1740,152,156,663,1541,479,1171,1014,1017,1157,1081;49;M
3491;1014,492,647,1004,152,157,202,1201,1017,473,293,1023,1570,35,663;33;F
3556;1260,866,1258,775,252,1211,76,773,473,157,209,188,1738,103,156;43;F
3577;141,1158,1017,377,473,454,663,1166,292,504,252,1419,1023,1133,35;46;F
3580;1738;16;M
3596;252,202,141,647,473,530;43;F
3597;1738;38;M
3612;1081,1104,1734,293,639,1198,1171,468,1107,492,1570,473,454,157,156;45;F
3614;81,202,1158,1138,1374,1246,103,454,292,252,647,1570,1133,377,866;41;F
3665;1198,81,504,1138,468,775,944,1107,1201,492,773,864,454,866,1541;31;F
3715;209,504,775,188,1246,1201,492,647,1158,1004,1166,1171,1157;22;M
3754;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;63;F
3777;1138,1246,293,1439,141,103,183,530,1107,944,1419,1201,377,454,142;39;F
3790;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;71;F
3814;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;63;M
3815;294,1023,663,35,292,530;53;F
3823;202,209;39;F
3843;1166,311,81,75,252,288,1207,530,454,1158,1133,647,141,1419,76;27;M
3878;1014,1258,288,311,1419,76,1133,1158,866,504,468,775,1201,492,454;38;F
3887;647,1258,775,252,157,209,1211,76,188,1738,773,103,1260,156,866;8;M
3908;1198,81,504,1138,468,775,944,1107,1201,492,864,454,866,1541;63;F
3921;864,866,1541,252,944,1198,504,1138,1107,1201,454;70;M
3938;288,1246,1107,1201,141,647,1004,142,311,1439,1419,843,1133,454;43;F
3941;81,202,1246,1419,1201,1570,1133,454,1166;61;F
3962;1258,1300,1104,76,311,1439,1419,1158,103,377,142,252,1246,1133,1166;39;F
3963;188,468,81,157,1258,775,288,944,1738,639,1201,1157,1736,1171,1570;30;F
3984;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;6;M
4004;1419,1246,1258,1133,473,530,1166;34;M
4036;773,1198,81,504,1138,468,775,944,1107,1201,492,864,454,866,1541;4;F
4041;1570,1104,1171,156,157;41;F
4042;252,157,1258,209,775,1211,76,188,1738,773,647,103,1260,156,866;3;F
4044;75,1104,76,1738,1439,141,1133,142,83,1258,311,1419,1158,1014,530;40;M
4057;1107,1104,156;33;F
4080;647,1570,1740,1004,103,1014,377,454,142,530,1258,1246,1419,1133,1158;55;F
4089;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;74;F
4099;504,83,289,454,473,156,209;35;M
4116;1171,1419,1439,188,202,288,1258,1158,252,76,1246,992,141,1133,530;37;F
4130;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;75;F
4140;202,944,252,1138,504,81,1198,1541,866,1570,1107,1201,454;71;M
4147;468,1258,157,209,775,252,1211,76,188,1738,773,103,1260,156,473;71;F
4152;252,1211,1246,1099,1133,1158,1419,473,454;34;F
4183;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;67;F
4188;1171,156,157,1104,141;42;F
4201;157;77;M
4218;75,1104,252,76,1246,311,1419,1133,1158,1014,377,183,1166;74;F
4254;209;32;M
4255;252,639,1419,142,530,1157,377,1133,1158,1740,647,141,1171,1246,76;56;M
4271;252,1246,479,1201,647,1133,103,35,1260,1017,473,1081,1166,530,1541;32;F
4281;1736,289,290,202,639,1419,1201,1099,647,103,1157,454,292,1081,663;43;F
4308;1541,76,83,1736,1258,775,252,141,103,473,663,142,292,530,1104;47;M
4335;75,83,1228,288,1207,76,479,141,1004,103,1014,152,473,142,530;40;F
4380;1738;17;M
4386;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;39;F
4389;1541,647;17;M
4390;504,1201,866,1198,454;53;F
4399;289,290,843,1171,1023,1099,647,1158,103,1017,473,663,1166,530,35;38;F
4419;468,1300,1138,504,290,81,157,1198,1211,1171,1201,35,864,473,454;36;F
4452;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;36;F
4459;530,252,288,76,1246,311,1439,1419,141,647,1570,1133,103,473,866;40;M
4460;81,288,944,76,1107,1201,773,647,103,1260,377,454,866,530;47;M
4496;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;82;F
4516;289,1736,157,75,1300,35,473,1157,663,866,775,76,1738,639,1171;44;F
4520;290,81,75,83,202,76,1419,647,1133,1158,1017,35;23;F
4521;142,530,76,202,293,1439,35,473,209;41;F
4527;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;27;F
4528;468,1570;54;F
4570;1104,1736,289,290,202,479,293,1023,1099,103,1017,377,663,473,35;44;F
4585;1201,1171,639,1107,188,944,1737,775,1138,1228,294,504,252,288,492;35;F
4619;209;47;F
4625;288,1198,81,504,1258,1228,1374,1246,1099,647,1133,1158,663,1081,1541;32;F
4634;1258,1300,142,1081,1133,647,1171,1419,1439,1246,288;38;M
4635;1737,468,289,290,1207,639,479,1171,1023,1201,35,1017,473,663,292;45;F
4649;289,1158,1133,479,293,639,1246,188,76,202,288,209;48;F
4652;647,864,1166,663,103,202,1207,290,289,1736,293,843,1023,1099,35;37;M
4666;35;24;F
4688;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;69;F
4758;864,377,454,1258,1228,504,311,141,142,530,1374,1246,1419,1158,1133;29;F
4773;775,81,1198,504,1138,468,944,1107,1201,773,492,864,454,866,1541;71;F
4778;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;69;F
4800;76,479,1734,773,647,1570,1740,103,35,152,1014,156,473,663,530;30;F
4812;1166,454,1201,288,1104,1258,157,1198,209;46;F
4815;209;45;M
4828;1258,775,252,1158,530,290,76,1419,1171,647,1133;71;F
4840;1107,775,1138,504,81,773;57;F
4855;1158,530,1439,293,1246,1171,1104,157,1107,479,141,1133,156,663,142;37;F
4860;1099,647,1570,1260,473,1166,142,83,252,773,141,1133,103,866,530;42;F
4895;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;75;F
4901;1198,81,504,1138,468,775,944,1107,1201,773,492,864,866,1541,454;70;F
4915;1171,1201,773,1570,864,454,252,290,1023,647,103,35,473,663,1081;39;F
4917;75,76,141,1014,142,530;38;M
4927;209;44;M
4931;202,209;62;F
4934;1014,142,1736,1258,311,1419,1570,103,76,1246,1171,141,1133,1158,530;22;M
4935;202,209;57;M
4962;773,492,209,252,288,1419,1171,1201,1099,647,1570,1133,473,454,1541;41;F
4963;103;41;M
4972;141,142,1104;40;F
4984;209;43;M
4995;377,1166,75,157,252,1211,76,1419,141,1133,103,1260,454,142,530;38;F
5012;289,1201,492,141,156,473,454,142,292;43;F
5044;252,454,1211,1207,188,639,479,293,1133,1004,152,1017,473,663,292;41;F
5045;992,1570,1740,1004,152,156,377,1166,1258,290,202,293,103,35,663;30;F
5065;81,1736,75,1198,1258,252,76,1246,311,1419,1133,1158,103,1014,530;35;F
5082;75,157,1198,1258,1211,76,1738,1171,492,647,1133,1017,473,663,292;41;F
5093;202,209;12;M
5101;1166,663,1014,1171,252,530,1099,1133,1158;43;F
5116;492,1419,944,76,1201,454;35;F
5136;290,1211,202,311,293,1570;36;F
5176;209,202;14;M
5184;293,1023,1201,1570,647,1740,103,864,35,1014,156,1017,377,663,454;67;M
5188;1017,1081,81,157,504,468,775,944,1107,639,1171,1201,454,866,1541;45;F
5192;252,157,1023,289,293,1211,492,647,1570,156,473,775,188,1740,866;30;F
5205;1419,141,1133,1158,1014,377,454,1166,142,530,209,504,288,76,311;44;F
5216;141,647,1158,1004,103,35,1260,156,1017,473,454,1081,1166,142,530;43;M
5218;1081,866,1541,202,773,647,1570;25;F
5221;209,202;17;M
5228;1738;16;M
5257;1738;17;M
5260;1738;16;M
5262;209,202;46;M
5268;1738;17;M
5274;1734,103,35,1736,1737,252,639,1419,1023,1099,647,1570,1740,1158,1017;30;F
5284;1419,252,775,1198,1171,454,866,1258,1133,1158,1014,1246,141,142,530;42;M
5331;252,1207,1738,1246,843,1201,647,1570,1158,1014,1017,530,202,1419,1133;48;F
5341;76,188,311,293,1419,1133,1158,1004,156,1017,1157,473,663,1081,1166;33;F
5354;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;74;M
5364;289,290,209,473,292,530;47;F
5372;290,1104,288,1246,479,1099,141,35,1017,377;47;F
5421;1258,81,209,1300,252,1738,1246,1419,1171,1201,647,103,663,454,866;46;F
5466;1138,209,81,202,1738,1419,1171,1201,1734,492,1570,1133,1158,864,454;36;F
5507;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;72;F
5531;1211,188,293,647,1158,1004,156,1157,473,663;30;F
5541;1104,1107,1541;40;M
5549;1158,775,252,1133,530,209,288,1207,76,479,1419,1201,103,35,1017;17;M
5563;288,1246,141,1133;59;M
5565;76,75,1736,252,1374,311,1439,843,141,647,1133,103,1014,142,530;39;F
5566;294,188,1171,1023,1740,1260,663,1166,292;45;F
5585;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;80;F
5617;1736,157,252,944,1738,1107,1419,1201,773,492,1570,864,152,454,530;40;F
5623;530;48;M
5645;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;7;F
5654;1198,81,1138,468,775,944,1107,1201,454,866,1541;66;F
5661;75,1258,209,252,288,311,1439,1419,1133,1158,1260,183,530,76,1246;45;M
5696;1198,81,504,468,775,944,1107,1201,773,492,864,454,866,1541;84;F
5704;76,1246,311,1419,1133,1014,377;31;F
5709;75,209,1104,252,76,311,1419,1439,141,1133,1158,1004,103,663,530;29;F
5714;1198,81,504,1138,468,775,944,1107,1201,773,492,864,1541,454,866;39;F
5720;188;61;F
5723;252,81,504,1374,1419,1201,1099,1107,1133,103,1198,1158,1004,454,866;42;F
5747;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;35;M
5765;775,639,1171,647,1099,663;31;M
5775;944,639,293,1099,1133,1166,1198,1138,1246,1171,1201,473,1157,454,866;17;F
5777;1004,454,157,289,468,479,293,1023,773,1570,35,1014,1017,473,663;34;M
5786;188;41;F
5810;1157,647,141,1201,1738,1374,252,157,1104,76,1246,1107,1171,1133,156;46;F
5812;1207,141,103,1017,142,530;40;M
5826;35,1133,647,141,1419,1439,311,1246,76,1207,1211,288,252,1104,209;17;M
5832;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;55;F
5848;468,289,290,83,1300,1138,202,188,1171,647,103,35,1017,473,663;36;F
5850;1198,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;76;F
5853;1158,454,142,75,1258,209,76,311,1439,1419,141,1014,1166,530,1541;42;F
5868;152;39;F
5880;293,1171,1734,103,156,473;28;F
5900;866,530,1258,81,504,1138,1439,492,141,142,1107,775,1201,864,454;35;F
5951;1198,81,504,1138,468,944,1107,1201,492,864,454,866,1541;15;F
5972;35,290,1133,141,1419,479,1246,75,76,311,1439;44;F
5987;1419,1246,1014,1260,142,377,1158,311,1374,1439,141,1133,288,76,530;52;M
5990;157,468,1738,1107,864,156;43;F
5994;188;11;F
6002;530,157,1104,1107,1171,141,156,377,183,142;52;M
6017;468,1166,1157,1419,157,81,504,1138,1107,1171,492,152,156,183,866;58;M
6020;1198,81,504,468,775,944,1107,1201,773,492,864,454,866,1541;76;F
6043;209,252,76,1738,1246,311,1419,773,1133,1158,103,864,473;43;F
6050;288,1198,81,1228,504,1138,639,1201,773,492,647,864,454,866,1541;65;F
6074;1198,81,1138,468,775,944,1107,1201,492,864,454,866,1541;75;M
6092;157,75,1211,188,1201,492,141,1158,156,454,530;29;M
6113;1419,1171,1201,1099,647,1740,1133,1158,1004,103,1017,377,142,866,76;28;F
6138;1104,1374,1211,76,188,1246,1439,1419,141;37;M
6140;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;31;F
6146;202,252,1211,944,293,1023,1099,1740,35,156,1017,377,473,866,663;30;F
6153;35,152,1017,473,663,142,292,530;41;F
6172;290,1171,1023,1099,1570,1133,35,1017,454,663;24;F
6189;1198,504,1104,1138,468,775,944,1107,1201,773,492,864,454,866,1541;32;M
6207;1198,81,504,1138,468,944,1107,1201,773,492,864,454,866,1541;50;F
6222;1736,504,311,141,454,142,775,252,288,76,639,1439,1419,1171,647;45;F
6239;1198,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;4;F
6253;142,157,1104,1374,188,1107,1171,141,156;46;M
6264;1133,864,1260,377,1198,1258,81,504,1138,252,202,1107,1201,454,866;36;F
6276;647,1570,1004,1158,103,35,152,454,468,252,1211,188,293,156,473;30;F
6278;289,202,639,1171,1099,1570,663,292;49;F
6284;1014,183,454,866,252,1246,311,1419,1201,141,1260,1158,377,142,530;47;F
6290;1198,81,504,468,775,944,1107,773,492,864,454,866,1541;74;M
6312;209;37;F
6318;663,530,142,1166,81,290,311,252,202,76,479,141,647,1133,1158;29;F
6324;1198,81,504,1138,468,775,944,1107,1201,492,864,454,866,1541;73;F
6344;773,492,1570,864,183,1081,1166,1198,157,289,468,639,377,1157,152;38;M
6355;1104,468,1737,202,1246,1171,1740,1004,35,156,1017,473,663,292,1541;47;F
6357;289,202,1419,103,663,142,252,1374;31;F
6425;157,647,103,377,142,530,1104,252,1107,141;40;F
6482;156;40;F
6508;1158,1014,183,141,288,1104,1300,1258,75,1419,1133,103,377,1166,530;33;M
6514;252,76,639,141,1570,1133,1158,103,35,1014,1017,377,663,142,530;29;F
6518;1738,311,479,1419,141,103,35,454,530,81,1211,293,1133,1158,473;38;F
6522;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;67;F
6528;152,288,290;50;F
6547;1158,103,864,156,252,1374,944,76,1246,1201,492,1133,1014,454,152;43;F
6549;157,81,468,775,1107,1201,1734,1004,156,454,1081,1541;5;M
6553;81,290,209,288,1211,293,1419,1099,454,866,252,1246,647,1158,473;36;F
6596;1171,647,1133,1014,142,252,1211,76,311,1439,1201,141,473,454,530;34;F
6598;1258,76,1738,311,1439,1419,1023,1201,1158,35,663,530,1133,454,292;48;F
6603;1171,293,289,157,1198,1104,468,1211,1099,492,35,1017,454,1023,647;45;F
6608;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;71;F
6620;504,1439,454;29;F
6628;1300,1211,1246,311,479,252,504,209,1207,103,35,1017,473,663,530;24;M
6658;866,1734,290,663,504,1138,202,1246,1099,141,1570,1133,454,142,530;46;F
6661;289,294,81,290,647,1570,1133,864,35,454,663,866,292,1541;65;F
6678;1133,492,1198,1258,944,1246,1419,1201,773,454;38;F
6762;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;63;F
6792;141,1133,1258,1300,76,1246,1419,1734,1158,103,1157,454,530;64;M
6805;468,188,1419,1171,773,647,1570,864,152,156,1157,454,1081;31;F
6825;843;43;F
6831;252,944,311,864,156,454,663,530;33;F
6859;1738,1246,1419,1133,252,647,1081;39;F
6883;1258,83,288,1246,1419,1133,1158,377;36;M
6885;1104,1228,83,775,76,1738,639,152,157,468,1171,141,1740,377,183;51;M
6886;1246,1201,141,647,1133,1158,377,454,142,292,866,530,1570,843;48;M
6950;663,1081;45;F
6956;1300,288,1211,1246,293,1439,1419,1133,141,156,1158,473,454,142,530;41;M
6979;157,81,1104,1107,1171,156,202,1133,377,473,142,530;37;F
6985;157,1211,311,141,1133,1158,1014,152,377,183,473,454,1166,142,530;43;F
7006;1260,377,866,141,647,288,76,1166,142,530,1374,311,103,454,1133;45;F
7014;1736,1737,252,202,76,639,1419,843,1158,103,35,473,1017;48;F
7036;1246,1107,639,1171,1023,1201,1734,1570,1740,1004,1014,1260,1017,454,663;37;F
7044;454,1260,311,1014,377,75,1258,76,1419,1158,1133,1246,141,142,530;50;M
7058;647,142,377,1004,76,1419,473,530,454,103,1133,1201,1246,288,1198;44;M
7096;76,311,141,1158,157,1014,75,202,1439,1201,1133,1260,183,454,530;53;M
7119;289,103,473,663,504,202,76,1201,492,454,35;42;F
7124;1211,530,103,1158,1133,141,1171,1419,639,1258,1246,1201,473,454,142;40;F
7125;1158,377,473;38;M
7158;1081;47;M
7172;209;14;F
7215;479,293,1171,492,647,1570,1133,35,152,1017,377,473,1541,188,156;36;F
7217;252,1138,1300,209,81,1258,103,1133,377,1260,530,647,1246,76,1374;45;M
7239;775,209,530,75,1258,1211,76,311,1439,1419,1171,773,141,1014,142;37;F
7258;75;51;F
7264;202,944,81,1198,504,1138,468,775,1107,647,1570,864,454,866,1541;31;F
7277;1198,81,1201,454,866;39;M
7279;290,294,289,1736,1104,775,1211,1207,1171,1157,311,293,1099,35,473;39;M
7333;1246,202,1737,81,992,1099,1133,103,377,663,866,252,1419,1201,647;35;F
7373;252,1246,311,1419,1133,1158,1166,76;35;M
7428;1198,157,775,202,311,639,293,1171,141,1570,103,473,663,142,530;47;F
7435;152;39;F
7439;209,252,288,76,311,1419,647,473,530;41;M
7457;289,157,1258,290,1300,252,288,1374,1211,202,188,1246,1133,156,473;39;F
7464;639,492,1004,152,157,468,156,209,76,252,1419,1133,1158,377,454;49;M
7477;1211,944,1207,188,639,293,1171,1734,492,647,1570,35,156,473,454;28;M
7546;1246,1133,83,202,76,141,103,1014,454,142,530;50;F
7572;647,1570,1133,35,1017,473,663,530,1201,454;14;F
7615;504,866,293,1439,1171,1201,492,1570,1004,103,35,156,473,663,292;43;F
7618;1104,1171,157,1107,156;42;F
7633;157,1104,1107,141,156,142;42;F
7665;454,663,866,1258,1738,1246,1419,1171,647,1133;29;F
7718;209,1201,1133,103,1166;46;F
7732;1738,1736,157,1258,1228,1300,1211,1419,1171,141,1570,1133,1158,473,1157;28;M
7737;1207,1439,1171,647,141,103,1166,142,377,530,76,1246,1419,1133,1158;31;F
7752;454,1081,1374,1207,252,1171,1201,142,530,377,76,1246,1419,1133,1158;39;M
7787;141,1570,1133,1158,1004,35,473,530,157,775,288,76,293,1017,142;34;F
7801;103,663,1081,530,311,1738,252,289,775,479,293,35,1017,473,142;36;M
7822;1201,647,1260,377,1157,454,1166,76,1246,311,141,1133,1158,142,530;48;F
7837;141,157,1104,188,1107,1171,152,156,142;48;F
7838;1107,157,1104,141,156,142;36;F
7839;454;68;F
7865;293,202,252,157,773,1570,1133,864,35,156,1017,473,454,663,292;36;F
7870;468,1138,1736,473,1157,188,76,209;41;F
7896;289,1138,252,1207,479,1419,647,1374,1023,103,35,1260,1017,1166,866;27;F
7901;1104,157,1107,1171,141,156,142;46;M
7905;81,288,1207,1201,1099,647,103,35,454,209,252,76,1246,1133,1158;41;F
7907;142,468,289,1258,157,473,663,1374,290,156,292,1104,639,293,35;40;F
7993;209,252,1211,311,1419,530;40;F
8030;473,1419,1439,293,479,1017;40;M
8034;479,293,1171,1201,773,492,1570,1133,103,35,156,473,454,663,292;44;F
8041;157,1738,76,293,843,1023,209,1171,663;38;F
8042;1211,183,377;83;F
8044;647,1201,1107,1198,81,1138,252,76,1246,1171,1133,103,454,530;18;F
8045;1104,1107,141,647,103,377,183;48;M
8048;289,202,647,479,1246,1138,290,1736,1439,1023,1099,1260,663,866,292;40;F
8049;252,1171,141,142,1258,76,311,1419,647,1133,1158,156,530;30;F
8071;311,1419,141,663,866,290,252,202,530;46;F
8084;288,1246,311,1171,1419,141,647,1158,103,1014,377,530,1133,1258,1300;33;F
8107;1166,1439,311,1104,83,209,1258,76,1246,1133,1158,377;42;M
8122;473,1541,1166,152,1570,1734,1201,76,944,252,468,81,1228,504,992;55;F
8123;209,288,1207,76,188,1738,492,864,35,473,454,530;8;M
8146;1258,1738,311,1133,103,1157,454,663,209,1541;35;F
8172;1211,639,141,142,252,530,103;37;F
8202;156,1419,1228,454,252,35,1017,289,290,1211,479,293,1023,1004,473;47;M
8231;202,76,311,1439,1419,647,1133,663,142,866;48;F
8238;454,1138,843,1570,663,142,292,76,1738,647,1133,1158,530,1419,209;46;F
8279;202,1246,1107,1201,492,141,81,504,252,1374,76,1171,103,454,142;48;F
8286;76,288,1211,1246,1171,1201,1133,1004,103,663,142,866,530,1260,156;38;M
8292;209;45;M
8304;843,1099,289,290,209,202,639,479,1171,1023,647,1570,35,1017,663;38;F
8316;1419,1004,1017,294,293,1099,292,289,1228,252,647,1570,103,35,663;31;F
8333;1138,141,292,530,1198,81,252,288,1246,1201,647,377,454,142,866;38;F
8367;1541,1081,1099,202,1374,252,209,75,76,1570,1740,1158,103;37;F
8369;1228,1246,1171,141,1570,103,35,1017,473,530;41;M
8386;1736,75,252,288,76,1246,311,479,647,103,1439,1419,141,142,530;40;M
8410;76,1738,1099,1133,1158,103,473,1081,1541;41;M
8411;288,293,1439,1133,377,252,1246,1419,141,1158,103,1014,1260,142,530;54;M
8463;1738,76,1138,81,157,468,647,1133,103,1260,183,473,1419,156,377;45;F
8471;647,103,1014,473,1157,294,1017,468,288,76,156,530,504,1228,639;46;F
8486;1439,311,142,479,83,1017,1166,530,252,76,141,1133,103,1014,152;14;M
8488;288,1374,479,103,1017,473;21;M
8489;377,1198,75,81,76,1419,1201,773,647,1133,1260,183,473,454,209;10;M
8493;289,479,1023,141,663,35;33;F
8506;1300,1374,76,1201,141,1133,1260,1171,103,1014,473,454,142,866,530;39;M
8517;1258,252,76,1246,311,1419,141,647,1133,1166,530;36;M
8546;288,377,530,142,1014,1260,1158,1133,141,1419,1439,1246,252,1300,75;52;F
8573;1104,252,76,479,293,141,1133,103,1017,530;45;F
8587;76,209;40;F
8591;75,83,1246,479,1439,141,1158,1133,1004,1014,377,530,1258,1207,454;39;M
8605;530,1570,866,647,202,252,141,1133,157,1104,1107,1171,152,156,292;47;F
8624;1171,1014,156,473,142,530,1211,479,293,141,1133,1158,377,1246,454;39;M
8635;209;12;M
8647;209,1300,252,1419,1171,142,944,1570,1133,1158,103,530;27;M
8677;1211;29;F
8686;1258,252,944,1419,647,1570,142,530;34;F
8694;157;39;F
8797;183,81,209,1374,76,1419,1201,1734,773,1133,864,473,454,663,1166;8;F
8800;1171,1201,647,1740,473,142,1246,479,1419,1158,103,1017,183,1157,454;18;F
8807;454,1157,152,1158,75,293,288,76,311,639,1439,1419,1004,1014,377;24;M
8823;1439,1260,152,377,142,1258,209,83,1300,1104,76,1246,1201,103,1014;46;F
8855;311,1738,188,81,1198,1736,1258,1138,252,202,76,1419,1158,1133,454;66;F
8857;157,1104,1107,1171,156;41;F
8858;1740,647,1099,773,1246,1138,157,1198,504,202,188,639,1171,454,1201;45;F
8878;1166,1211,293,1158,454,81,209,1228,1737,76,1419,1133,103,183,530;38;M
8900;157,1104,944,202,188,1171,1570,1740,103,35,156,473,663,1081,292;39;F
8928;209;41;M
8985;1258,1374,1246,843,1133,35,377,663,292;56;F
8990;202,311,843,1171,1023,992,1099,647,1570,35,156,473,1157,454,663;29;F
9064;1374,76,1246,639,479,293,1171,992,647,1158,103,864,35,1017;56;F
9073;1737,1258,252,188,1246,1439,1419,141,1133,1158,1004,103,152,156,377;39;F
9082;142,157,1104,1107,1171,156;8;M
9141;504,1138,1107,1201,773,492,1198,454;64;F
9183;142,157,1104,1107,1171,156;40;M
9211;290,468,252,288,188,1107,293,1419,1171,492,141,156,473,454,663;38;F
9219;157,1104,1107,1171,156,142;11;M
9236;1157,1198,290,1228,1300,288,188,1738,1246,1171,773,141,1570,1740,103;27;F
9240;1570,157,289,1104,1107,1171,141,156,473,454,142;42;F
9249;75,1258,252,288,1246,639,1171,647,1158,1133,103,1017,142,1166;27;F
9278;293,479,76,1104,252,1246,1439,1419,141,1133,1158,377,473,142,530;55;M
9290;103,1133,647,1246;44;M
9291;252,479,141,647,1570,1133,103,142,866,292,530;43;M
9307;473,530,1138,468,252,1211,944,188,76,293,492,156,1570,1133,103;31;F
9314;1570,1133,103,1201,843,1107,647,202,81,1736,944,454,992,35;32;F
9321;288,1133,289,290,1374,1246,639,479,1099,647,103,35,1017,663,1541;30;F
9348;141,1158,103,530;30;M
9354;377;25;F
9358;468,944,76,202,1734,188,293,1171,773,492,1570,1133,1004,156,473;28;F
9361;81,1207,76,311,639,647,1158,183,142,1419,141,1133,103,1081,530;29;M
9408;1104,377,183;52;M
9423;209;44;F
9437;1138,76,1246,1107,1201,141,647,103,864,1014,377,183,454,142,530;40;M
9451;292,663,454,647,492,1211,290,294,289,209,843;39;F
9456;76,530,209;45;F
9489;1017,492,1171,188,468,209,290,157,293,773,156,473,454,292,202;40;F
9499;1198,81,775,468,1138,504,944,1107,1201,773,492,864,454,866,1541;26;F
9533;83,209,1258,75,1211,311,293,141,647,1133,1014,156,473,142,530;33;F
9560;639,1439,75,289,294,1228,288,1023,773,103,35,152,1017,663,292;49;F
9585;504,157,1258,1157,454,1211,1246,293,1419,1133,1158,152,156,377,473;36;F
9595;1258,252,288,76,1246,1171,1133,1158,103,377,1157,530;27;M
9622;81,252,1738,311,1419,141,1133,156,530;32;F
9726;142,530,454,1201,1246,843,1099,141,647,1570,103,35,663,1207,252;31;F
9744;1419,1133,103,142;39;F
9751;1374,1158,35,663,292,1258,289,1246,1107,843,377;56;M
9755;1439,1419,473,530;44;M
9797;252,639,843,141,1081,530,289,479,293,1023,35,1017,663,142,292;47;F
9808;1300,468,188,492,156,944;32;F
9809;775,1737,1419,1570,1133,1004,1081,292,1258,289,504,288,1246,35,663;31;F
9811;35,377,454,1166,81,1736,1198,252,76,141,647,1133,103,142,530;31;M
9813;75,83,202,76,492,647,1570,103,35,1014,156,473,454,663,530;39;F
9831;75,83,311,141,647,103,1014,1017,142,530;44;M
9842;1570,156;36;M
9869;639,202,288,252,1138,290,1198,81,1246,293,1201,103,473,454,663;41;F
9879;1171,647,377,1166,252,288,76,1246,311,1201,141,1133,1158,142,530;31;M
9897;1081,663,454,647,1171,639,1107,76,1138,81,1104,252,141,156,142;48;F
9908;209,1171,492,1570,1004,103,152,1017,473,1157,454,1166,142,292,530;38;F
9952;288,1211,76,311,1419,1171,1201,492,1099,1570,1133,473,454,663,866;39;F
9958;1004,35,141,647,1737,1171,157,289,1014,663,473,454,293,1207,152;41;F
9964;75,944,293,76,188,639,1419,1171,492,1133,1158,1004,152,156,454;32;F
9971;1300,1099,1133,1014,75,76,1246;50;M
9977;141,1133,377,142,530,1158;37;F
10027;141,492,1201,1419,83,530,454,1014,1246,76,1138,1300,157,75,1198;41;M
10088;1258,288,1374,76,1246,311,1419,1133,1158,530;24;F
10089;290,252,647,1133,1228,202,1201,377,1107;57;F
10140;252,202,76,188,1246,1419,1201,492,647,1570,1133,1158,156,454,663;36;F
10148;252,288,1211,473,1014,1419,1439,311,75,83,76,141,1133,142,530;54;M
10160;141,1014,142,288,311,1133,1158,377;50;M
10166;76,311,1158,454,1211,1246,1419,473;36;F
10190;81,1201,1158,1133,103,454;46;M
10207;75,1133,647,141,1099,992,311,1738,1258,252,288,76,1246,1419,1158;40;F
10230;103,773,1300,157,252,288,1419,647,530,1104,1258,142,141,311,1133;37;M
10240;76,1419,647,1133,1158,1014,183,473,1166,479,141,103,1260,142,530;43;M
10241;647,1570,1158,103,473,663,1166,530,1198,252,944,1246,1201,1133,454;32;F
10302;454,1133,530,141,1158;28;M
10346;202,639,843,1171,492,103,864,156;38;F
10349;1104,1171,156,157;44;F
10355;293,1419,843,1201,1017,1260,1133,647,157,1207,103,35,473,142,530;47;M
10357;293,773,492,35,156,473,142,292,530,1300,76,647,103,1260,1258;42;F
10373;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;48;F
10389;152,454,1081,530,775,290,1207,1246,843,1171,35,473,1157,292,1541;44;F
10512;775,479,293,141,1158,1014,1017,142,1541,103,473,530;44;F
10518;188,293,1171,1570,152,530,454,142,288,1211,1439,1419,156,377,473;34;F
10530;377,530,81,1107;69;F
10574;142,1014,75,1158,1258,81,83,1246,311,1419,1570,1133,103,454,530;20;F
10608;290,252,1211,76,1419,647,1158,156,473;32;F
10614;1570;61;F
10711;76,1439,141,647,1133,142,530;46;M
10718;1419,1201,992,1099,141,1570,1158,1014,142,75,209,311,103,454,530;36;F
10749;103,647,1171,1419,293,1207,1211,1374,209;44;F
10760;1419,1201,141,1133,1014,1017,473,292,1541,647,76,142,530,377,183;53;F
10788;663,252,647,1133;29;F
10815;1107,157,1201,530;43;M
10830;944,202,188,311,293,1201,492,1570,1158,103,35,156,473,454,663;28;F
10853;1158,1014,1104,252,76,293,141,647,142,377,530;38;M
10888;1171,639,188,1207,1211,1104,75,252,1374,76,479,1014,152,156,1017;43;F
10905;479,293,141,473,142,530;35;M
10912;290,1211,202,1419,1171,1201,141,647,35,377,663,142,530;47;F
10933;479,209,290,289,1023,1570,1133,35,1017,663,292,1541;44;F
10941;1014,468,944,188,156,152;38;F
10979;944,1570;38;F
11025;75,1258,504,1260,81,252,1374,479,647,35,1017,1081;29;F
11032;454,1198,81,83,1246,1419,1158,1133,647;39;M
11068;639,157,252,1171,1201,1158,152,377,866,1258,209,1738,1419,1133,454;36;F
11131;1133,1419,1246,1158,530,454;25;M
11144;188,1171,141,1260,473,142,156;75;M
11241;468;28;M
11295;454,1158,1740,647,1419,311,1246,252,504,81,1258,1133,1166,142,530;53;F
11299;1736,843,1171,35,473,1157,663;37;F
11306;294,1258,157,209,468,252,202,188,1171,773,647,103,156,1157,1081;9;M
11319;1300,1541,75,252,76,1246,479,141,647,1570,1133,1158,1004,1081,530;26;M
11328;468,1300,1198,1258,1541,1157,1570,647,1734,1246,157,1104,1107,1171,156;38;F
11376;1736,294,209,1374,1211,202,188,639,1171,773,647,864,156,1157,1081;54;F
11385;1260,183,377,75,81,76,141,647,1439,1419,1133,1158,1166,142,530;41;F
11400;81,1300,288,1246,1201,103;35;F
11401;156,76,1004,83,1258,75,1300,252,1246,1133,1014,454,530,1171,103;45;F
11455;504,1300,81,1258,157,209,311,1246,1419,141,1570,1260,454,1166,866;27;F
11480;647,1099,311,1246,202,468,75,1228,1300,1138,1201,141,1014,454,530;51;M
11498;252,647,530;23;F
11499;103,473,454,530,290,504,252,1211,1023,1014,156,1017,292,1201,152;40;F
11522;1171,1023,773,492,1004,103,473,1157,454,142,75,76,141,1014,530;34;F
11523;290,454;42;F
11528;992,1201,141,1570,103,35,663,530,1198,1374,1740,1133,454,142,866;62;F
11549;1171,293,639,1738,188,76,202,944,1211,252,504,1736,1570,1133,1158;40;F
11583;76,311,479,647,1260,530;36;M
11598;209,1201,492,141,647,1570,1133,864,152,1017,473,454,663,142,530;44;F
11606;530,311,1107,843,992,1158,103,377,141,292,504,76,1201,1133,454;43;M
11645;157,289,647,1740,103,156,81,290,944,1099,1570,1166,866;35;F
11671;1158,1260,152,1081,202,1171,773,1570,1133,864,156,1157;40;F
11679;479,103,1017,663,530,152,292;48;F
11686;209,141,1201,454,288,1158,647,1419,311,1246,76,252;37;M
11823;290,252,1211,188,479,1171,1570,35,156,1017,377,473;33;F
11871;75,252,1207,76,1246,311,1439,1419,1099,141,647,1133,103,142,530;31;F
11937;775,288,1246,639,1419,1171,1201,492,1740,1004,864,152,1017,1157,1541;34;F
11939;188,202,944,1374,252,468,1228,504,288,76,1738,1246,1171,1133,864;49;M
11989;75,1228,504,775,288,311,479,1419,1171,1133,1004,103,864,142,473;24;M
11998;288,1211,188,1246,639,293,1419,1171,1133,1158,156,473,1157,454,530;33;F
12016;1736,294,290,1228,504,775,288,202,1246,639,1419,1171,647,530,1740;51;F
12023;142,311,1439,141,377,530;36;F
12031;1211,288,1138,75,1198,468,252,1246,1570,1133,103,473,454;35;F
12032;1158,479,1439,290,252,76,1419,843,141,1570,1133,663,103,530,142;49;F
12061;1439,288,1246,1419,1133,377,142,530;42;F
12097;157,156;20;F
12123;1228,1207,1201,473,454;44;M
12129;156,492,1734,992,1201,1171,479,639,188,468,504,1228,290,157,1198;34;F
12154;157;38;M
12216;1246,1439,1419,1171,1133,530;42;F
12238;866,1201,1258,468,188,209,504,1419,1133,1158,183,454,1166;34;M
12255;209;49;M
12296;454,530,209;36;F
12330;288,252,1737,290,75,1374,479,1023,1734,1740,35,1014,663,530,292;40;F
12369;289,103,35,1014,152,1017,1570,1541,1300,504,639,1171;42;F
12379;1166,530,1158,1133,141,1023,1439,293,142,292,209,1419,35,473,76;44;M
12438;252,288,1211,76,202,311,479,293,1023,1201,141,473,454,663,530;35;F
12464;1198,288,1419,843,1171,1201,152,156,311,1133;46;M
12493;1138,252,1374,76,188,1246,311,1419,1201,647,1158,1133,103,454,866;35;F
12548;1246,1201,1734,773,492,1099,1004,454,35,1260,1017,183,377,473,866;40;M
12574;1171,1570,1158,152,530,290,288,1439,1419,1099,647,1133,1004,156,454;35;F
12606;468,944,1099,141,1014,152,1157,1081,866,209,1201,492,773,647,454;45;M
12638;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;85;F
12701;209;45;M
12719;1166,647,141,142,530;40;M
12732;377,183,1157,1166,142,530,157,1104,252,1211,76,1107,1171,141,156;35;F
12738;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;51;M
12743;75,1258,83,76,1246,1439,311,1419,141,1014,142,530,1738;43;F
12758;202,293,1133,1158,157,1104,1107,1171,647,1570,103,156,473,454,663;37;F
12761;209,944,188,293,1734,773,492,1570,35,156,1017,473,454,663,292;41;F
12799;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;48;F
12810;1017,289,294,290,1228,1737,647,1570,103,35,183,454,663,866,292;68;F
12819;992;52;M
12832;252,288,76,1246,843,152,141,647,103,157,1104,1107,1734,1171,156;6;F
12838;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;14;M
12873;1541,1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866;68;F
12891;1207,252,1737,1104,1228,1258,75,288,76,311,141,647,103,377,183;31;M
12903;188,639,473,454,292,35,103,647,492,773,1419,293,157,290,209;43;F
12909;252,479,1133,35,1260,473,454,663,292,1166;52;F
12928;252,1201,647,1014,454;51;M
12934;1211,639,1570,35,183,188,479,293,1099,141,156,1017,473,142,530;35;M
12966;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;37;M
12970;473,1211,252,209;48;F
12972;202,492,1099,647,1570,454,76,944,1171,639,81,663,1081,1166,992;40;F
12975;83,1300,1374,76,311,1201,141,377,183,454,142,530,1246,1014,1258;45;F
12978;1201,293,76,81,1258,209,1207,1738,1133,103,152,156,454,142,530;40;F
12984;76,311,1419,843,1171,1023,647,1133,35,290,1099,1017,473,663,292;42;F
13000;1198,81,504,1138,468,944,1107,1201,773,492,864,454,866,1541;67;F
13016;454,1158,1133,1099,1734,288,252,1138,1198,1228,1201,473,1570;40;F
13027;289,1211,1207,473,293,1201,647,1004,1017,292,1198,1228;40;M
13043;1104,1211,188,1246,293,647,1133,103,156,1017,473,454,663,530,1541;37;F
13071;1023,1099,141,1158,103,35,1014,156,1017,473,454,663,142,292,530;40;F
13078;1570,1017,530,1258,1300,775,1737,1374,639,1439,1419,1171,141,1158,1014;50;F
13083;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;2;M
13091;1570,647,1099,492,1023,1171,293,311,1246,202,1374,468,1228,156,1081;27;F
13093;1258,76,141,1133,530;40;F
13124;294,1736,75,377,76,1439,1570,663;62;F
13133;1198,81,504,1138,468,775,944,1107,1201,773,864,454,866,1541;33;M
13141;289,252,479,1570,1133,1260,1017,454,1081,1258,290,293,141,473,530;40;M
13145;1104,775,1211,141,1158,156,377,473,142;37;F
13161;76,1439,1419,492,141,1133,1158,1004,103,152,156,377,473,142,530;42;F
13169;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;32;F
13186;1133;37;M
13191;75,252,103,530;32;F
13197;141,142,292;53;M
13216;944,202,75,83,1300,252,288,1099,647,1570,103,152,663,142,530;43;F
13227;81,290,252,293,1133,663,292;47;F
13282;1246,1133,1158;58;F
13291;252,1133,1158,468,530,76,1201,1014,1570,454,1171,1104,141,843,1260;42;M
13305;209;52;M
13308;663,1166,1017,1171,1099,647,1570,530,1541,290,209,504,775,1374,992;23;F
13313;944,639,1171,492,647,1570,1133,1158,103,864,1014,156,473,454,663;28;F
13335;1166,81,252,288,639,1171,530,647,1014,1374,76,1246,1419,1133,1158;31;F
13338;1419,1099,141,76,75,1207,1246,1740,1166,142,252,647,1133,1014,530;44;F
13339;81,377,1133,1570,1099,1201,311,76,1374,252,775,504,103,530,647;34;M
13341;294,1014,156,473,454,209,76,311,1439,1419,141,1133,1158,142,530;40;M
13360;142;45;F
13372;75,81,1228,1246,1439,1158,663,479,202,76,252,1419,647,1133,530;33;F
13391;156,1017,1171,1419,311,157,1258,1211,944,1207,188,639,293,492,473;31;M
13397;292,663,1017,1023,293,35,290,1541;65;F
13404;492,1157,454,103,1419,293,468,209,1211,76,202,1171,156,473,663;46;F
13410;992;38;F
13413;1081,1158,35,1258,468,209,944,202,188,1738,1246,479,647,152,156;43;F
13414;1104,252,288,1207,479,293,1439,1419,1158,1004,103,1014,1017,377,473;40;F
13434;288,311,141,142,530;42;M
13452;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;68;F
13509;1198;76;F
13521;294,843,1023,1014,504,1138,1107,1439,141,1004,454,663,142,530,292;51;F
13542;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,1541;76;M
13550;202,1246,293,157,1104,1107,1171,156,1570,1133,1158,377,473,454,663;12;M
13551;944,1211,775,1737,1300,83,290,289,1258,75,1099,103,473,663,866;31;F
13567;479,1201,866,252,1570,209,377,1133,647,1246,1419,141,103,142,530;40;M
13573;944,1419,1201,1158,1014,454,142,530;36;M
13587;157,76,639,479,293,1419,1570,1158,103,377,473,1157,142,530;42;F
13603;81,1104,468,252,288,76,1171,1201,1099,647,1570,103,454,663,530;31;F
13650;468,944,188,1171,492,156,1133,1014,152;52;F
13653;1419,1171,992,773,1099,141,1570,103,35,152,377,473,454,1081,530;36;F
13656;1198,1258,83,1104,775,1246,1419,1201,141,1157,530;26;M
13684;209,76,1246,647,1133,183,454,1166;38;M
13692;1198,81,504,1138,775,468,944,1107,1201,773,492,864,454,866,1541;72;M
13695;1258,1228,252,1374,1246,1419,647,1740,1004,1158,1133;31;F
13696;1374,1133,1158,75,81,252,1246,647,454,530,1258;42;F
13702;1246,479,293,647,103,1081,252,76,1738,843,1017,530,292,1014,152;47;F
13716;75,288,1158,1014,142,530;45;M
13719;1300,1171,1014,152,473;44;F
13723;1138,1107,454,1198,81,290,288,202,311,639,1419,1171,1201,103,647;28;F
13745;1300,35,1198,504,1201,454,75,83,76,866,1014,293,473,103,152;50;M
13763;75,252,1374,1211,1246,479,293,1099,647,103,152,473,663,292,530;48;F
13770;141,142,530,1014,290,188,1171,492,1570,152,156,1541;40;F
13791;1740,103,1014,377,663,142,292,1737,479,1023,1570,1158,1017,294,290;49;F
13799;1198,81,504,1138,468,775,944,1107,1201,492,864,454,866,1541;67;F
13814;1198,81,504,1138,468,775,944,1107,1201,773,492,864,866,1541;75;F
13816;1198,1157,454,663,530,292,75,81,83,1300,1138,252,76,103,152;44;F
13843;1738,1246,311,639,1171,103,156,1166,75,83,76,141,1014,152,530;47;F
13892;35,103,1133,1201,293,75,1258,1738,1246,1439,141,1158,1014,152,454;9;M
13910;209,1207,202,1439,103,35,473;12;M
13925;1104,468,1107,377;40;F
13933;1171,473,1158,864,377,1157,1081,75,1258,1300,252,1246,1419,866,530;46;F
13949;141,142,530,1419,1104,1133,1158;38;M
13955;1158,647,76,1171,142,288,1246,152,663,530;43;F
13957;290,209,202,1439,103,35,530;9;M
13968;843,1570,1014,377,183,1738,188,76,1374,202,141,1158,1133,35;34;F
13984;1017,1133,141,647,209,252,1207,202,1738,1246,103,35,377,473,663;45;F
14003;1211,188,479,647,103,35,1014,152,156,1017,473,530,1198;37;F
14020;1374,202,293,492,647,1570,1133,1158,473,454,157,1104,1107,1171,156;8;M
14022;83,209,75,1258,1207,1738,1246,1201,141,1133,1158,152,454,142,530;12;F
14024;1166,1201,152,1157;43;F
14037;454,1004,647,1201,1107,311,1246,288,775,81,1198;45;M
14048;209,647,473,663;40;F
14058;473,663,157,1104,1107,1171,156;36;F
14089;663,142,292,530,866,504,1138,775,944,1107,1201,773,492,864,454;72;F
14098;209;42;F
14115;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;73;F
14121;35,773,1023,293,639,202,468,157,75,83,252,1171,1014,1211,152;40;F
14139;142,530,76,1246,1419,1439,141,288,75,311,1201,1014,377,1157,454;18;F
14145;75,1738,1246,479,1439,1201,141,1133,1158,103,1014,152,530,142,454;14;M
14151;152;44;F
14180;1258,75,252,76,1246,647,1158,1133;19;M
14194;479,293,1171,647,156,1258,1207,76,1419,1158,1133,1014,152,473,454;46;F
14231;1439,647,1004,152,1133,103,1014,454,142,288,1171,1158,76,1258,1246;30;M
14236;1133,1004,209,1246,1419,473,454;38;F
14242;1258,209,83,76,1246,311,1439,1419,141,647,1133,1158,1014,377,530;35;M
14243;479,1171,492,1004,864,1260,454,290,76,293,1201,141,377,866,292;44;F
14246;290,289,473,292,530,209;45;F
14250;75,83,1300,1201,1014,152,454;43;F
14265;1138,504,290,773,647,141,1014,663,468,1171,1201,864,152,454,292;39;F
14273;479,188,76,290,1228,1211,293,1734,773,647,1570,103,864,156,473;35;F
14276;1133,1260,454,866,530,1300,252,76,1419,647,103,1014,152;37;F
14286;1198,81,209,1740;43;F
14287;843,202,1374,252,775,1138,1258,289,290,1228,1737,1570,866,663;70;F
14333;1099,1171,1439,639,1246,1738,468,1258,1736,1419,1201,647,103,1157,454;24;F
14339;152;50;F
14371;209,1419,1133,1158;39;F
14429;1740,1734,1171,288,1138,290,209,775,202,639,773,1570,103,864,454;48;F
14478;1171,76,252,1138,1198,157,1570,292,1166,454,1133,647,1211,81,209;39;F
14496;1166,252,1246,1133;36;M
14498;103,1166,252,1374,647,1158;25;F
14509;1570,1171,1439,1211,1158,288,293,1419,647,473;28;F
14511;141,1171,1258,252,1374,1207,76,1246,1419,647,1133,1158,1166,530,209;35;M
14520;76,293,1023,1099,1081,83,775,252,639,1171,141,647,1133,103,473;48;F
14526;1166,864,311,1738,1104,1258,288,1246,1419,141,1133,1158,1014,142,530;32;M
14530;1198,1171,1023,1570,103,35,473,1157,454,292,293,141,1017,142,530;44;F
14548;454,1004,1099,1201,1171,639,1228,504,1138,775,288,1211,944,188,311;23;F
14554;152,156,377,157,1736,81,775,468,293,1211,479,1099,1260,473,454;38;M
14558;81,209,311,156,473,454;43;M
14572;377,183;71;M
14573;209,81,289,1374,944,188,639,1171,1023,1570,1133,156,473,663,292;41;F
14576;454,1014,35,311,83,289,1246,293,1158,76,141,647,1570,1133,663;50;F
14585;157,1258,252,1211,188,293,647,1570,1133,1158,864,35,152,156,473;38;F
14595;1099,639,290,209,1138,775,202,1419,773,1570,1740,864,183,454,866;76;F
14628;75,83,252,76;35;M
14645;1211,473,293,103,1570,1246,1158,1207,944,209,156,35;45;M
14667;157,156;43;M
14671;157,156;68;M
14688;252,76,1246,479,293,1419,1099,647,152,473;44;F
14724;663,183,1734,288,1138,209,775,202,773,1099,1570,1740,864,377,454;13;F
14731;157,775,1439,1419,141,647,103,473,454,142,292,209;37;F
14740;293,1211,944,252,1419,1171,1158;37;F
14756;1133,103,76,1374,252,1198,1138,1738,1023,454,663;39;F
14760;288,1374,202,1738,1419,864,663,1081,142,530,1541,209,252;39;F
14762;209,1198,81;6;M
14765;156,188,468,152;39;F
14800;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;68;M
14805;292,290,1017,377,252,1419,35,663,866;64;F
14806;157,188,1107,141,156,142;61;F
14821;1419,1207,76,252,1374,1246,1107,479,1439,1171,1023,1133,1158,1157,663;54;F
14833;377,142,530,1198,209,76,311,479,1439,1419,141,1133,1017,473,454;67;M
14842;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;68;M
14854;103,152,377,142,530,141,647,1570;46;M
14902;647,103,35,454,142,1570,202,252,209,1171,1419,1133,1158,473,530;45;F
14915;157,202,773,864,156,663,530;38;F
14995;504,1138,468,775,944,1107,479,1201,773,492,1014,864,454,866,1541;41;F
15014;183,288,1419,141,647,1260,142,292,530,1258,1374,293,1439,1133,1158;59;M
15023;157,1228,1104,252,1439,647,141,1158,103,1014,183,473,142,1260,156;45;F
15031;290,468,639,479,1023,492,141,647,1570,1158,103,1014,1017,473,663;35;F
15069;479,141,1014,454,530;43;M
15079;1211,289,1736,157,288,944,188,209,1171,1570,473,454,663,530;37;F
15086;530,35,293;45;M
15100;479,293,1158,103,473,454,1258,76,1246,1419,141,1133,1014,142,530;34;M
15108;1198,81,504,468,1138,775,944,1107,1201,773,492,864,454,866,1541;74;F
15158;209;35;F
15161;311,1246,76,1300,293,454,142,530,252,1107,1439,1419,1133,1158,377;33;F
15162;75,288,1439,141,103,142,866,530,1541;40;M
15178;35,775,1300,290,289,293,1419,1171,1734,1099,1570,1133,1158,156,1017;43;F
15201;76,311,1439,1419,141,1133,1158,1014,156,377,473,454,1166,142,530;36;M
15235;289,1171,647,1133,152,292;53;F
15251;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;73;F
15267;209;40;F
15271;209;68;F
15285;1246,1419,647,1133,530;42;F
15323;1260,1014,103,1133,1570,647,141,1439,252,1104,1228,157,1166,142,530;18;F
15326;252,311,647;40;F
15356;1166;59;F
15409;288,1107,866,81,1439,1258,377,183,75,311,76,1246,1419,1133,1158;33;M
15480;75,209,1738,639,1419,141,1004,1258,288,76,1246,647,1158,1740,1133;51;M
15531;81,75,289,290,1104,1207,1439,1158,1014,1258,1246,1171,647,1133,103;45;F
15547;209,103;37;M
15549;311,1419,1133,473,530;39;M
15575;252,1211,944,76,479,293,1023,1099,647,1570,35,1017,473,663,1541;29;F
15586;209,1201,1570,1541;28;M
15601;866,1198,81,1419,647,1014,252,76,1201,1158,1133,454,142,1258,530;33;F
15611;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;74;F
15620;775,76,647;57;F
15621;76,1246,473;46;F
15622;142,663,103,479,639,288,252,141;44;F
15625;1198,81,504,1138,468,775,944,1107,1201,773,492,864,866,1541,454;65;F
15639;293,1201,454,288,944,188,773,647,1570,1740,103,35,156,473,1166;38;F
15658;311,479,293,492,1133,1158,103,864,35,1017,473,454,663,142,292;38;F
15662;639,1171,492,1158,103,454,1014,311,141,1157,142,530,1133,1166,866;30;M
15667;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;79;F
15684;81,1198,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;50;F
15704;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;42;F
15722;1158,152,1133,1374,1300,1258,141,1014,142,530,75,83,1207,76,103;52;F
15723;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;6;F
15729;188;43;M
15743;1201,1198,81,504,1138,468,775,944,1107,773,492,864,454,866,1541;17;M
15774;188;18;M
15779;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;51;M
15783;1211,1419,647,35,156,473,454,530;38;F
15800;1374,311,479,647,103,1014,1017,377,183,1081,142,866,530;33;M
15821;290,1419,202,293,1023,1201,454;38;F
15830;142,454,1439,209,76,1246,1158,35,75,1211,479,647,1133,103,473;39;M
15831;188;54;M
15872;311,76,252,81,209,647,473;40;F
15898;1198,290,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;69;F
15899;209;39;M
15911;288,1439,1171,1201,141,1133,1158,1260,454,866,530,76,1246,1419,142;58;F
15944;1198,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;80;F
15953;1300,1104,288,76,1017,152,1133,479,83,103,141,1207,1258,1014,530;39;F
15960;294,288,1171,1023,647,663,292,1166;63;F
15967;1419,141,252,1201,1158,1133,479,454,103,76;29;M
16004;1258,1246,1107,1439,1419,647,1570,1133,1158,1017,377,1081,1541;18;M
16017;188;48;F
16026;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;63;F
16035;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;58;F
16043;1258,1228,1300,1246,479,293,1419,773,647,1570,1133,103,1014,473,454;12;F
16045;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;68;M
16061;1198,504,1138,468,775,944,1107,773,864,866,1541,81,1201,492,454;50;M
16062;1107,1201,773,492,1570,864,35,156,1157,454,663,1081,1166,292,1541;54;F
16070;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;69;F
16086;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;56;F
16087;1246,152,35,864,103,1004,1158,1133,1570,141,1099,492,992,1023,1171;49;F
16102;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;63;F
16118;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;62;F
16120;1138,775,773,141,1133,866,530,81,944,1107,1201,492,864,454,142;42;F
16135;1374,288,252,1419,1171,142,1541;38;F
16139;492,1734,843,1246,504,81,294,1107,1439,1419,1099,141,1133,142,530;35;F
16144;209,202,1570,1023,1201,103,1014,454,663;33;F
16166;209;29;F
16167;188;43;F
16177;188;34;F
16194;188;16;M
16198;157,1133,183,81,468,1211,76,188,639,1570,1158,473,454,1166,292;40;M
16241;157,639,1171,81;35;M
16259;252,76,1419,141,647,1158,142,530;35;M
16280;252,76,1099,141,1133,1158,103,454,142,530,1374,1246,1419,647;37;F
16295;1736,290,252,202,1171,1099,647,1570,152,156,454,663,1081,1166,142;43;F
16310;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;71;F
16328;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;70;M
16332;1246,292,293,479,1133;24;M
16335;311,1439,504,35,468,479,1171,647,1014,152;44;F
16339;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;44;M
16343;252,454,141,142,530,479;46;M
16346;209,1138,252,1211,293,1201,1734,492,647,1570,864,473,454;6;F
16348;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;69;F
16354;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;42;M
16379;1211,76,1738,1246,1171,1201,647,1133,1158,103,156,1017,473,663,1541;33;F
16385;1419,1171,1734,1099,647,1570,1004,152,156,473,1157,454,1166,142,209;41;F
16409;157,81,293,1201,473,1107,454,1133,142,1246,311,1439,141,1260,530;48;M
16461;76,1246,311,141,647,1570,1158,35,530,252,288,1133,103,454,142;38;F
16468;1228,639,1099,1374,76,1158,183,377,1157,288,252,1246,141,103,1133;25;F
16469;1158,454,1104,468,188,202,76,293,1419,1734,1133,864,473,1171,1166;38;F
16474;1099,311,188,76,252,504,81,468,1419,1171,530,1198,1017,202,35;20;F
16536;864,81,35,1004,1419,454,1258,1246,1158,1017,473,1133,647,209,76;31;F
16539;188,1107,1439,1171,1166,1246,83,75,1258,81,1300,76,103,1014,454;42;F
16549;141,1740,1133,663,142,81,504,468,775,944,1201,773,492,864,454;66;F
16562;209,1246,311,1439,1419,141,1570,1133,1158,103,1014,152,156,142,530;41;F
16564;1107,1419,1201,141,1133,1014,1260,454,530,252,288,311,647,103,1166;31;F
16570;209,311,1419,141,35,142,530;34;F
16640;1104,293,141,1570,1158,103,1014,152,156,1017,473;38;F
16653;290,1211,202,188,843,1023,492,1099,647,35,156,1017,473,663,292;39;F
16661;1246,1107,492,141,1133,1014,866,292,504,81,944,1201,773,864,454;70;F
16667;289,639,293,1171,492,152;45;F
16682;288,1246,311,1171,1014,454,530,647,1133;26;M
16686;1198,252,1374,1201,647,1133,454;47;F
16698;1198,1258,1246,1201,1133,152,454,866;59;F
16702;473,1419,293,639,188,944,288,775,468,1104,75,1107,1171,157,156;47;F
16708;1419,1133,1158,473,530;37;F
16722;492,775,468,1198,81,504,1138,864,454,866;67;F
16741;252,76,479,1023,492,647,1158,103,35,1014,1017,663,866,292,1541;42;F
16750;141,639,1300,290,289,1081,473,1260,1171,1211;59;M
16774;454,944,75,1211,1246,293,141,1133,103,35,152,473,530;39;F
16787;157,944,188,639,479,293,1439,1419,1171,1004,152,156,1017,473,663;18;M
16807;647,252,293;35;M
16814;142,530,209,76,1419,647,1133;39;F
16816;83,1228,202,188,639,843,1171,492,1099,1014,152,156,1017,1157,75;43;F
16839;639,293,1419,1171,1201,647,1570,1133,103,1260,1017,454,663,866,292;53;F
16852;1158,1133,1419,1439,311,1246,76,83,209,1258,288,141,1014,142,530;33;M
16853;209,1258,1104,252,156,530,293,1738,188,1158,944,141,103,142;28;F
16856;81,293,473,454,866,156,141,1201,1171,1107,775,1104,157,142,530;38;M
16866;288,1246,1157,1300,209,252,76,1738,1419,1171,1201,647,103,454,530;37;F
16920;473,288,83,75,1207,76,1246,1439,647,103,1014,152,1017,377,454;41;F
16944;311,103,81,293,141,454,142,530;37;M
16947;1198,1138,76,81,1107,1201,454;55;F
16993;663,1198,1374,1207,76,1258,479,1419,647,1158,103,1017,473,454,530;48;F
17006;1104,1107,157,773,1171,156;38;F
17023;81,75,1198,288,1246,639,647,1133,377,454,1166;22;F
17051;75,81,83,252,76,103;31;F
17052;76,1258,1104,1246,639,1419,1171,141,1133,1158,1014,473,142,530;55;M
17053;288,1374,479,377,530,1258,76,1419;38;M
17056;1198,252,188,639,1419,1171,492,647,1570,1133,103,473,1157,454,530;51;F
17069;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;61;F
17077;775,81,1207,1133,1014,530,75,252,103;43;F
17138;492,1258,1736,290,1228,252,944,76,188,773,647,1570,103,35,866;68;F
17156;1570,1014,1157,1198,1738,1246,311,1107,639,1201,377,663,81,1133,454;50;F
17168;1104,76,188,1246,1133,103,156,142;66;F
17171;1258,1300,288,76,1439,1419,843,1171,1201,141,1158,1014,377,142,530;50;M
17180;530,1246,1258,252,288,76,188,1738,1419,647,1133,1158,473,1157,454;29;F
17187;311,639,1419,1171,1201,492,647,1133,156,157,1104,288,1439,103,142;44;F
17249;843,1023,1099,141,1158,103,663,142,292,530,289,76,479,1014,152;51;F
17267;1258,76,311,1439,1419,141,1133,1158,103,1014;13;M
17278;944,293,647,1158,35,152,156;53;F
17382;1198,81,504,468,1107,1201,773,492,864,454,866;39;F
17419;1133,209,252,311,639,1171,647;41;F
17420;773,492,1198,944,1201,468,775,864,156,473,454,866,1541;75;F
17442;81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;70;F
17446;1198,81,504,1138,775,468,944,1107,1201,773,492,864,454,866,1541;51;F
17447;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;75;F
17449;1014,75,1171;35;F
17470;1258,1198,75,81,1374,202,1246,1201,141,647,1133,1158,103,454,663;23;F
17473;1198,81,1138,504,468,775,944,1107,1201,773,492,864,454,866,1541;56;M
17485;290,1104,647,103,473,157,156;33;F
17497;252,152;44;F
17528;1300,252,288,293,1570,1004,866,530,944,1246,1419,1201,1133,1158,454;36;M
17535;252,202,479,843,1023,1201,1099,1570,1740,103,35,1017,473,663,292;51;F
17553;103,35,142,663,866,530,1201,183,290,1104,1138,775,377,1260,454;51;F
17591;1198,252,944,76,1439,1419,992,492,1133,1158,103,454,1166;42;F
17604;81,1419,1201,454;42;M
17619;1246,141,142,530;41;M
17629;288,647,289,294,290,311,293,663,292;72;M
17659;290,288,1211,1171,1023,1099,647,103,35,152,377,1017,473,454,1166;45;F
17674;1736,290,1228,252,1211,76,479,647,1158,103,35,156,292;69;M
17676;289,294,290,288,311,293,647,663,292;72;F
17691;288,1374,76,639,1419,1171,1099,1158,864,1260,183,1166,1258,1133;15;M
17703;1158,647,75,252,76,1133;66;F
17707;288,76,1738,479,1171,773,141,647,1158,103,377,473,1157,142,530;22;M
17714;647,1133,103,1541,1374;22;F
17755;843,311,1738,76,468,1198,157,252,944,202,1201,1570,473,454,663;40;F
17759;188,647,1570,1133,103,35,473,1081,152,156;36;F
17761;1198,157,468,252,944,202,76,1738,311,843,1201,1570,473,454,663;5;F
17763;83,293,1734,773,1014,473,530,1300,468,775,252,1207,1738,76,479;40;F
17764;202,76,843,1198,157,468,252,944,1738,311,1201,1570,473,454,663;75;F
17787;152;68;F
17791;1228,468,647,1570,1004,103,35,1017,473,1157,663,1081,292,530,152;48;F
17807;1133,157,1171,156;53;M
17809;775,1737,202,1246,1107,843,1201,773,1570,35,454,663,866,292,1541;48;F
17823;83,252,1107,311,1439,1570,76,1246,1419,1201,1133,1158,103,454,530;67;F
17881;504,188,1107,639,1201,492,141,647,1133,864,1260,156,183,454,866;38;F
17925;1138,1107,454,866;61;F
17926;81,775,1099,141,647,103,1017,473,454,663,142,530;47;F
17929;1258,202,290,252,1246,293,1171,647,1570,103,35,1017,473,663,1081;36;F
17962;141,1158,35,530,202,1258,944,479,1201,1570,103,156,1017,473,454;41;F
17964;35,292,103,156,473,454,290,468,1211,944,293,1171,492,1570,188;43;F
17966;1419,311,1133,1014,377,83,944,76,1439,1201,492,454,75,1246,1158;46;M
17990;311,1419,647,103,156,252,1374,944,76,1246,1133,1158,1014,152,454;13;M
18001;75,157,288,1374,1211,639,293,1171,1201,773,1014,156,1017,473,1157;32;F
18025;1138,504,290,81,775,944,202,639,1171,773,1099,864,35,156,454;38;F
18039;103,1201,311,944,1374,1258,252,76,1246,1133,1158,1014,156,454,152;8;F
18085;1133,1004,35,1017,454,292,252,1107,1419,1740,377,530,1570,663,142;51;F
18109;75,83,252,647,1014;47;F
18132;504,1737,944,188,1738,639,1171,1201,1734,492,1570,1133,103,156,1166;33;F
18160;157,156;42;F
18172;1198,1419,76,992,647,1740,1133,1017,473,454,663,866,530;70;F
18201;1374,209,639,1023,1171,647,1570,1166,35,141,76,311,1133,1017,530;46;M
18207;35,1023,289;59;F
18216;944,639,1171,1133,1158,152,1017,188,76,288,1258,75,1014,156,473;37;F
18220;152,1157,292,1419,1133,103,35,1198,76,1099,647,454,663,209,1201;42;F
18228;81,252,1201,454,1081,944;43;F
18318;289,290,209;4;M
18322;288,76,75,1133,103;42;M
18341;1439,103,377,76,141,1158,142,530;51;F
18373;75,288,1374,76,1099,647,1133,1004,103,454,663,866;44;F
18404;504,1439,1419,1201,1133,1158,75,288,76,141,103,1014,377,142,530;20;F
18412;647,1133,35,156,1017,473,468,1246,1023,1171,1570,454,663,292,530;33;F
18417;141;39;M
18419;157,1104,252,288,1107,1171,156,183;43;M
18436;647,75,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,530;42;F
18437;1439,1419,1099,647,473,1157;39;M
18442;1133,1004,290,81,289,1198,1211,479,293,156,1017,473,454,866,530;33;F
18474;1004,1158,1419,1439,311,1228,504,76,1201,377,1014,141,647,103,530;49;M
18493;142,866,530,775,288,647;26;M
18518;775,639,293,1171,1099,647,1570,1158,35,1014,1017,473,663,292,530;40;F
18558;1099,141,1570,1014,473,75,294,290,1207,76,293,843,1133,103,530;53;F
18585;775,157,1258,83,76,1246,1158,1260,530,75,103;34;M
18626;377,252,944,202,35,288,1211,188,639,1439,1419,1171,1570,473,663;36;F
18630;454,530,1081,103,1158,1570,647,141,1201,1419,1246,202,252,290,1258;38;F
18643;1570,35,1260,1166,81,252,639,479,492,141,156,1017,377,142,530;23;M
18648;1258,81,1374,1246,311,479,1439,1171,1201,647,1133,1158,156,377,530;45;M
18656;294,1138,252,843,1201,1099,35,454,663,866,292;50;F
18668;663,992,311,1211,288,504,530,1133,1419,293,1246,76,468,294,209;35;F
18679;1246,1133,1260,530;38;M
18688;293,473,663,1081,142,292,530,157,289,290,209,1541;44;F
18696;252,1138,81,75,866,1166,1133,647;34;M
18697;473,1017,1260,1014,1004,1158,1133,647,1419,288,377,142,530,209,141;39;M
18718;1258,209,1138,1246,1570,1133,1158;37;F
18772;843,1201,773,1133,473,663,530,157,252,202,293,1419,492,35,454;41;F
18774;492,1570,103,1014,152,156,473,1157,454,1166,1171,188,468,1211,944;35;F
18784;103,1570,647,1201,76,252,288,202,1439,1419,1133,454,866,142,530;33;F
18788;83,1207,1023,1099,663,75,1228,252,843,647,1570,1133,1004,103,1017;23;F
18832;75;42;F
18852;293,1419,141,103,663,530,290,1099,1133,1158,35,1017,473,1081,292;45;F
18866;76,188,1171,992,35,156,1017,530,289,290,202,639,843,1734,209;42;F
18890;76,311,1419,647,1570,1133,1158,252,1246,639,663,1166,209;36;F
18893;454,1246,1374,288,1138,504,1736,1198,252,76,639,843,1171,1201,647;43;M
18906;252,76,1246,209;41;M
18909;1258,83,1300,288,944,293,1419,1171,1133,35,1017,473,1157,530,103;40;M
18932;1736,1201,1734,492,103,864,35,1260,866,473,157,1171,1107,1104,156;37;M
18937;1258,289,290,1300,1211,479,293,1734,773,647,1570,103,1017,473;36;F
18973;1198,530,292,1017,1014,35,103,141,76,1207,1228,83,75,1300,1133;45;M
18975;1198,311,1171,141,1157,142,530;46;F
18977;209,1541;65;F
18998;1246,1570;34;F
19001;156,473,663,293,188,1211,252,76,311,1439,1419,141,1133,142,530;35;F
19011;188;37;F
19042;288,1419,377,1201,252,81,141,1107,454,142,530;42;F
19074;252,311,639,141,647,1133,35,663,142,530;53;F
19103;1171,76,252,1133,1158,142,141,530;39;M
19120;1738,311,1201,647,156,377,142,866,209,293,103,473,454,1166,530;39;F
19136;252,75,992;27;M
19140;1198,202,76,647,35,1158,1171,252,288,1246,1133,454;43;F
19144;530,141,142,1158,1133,252,76,1171;39;F
19163;1419,1171,1570,1133,156,454,1166,530;35;F
19165;142,1158,1133,1201,504,75,288,1246,311,141,1004,1166,530;53;M
19174;647,252,289,290,209;39;F
19222;81,202,76,311,1439,1419,1201,1740,1133,454,142,1246,141,530;42;F
19239;1198,1201,252,1258,75,1300,1211,1246,311,492,1014,454,663,1081,1166;46;F
19248;209,473,454,142,530;41;F
19255;1198,209,1211,202,311,1171,1570,103,454,142,530;38;F
19259;157,1104,1211,1107,293,843,1171,141,1570,1133,1004,156,1017,473,377;45;F
19285;1017,663,1166,530,1258,252,1207,1738,1246,1419,1171,1133,1158,1014,1157;44;F
19289;75,103,1300,252,1419,647;23;F
19297;157,252,530,141,142,1158,1133,76,209,1171;9;F
19298;1158,76,1104,209,1258,1439,75,311,1133,1014,377,141,647,142,530;41;M
19303;209;36;F
19339;75,76,479,293,141,1570,1133,1158,183,530,157,1104,1107,1171,156;32;M
19348;75,83,252,76,1246,1133,1004,103,1260,377,454,1081,1166,530;44;F
19352;292,157,663,454,1570,1099,992,1171,639,311,202,468,504,289,1736;49;F
19411;1171,647,1157,454,1166,530;24;F
19446;504,1374,492,156,1198,1258,1228,775,992,647,1570,864,157,288,1158;37;F
19467;1198,288,76,1419,1201,1014,1260,454,311,1439,773;32;M
19481;209,454,639,76,1419,1171,1201,141,647,1570,1133,103,473,142,530;47;F
19488;1014,1258,1198,81,1211,76,1419,141,1133,864,1017,473,454,142,530;31;M
19516;1171,473,142,1107,479,377;49;F
19523;530,142,473,1133,647,141,773,479,639,188,157,1104,1107,1171,156;39;F
19540;1439,1419,209;44;F
19544;1198,504,1138,252,944,1107,293,1419,1201,1734,492,1570,1133,377,454;35;F
19559;311,1419,1133,103,473,530;33;F
19566;504,81,157,530,1166,454,473,156,1133,647,1201,1419,188,1211,209;39;M
19646;209;13;M
19677;209;11;M
19692;141,1171,1419,1439,311,1246,1738,188,1207,76,1211,288,83,157,530;45;F
19731;1198,1171,1201,992,454,866;44;F
19744;1133,647,141,75,252,76,1419,1014,1260,377,183,866,530;21;M
19749;1374,1201,454;44;M
19763;1207,1104,83,75,1258,202,1171,1734,1570,1740,1158,103,377,473,866;32;F
19778;288,1211,944,188,1738,639,479,293,1171,492,103,152,156,473,454;34;F
19781;1258,1439,1107,141,639,1198,311,1014,530,288,1138,1246,1201,647,454;39;M
19785;454,1014,504,1258,775,288,1374,1246,639,1439,1171,1201,647,1004,1157;37;F
19808;1419,647,142,663,454,1258,76,1133,75,311,1439,1023,141,1014,530;29;F
19818;1374,311,479,1419,1099,141,647,1133,1004,103,530,202,252,775,1258;18;F
19824;209,292;14;M
19826;1737,468,1138,1258,209,944,202,1419,1171,1570,1133,35,473,1157,454;36;F
19878;81,76,639,1171,141,647,1133,1158,103,663,1166,142,292,530;44;F
19906;1107,141,1158,103,454,142,1736,202,76,1201,647,1570,1133,866,530;45;F
19918;1158,1014,1017,1166,75,1258,83,1300,1133,103,377,473;44;F
19946;1300,83,294,1736,75,1258,76,1171,1133,1158,103,156;69;F
19949;1104,1138,288,76,311,1419,1171,1201,492,1133,1158,103,454,142,530;42;F
19968;209,141,647,454,530;51;F
19976;530,473,1158,1374,944;35;F
19988;76,202,1211,288,775,1138,504,1300,290,1198,209;4;F
19991;454,157,1107,1570,293,1171,141,156,377,183,1104,81,1541,1419,142;46;M
20029;1198,1201,492,454;37;F
20039;1171,773,1157,530,479,843,647,1099,1201,639,252,663,1017,35,1023;29;M
20054;1157,454,1166,311,202,288,290,75,1081,663,473,103,1570,647,992;24;F
20074;1138,202,1201,647,1570,864,1198,157,775,773,454,663,292;45;F
20081;209,252,76,1246,1419,647;35;M
20100;81,141,1133,1158,1004,1260,1014,454,1166,142,530,75,288,311,1439;29;M
20120;468,1246,311,293,1201,1570,1158,454,81,1211,1107,1419,492,864,473;38;F
20122;81,289,75,290,76,1246,1107,1419,1099,647,1158,663,530,1736,1133;28;F
20158;157,468,775,1211,944,188,311,293,1171,1201,1734,141,156,473,530;49;M
20167;647,103;39;M
20168;1228,1104,288,141,1740,1158,1260,1166;67;F
20250;81,1258,209,311,1246,202,76,252,1138,1171,1201,1133,454;32;M
20264;209;41;F
20289;530,103,1374,35,1023;32;M
20300;647,1201,76,202,1736,454,103,1158,1107,473,1081,141,866,142,530;50;M
20339;1570,1133,530,142,866,141,1107,1158,103,454,1736,202,76,1201,647;72;F
20351;293,1439,1419,141,103,1014,142,530,290,209,1201,35,152,473,454;43;F
20383;75,76,1246,293,1171,1133,103,473;19;F
20402;1734,479,311,202,1258,944,252,468,157,773,1171,492,473,454,530;35;F
20403;530,290,209,293,473;44;M
20410;479,1439,289,294,1023,1099,141,1570,35,1017,377,663,142,292,530;71;M
20425;75,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,183,530;57;M
20440;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;50;F
20442;1300,202,1738,1246,1439,1419,141,1158,142,530,1260,103,311,76,75;47;F
20444;75,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,183,530;57;F
20461;1736,294,1374,202,76,1246,141,377,1166,292;62;F
20485;209,504,1211,76,188,479,1171,647,1570,1133,156,473,454,1541;33;F
20523;1246,1258,1171,1734,492,1099,141,647,1133,1014,1157,142,866,292,530;41;F
20531;288,311,1419,454,663,141,377,142,530;74;F
20542;75,76,1439,1171,103;46;F
20609;1104,1300,209,75,1207,1246,1419,647,1133,1158;30;F
20612;188,1246,639,293,1171,1201,1099,1570,103,152,156,473,454,663,142;37;F
20624;311,293,1171,1201,141,1014,142,252,1211,1419,1133,1260,473,1166,530;41;M
20643;1419,1734,103,1260,156,663,1081,1228,252,76,1246,1171,1570,1740,1158;34;F
20646;157,156;14;M
20647;311,141,1014,142,530,377,1246,1419,1133,1158,75,1258,76,1738,103;47;F
20671;76,311,1171,1419,479,944,1258,1211,188,293,156,1017,473,663,530;34;F
20698;454,289,294,290,775,76,1201,35,663,866,292;71;F
20724;157,156;22;M
20752;209,188,293,156,473,663,142;37;F
20765;1201,311,530,76,1738,1246,1419,1570,1133,1158,639,1171,992,152,156;37;F
20782;504,1158,377,142,1198,75,288,76,1246,311,1439,1201,1133,454,530;33;F
20807;252,1439,141,1158,377,75,1258,76,1246,311,1419,1133,103,1014,530;48;M
20814;1246,1138,1198,76,188,141,1133,103,1014,156,454,663,1166,142,530;40;M
20819;1439,1207,504,290,81,289,1258,252,1246,311,639,1171,1099,35,663;38;F
20873;479,293,141,1570,1133,103,35,156,1017,183,530,292,663,454,473;41;M
20884;530,1023,1419,479,1246,311,76,1207,83,290,289,75,1133,103,1017;21;F
20886;75,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,183,530;46;M
20918;1157,156,1158,1133,647,992,1171,1419,311,1246,188,76,288,252,944;28;F
20938;209;49;F
20947;75,504,288,76,311,1419,1439,141,1133,1158,1004,103,377,454,530;18;F
20972;311,1201,530;45;M
20975;1198,1138,76,188,1246,141,1133,103,1014,156,454,663,1166,142,530;9;F
20999;75,76,1201,1014,454,530;44;F
21005;647,1246,288,75,252,311,1439,141,1133,377,1166,142,530;47;M
21013;188,202,1211,290,209,76,1738,1246,311,639,647,1740,1133,103,377;43;F
21014;288,1419,1260,454;52;M
21042;157,156;20;F
21059;1419,647,1740,103,142,252,1246,311,1439;43;M
21084;473,1198,202,1138,468,944,188,479,293,1201,492,1133,1158,156,454;33;F
21095;292,289,202,76,1246,1439,843,1023,1133,377,142,290,141,663,530;44;F
21144;288,1738,1419,1133,1158,1258,1246;36;M
21170;468,1138,504,1104,1228,1736,1198,76,188,1201,647,1570,864,156,454;45;F
21275;209,252,76,1419,647;30;F
21290;1166,1099,1158,141,647,1133,377,473,454,142,209,252,76,1419,530;52;M
21313;1004,103,864,35,454;59;M
21341;288,647,1133,75,1258,76,1246,1158,1014,1738,311,1419,141,142,530;43;M
21366;473,775,1138,81,1198,75,1107,293,141,1158,864,530,1201,1133,454;15;M
21376;209;46;M
21404;290,1541;72;F
21407;81,252,1419,141,647,1158,1133,103,35,1017,473,1157,454,1166,530;14;F
21437;1541,1014,1246,843,1171,1017,1158,288,1737,83,75,252,1374,1133,103;20;F
21456;289,290,202,1023,35,473,663,292;44;F
21472;1258,1207,76,1738,1099,1004,156,209,1017,504,1138,288,311,1201,454;40;F
21524;288,76,188,639,1004,311,75,1246,1439,141,1158,1133,1014,142,530;36;M
21526;1419,1171,1201,992,1099,647,1133,1004,35,377,473,454,142,866,530;47;F
21577;1228,504,468,1374,639,35,152,292,252,76,1246,1099,1570,663,454;51;F
21604;288,1374,1439,1419,1201,141,1198,944,1246,1107,377,183,454,142,530;45;M
21622;289,290,209;3;F
21625;35;46;F
21640;141,1133,1158,1014,142,944,1107,1439,1419,1201,103,183,377,454,530;7;F
21642;75,81,83,252,76,1439,103,1014,454;15;M
21668;209,1541;41;F
21683;288,1133;20;F
21690;209;40;F
21699;1198,944,1207,1107,293,1439,1419,1201,141,103,377,183,454,142,530;13;F
21714;293,479,252,468,209,290,289,1211,202,188,639,1570,473,663;34;F
21717;1736,289,252,639,1419,843,1099,647,1133,1158,35,454,663,866,530;39;F
21722;377,183,1374,288,76,1419,1133,1260,252,1158;38;M
21729;530,1104,103,288,1099,1570,1138,647,202,1107,639,1201,992,454,1081;34;F
21730;1419,1740,1004,1014,1017,454,157,288,479,1171,492,1099,647,473,209;34;F
21742;1198,75,1258,81,83,1138,468,1246,773,1570,1133,1158,152,473,530;11;F
21764;290,209,252,202,188,639,1570,156,473,663;5;F
21818;1374,202,76,1246,1419,492,1099,647,1133,1158,864,35,156,292,530;38;F
21854;252,288,1171,473;43;M
21878;1439,1738,76,1171,141,1133,288,293,647,473,142,530;37;F
21915;209;32;F
21918;530,103,1201,1374,252,468,81,1258,504,1738,1246,1419,1133,1014,152;9;F
21922;1014,1017,1157,1081,142,866,530,103,141,1439,288,83,75;52;F
21942;293,479,1246,1738,188,288,1104,75,1198,504,1201,141,1014,454,530;41;F
21968;183,157,1104,76,1107,479,293,1201,141,1570,1133,1158,156,530,1541;69;F
21970;75,157,1104,76,1107,479,293,141,1570,1133,1158,156,183,530;46;F
21996;1258,944,202,76,1419,1201,141,1133,1158,1004,103,1260,454,142,530;40;F
22016;1198,81,1138,252,202,1107,639,293,1171,1201,992,773,1570,473,454;42;F
22034;75,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,183,530;45;M
22043;252,1171,103,1157,663,866;43;F
22048;1138,209,1228,252,76,1246,311,1419,141,1133,1158,377,454,142,530;31;F
22053;81,290,1246,103,1133,1158,76,202,294,1228,647;65;F
22089;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;76;F
22115;473,1004,647,1099,1201,639,504,202,293,1171,1014,152,156,454;39;F
22118;1198,1258,141,1133,473,454;45;F
22141;1099,1740,1738,1246,103,647,1570,663,1081,866,530,252,1258,1133,1158;29;F
22181;252,647,1133;40;F
22199;252,311,1133,103,1166,530;32;F
22221;142,1138,468,252,202,76,492,141,647,1570,1740,1133,864,1166,866;37;F
22247;1419;53;F
22286;157,156;45;M
22299;1570,647,35,288,1374,1211,76,188,1099,473;30;F
22346;1246,188,76,202,1211,252,468,290,81,1081,454,473,156,1133,209;38;F
22349;157,81,209;40;M
22372;1738,288,468,504,294,1228,252,1211,76,1246,647,1133,103,35,1017;30;F
22393;75,1104,1246,1439,1171,1099,647,1133,1158,377,1157,1166,76,288,1419;28;M
22417;311,473,454,252,288,76,492,647;34;F
22419;289,1211,1738,293,1419,647,1570,103,152,156,1017,473,1157,454,663;36;F
22443;944,1171,156,152,1004,1158,1419,188,1211,252,288,1374,103,35,377;30;F
22444;866,1541,1198,81,504,1138,468,775,944,1107,1201,773,492,864,454;30;F
22457;1157,663,1081,866,454,156,1734,1201,639,252,504,1104,290,289,157;26;F
22490;76,530,1246;30;F
22509;492,35,377,473,663,866,292,1211,294,1736;59;F
22528;1736,1738,188,1258,504,1211,944,202,1246,1570,1158,156,1017,473,663;28;F
22557;157,504,1211,188,639,1171,492,1158,1004,152,156,473,454,288,992;31;F
22579;1014,288,252,1258,775,1374,1246,311,141,647,1158,103,1166,142,530;37;M
22606;157,1104,1107,1171,156;46;M
22632;252,311,293,1171,1201,492,141,1004,103,1017,377,473,454,142,530;40;M
22669;1439,504,492,141,142,530,454,1158,157,1258,775,252,288,1246,1133;33;F
22693;1211,944,188,639,293,1171,1201,647,103,864,1260,156,473,1157,454;31;F
22715;1246,1171,1734,1158,252,288,76,639,773,647,1133,454,663,1166;37;F
22737;209,252,76,141,1133,152,142,530;35;F
22769;202,1207,288,290,1736,75,252,289,294,1258,663,1374,1133,1260,183;28;F
22771;1157,454,504,1104,75,639,1439,1201,1258,1133,1246,1158,1374,76,1419;34;F
22780;454,663,1228,202,1570;56;F
22787;1004,311,775,209,1258,1211,1246,1171,1201,492,647,473,1157,454,530;39;F
22816;663,1198,1138,188,76,1246,141,1133,103,1014,156,454,1166,142,530;6;F
22840;1258,1738,293,1171,1201,1099,1570,152,156,473;40;F
22847;83,1300,1374,76,1166,252,647,1133,103,1017,866;51;F
22861;35,647,1099,492,773,293,188,944,157,468,252,1211,1171,1157,1570;41;F
22866;1099,843,1419,1439,294,1737,252,288,202,76,1246,311,103,1260,183;55;M
22878;1258,252,202,76,1246,293,1171,1201,141,1133,1014,156,454,142,530;40;F
22895;1419,1171,1570,1133,1158,152,377,473,454,292,504,288,639,1023,35;47;F
22904;209,294,157,1258,311,1439,1419,992,141,1133,1014,152,156,377,142;33;F
22905;1158,1260,530,157,1258,252,76,1246,479,1133,377,183,454,1166,866;36;F
22909;1228,1081,1570;61;M
22985;1258,504,468,252,1738,1246,1419,1171,492,647,1570,1133,103,377,142;41;F
22987;1099,35,530,1207,209,454,103,1133,1419,293,76,142,1439,1258,1246;35;F
22988;293,76,103,141,290,663,292,1017,35,1570,647,1023,479,289,1736;22;F
22994;252,1104,75,1258,1738,1246,1201,141,1133,1158,1014,152,454,142,530;45;M
23006;1211,647,1133,454,1166,530;31;F
23013;454,1158,141,1099,1419,1107,76,288,252,504,81,1736,157,1198,530;24;F
23025;75,1258,81,290,252,202,76,1246,141,1099,647,1133,1158,103,530;29;F
23061;35,530,81,1228,504,1138,468,252,76,1171,1201,1017,473,454,663;33;F
23066;202,311,293,992,647,1570,1133,103,473,1157,454,663,1081,142,530;44;F
23076;293,944,1211,157,1104,775,188,311,1107,843,1171,141,1570,156,377;46;M
23115;1258,157,1736,1104,188,1107,1171,1734,141,1740,103,152,156,454,142;10;F
23122;1107,252,1211,944,479,293,1171,1201,492,647,1133,103,473,663,1166;37;F
23127;83,209,81,1258,157,1104,1107,1439,843,1171,1734,141,1740,156,454;12;F
23135;311,1246,76,1211,288,775,157,1198,81,209,1201,1260,377,454,866;41;M
23139;1198,81,1258,157,1104,1107,843,1171,1734,141,1740,1004,103,152,156;52;M
23218;252,288,1374,944,1207,202,76,1419,647,1570,1133,1158,1004,454,663;38;F
23219;142,83,1258,1439,1166,141,1014,377,75,76,1419,1133,1158,1260,530;15;M
23225;157,1570,292,530;49;F
23233;377,103,1133,1570,1419,76,252,209,188,454,663,1166,142,292,530;40;F
23242;639,647,1133;23;M
23275;288,311,530;38;M
23285;492,141,35,252,311,209,1419,1171,647,1133,1017,377,473,454,530;39;F
23318;1228,775,252,1374,76,1439,1419,647;32;F
23330;1228,504,1419,35,1017,156,1081,1166,473,1157,76,639,647,1158,1133;48;F
23352;1166,377,183,81,83,75,76,252,103,209,202;48;M
23367;76,311,142,479,252,83,75,141,1014,530;39;M
23372;1198,1258,81,504,252,1246,1133,864,1419,843,1201,1158,183,454;43;F
23401;289,479,35,1017,473,292;51;F
23402;1017,292,35;74;F
23493;252,311,1419,647,377,183,473,142;39;F
23495;1014,288,1258,76,1738,1246,1419,141,647,1133,1158,377,454,142,530;32;F
23498;1570,1158,103,35,156,454,292,530,81,83,252,293,1419,1201,141;42;F
23569;663,1004,103,1570,647,1171,1246,290,1228,504,252,288,35,156,1017;31;F
23571;288,76,188,1107,639,1171,1201,1158,1133,1004,152,156,473,1157,454;33;M
23599;209,775,639,1201,1734,773,1740,103,152,454;49;F
23601;1734,864,1166,142,866,209,1246,1740,530,454;47;M
23644;530,142,1166,454,183,1260,1014,1133,141,843,1419,1439,311,1246,76;45;F
23660;1107,202,1138,157,76,454,209,252,311,479,1201,992,773,1570,1158;44;F
23693;504,479,1570,377,454,1258,252,76,1246;37;F
23706;311,293,141,530;45;M
23736;1171,1023,1014,473,1258,209,202,76,1570,103,152,663,142,292,530;49;F
23755;76,1419,1201;47;F
23784;1736,83,1099,142,1158,1133,773,843,1258,1104,1246,1419,141,377,530;47;M
23787;75,639,293,1099,1014,156,473,1157,454,1171,152,663;43;F
23794;1246,311,141,1133,1014,1260,454,1166,142,530;40;M
23811;157,290,1228,252,1207,1246,639,479,293,1419,1004,103,156,1017,473;41;F
23814;468,83,1258,1133,1158,103,1014,289,290,1138,1017,183,473,663,866;50;F
23837;293,479,639,1211,1300,83,1246,1201,141,1014,152,1017,473,142,530;42;M
23841;1246,76,1207,83,1258,1198,209,288,1419,141,1133,103,377,454,142;40;F
23843;944,288,775,157,468,252,1211,293,1171,103,35,156,473,454,663;34;F
23858;473,530,157,1104,1211,1439,1419,1171,156;37;F
23860;76,1419,1133,1260,1166;36;M
23867;1439,1419,1133,1158,530;34;F
23904;290,202,76,1419,1171,992,647,1740,377,454,663,866,292;73;F
23912;1439,1133,377,183,473,454,1104,252,288,1246,1419,1158,530,1260,142;14;M
23918;1246,188,504,1198,209;70;F
23928;1258,1246,1419,647,1133,1158,103,864,1260,866;36;M
23942;288,1419,530,142,311,209;45;M
23963;252,1439,377;29;F
23982;866,76,1207,288,1258,83,252,1246,1419,647,1158,103,1014,152,530;46;F
23994;1133,773,1099,1171,157,209,76,1201,530;43;F
24013;1201,492,647,103,864,663,504,252,202,639,1099,1740,156,183,866;44;F
24026;293,1171,1014,1260,454,530,81,504,252,647,103;43;F
24040;103,530,1158,35,647,663,76,1166,1133,188,209,1171,142,1439,1419;39;M
24048;293,1099,141,647,1158,473,288,1374,76,1419,1246,1133,1104,142,103;16;F
24062;209;6;F
24078;1171,1419,1260,454,866,647,288,1740,1374,76,1246,1099,1133,1158,1157;32;M
24085;202,141,1014,647,1258,76,311,1419,1201,1158,1133,103,530,252,1374;25;F
24087;76,1104,202,1107,1133,377,252,1207,843,1099,141,647,1740,103,1541;45;F
24105;1228,647,1166,992,293,479,81,289,75,1104,288,311,1133,1158,142;16;M
24198;157,290,1419,1023,1201,647,1157,473,454,663,1081;31;M
24212;1158,1570,35,76,1133,209,1171,81,142,1419,1439;7;F
24228;75,81,83,252,76,103;44;F
24272;1133,1439,1419,209;39;F
24331;157,1104,1107;41;F
24391;103,1133,1104,1258,1158,75,83,1300,76,1246,311,1439,1419,141,530;10;F
24393;1107,1201,1740,866,183,1166,1198,81,252,103,1260,377,454;74;F
24408;75,83,252,1374,76,647,1004,103;50;F
24409;1104,1419,1734,141,647,1133,1004,103,864,35,377,473,454,142,530;50;M
24416;141,157,1104,1107,156,1171;38;F
24418;157,288,1211,202,311,773,377,639,647,1740,156,473,454,1081,866;64;F
24419;252,76,1246,843,141,647,142;35;F
24437;288,1246,639,1171,1133,103,1260,292,530,142,663,454,156,377,183;23;F
24471;75,83,252,1374,103,141,647,530;46;F
24475;1258,1104,288,1158,1014,141,1419,1439,311,1246,76,83,75,142,530;48;M
24487;1201;42;M
24491;639,252,75,289,290,1228,76,479,293,141,1570,35,103,1017,530;62;F
24528;103,152,1017,473,142,288,311,141,1419,1439,1014,454,530,157,156;18;M
24529;81,252,1246,843,141,1133,454,142;41;F
24537;157,1157,1166,530,76,1171,1104,1246,1107,1439,1133,156,377,473,454;41;F
24624;504,944,188,1738,1107,639,1201,492,1014,1260,156,377,183,454,866;5;M
24644;209;37;F
24660;492,1258,252,76,311,1246,639,1419,1171,1201,647,1133,1260,377,454;46;F
24661;1157,292,530,1198,1258,504,202,843,1201,1734,1004,1081,866,473,454;47;F
24681;1419,639,202,1228,1258,1198,1104,1138,76,1107,492,647,1570,183,454;43;F
24687;775,1104,289,479,647,103,35,1017,663,1166,209;38;F
24703;492,663,1201,1017,473,866,292,1541,454;69;F
24706;81,1228,647,1570,454;22;F
24714;157,209,1300,944,188,1738,1570,156;28;F
24716;311,76,1104,1228,290,289,157,775,202,843,1570,103,663,292,530;42;F
24718;377,866,292,1166,663,454,35,1158,1133,647,157,1104,1107,1171,156;34;F
24724;1166,1133,1201,1198,81,504,468,252,944,188,492,1570,864,156,454;36;F
24732;252,1439,75,843,141,103,663,142,530,1570;29;F
24740;152;44;F
24748;377,647,75,83,1300,252;40;F
24757;1570;64;F
24760;142,311,1734,141,1014,1004,1157,454,663,530,1570;30;M
24766;81,1138,252,1570;39;F
24768;1570;29;F
24812;1228,1138,252,288,1439,1171,1734,141,1570,103,1014,377,183,663,530;33;F
24817;75,83,1300,252,202,479,454,1541;49;F
24851;311,639,83,252,76,103,377,81,1158,1133,75,141,1014,142,530;45;F
24861;288,252,81,294,1258,1198,1099,1570,1133,1158,103,663,1166,866,530;36;F
24871;75,1258,83,1439,1419,141,1133,1158,1014,1260,183,454,1166,142,530;41;F
24886;1570;30;M
24893;311,377,1211,75,1258,252,76,1246,293,1419,647,1133,1158,1014,473;33;M
24901;76,1439,647,1004,183,473,142;52;F
24923;288,1246,639,1419,647,663,1439,1258,1133,1158;23;F
24938;1171,1099,141,647,1133,1158,35,377,1166,142,530,81,1107,1439,454;48;F
24939;1211,1246,479,293,773,1570,1158,103,35,1157,83,775,252,1207,473;36;M
24968;1104,647,377,1541;40;F
24969;289,294,290,479,293,1023,1017,377,183;51;F
24981;1198,157,530,775,202,1246,1201,773,492,141,1158,454;39;F
25025;157,1258,866,1246,1171,103;44;M
25028;83,252,311,152,377,1133,141,76,81,75,1158,103,1014,142,530;10;F
25050;290,188,1201,103,1107,454,288,1171,647,1570,35,473,1104,156,157;44;F
25061;75,81,83,252,76,311,152,377,141,1133,1158,103,1014,142,530;12;F
25065;157,252,1158,454,209,1104,202,1738,639,1419,1171,1570,1740,156,1157;43;F
25072;290,209,252,1374,639,1419,1171,647,1133,35,1017,473,663,292;46;F
25085;75,81,83,252,76,311,152,377,141,1133,1158,103,1014,142,530;46;M
25103;81,1198,75,1138,76,639,1171,1201,141,1570,103,473,454,866,530;39;F
25139;1198,76,1023,492,773,1570,103,35,864,454,866,1541;45;F
25158;647,35,1017,292,1166,1023,1099,663;48;F
25161;1419,647,1158,1157,1104,1246,1133,1014,473,663,292,141,377,142,530;42;M
25164;209;7;M
25165;647,1133,35,473,1157,663,530,202,639,1419,843,1171,1099,103;41;F
25189;209;7;M
25255;188,1246,103,152,156,1166,290,1228,1374,843,1171,773,647,1570;66;F
25278;75,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,183,530;72;M
25324;288,76,1246,311,1419,647,141,1133,1158,1004,35,1014,1017,454,530;18;F
25333;311,1107,479,293,1419,647,1570,156,454,209,1211,1201,35,473;38;F
25347;944,1228,81,1258,75,76,479,293,1171,141,1570,1133,1158,530,1104;56;M
25371;252,1246,1419,647,1570,1133,663,866,530;49;F
25379;76,479,1439,1133,252,288,1171,141,647,1158,1081,142,530,1246,1419;41;F
25416;1300,944,1246,1133,103,35,454,663,292,530;42;F
25469;1201,290,209,504,1138,775,1171,647,1570,1740,35,473,663,866,292;56;F
25472;1171,1246,1198,75,76,311,479,1439,1419,1201,1133,1014,454,142,530;30;M
25494;479,35,252,1211,76,188,1171,647,1570,1133,103,156,377,473,663;37;F
25567;1570,492,1419,188,1207,944,252,1211,202,479,103,156,473,293,647;34;M
25572;252,202,76,1246,1201,647,1158,1133,103,1014,1260,183,454,1166,866;38;F
25574;775,311,773,1171,157,209,252,288,1158,1260,473,530,1419;34;M
25614;468,289,1736,157,1211,188,1246,479,1171,1099,141,103,156,1017,473;33;F
25644;209,1104,468,288,1374,944,202,76,311,639,1171,492,1004,103;32;F
25706;141,1201,1171,202,1374,1258,1198,81,252,76,1246,1419,1133,103,454;48;F
25736;454,157,156;38;F
25746;454;73;M
25752;1246,288,1228,76,75;41;F
25762;843,1201,992,1099,1017,202,1374,252,290,293,1419,1570,1133,35,473;50;F
25768;1300,1138,76,311,293,1439,377,473,866,1201,141,103,454,142,530;46;M
25849;1104,81,1736,157,504,1738,773,864,1157,252,103,1228,1207,1246,1158;43;F
25855;468,1138,1104,294,1198,252,1207,293,1201,1570,103,35,1014,152,454;39;F
25861;1738,1258,288,1374,76,1246,1439,1419,141,1133,1158,1004,1014,142,530;29;F
25873;639,293,773,647,1158,473,1166,1211,252,81,76,479,1419,1201,454;37;M
25898;377;65;M
25911;1207,944,1138,1198,1258,468,252,1374,76,1246,1419,647,1133,454,1166;42;F
25915;1201,454,1738,1133,293;44;F
25919;1198,1734,1570,1228,290,504,288,76,843,1201,1740,1158,1157,454,292;44;F
25937;75,377,454,1541,1198,1228,252,1374,944,479,1201,773,1099,1017,1570;34;M
25939;1228,1138,468,1737,76,1246,1171,1099,647,1570,1133,156,454,663,1166;64;F
25976;1017,1157,454,1166,1081,1014,473,866,292,290,252,1246,479,152,663;44;F
25977;252,1374,76,1419,141,647,1133,103,866;44;F
25979;1133;21;F
26031;1004,141,454,142,530;37;M
26033;157,294,290,292,142,156,289,1737,252,76,1738,311,1023,35,473;40;F
26038;530,1014,75,1736,252,1207,76,311,141,647,103,35,1017,142;41;M
26039;76,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;64;M
26054;288,1374,1419,1734,1099,141,1133,1158,183,1166,468,252,639,377,1081;26;M
26069;76,81,75,1198,294,504,1207,202,1023,141,1570,663,866,292,530;60;F
26070;209,1211,202,188,639,479,293,1171,492,647,1570,103,35,473,663;37;F
26105;1138,252,188,293,492,647,1570,103,35,1260,156,377,183,663,866;33;F
26114;1737,1138,1228,1258,1104,1246,1734,141,1740,1133,1158,377,1166,142,866;51;F
26123;188,639,1171,1570;52;F
26134;1246,1133,377,183;53;F
26147;289,773,252,290,157,293,1171,1023,141,1570,1014,473,454,663;41;F
26155;1171,639,1258,209,252,944,1207,293,1439,1419,1133,1158,103,142,530;27;F
26161;141,773,1260,454;44;M
26172;1014,1258,1201,141,252,288,76,1246,311,1439,1419,647,1158,1133,530;37;F
26185;1736,83,1207,202,843,1171,1023,1201,992,773,492,864,454,866,1541;35;F
26187;1099,639,775,81,76,188,1171,1201,1014,152,156,473,1157,454,1541;40;F
26201;377;53;M
26221;1138,468,843,1023,492,1570,103,864,35,1017,454,663,1081,866,1541;37;M
26243;75,252,639,293,647,473,152;48;M
26260;75,1300,252,1374,479,293,141,1133,103,1014,152,1017,473,663,530;54;F
26297;157,1300,775,252,76,1246,773,1740,1133,103,1260,377,866;35;M
26308;289,1211,843,1171,1023,492,103,35;39;F
26346;252,1734,1157,1198,81,209,1738,1246,1171,1201,647,1133,473,454;43;F
26356;1246,1419,1201,454,1166,1541,1099,141,1158,377,663,1171,647,1133,103;28;F
26410;75,290,252,1374,202,76,479,647,103,1017;29;F
26428;1300,202,293,492,1133,103,864,1017,530,75,1258,1138,479,473,454;40;F
26436;35,1017,1158,1171,639,1246,202,504,479,141,1133,1004,1166,142,530;34;F
26456;202,252,468,209,75,83,1374,1207,1171,141,1570,103,1014,142,530;41;F
26466;1138,83,294,1736,1198,157,1258,209,775,639,843,773,103,1157,866;46;F
26497;1198,103,1260,152,454,504;49;M
26529;157,289,504,1138,76,843,492,35,290,639,1171,864,1260,292,454;42;F
26540;81,252,1734,1570,1740,473;39;F
26553;35,377,473,530;39;F
26583;81,1211,944,188,1107,479,1419,141,1570,103,156,473,142,530;32;F
26584;639,1198,288,81,290,1138,1419,1023,1201,492,1570,35,454,1081,663;36;F
26593;311,1246,209,1258,141,1133,454,142,530;43;M
26594;288,76,311,1419,1171,141,647,1133,142,530;44;M
26601;1439;38;F
26608;1738,1104,1211,1246,1107,1439,1419,1171,141,1570,1133,1158,156,183,530;39;M
26643;1107,1133,377,454,530,141;43;F
26649;1104,294,157,289,1228,252,293,1171,141,1570,103,156,473,663,530;63;M
26657;152;45;F
26667;1300,1104,1211,188,1107,293,1171,1023,1570,1133,1158,156,1017,183,530;36;F
26683;1198,1258,252,288,76,293,1439,1419,1201,1133,1158,1014,1260,377,454;40;M
26716;209;42;F
26725;156,1201,1171,202,81,290,209;37;F
26741;992,311,288,157,209,1211,76,293,103,35,156,473,142;35;M
26753;209;36;F
26754;209;37;M
26761;289,473,454,530,209,1541;37;F
26767;209;35;F
26818;290,288,1099,1541,473,1157,209;48;F
26851;663,473,1017,35,1023,1171,293,479,639,1738,202,1207,468,1104,209;38;F
26854;1133,1570,141,288,252,1258,290,209,76,1246,293,1419,1201,647,530;46;M
26867;292,663,454,1246,76,1211,1300,75,1258,83,1133,1158,103,1014,530;45;F
26881;473,1166,142,866,1419,252,209,76,1246,311,141,1133,1158,103,530;37;F
26905;75,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,183,530;64;M
26908;75,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,183,530;63;F
26912;289,647;20;M
26918;311,1246,1738,288,81,1258,1198,1138,202,1419,647,1133,103,864,454;46;F
26926;1158,1133,647,773,1201,293,76,252,83,1211,479,141,103,1014,473;42;M
26936;639,479,1017,530,1201,454,75,81,290,83,1374,76,293,1570,35;51;F
26948;1738,83,81,1198,289,288,530,75,311,1419,141,1133,1014,142,209;36;M
26974;1419,1246,288,252,504,81,141,1133,377,473,530,1207,293,35,152;42;F
26977;76,75,83,1300,252,1207;31;F
27002;1104,252,1211,202,141,647,35,152,473,454;43;F
27038;1198,1211,1023,292,1738;49;M
27047;209,1570;42;F
27065;209,639,1171,647,1570,473,1157,530,1541;42;F
27066;209;43;F
27086;209,1211,202,1171,647,473,663;40;F
27087;1198,492,1570,103,864,156,1017,473,454,663,292,1541;47;M
27100;290,252,1738,1246,293,1023,647,1570,103,35,1260,473,454,1541;52;F
27111;1198,468,1201,1734,773,864,156,1017,454,663,866,292,1541;12;F
27122;202,1738,639,1171,1201,1099,647,1740,76,1246,311,1419,1133,1158,377;24;F
27135;647,1740,1260,292,1374,252,202,843,1171,1570,156,1017,454,663,530;42;F
27138;1198,504,252,1734,492,1570,156,1017,473,454,663,866,292,1541;8;M
27162;1198,209,81,639,1171,647,103,35,473,1157,663,454,142,866,1541;47;F
27216;1570,1133,1157,454,504,1737,76,1246,1107,1419,1201,1740,1158,1004,209;38;F
27233;1740,1258,157,81,1104,252,1246,1107,1171,1734,1133,103,156,454,1198;82;F
27239;209;43;F
27291;1201,188,1374,252,1099,1004,1014,473,1157,454,152;42;F
27297;1740,290,504,639,1201,1004,454,142,294,75,1228,141,1133,292,530;50;F
27385;81,209,76,293,1419,1133,1158,35,377,473,663,1166;52;F
27440;75,209,288,76,311,1107,1439,141,647,1133,1014,152,1017;36;M
27443;639,1734,1736,1158,1081,1260,1133,1201,1246,202,252,1138,75,1198,142;25;F
27489;866,1207,288,157,1258,252,202,76,773,647,1133,1004,103,377,530;42;F
27504;75,81,83,1300,252,76,311,1099,141,647,103,473,1157,454;44;M
27510;209,473,35;44;F
27575;288,1300,294,75,83,311,1171,141,1004,1014,156,473,1081,292,530;47;F
27593;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;68;M
27603;647,1201,1171,843,1738,188,76,775,1258,209,468,252,202,1004,152;43;F
27633;1228,252,202,311,1439,141,647,1740,1133,1004,1017,473,663,142,292;44;F
27658;252,1419,647,35,156,1081,292,1211,944,293,843,492,473,454,663;40;F
27666;1198,288,83,75,76,1246,141,1133,1158,142,530,1737,1211,311,1419;54;F
27686;639,252,1260,156,1017,377,530,1736,1023,1099,1171,647,1570,473,663;45;F
27687;504,294,75,288,1246,103,473,1157,142,209;45;F
27698;1734,1158,1104,1374,1207,76,1246,311,293,773,141,1570,103,35,473;39;F
27741;1736,289,1133,1158,663,1166,142,866,530,1258,209,1246,1419,647,141;48;F
27747;647,1158,142,530,1439,1419,209;44;M
27759;1171,454,142,530,252,76,479,293,141,1014,152,377,473;38;F
27775;209;49;F
27776;1228,288,1738,1107,1023,1201,1570,1740,1541,1158,639,1171,1004,156,473;44;F
27842;1133,866,775,81,1198,209,1374,843,1201,773,492,864,454,663,1541;34;F
27843;1736,76,1246,1570,1133,1158,103,663,530,252,1374,202,1419,647;35;F
27861;292,35,288,252,1138,1736,290,504,202,76,639,479,647,1081,866;55;F
27862;209,775,252,288,1419,141,647,1570,663,142;36;F
27865;152,377,183;53;F
27894;252,311,1419,142,157,1104,1107,1171,156;38;F
27902;76,1133,647,209;40;F
27916;202,647,1158,530,1198,1104,504,288,1133,103,1260,156,1017,377,473;52;F
27921;647,1570,473,152;42;F
27958;1258,944,75,81,209,252,76,1246,311,1439,1133,1158,1166;40;M
28013;75,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,183,530;52;M
28036;103,1570,992,1171,639,294,252,944,76,293,1734,141,1740,377,183;58;F
28046;1158,473,1138,288,944,202,188,1201,492,647,156,1017,454,663,530;31;F
28056;75,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,183,530;40;F
28070;1246,1158,1157,454,1166,1258,209,1104,1419;8;F
28086;75,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,183,530;13;F
28093;1738,1246,1166,1258,209,1104;42;M
28110;75,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,183,530;6;M
28128;75,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,183,530;70;F
28164;492,773,1738,188,944,288,468,1300,209,1198,157,504,1107,156;33;M
28230;202,1023,1736,289,290,209;39;M
28278;1198,75,290,468,1374,1570,663,292,944,1158,1133,76,1258,209,1419;14;M
28282;1211,1374,288,468,1138,1104,81,1198,142,209,1133,1246,290,289,1258;37;F
28295;1171,864,1260,1081,866,209,775,252,1211,202,76,311,1419,103,454;29;M
28302;1419,1171,1570,292,530,1541,1198,81,252,202,639,1201,647,1133,454;39;F
28306;157,156;44;F
28370;1138,1198,1107,1419,1201,492,1570,35,152,156,1017,473,454,663,1541;35;F
28417;1198,504,468,944,1107,1201,773,492,864,454,866,1541;68;M
28428;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;64;F
28431;157,1107,1171,156,141,142,1104;47;M
28451;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;67;M
28461;1374,1228,1570,252;32;M
28467;1228,1374,202,1023,1099,647,1570,866,252;32;F
28475;252,288,202,76,311,1419,1171,647,1570,1133,35,454,530;36;F
28487;1201,152,156;39;F
28519;1738;15;M
28529;1738;16;M
28533;1738;32;M
28556;289,468,81,290,944,202,188,639,1171,492,1570,103,152,377,156;25;F
28572;209;37;F
28623;75,1198,252,76,311,1107,1439,1419,1171,1201,141,1133,1014,142,530;30;F
28629;1171,141,1570,1017,142,157,209,1228,1104,1738,311,293,1158,473,530;40;F
28647;639,647,1158,530,252,1246,311,1419,141,1133,103,454,663,142,866;29;F
28659;1138,468,1246,479,639,293,1419,647,1570,1133,103,1157,454,663,1541;17;F
28667;1246,479,647,103,1017,252;33;F
28671;1300,479,1419,1014,866,530;55;M
28691;81,294,290,1228,775,1737,252,1158,103,1260,454,663,142,1541,530;67;F
28719;473,103,1099,288,252,1211,1023,992,492,647,35,156,663,142,530;34;F
28730;773,1081,866,1736,209,252,1374,202,76,639,1171,1570,1740,103,1541;49;F
28753;647,473,663,209;37;F
28763;294,75,81,1138,468,775,1107,1201,864,454;66;F
28777;1201,454,663,1374,1246,479,293,1439,1419,1099,647,1133,103,473,252;16;F
28792;1211,944,188,293,1023,1201,773,492,1133,864,35,156,473,454,663;30;F
28832;504,290,288,944,188,293,1201,773,492,35,1017,156,473,454,663;3;F
28836;209;34;F
28837;1211,188,647,473;40;F
28846;188;36;F
28848;288,290,1419,992,35,1017,183,377,663,292,1541;67;F
28856;202,775,1737,1104,290,157,75,1258,1300,479,1171,103,1017,473,292;46;F
28882;293,663,157,209,775,252,1211,76,188,479,492,647,473,454,530;31;F
28888;1738;15;M
28890;142,156,1014,1158,141,188,288,775,468,209,1419,492,647;42;M
28891;1738;16;M
28908;1228,1258,1736,157,468,775,252,647,1166;29;M
28912;454,1258,202,1734,773,492,1740,864,1260,183,1166,1081,142,866,1541;33;F
28920;1740,1207,142,81,288,141,647,530,76,1166,183,1260,1201,1107,454;44;F
28927;468,209,1246,1419,1171,1734,492,647,1133,473,454,530,188;35;M
28937;1166,1133,843,290,1738;54;F
28948;75,81,252,141,103,454,530;48;F
28956;1081,141,530,1439,479,290,1258,202,1171,1201,647,1133,473,454,292;45;F
28980;454,252,288,311,1201,141,142,530;39;F
28989;209,76,639,1246,252,1419,1201,141,1133,1158,377,454,1166,866,530;37;M
29045;209,76,1419,141,142,530;42;M
29061;252,288,311,1201,141,142,530,454;40;M
29078;468,775,1300,83,1258,75,252,288,76,1171,141,1014,473,530,152;37;F
29079;663,473,864,492,293,479,639,1211,288,1258,290,1246,1419,1133,1158;45;F
29089;1099,775,1133;71;M
29101;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;80;F
29105;76,1171,1017,663,1258,202,293,141,1570,1133,1004,103,377,473,454;45;F
29143;530,663,454,1017,35,1133,647,1099,843,479,252,290,289,75,1201;47;F
29190;504,1570;58;F
29198;252,1246;36;F
29200;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;74;F
29204;1211,35,1014,1017,1541,530,142,1166,1081,1157,473,141,311,1207,76;48;M
29221;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;72;F
29229;775,647,1157,663,142,504;43;F
29234;504;61;F
29245;639,1171,209;41;F
29256;639,468,188,156,142,1419,141,1133,1158;42;F
29273;202,1081,866,1541,252,1374,311,1419,141,647,1570,103,663,142,530;31;F
29285;1419,663,473,1017,35,1133,1570,479,1207,290;50;F
29316;288,1014,454,1166,75,157,468,76,293,141,1133,1158,473,142,530;38;F
29323;1138,252,202,639,293,1201,647,103,1014,473,454;35;F
29339;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;70;F
29346;81,944,288,252,1211,311,293,103,864,156,473,454,663,1166,1081;28;F
29349;290,81,1258,1211,76,188,492,1004,35,1014,156,473,1157,663,142;43;F
29373;775,468,289,1736,1374,202,1201,773,141,1133,473,530,142;45;F
29383;1570,647,492,992,1171,1439,479,639,76,1207,1104,1211,188,473,209;39;F
29404;454,1004,1158,1133,141,1099,773,1201,1246,76,252,142,530;41;M
29475;639,311,1246,289,1104,504,468,252,288,1211,188,454,663,292,530;40;F
29499;252,1211,1207,188,293,647,103,156,377,454,530,1260,1246,1300,1258;34;M
29521;142,209;39;M
29528;293,1171,1734,1740,1158,1133,103,35,1017,377,183,473,1081,1541,156;59;F
29543;1228,288,1211,76,1419,992,1099,1740,1133,103,1014,473,1081,866,1541;66;F
29566;76,647,292,663,454,35,103,1133,1570;51;F
29608;504,1171,152,156;52;F
29625;775,252,944,202,1246,479,293,843,773,1099,1570,1133,1017,473,530;13;M
29632;81,290,1737,479,1201,647,1570,1133,377,1017,454,663,866,292,530;62;F
29635;479,293,492,35,454,1166,209,202,76,1246,1419,647,1570,1133,473;38;F
29640;142,1198,775,1737,1246,1133,530,288,1374,1260,454,663,1081,866,292;56;F
29670;1211,290,289,252,647,103,1017,377,473,1166;31;M
29687;992,1107,1738,288,1104,1736,209,311,1419,1171,141,1158,142,530,1541;39;F
29714;1258,209,252,479,1246,1439,1419,141,647,1133,1158,1014,142,530,311;34;M
29716;83,1300,252,1374,76,311,1171,647,1133,1158,103,1017,473,142,530;48;F
29733;1258,288,1211,1419,1171,35,156,473;42;F
29752;35,1246,1171,1201,141,1260,1017,454;34;M
29762;1541,1198,81,252,1419,1099,647,35,377,1157,454,1081,530;18;F
29768;1740,103,864,76,1099,1166,290,209,1107,1419,1171,647,1158,454,866;33;F
29775;1736,1300,1138,1211,1023,1099,1570,1004,157,1419,1198,289,1201,773,454;40;F
29780;377,454,1158,1419,1439,311,288,83,75,252,76,141,103,142,530;36;M
29821;293,1738,188,76,944,288,1228,157,75,252,1211,647,156,473,454;35;F
29830;1014,1017,1157,1081,81,288,1439,1419,773,1133,75,83,103,1300,76;18;M
29836;76,1419,1133,1260;41;M
29847;1133,103,454,288,252,647;29;F
29882;944,188,1171,1201,1734,773,492,1570,35,473,1300,468,1211,103,156;40;F
29896;1246,141,1133,1158,1570,992,293,311,288,252,290,35,473,663,142;43;F
29913;157,156;46;F
29928;1133,1171,75,252,1014,454;49;M
29936;1246,76,202,252,1737,775,289,290,647,35,1017,663,1166,866,530;30;F
29958;377,1158,1419,1246,775,252,454;68;M
29968;76,1246,647,103;45;M
29991;866,1157,454,1198,75,81,83,1737,252,288,311,1171,1099,1133,1260;19;M
30020;252,288,311,647,377,454,188,209;42;F
30022;76,188,209,1541;35;F
30054;1737,944,202,1740,1258,1211,188,639,1171,1734,492,1004,35,152,156;42;F
30064;142,1014,1133,141,1419,76,311,1158;27;M
30101;75,252,76,1107,1171,1201,454;52;M
30135;454,866;77;M
30152;1201,141,473;88;M
30165;1246,454,1171,1107,1104,157,252,141,377,663,142;43;F
30168;1258,209,1419,1201,647,103,454,142;43;M
30183;377,183;9;F
30217;1198,81,504,1138,468,775,944,1107,1201,773,103,864,454,866,1541;65;F
30224;504,288,1246,1133,1158,76,1419,1201,454,866;63;F
30231;1017,377,1157,866,292,157,209,504,1374,1107,293,1171,1734,1133,473;37;F
30235;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;65;F
30238;377,183;45;M
30241;377,183;14;F
30259;183,377;74;F
30280;377,183;75;M
30300;252,944,1570,1541;37;F
30311;1570,647,1099,1419,479,76,209;43;F
30373;1158,141,1198,1138,504,252,288,76,1246,1107,1439,1201,492,1133,454;45;F
30378;1207,1211,288,252,1198,290,1023,492,864,152,473,454,663,292,1541;40;F
30379;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;50;F
30411;1198,75,1258,76,311,1419,1439,1171,1201,1133,1158,1017,1157;40;F
30451;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;71;F
30461;1737,504,1228,76,1419,1099,647,1570,1133,1158,1004,35,1260,1017,1081;23;F
30470;1138,1246,1023,1133,1158,35,1014,1260,663,530,290,252,202,76,103;40;F
30500;1166,142,775,209,76,311,479,1419,1201,1133,1158,35,377,473,454;43;M
30510;775,288,1260,75,504,1201,454,530;53;M
30536;209;77;M
30570;1138,1198,81,252,202,1201,647,103,454,866;39;F
30598;1198,81,504,1138,468,775,944,1107,1201,773,864,454,866,1541;63;M
30615;639,1157,647,1738,1541;44;F
30639;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;14;F
30644;1439,1171,1017,530,290,209,83,1246,1419,141,1133,1158,1004,377,252;26;M
30651;1738,288,1158,1081,1541,202,1228,290,75,1258,1374,76,1246,639,1133;46;F
30658;1228,288,1023,1570,1158,1133,103,35,1014,1017,377,473,142,1166,663;26;F
30659;209,1541;36;F
30664;209,864,35,1014,156,1017,1246,311,1419,1166,142,530,1158,1133,1374;44;F
30687;1736,1198,1138,252,202,1201,1570,864,454,663,866;48;F
30705;663,1541,647,454,377,311,294,290,289,103,1736,1258,81,292,76;68;F
30713;1104,1300,294,1258,1228,252,76,311,639,773,647,1133,473,454,530;24;F
30723;202,188,156,473,663;41;F
30749;454;60;F
30782;1138,1737,479,1738,1107,292,81,1198,504,468,775,944,1201,864,454;45;F
30797;157,209;27;F
30807;209;44;F
30818;209,311,479,1023,141,1133,1158,294,1228,1419,35,1017,663,292,530;72;F
30819;157,293,773,647;41;M
30856;639,1201,454,1258,1300,468,252,1246,1419,1171,1133,1158,1004,864,1260;75;F
30888;157,1736,773,992,35,289,202,843,1023,1201,1570,1211,1419,663,473;36;F
30889;1014,142,1081,647,141,1107,311,468,1300,209,81,76,1201,454,530;42;F
30952;209,1201,773,1133,1570;45;F
30968;252,1374,454,1201,288,76,1246,1419,647;39;M
30971;76,293,1171,1201,1099,647,1570,864,35,1017,454,142,866,292,530;70;F
31025;1736,157,289,209,288,1374,202,843,1171,647,1570,35,473,663,530;38;F
31029;141,647,1014,1260,183,1166,142,252,1246,311,1419,1133,1158,377,530;31;F
31037;639,1171,1201,1133,152,454,1081,1166;50;F
31057;209;8;M
31061;209;6;M
31071;377,142,866,454,1133,1158,1260,141,647,81,252,76,183,1166,530;34;M
31078;468,1738,1081,866,1198,1736,252,1099,647,202,639,1171,773,1570,152;43;F
31096;479,1099,156,1017,473,663,454,530;47;F
31148;81,1107,157,1104,944,76,103,156,1017,530,142;43;M
31164;81,289,1738;47;M
31209;1374,288,1207,252,75,1300,76,311,103,152,1017,473,1157,454,530;45;M
31219;944,142,530,1017,156,103,76,1104,157,1107,81;8;M
31235;75,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,183,530;33;F
31293;639,1171,1201,773,492,1133,152,1541,290,209,944,188,1419,1570,156;32;F
31325;1201,864,454,1258,1419,1133,1158;18;M
31326;1133,454;44;F
31356;504,1138,468,944,202,492,647,1570,864,377,454,1166,866,1541;54;F
31370;209;35;F
31372;81,479;50;F
31405;1570;32;M
31427;188,288,504,1198,1736,81,1138,252,202,1107,992,1201,454,1081,866;47;F
31447;1166;44;F
31454;252,1207,76,1246,1419,1201,1570,1740,1133,1004,1014,1260,1017,454,1166;67;F
31463;1138,252,1570,1133,156;31;F
31476;1158,1133,647,141,773,1171,1419,1439,639,252,1258,530,377,1260,103;18;M
31488;1107,1246,1258,1198,1736,289,1138,775,252,1419,1201,1099,647,663,866;59;F
31491;1158,103,473,663,1570,773,639,1736,504,202,311,992,1099,454,292;18;M
31514;1228,1258,209,252,288,1207,311,293,992,141,647,1246,1419,1133,454;44;F
31547;1017,1107,252,1138,1228,1198,81,76,479,1099,1740,103,454,288,866;49;F
31559;454;73;M
31560;311,1738,252,468,1736,1570,1099,1171,293,479,288,775,290,76,103;40;F
31573;647,1166;24;M
31585;1099,492,639,1246,202,775,468,504,290,81,157,1133,1157,292,1738;46;F
31602;1099,293,141,647,473,454,252,288,202,311,1201,142,530;38;F
31627;1374,76,293,1419,1099,647,473,530;47;M
31650;81,209,1419;40;F
31664;209,288,1419,1171,647,103;43;M
31695;209;43;M
31701;1570,188,157,1258,81,1133,156,473,530,293,202,1211,1201,103,454;35;F
31740;473,1157,530,1541,157,1207,202,1246,639,479,293,1171,492,1099,1570;42;F
31752;1374,377,473,1246,1099,647,1570,1133,1158,103,35;26;F
31766;1246,647,866,1541,311,1419,141,1133,1158,377,142,530;42;F
31772;157,1104,1107,1171,141,156,142;47;M
31787;141,142,76,377,183;21;M
31818;1158;31;M
31903;1198,1228,504,252,288,1246,311,992,1133,530;41;F
31920;1738;50;F
31931;290,209,1737,1211,479,293,773,647,35,473,288,1207,141,142,530;45;M
31965;1738,76,202,1207,1211,288,504,294,252,773,1099,647,1133,473,1166;44;F
31994;311,1738,288,289,252,202,76,639,1171,1023,1570,473,454,866,530;52;F
32000;1198,157,1736,504,202,311,639,992,773,1099,1570,103,454,663,292;10;M
32006;1198,252,288,1374,944,202,76,188,311,1201,992,492,454;31;F
32033;202,311,479,1201,1099,141,647,1570,103,35,1017,454,663,142,530;30;F
32069;773,1246,1738,157,76,293,1171,141,1570,1133,1158,183,473,292,530;43;M
32109;209,468,1211,76,188,1023,1570,103,944,202,293,1201,156,454,663;37;F
32120;76,1246,311,1439,1419,1171,1201,492,647,1133,1158,103,454,142,530;37;F
32126;1300,252,1211,76,1171,141,647,1133,103,1014,156,1017,473,142,530;37;F
32158;1211,1023,1201,647,1570,35,473,454;46;F
32183;1300,1171,103,473,1157,142;38;M
32217;76,1419,1201,647;27;F
32236;1211,288,75,1158,142,530,293,647,103,473;42;F
32284;311;30;F
32291;83,1207,76,311,1439,1419,141,647,1133,1158,103,1014,377,142,530;36;M
32292;209,1198,188,1246,639,293,1171,1201,773,492,647,1570,152,454,866;41;F
32304;252,647,530;44;M
32305;1419,76,468,157,1198,311,252,209;39;F
32321;1104,76,142,1158,1133,1570,141,1419,311,1258,75,209,1374,1738,1246;31;F
32355;76,311,1246,1133,103,1260,473,454,530;24;M
32364;1734,1004,1258,1300,1738,311,1419,1171,773,1014;34;M
32372;202,252,1736,1104,1138,76,639,843,663,1166,530;58;F
32376;1166,103,1570,1246,76,288,252,209;48;M
32386;1014,1300,311,1419,1171,647,1133,81,83,530,76,202,75,252,141;52;F
32392;473,1171,1439,293,639,1374,1133;29;F
32408;157,1211,76,293,1419,141,1570,152,156,1017,473,454,142,530;40;F
32424;1198,157,81,209,1419,773;40;F
32435;647,76,479,1171,103,1017,473,1157;21;M
32443;75,647,103,377,142,288,76,1133,1419,141,530;22;M
32450;141,1133,1158,1166,530,142,209,252,76,1419,647;38;M
32477;76,252,83,75,1258,209,1246,311,1419,1133,1158,1014,377,142,530;45;M
32480;647,1570,183,473,1166;47;M
32489;142,530,1260,1014;31;M
32554;377,1158,311,1738,1138,1228,294,288,1374,202,76,1246,1570,1133,663;59;F
32560;1014;33;M
32588;1017,103,647,141,530,1014;35;M
32596;103,1570,647,141,479,1246,188,202,944,1374,252,1737,468,289,1258;35;F
32622;866,377,1260,1014,1158,1419,1439,76,288,83,75,311,141,142,530;32;M
32674;1104,1246,1107,639,1419,492,141,647,1133,152,1017,473,142,530,156;50;F
32691;75,1300,252,1246,103,183;47;F
32693;1736,1198,157,1258,775,1246,1201,773,1158,1004;50;F
32695;1133,1158,1246,252,209,377,454,76;41;M
32705;1171,647,252,76,843,454,866,1133,773,1207,202,468,209,81,1736;44;F
32742;504,1171,141,1740,1133,1004,142,290,1228;58;F
32836;647,293,479,202,252,473,454,103,156,1014;33;F
32853;252,76,1419,647,1158,377;30;M
32855;76,289,292,83,293,157,75,1258,252,1207,479,103,1014,1017,530;40;M
32990;209,479,293,1171,35,473,1157;42;M
33006;75,81,288,76,311,647,1260,1166,1198,1300,252,1107,1201,1014,454;61;M
33008;647,35,1166,866,1541,530,468,775,1737,944,103,156,473,663,1081;40;F
33013;311,1419,76,473,142,530;42;M
33036;289,76,293,1439,1133,1004,1017,473,290,35;69;F
33055;1736,81,209,76,1738,1439,1419,1201,647,1133,1004,103;38;M
33073;1419,103,530;31;M
33088;1738,1419,992,1740,530,454,103,1158,1133,647,1201,311,1207,81,209;8;M
33105;1736,81,252,1207,76,1419,1171,1201,647,1570,103,35,454,530,209;8;M
33122;311,1246,992,1099,1740,1004,864,1081,377,1201,288,1014,141,142,1158;35;M
33135;1570;48;F
33170;81,209,252,1207,76,1171,1201,647,103,35,454,530;6;M
33189;293,1017,473,141,530,1738,1107,1419,1171,1201,1570;38;F
33193;639,1171,1740,1004,35,156,1017,473,454,292,294,1228,504,775,1737;44;F
33240;1541,1439,1738,1374,1737,1104,290,1258,1246,1419,1171,1133,454,209,1166;46;F
33246;1171,647,1570,1133,103,35,1014,1017,473,454,663,75,288,76,479;40;F
33248;775,1419,1570,647,103,454,663,1166,76,311,293,35,1014,473;43;M
33259;479,103,76,83,75,1133;50;F
33268;468,209,1228,1211,944,1246,293,1171,1734,35,156,473,663,188,1541;28;F
33289;468,504,81,1258,1300,1104,252,1246,1201,1099,103,1260,156,454,663;68;F
33298;1260,1014,647,288,75,83,1300,252,76,141,103,142,530;42;M
33307;75,1300,1246,293,1023,1201,1099,454,530,1171,773,492,103,1014,152;44;F
33308;1138,288,76,1246,1419,141,647,1133,1158,1014,473,1157,454,142,530;42;F
33325;252,1171,1023,35;32;F
33326;142,530;41;M
33384;294,1736,188,202,468,1228,290,1171,647,1570,103,156,473,454,292;69;F
33401;1201,647,1133,866,1541,75,252,288,76,311,141,1004,1014,142,530;58;F
33420;76,530;44;F
33421;1171,1023,141,1133,103,1017,454,663,1166,292,530,647,35,473,142;45;F
33422;289,843,1023,1099,35,1017,663,292;47;F
33430;1133,1246;25;M
33472;1207,1246,76,141,1133,1158,142,530,1258,252;47;F
33474;75,81,83,252,76,647,103;48;F
33475;75,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,183,530;35;F
33545;76,773,141,473,530;45;M
33553;1419,1158,377,1246,1133,1738;35;M
33565;1736,209,202,188,663;37;F
33572;289,81,775,76,311,1023,1201,773,141,1570,103,35,454,663,292;53;F
33583;75,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,183,530;24;F
33599;288,188,1099,103,454,468,1211,1107,293,1201,492,1570,35,156,473;40;F
33636;1738,76,944,775,1138,1198,202,1211,209,647,1570,1004,103,1017,473;42;F
33643;290,209,468,188,103,473,663;41;F
33647;1300,142,1171,75,1157,183,1158,1133,141,1419,76,288,1104,1260,530;27;M
33688;157,209,76,454,663;43;F
33739;76,1133,1158,454,530,209;48;M
33753;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;63;F
33763;1258,1104,1246,1419,1260;77;M
33789;81,202,311,1201,141,647,1570,1133,103,454,663,1081,142,866,530;33;F
33793;75,1258,1246,1419,1133,1158;45;M
33799;1158,35,1014,142,866,530,1201,311,1246,1258,76,288,252,454,663;31;F
33802;1419,1570,292,1228,1439,843,377;56;F
33825;1300,1014;39;M
33839;252,288,1211,866,1099,1246,289,647,1133,1419,1570,1171;31;M
33860;1017,1157,663,292,289,290,83,252,76,479,1201,647,454,142,530;50;F
33866;76,1099,1158,454,1166,209,156;48;F
33885;1104,1207,76,311,639,1439,1419,1171,1201,141,1158,1014,473,142,530;33;M
33891;663,142,1419,1258,377,252,288,76,1246,311,647,1133,1158,103,866;35;F
33955;290,775,1107,1439,647,1570,142,209,1419,1171,1099,1133,1158;50;F
33962;1570,1158,1014,156,75,944,1138,1300,252,202,76,1738,1133,377,454;32;F
33966;142,530,288,1211,76,311,479,141,1014,473,454,1081;36;M
33971;1737,141,1158,1014,454,142,530,639,1374,479,1171,1099,647,1017,473;44;F
34028;142,290,209,1439,1171,647;39;F
34036;1099,311,1133,1570,663,530,142,1166,454,1017,1201,1246,288,252,290;58;F
34083;468,1228,290,1258,530,473,1017,1171,293,639,1246,1023,647,454,1133;46;F
34111;1570,1201,1419,1300,209,188,492,152,156;34;F
34130;157,1104,1439,1419,1099,141,156,454,663,142,530;45;F
34137;311,1736,252,647,663,1081,530,1374,1738,1246,639,141,1133,1158,864;43;M
34202;530,311,293,1004,1014,75,290,252,202,1099,473;51;F
34243;1198,944,311,639,1171,35,142,293,1201,492,1133,1158,530,473,454;33;F
34349;1138,290,76,1246,1133,663,292,504,775,944,1201,864,454;75;F
34354;944,504,1211,311,1201,1133,1570,1158,142,530,1014,156,473,454,663;4;M
34472;1133,1158,35,1014,1017,183,1104,639,1439,1171,647,377,1157,142,1570;36;F
34489;530,454,1133,1201;45;F
34512;157,156,1104;59;F
34520;1439,454,209,639,1171,292,252,288,202,188,1419,1133,152,156,473;45;F
34555;1158,1004,377,1258,81,252,76,1107,293,1419,1201,1133,1157,454,530;42;F
34576;81,76,1439,530,75;47;M
34585;1211,1246,530,1541,1738,188,252,157,76,639,1419,1171,152,156,292;45;M
34598;1198,81,504,1138,468,944,1107,1201,773,492,864,454,866,1541;76;F
34612;141,1014,142,1201,75,1300,1439,1246,377,1158,1133,209,76,1419,530;40;M
34614;468,202,188,1171,773,492,647,156,473,1166;68;F
34656;1014,209,252,76,1246,293,1419,1171,1201,141,647,1133,1158,103,864;34;M
34714;1014,141,83,75,530;6;F
34721;188;74;F
34747;188;26;F
34748;1374,202,76,141,647,1133,1158,103,35,1014,1017,663,1166,142,530;28;F
34771;1017,1157,1081,1734,1171,639,1107,311,1258,530,288,1419,1099,141,647;28;M
34777;188;23;M
34787;1419,157,209;53;M
34799;1258,1300,252,1211,864,663,1158,1133,1419,1246,1738,76,288,157,209;37;F
34804;1258,209,1228,1104,1738,1246,1004,35,1157,454,311,1439,1419,1014,377;34;F
34824;1198,1258,252,202,1246,454,1541,76,479,1740,1133,103,473,1166,866;52;F
34849;290,75,1300,252,1211,479,1171,492,647,103,156,1017,473,454,292;41;F
34862;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;71;M
34881;468,252,1734,773,492,1099,647,1133,103,1014,156,663,1081,1166,530;35;F
34892;141,454,142,530;43;M
34909;1201,1171,1014,1004,530,468,454,311,152,141,81,76,75;38;F
34924;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;77;M
34937;1198,1300,1211,944,202,76,188,639,293,1171,647,103,473,454,530;35;M
34974;944,1439,1419,1201,492,1133,1158,103,864,1017,377,454,663,866,1541;85;F
35040;289,76,35,1017,454,663;35;F
35043;188;41;M
35054;293,1439,1419,530,209,75;46;M
35057;252,76,311,1439,647,1133,103;25;F
35134;252,288,1211,1419,1171,1023,1734,492,647,35;35;F
35136;209,1004,35;32;M
35143;1737,775,81,157,294,290,209,1246,1023,492,647,864,473,454,663;41;F
35157;289,1258,530,1023,1570,35,1017,663,142,292;57;F
35247;290,209,1211,647,473,530,1541,188;38;F
35250;292,530,1228,75,1736,290,252,202,843,1201,647,1570,473,454,663;43;F
35267;1419,647,1133;41;M
35303;1166,1258,504,1138,775,252,188,1419,1201,141,1133,1158,864,454,530;25;M
35308;188,76,311,1439,1419,1133,1158,1014,377,1166,1246,141,1004,142,530;28;M
35310;1246,289,290,775,1374,202,76,479,1099,647,1740,35,1017,663,1541;41;F
35327;843,866,292,663,1736,290,479,103,141,142,530;57;M
35367;1107,311,81,252,647,141,1158,454,142,530,1374,288,1246,1201,103;26;F
35391;209;9;F
35392;75,639,492,103,1138,504,288,1211,1171;44;M
35396;202,76,81,83,252,103,377,183;12;F
35403;1171,1099,492,647,1570,1740,35,1014,1017,473,454,663,1081,866,292;37;F
35405;1258,1198,294,81,209,639,1171,1023,1740,1133,1017,473,454,663,292;43;F
35419;209;50;M
35420;141,188;47;M
35425;188;47;F
35427;103,377,454,530,1198,81,252,1374,76,1246,1419,141,647,1133,1158;26;F
35443;83,252,1374,843,1099,141,647,1570,1133,35,1014,1017,142,292,530;40;F
35459;454,663,530,1166,473,377,1017,35;38;F
35460;76,311,1439,1171,1201,141,454,142,530;36;F
35466;1171,141,1158,1004,103,152,1017,473,1157,1541,288,1246,1133,142,530;34;F
35490;1201,773,141,454,530;44;F
35502;141,647,1133,377,183;28;M
35509;209,202,75,76,81,83,252,103,377,183;15;F
35514;1258,1211,1419,1158,1374,1246,647,1133;33;M
35539;289,290,479,1023,1570,1158,35,1017,473,454,663,292;61;F
35545;1138,1300,1198,75,81,288,76,1570,1017,473,454,530,1541,1258,290;49;F
35555;288,492,141,1570,864,156,142,1198,1138,468,944,1201,1734,454;37;F
35571;492,1014,156,75,188,1300,468,141,1133,530,775,1374,944,864,152;46;M
35585;468,1104,1258,157,81,1138,775,773,492,1570,1004,156,473,454,530;45;F
35593;1439,1246,468,504,75,1300,1211,188,1738,1419,1171,103,156,473,1166;32;F
35596;468,504,157,188,492,156;42;F
35601;188;35;F
35621;188;57;F
35625;1133,294,1246,639,1171,1099,1740,1014,252,1736,202,647,35,377,530;33;F
35629;639,1439,1419,1734,141,1570,1740,1004,1260,377,183,454,663,142,530;37;F
35635;311,479,293,141,1017,473,454,142,530;39;M
35638;188,454,663,75,1300,468,288,1211,944,76,1439,1419,35,156,473;27;F
35642;252,944,76,188,141,1133,473;34;F
35651;1207,1138,1258,1198,1736,1228,1246,1201,1734,1133,1004,1260,530,75,1300;46;F
35657;252,311,1570;37;F
35668;468,252,188,1738,639,1171,773,492,864,156,663;31;F
35683;288,141,1740,156,142,530,504,775,773,492,1541,1201,454;65;F
35702;188;29;M
35753;1300,1207,479,1201,647,1158,103,1017;24;F
35773;663,530,1138,252,944,202,1738,1246,311,639,1419,1171,1201,492,1133;35;F
35782;1133,1258,1171,647,76,1246,1158,103,142,530,209,504,944,1419;32;F
35790;188;35;F
35791;292,1099,76,293,1201,1014,152,473,866,75,103,454;8;F
35815;76,141,1158,103,377,142,530;46;M
35825;209,1541;8;F
35830;1158,311,1198,454,530,992,1737,288,1138,252,202,76,1201,1740,473;67;F
35835;1207,188,293,1201,1734,773,492,647,1570,1133,103,35,156,473,454;31;F
35839;188;9;F
35879;944,311,1107,479,1201,473,454,1211,188,293,1419,1171,492,103,156;36;F
35921;188;6;M
35925;293,992,492,1099,647,1570,103,35,156,1017,473,454,663,292,530;41;F
35936;288,290,1258,75,289,252,1419,843,647,1133,103,35,1017,183,663;28;F
35979;252,209,290,1736,289,202,1419,1133,35,1017,377,663;31;F
35991;288,468,504,1300,944,202,639,530,473,156,152,1171,188,1211,1374;38;F
36005;76,141,103,142,530;55;M
36011;473,663,1081,142,530,157,1258,1104,1211,76,311,647,103,35,866;36;M
36016;209;34;M
36033;188;42;M
36035;639,1419,1133,156,1166,492,1171,157,81,944,76,1201,473,454,530;32;M
36049;290,209,252,288,1738,311,843,1099,141,1570,35,663,142,292,530;48;F
36052;188;41;F
36053;288,504,1246,647,1570,639,1171,141,1133,1158,103,377,1157,142,530;34;F
36066;252,76,1419,1133,156,454,530;32;F
36074;81,1198,288,311,843,1171,1201,141,454,142,530;49;F
36091;504,1138,775,773,454;56;F
36097;1133,1158,1419,1246,1166;35;F
36099;35,156,1017,473,454,530,1138,252,1211,188,639,293,1419,1171,866;34;F
36122;202,183,473,663,1166,142,866,530,1138,252,1023,843,1738,1081,647;51;F
36127;1738;52;M
36128;1198,81,504,1138,468,775,1207,1107,1201,773,492,864,454,866,1541;73;M
36142;647,103,1014,156,473,454,1081,81,294,75,479,1017,142,141,530;49;M
36157;188;34;F
36162;1171,1099,1017,843,141,1133,35,663,142,530,1138,252,202,1246,639;36;F
36169;288,639,843,1099,473,252,1374,1246,1419,1171,1133,35,156,1017,1157;42;F
36172;1258,76,141,530;59;M
36176;76,1541,530,142,1133,647,141,1099,103,1014,252,479,1260,183,1166;32;M
36180;504,1138,468,252,1211,76,1246,311,479,647,1133,103,156,1017,473;35;M
36186;252,1171,1201,1570,1133,663;46;F
36211;1211,1246,1439,141,1133,1158,473,1166;46;F
36237;468,1104,209,81,1258,504,252,76,639,1171,103,156,473,663,530;34;F
36245;1158,141,1439,311,1133,530,1419,142;27;M
36249;252,1211,1738,1246,1171,1734,773,492,647,103,473,1157,454,530;36;F
36252;647,1258,157,75,1198,1211,1099,468,479,1171,1201,156,663,1081,530;22;F
36287;156,103,293,944,1211,252,468,473,35,663,1541;47;F
36296;75,1258,504,252,1246,293,1419,1171,141,1133,103,473,142,530;45;M
36303;288,76,75,103,141,1014,142,530;38;M
36311;1419,141,1133,1158,530;29;F
36316;1099,1734,1023,293,202,1138,1300,209,252,1211,944,188,492,647,1570;33;F
36319;81,76,1419,1201,1260,454;31;M
36333;288,1258,1300,1374,202,1246,1171,1099,1133,103,1014,1260,156,454,866;33;F
36347;81,1734,773,492,647,1570,1133,1158,103,864,1017,473,1157,1081,530;26;M
36391;35,156,152,293,76,944,1374,468,1104,209,1258,288,1171,647,473;42;M
36398;1171,773,492,141,647,1133,1004,1260,152,156,1017,473,1157,142,866;75;F
36424;289,1300,468,252,288,944,188,1171,492,647,156,454,530,1081,1166;30;F
36430;294,1228,775,866,1570;75;M
36456;468,81,252,944,202,293,1171,1099,647,1570,1133,156,473,530,188;36;F
36460;1198,76,1107,1201,103,35,454;79;M
36461;1198,504,1138,944,1107,1023,1201,492,1570,864,1017,454,866,1541;47;F
36469;1734,1171,639,1107,311,1246,1738,188,76,944,1211,775,468,157,209;41;F
36473;1198,290,1138,843,1171,1201,992,152,864,1017,473,288,944,454,188;48;F
36476;468,252,288,1211,944,202,479,1419,1201,492,141,1017,377,454,142;57;F
36481;202,504,1104,1300,209,290,81,252,1246,1419,647,1133,1158,103,1166;38;F
36482;1166,311,294,1228,775,288,992,1201,1570,1740,454,1081,866,292,530;45;F
36492;647,1133,1014,1157,1300,76,1246,1419,1023,141,1158,35,663,866,292;48;F
36494;1228,1138,1201,992,1081,866,1133,454,292,311,647,1570,1166,530;75;F
36498;75,1207,76,1439,1201,141,103,473,454,142,530;35;M
36510;504,1228,775,252,76,639,141,647,1004,1133,103,473,1157,663,866;30;F
36520;639,504,468,288,1246,1171,141,647,1133,1004,864,35,1017,473,530;24;F
36527;141,530;34;M
36537;454,141,142,530;28;F
36588;1419,141,1158,1133,103,1017,473,311,142,530;48;M
36595;311,1419,1133,1158,1014,142,530;55;F
36604;290,209,141,103,473,530;39;F
36619;103,1166,530,252,1246,647,1133,663;35;F
36655;1157,377,944,468,1300,843,1419,202,289,209,290,639,1171,1570,1166;36;F
36661;1734,647,1570,1133,1158,103,377,142,252,1246,76,479,1081,1166,530;41;M
36685;1374,252,1738,1171,141,1740,1014,1260,1017,183,663,1081,1166,142,530;43;F
36694;992,1201,479,639,1207,288,290,1419,1004,1133,103,473,663,142,530;47;F
36695;1228,288,1246,141,1133,1570,142,530;47;M
36762;103,35,156,1017,473,1157,1081,292,157,1258,468,252,843,1171,1099;39;F
36778;1258,1734,773,141,1740,1004,103,864,1014,152,156,454,142,866,530;48;F
36785;76,288,1258,81,252,1419,647,1570,1133,1158,103,1157,473,663,454;41;F
36805;479,293;40;M
36811;1166,202,639,1023,992,1099,141,1570,1158,103,35,1017,663,142,530;40;F
36818;1211,944,76,188,1246,293,1171,1133,103,156,1017,473,866;33;F
36830;252,479,647,1570,1133,1158,103,1014,1017,473,454,663,142,292,530;52;F
36859;504,252,288,209,1246,1419,1133,1158,473;36;F
36863;1004,1171,1419,639,311,1246,1258,468,252,1211,944,188,454,1166,1541;3;M
36866;1201,647,473,454;40;M
36879;479,647,289,290,35,1017,473,1166,292;46;F
36883;209,944,202,76,188,311,639,1439,1171,1201,1570,103,152,454,1166;27;F
36890;1166;66;F
36892;75,157,1104,288,1107,479,293,1133,1158,454,1171,141;33;F
36903;1258,1104,202,1246,1099,103,156,1017,473,663,292,1157,454,1133,530;24;F
36913;1734,1166,103,843,639,76,1207,1138,1258,1246,1570,1133,1158,1081,1541;33;M
36928;157,944,293,1171,492,156,473,468,647,377,1157,866;40;F
36936;209;44;M
36951;209;10;M
36952;1419,1570,103,35,473,1198,209;39;F
36963;252,1419,1099,141,647,1133,1158,103,1014,156,1017,454,142,530,1541;23;F
36982;75,83,288,76,311,1419,1171,141,1133,103,1260,1017,377,473,530;18;M
36988;1258,290,468,288;53;F
36991;209;8;M
36998;209;4;F
36999;944,1198,76,1246,293,1201,647,1570,1158,103,35,1014,473,454,663;35;F
37016;1158,103,1017,663,142,292,530,288,1374,76,1419,1171,141,377,1166;44;F
37030;252,663,639,1201,1133,473,454,866,292,202,1171,647,103,142,530;42;F
37055;1171,311,1738,288,1104,468,775,1211,76,479,293,1419,156,473,188;35;M
37104;81,1419,141,1158,1014,83,252,202,76,311,647,377,473,530,75;79;M
37120;992;23;F
37123;1211,76,1246,293,1099,647,1133,1158,473;30;F
37125;1133,530,142,141,1419,1246,473,468,311,293,288,188,103,156,76;38;M
37141;157,1258,775,288,1246,1201,773;22;M
37149;1198,81,1133,141,1004,1260,1014,473,142,530,157,1104,1107,1171,156;8;M
37169;1138,290,157,504,775,944,639,773,492,1570,864,152,1157,866,1541;37;F
37171;156,1171,1107,1104,157;66;F
37173;639,1099,141,1133,1158,252,288,1374,202,1201,647,1570,1740,103,454;38;F
37212;1133,530,1419,1246,473,468,311,293,288,188,156,142,141,103,76;39;F
37218;152,1014,83,1300,1737;47;F
37263;289,1258,75,1158,103,142,530,1133,647,1419,311,1246,76,1207,252;30;F
37280;1158,1246,288,311,1570,156,377,81,1228,504,775,1201,1157,454,530;32;F
37291;1246,288,293,290,1138,639,1171,1201,1099,1017,454,663,866,292,1541;48;F
37313;152;38;F
37321;1258,1104,1374,188,1246,843,1171,1201,492,1099,1740,1133,1004,156,454;39;F
37348;76,141,647,1158,1133,530;18;M
37355;377,864,1198,81,504,1138,252,288,1107,1171,1201,992,454,866,530;49;M
37392;288,944,1201,1734,1740,1260,156,377,183,157;63;M
37393;252,141,103,1014,142,530;52;F
37403;293,1171,773,473,454,142,530;48;M
37420;1207,1738,141,1133,530,75,1258,81,83,1300,252,76,479,1439,103;49;M
37424;288,83,75,1258,1246,1419,1133,1158,142,1198,252,141,103,454,530;25;M
37426;75,1300,1104,252,293,1201,141,647,1570,1133,1158,103,1014,152,454;41;F
37432;1258,252,76,311,1439,1419,141,1570,1133,1158,103,142,530,1541;39;F
37461;1570,864,1157,1081,1541,1198,289,290,1300,1138,944,1738,1171,156,152;50;F
37462;311,141,1133,1158,1014,142,530;36;M
37469;639,468,1228,504,1138,944,202,1107,1023,1201,773,492,864,454,156;64;F
37477;311,1258,252,76,1246,1439,647,1158,103,1166,141,1133,377,142,530;48;F
37504;530,142,1081,1133,141,1419,479,1246,76,288,252;27;M
37507;1157,454,504,468,288,188,773,152,156,866,1570,492,1201,944,209;11;M
37518;157,1104,1107,1171,156;34;F
37522;83,1104,288,1211,76,1246,1419,647,1133,1158,1014,473,1166,866,530;40;F
37550;492,1158,183,1166,157,1104,1107,156;69;M
37552;75,141,1133,1014,156,1439,1419,142,530;39;M
37568;209,75,1258,76,1246,1419,141,1133,103,530;24;M
37590;647,209;31;M
37592;1166,663,473,1017,35,103,1099,1023,293,479,1374,81,289,290,209;35;F
37619;1166,1258,75,209,1300,1207,76,1171,141,103,1014,377,663,142,530;40;M
37637;1198,1171,1201,1374,866,252,1738,647,103,1246,141,142,530,1133,1419;38;F
37640;843,1171,1023,1201,1133,1158,773,1099,1570,454,35,156,530,1017,473;42;F
37643;1166,1541,1738,1246,1439,647,1740,1211,1419,1171,1099,1157,473,142,530;38;F
37657;1157,1004,1419,1099,1158,1171,647;44;F
37665;647,1099,468,1211,1207,188,639,293,1570,35,156,1017,473,663,1171;36;F
37687;468,1138,290,81,289,157,75,775,1439,1099,103,864,1017,1081,292;45;F
37694;156,473,454,1081,188,293,141,647,103,152,377,142,530,209,1570;43;F
37695;252,288,188,1419,1004,35,156,152,454,1166,293,473,647,1570,209;45;M
37712;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;49;M
37719;1171,35,473,209;51;F
37731;1158,156,290,157,81,209,252,76,1246,1419,773,647,1133,473,663;49;F
37739;289,1258,209,504,1374,76,1738,311,1419,1099,141,1004,156,142,530;47;F
37758;288,76,479,1171,647,1570,1740,103,35,1260,377,473,1157,142,530;49;M
37761;1158,377,530,252,1246,293,1171,492,647,1133,103,1014,473;39;F
37769;1166,1081,454,377,288,76,1419,141,1158,1133,530;28;M
37778;1138,504,311,1107,1419,1099,1740,1158,864,35,1017,454,663,866,292;62;F
37808;1738,639,479,293,1133,663,1014,75,1228,188,1171,492,1570,103,156;33;F
37844;202,76,1734,1133,1004,377,252,1099,647,1740,103,454,1166,142,530;43;F
37848;188;34;F
37859;157,639,1107,1171,209;39;M
37869;289,290,1246,311,639,141,647;27;F
37897;504,1737,252,202,1738,1246,647,1570,1740,1158,864,1017,454,663,142;26;F
37908;252,202,479,1570,35,1017,663,1081,292;25;F
37909;1166;44;F
37912;1374,1570,1133,1166,1198,1258,209,1104,1419,1201,141,647,1158,142,530;36;F
37916;252,647,1133,103,473,1166;23;M
37940;288,1211,639,1171,1201,1004,1014,152,156,473,454,663,142,292,530;38;F
37952;209;37;M
37970;944,1198,1157,454,639,1171,209;37;F
37975;468,252,188,293,1419,1171,1023,492,647,1570,35,156,454,663,530;34;F
37978;76,1171,209;8;M
37980;252,1246,311,1133,35,1260,183,530,76,1419,647,1158,103,1017,377;30;F
37986;1198,81,290,202,76,479,1419,1201,141,647,103,454,142,866,530;29;F
37991;76,1246,639,1171,647,1133,1004,103,1014,156,183,473,454,142,530;29;F
38013;290,252,288,293,843,1171,1201,156,473,530;33;F
38017;1171,103,1157,663,1570,35;28;M
38022;530,1166,1260,1133,647,1419,1107,311,1246,76,288,1258,81;25;F
38034;76,311,141,1158,473,142,530;80;M
38066;141,1158,530;37;M
38067;1211,157,209,468,252,288,1738,1246,141,76,1133,473,454,142,530;35;M
38085;1246,311,479,1419,1171,141,647,103,377,183,1166,142,866,292,530;26;F
38086;209;47;F
38105;1258,288,1246,141,647,1133,183,142,530;31;F
38139;1166,1211,288,504,76,311,1419,1734,1740,1133,1158,1260,377,454,663;39;F
38175;492,647,864,377,75,202,76,843,1570,1258,252,288,1246,1419,1133;46;F
38193;1258,944,1207,202,1738,311,1246,639,1439,1419,1099,141,1158,1133,103;37;F
38194;775,1258,157,81,209,1104,1738,1246,1419,647,1158,1004,35,1166,530;70;F
38196;775,1099,81,454,530,75,1258,76,188,1246,1171,1133,1014,156,152;50;F
38199;1246,1374,81,252,288,141,1133,103,1157,454,1166;32;F
38212;1198,81,1228,1138,202,1107,1201,141,864,1157,454,866;39;F
38226;76,141,142,530;62;M
38238;1198,311,293,141,647,1570,1133,35,454,142,292,209,76,1099,530;47;F
38241;75,157,1104,76,1107,293,1171,141,1570,1133,1158,156,183,530;31;M
38244;188,293,1201,647,156,473,454;37;M
38245;76,1246,293,141,1158,142,75,1258,81,1107,1439,1201,1260,454,530;41;F
38261;76,141,35,377,473,142,530;27;M
38267;1246,504;68;F
38293;944,103,183,156,377;20;F
38301;1541,530,103,1570,1171,76,252,775,83,209,75,1374,1017,1166;45;M
38327;290,1300,1211,944,479,1171,492,1099,35,152,156,1017,663,1081,530;38;F
38344;75,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,183,530;56;M
38363;639,1439,141,647,1158,1004,103,1157,530,252,1419,1133,1014,142,866;25;M
38367;252,288,76,1246,311,647,1133,530;38;M
38391;1104,252,1374,1207,647,473,292,530;39;F
38405;288,156,454,157,1171,1734,1740,1133,473;37;F
38413;1736,252,202,639,1171,647,1740,103,35,454,663,1081,1166,530,1541;33;F
38420;311,1158,1133,454,1166,142,530,252,157,1171,1734,773,141,647,1570;35;M
38444;530,311,479,293,1419,141,647,1570,1133,1158,103,1017;30;M
38455;252,1374,76;30;M
38462;103,311,288,775,1138,377,866,1211;35;M
38470;1246,1171,1099,141,1004;23;F
38480;1374,76,1246,639,293,1171,1570,1133,1158,103,35,156,1017,473,663;19;F
38482;1570,1158,83,252,1246,479,1419,647,1133,103,1017,377,473,663,1166;54;M
38501;152,292,504,188,639,1171,103,35,156,1017,473,454,663,142,530;44;F
38518;157,81,1300,252,1211,479,141,647,103,1014,156,377,473,454,1541;36;F
38536;504,1374,202,639,479,293,454,647,1017,530,294,1099,141,35,1570;49;F
38548;75,1104,1258,1439,1133,647,141,1014,142,530,1419,76,1158,311,1736;31;M
38554;76,75,83,311,1133,1014,377,1246,1419,141,1260,183,1166,142,530;30;M
38560;1300,288,76,1246,81,1198,1419,1201,141,1004,1014,1260,454,142,530;39;F
38595;1228,504,1737,252,202,76,639,1419,1099,647,1570,1133,35,1017,292;52;F
38597;1419,647,454,75,1138,1023,1099,1004,76,1246,1158,103,35,1014,1017;36;F
38598;530;41;M
38612;141,530;54;M
38647;103,292,530,76,288,1198,81,252,1201,1099,1570,1133,35,454,1081;41;F
38672;311,639,1166,1133,866,1439,1419,492,1158,647,76,1201,454,142,530;46;M
38701;76,1246,311,773,1133,473,530;45;F
38702;1300,76,1133,1004,293,1439,1419,1734,141,473,142,530;51;M
38703;75,1258,83,1300,76,1439,141,152,1133;46;F
38713;775,1104,83,252,1171,1133,1158,103,864,1017,377,473,1166,142,530;43;F
38714;1258,81,468,864,454,1138,1201,1166,141,1738,1158,377,1246,1419,1133;43;F
38717;1017,202,311,647,1158,103,1014,35,663;26;F
38730;75,202,1439,141,1014,183,454,142,866,530,209,76,647,1158,103;21;M
38749;75,252,76,1246,479,1201,1133,1158,103,454;32;M
38750;76,1158,1081,75,1246,647,1133,103;31;F
38753;473,530;32;M
38755;209,1300,1104,252,76,1419,773,647,1133,1158,864,35,1014,156,454;42;F
38757;81,1211,944,76,188,311,293,1419,492,647,1133,1158,156,473,1166;32;F
38798;1166,473,156,1133,1171,1570;38;F
38799;311,1419,992,141,647,1158,473,142,530;41;M
38800;35;48;M
38810;142,866,530,1201,1570,473,35,156;46;M
38829;288,468,289,1300,252,1207,76,1246,479,1023,1201,492,103,156,1017;37;F
38833;1158,1133,1099,1246,1738,76,288,1104,1258,209,252,639,1171,1157;24;F
38835;1198,294,81,290,209,454,663;39;M
38838;1081,1104,209,81,1258,76,1246,1419,141,1133,1158,103,454,142,530;41;F
38867;288,76,479,843,1570,1014,1017,663,866,1541,81,1099,141,142,530;50;F
38872;1081,1157,473,1198,81,944,468,504,1570,639,1228,288,1004,1260,454;34;M
38876;209,492,1570,1157;37;F
38919;1734,773,202,1107,479,103,864,35,1014,156,866,1201,1133,454,1246;42;F
38936;1439,1541,773,1201,142,775,288,76,1246,647,1133,1158,103,1081,1419;23;M
38998;1104,141,103,377,473;37;F
39003;183,1166,1198,81,252,76,1246,1201,1133,454,530;23;F
39019;202,1228,252,1374,76,639,1419,1171,647,1570,1740,1133,1158,35,292;33;M
39078;35;47;F
39158;944,1138,1198,81,290,76,311,1107,1171,1201,492,141,1014,454,866;32;F
39182;1133,103,1246,1158,530;21;F
39192;1201,454,530;38;M
39214;1158,454,866,530,1201,1246,944,252,1138,504,1300,81,1198;42;F
39238;473,1004,1158,1570,647,1099,1419,1738,76,288,1258,1736;21;F
39249;252,1738,647,1570,103,156,473,1541,209;32;F
39273;75,83,479,141,530;17;M
39295;1081,843,1419,293,311,188,202,775,1104,944,1211,288,209;40;F
39321;252,76,35;38;M
39346;141,1158,35,156,252,202,1023,647,663,292;45;F
39383;639,1439,864,866,1258,252,1246,1419,141,1133,103,1014,473,663,530;39;M
39388;1738;15;M
39394;1738;16;M
39399;1138,311,141,454,142,530;41;M
39403;1738;18;F
39405;202,1419,1570,141,492,252,288,1107,992,647,864,454,530;37;F
39416;81,1138,252,311,1419,1133,35,1198,76,141,1570,454,1166,142,530;43;F
39430;290,289,1736,1198,142,183,1260,252,288,1419,843,141,647,663,530;36;M
39438;1201,492,156,504,81,1258,468,252,76,639,1171,1133,454;29;F
39444;288,76,311,992;50;F
39484;454,663,1207,288,1300,1228,1737,1211,1419,1023,1201,473,530,188,209;38;F
39489;1260,1570,35,292,290,202,76,293,1023,1201,1099,647,1133,473,663;51;F
39523;1198,289,290,1138,775,1211,1246,1419,773,1570,103,156,473,454,142;38;F
39532;1198,76,1201,454,530;38;M
39569;81,288,202,76,1738,639,1439,141,1158,1133,1014,663,142,647,156;42;F
39570;1738;15;M
39594;209;28;M
39626;1201,141,1740,1014,1157,1133,1158,454,142,866,377,81,75,530,209;45;F
39635;76,311,1439,1419,530,647,1133,1004,377,473,663;27;M
39660;1023,35,1017,663,866,1374,293,992,1570,454,292,311,288,1133,1158;46;F
39664;209,293,663,647,35,1017,473,1541;36;F
39671;1541,1166,1081,1570,647,202,81,252,377;28;M
39695;1138,504,209,288,1211,1171,773,492,1133,864,152,156,473,454,866;4;M
39729;1198,81,1138,775,454,866;73;F
39735;504,1736,1258,1228,1737,944,1246,1734,1570,103,377,454,663,1166,530;37;F
39738;293,1171,141,1017,473,142;35;F
39750;866,81,202,76,1133,1198,75,252,293,1201,103,183,473,454,530;39;F
39766;1258,157,1736,288,1171,141,35,1541,1198,1570,473,1157,663,142,530;50;F
39772;157,1158,103,1260,377,1258,1374,1207,1246,479,141,183,473,142,530;45;F
39775;311,141,1017,530;30;M
39777;1258,1157,156,152,103,1004,1133,1246,76,288,252,75,663,292,866;21;F
39780;252,76,647,209;43;F
39784;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;48;F
39794;288,76,1419,647,1004,156,1017,473,311;50;F
39800;141,1133,35,1260,292,530,290,775,202,76,1246,293,773,1570,473;39;F
39802;209,1541;43;F
39809;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454;75;M
39816;157,1104,1107;36;F
39844;1570,1133,454;51;M
39889;504,1138,76,1107,647,1570,1133,35,1166,292,468,1201,1541,454,866;73;F
39900;311,103,377,141,1439,1419,1740,1133,1158,142,530,1246,83,76,1014;52;F
39961;157,1104,1107,1171,156;67;F
40018;1570,663,866,188;34;F
40046;1133,103,142,530;40;M
40066;1246,141,1133,142,530;40;F
40067;1246,1133,843,1099,1017,663,1104,473,156,35,1211,188,479,293,209;38;M
40083;209,75,83,1300,1138,468,76,1246,1171,1158,1004,103,1014,152,530;40;F
40095;1570,1133,1014,1258,1158,530;41;F
40124;1419,1246,1211,81,157,1300,252,1171,647,1158,1014,377,473,454,1166;37;M
40135;1207,311,1171,1201,141,1570,647,1133,103,1157,142,1158,473,454,530;44;M
40199;1017,663,1201,1419,252,1246,639,1099,1166,1158,647,1133,103,1081,530;28;M
40216;288,1246,1201,293,775,1138,773,492,103,377,473,142,866,530;35;M
40217;83,252,76,1738,311,1201,141,1133,1014,454,530,1439,1419,1158,142;30;F
40236;1198,311,1201,1099,252,293,141,473,142,530,1014;48;F
40245;76,1014,377,1158,209,288,141,530,142,311;37;M
40257;83,468,103,1017,156,152;44;F
40266;1104;31;F
40284;1374,290,209,1211,188,663,639,479,293,1171,1570,35,156,1017,473;37;F
40295;1246,1419,141,647,1133,1158;35;M
40306;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;43;M
40323;1246,1211,1300,83,75,76,311,141,1158,142,530;44;M
40330;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;39;F
40369;1133,1158,377,142,530;77;F
40392;1198,81,504,468,1138,775,944,1107,1201,773,492,864,866,1541,454;66;F
40399;83,775,103,1014,1017,473,454,142,292,530;50;M
40412;141,1570,1133,1158,103,1014,454;36;F
40426;530,209;45;M
40461;1258,1246,1419,141,1158,1260;45;M
40462;292,202,294,289,293,479,775,1228,157,1737,141,156,473,142,530;67;F
40497;1419,1246,290,663,377,156,103,293,473,35,1099,1207,289,209,479;13;M
40526;103,1133,1419,479,1246,141,1017,377,142,530;19;M
40531;1570;27;M
40543;75,1258,83,1300,76,311,1246,1439,1014,530,1133;50;M
40551;76,293,1439,1419,141,103,377,454,142,530;40;M
40561;1374,288,1228,294,202,639,1171,1023,1099,1570,103,152,377,183,663;30;F
40563;1104,504,1138,76,1246,293,647,473,454;37;M
40566;209,1740,103,1017,473;38;F
40588;639,479,1171,1023,141,647,1133,103,152,156,1017,377,473,292,530;43;F
40589;473,1081,288,252,468,1736,156,1157,530,209,1246,293,1419,1171,647;38;F
40594;1439,1419,1014,1017,35,103,1158,1133,479,76,157,141,377,142,530;43;M
40596;142,76,157,1104,141,103,454,530,377;40;F
40605;1258,1211,311,1099,1570,1133,35,1017,473,663;28;F
40608;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;2;F
40630;75,157,76,647,1740,1158,866,1246,311,1419,1541;42;M
40645;1570,1138,76,1133,1260,1198,81,252,311,1419,1201,141,454,142,530;35;M
40673;473,454,663,209;37;F
40676;1104,288,202,1439,1099,377,454,663,1081,209,76,1419,1133,1158,103;28;F
40708;103,473,663,1228,1104,1300,1207,1246,1439,1419,1166,142,311,141,530;50;F
40738;209,1374,1211,188,639,479,293,1171,1570,1158,35,156,1017,473,454;7;M
40743;1258,141,1158,1246,1419,1201,647,1570,1133,103,454,1166,142,866,530;29;M
40766;1198,81,504,1138,468,775,944,1107,1201,773,864,866,1541,492,454;45;F
40772;1201,773,647,454,530;37;F
40784;289,504,76,1738,1107,1158,864,1017,454,1258,1246,1439,1419,647,1133;49;F
40786;288,76,1107,1419,1734,492,103,377,866,454,663,530,1133,1158,1570;60;M
40787;1201,1570,1004,530,1198,1258,311,1419,1171,1023,1133,1260,663,1166,142;30;F
40798;209;40;M
40802;504,1198,81,288,1246,141,647,1004,866,1201,530,75,252,103,454;45;F
40825;188,1439,1133,492,252,647,473,454,142,530,157,1104,1107,1171,156;44;F
40853;1107,1201,156,866,454,1158,1133,647,1419,1246,1738,76,504,289,1258;52;M
40861;944,202,188,1246,1734,1740,156;32;F
40880;311,1419,141,142,530;36;M
40884;1211,188,479,293,1171,1023,492,1099,647,1158,35,1017,473,663;31;F
40938;311,1419,141,142,530;8;M
40946;1419,639,1099,1740,103,252,479,293,647,1570,1004,1017,473,292,1541;45;F
40959;103,864,1014,1157,1166,530,1198,1419,647,35,454;35;M
40974;311,1419,141,142,530;6;M
41029;1211,188,647,454,1570;34;F
41042;252,76,311,1171,773;40;M
41052;290,468,775,202,639,647,473,1157,663,209;44;F
41079;1570;57;F
41086;468,1419,1171,1734,773,647,1570,1133,1158,103,156,473,454,142,530;40;F
41093;1171,492,1099,35,103,647,1201,252,157,1198,473,454,663,530,866;39;F
41107;1138,944,1738,188,1107,293,1201,492,141,1570,1158,103,156,473,454;33;F
41109;1439,294,1228,1738,1246,311,639,1419,1740,1133,1158,1004,103,1014,530;41;M
41110;864,468,944,1419,773,292,157,1258,288,1246,639,1439,473,142,530;41;F
41112;864,1260,377,183,866,1541,1198,504,1138,468,1107,1201,492,454;49;M
41116;1246,1736,1570,1133,1081,142,1099,1107,288,1207,1228,504,639,1419,1171;33;F
41120;81,288,76,1246,1419,1201,1734,773,1133,454,1166;42;F
41141;647,311,479,293,1570,1017,289,294,290,1228,288,1023,35,663,292;65;F
41171;1201,1099,479,209,142,103,1419,1158,1133,866,647,530,454,288,76;28;M
41219;202,289,294,290,1228,479,1023,1099,647,1570,35,1017,663,866,292;60;F
41220;209,1104,1207,1014,377,530,252,76,1246,311,1419,1133,1158,103,1166;37;M
41221;252,1211,1207,1171,992,1570,35,473;36;M
41238;293,1201,1198,1258,1211,944,1246,1419,1133,1004,103,156,377,473,454;31;F
41293;293,479,289,294,290,1228,288,311,1023,992,647,35,1017,663,292;64;F
41301;530,75,1201,141,103;51;F
41319;1246,188,76,202,1211,775,468,1138,1300,81,157,1104,1107,1171,156;40;F
41336;647,311,1258,81,83,1104,76,1158,142,75,141,1133,377,1439,1419;35;M
41423;1734,492,1260,1374,944,1738,311,1570,864,156,183,473,454,663,866;36;F
41428;290,202,76,1201,773,141,647,1570,473,454,188,1171,864,866,530;43;F
41435;1166,142,530,1198,157,83,468,76,1246,479,1201,1133,1017,377,454;30;M
41448;1023,1171,639,1374,157,290,468,76,1107,492,141,377,473,663,292;45;F
41450;1081,473,530,1017,103,1133,1570,1419,311,1374,1300,83,1258,75,252;44;F
41481;647,1171,188,311,1374,639,1023,1570,1158,156,377,183,454,663,530;31;F
41489;1201,1258,1419,1133,1158,1014,454;28;F
41533;1166,1099,76,1138,1171,1198,290,1228,252,1419,1570,1133,864,377,866;74;F
41561;75,775,252,944,188,293,1201,141,1014,142,530,83,1300,103,473;39;M
41569;1166,142,530,1258,1138,468,252,1374,76,1246,1419,647,454,1201,1158;24;M
41588;1570,1541,775,468,1211,944,76,1107,293,1171,492,473,454,292;53;F
41599;81,1439,1246,1014,75,1099,142,141,311,1133,530,647,1419,76,288;30;F
41601;1300,252,1374,76,103;34;M
41607;290,157,530,142,1014,35,76,83,75,1300,1211,773,492,141,1133;39;F
41625;76,944,504,252,288,188,1439,1171,492,647,1246,1419,530,141,1133;39;F
41627;492,1570,864,156,1157,454,1081,1107,1171,1201,81,35,473,773,944;47;F
41631;864,663,1258,289,468,1211,479,293,1201,773,1099,35,473,454,1081;34;F
41635;290,1198,289,492,1201,1738,202,81,468,639,1171,1570,864,1081,1166;13;F
41666;1004,1439,1570,35,1017,663,75,1198,775,1737,252,1374,76,1099,454;64;F
41756;75,83,252,1207,1099,103;47;F
41770;81,290,252,141,647,1570,1133,1158,103,377,454,663,1081,142,530;25;F
41802;1419,944,1737,1228,468,1258,1738,1246,639,152,156,377,1157,663,1166;40;F
41803;81,290,504,288,76,1107,293,1171,1734,773,1740,1133,103,473,530;43;F
41852;504,1158,1374,1246,1107,1439,1419,647,1133,103,35,1260,183,663,142;32;F
41856;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;62;F
41857;1099,1570,76,1738,1246,1419,647,1133,864,663,1166,292,530;50;F
41886;209;9;M
41891;289,76,293,1171,773,647,103,1014,156,473,292,1300,152;42;F
41897;1419,1133,103;42;M
41907;209;6;M
41920;1201,1099,647,103,288,1374,202,1171,1157,663;28;F
41949;252,1246,311,141,1158,1133,142,530;43;F
41956;1198,1258,188,1419,1211,1207,311,35,156,663,1171,1023,1246,293,473;41;F
41964;1374,1258,252,311,479,1419,1023,1099,647,103,454,663,1081,866,530;27;F
41975;775,76,311,1439,1419,992,141,1158,35,1014,1260,454,142,292,530;42;F
41996;188;28;F
42009;1374,288,468,1104,1228,83,209,81,1258,75,1738,1246,1014,142,530;47;F
42010;1099,663,288,1738,479,1419,1133,156,152,81,252,647,1570,1158,103;29;F
42011;1374,311,647,1133,1004,156,454,1166;40;M
42026;76,311,639,1201,773,492,647,157,1258,1246,1419,1171,1133,1158,454;30;M
42046;209;39;M
42047;1734,1023,843,293,479,639,289,1228,1138,775,288,1211,944,1541,866;37;F
42064;209,83,1014;26;F
42073;773,647,103,1014,152;42;M
42076;1300,1207,1017,76,1246,639,1419,1171,1740,1133,1158,35,152,663,773;38;F
42085;530,209,290,1736,504,252,944,188,843,773,492,103,35,156,663;32;F
42088;252,288,1374,1246,479,293,1419,1439,1171,1201,1099,647,1133,454,663;52;F
42089;1138,252,1439,1201,492,1099,156,473,454,142;33;F
42095;1228,479,647,1158,103,35,1014,1260,1017,473,663,142,530,1570,1166;42;M
42105;83,775,1211,202,76,1246,479,1023,103,35,1014,1260,152,1017,663;37;F
42106;1104,252,1374,1211,1439,647,1158,473,75,1419,141,103,1014,142,530;31;F
42115;1570;46;F
42123;103,866,152;45;F
42124;288,76,311,1439,1419,1171,141,1570,1740,1133,1158,663,866,292,530;44;F
42134;157,252,76,1439,1419,1171,647,1104,1211,156,473,141,1133,142,530;44;M
42150;209,294,81,252,1207,1570,103,1017,473,663,292,530;61;F
42152;293,1201,454,76,141,142,530;37;M
42163;1023,492,156,473,290,252,1211,1107,293,1099,1570,103,35,454,663;36;F
42175;775,1246,1201,141,1133,1004,454,530;46;M
42187;775;26;M
42188;83,311,141,1133,1014,142,530;19;M
42189;288,1201,103,1166,647,141,1133,142,530;36;M
42207;293,492,647,35,1017,1014,142,288,252,1171,141,1133,152,473,530;39;F
42222;288,468,504,1228,294,1736,639,843,1201,647,35,454,663,1570,209;40;F
42223;1171,1246,202,252,468,1138,1258,1734,209;35;F
42224;293,1017,202,775,289,290,468,288,1738,639,1171,773,1570,1157,1166;46;F
42227;141,1158,1004,530,209,1211,76,1246,311,1171,1734,647,103,473,1166;36;M
42234;775,639,647,1740,473;38;F
42255;1198,75,1158,377,454,1166,1258,209,252,76,1246,141,1133,142,530;37;M
42257;1246,1133,1158,311,454;50;F
42268;639,1023,1570,1740,1133,663,142,530;49;F
42269;773,1570,152,156,454,157,290,504,479,293,1201,492,1017,473,663;7;F
42276;1207,76,188,639,647,530,1157,1099,773,1734,1201,1171,1211,252,454;39;F
42288;76,1166,252,1107,1201,647,103;33;M
42328;1211,944,647,1570,473;37;F
42330;311,1570,1014,1157,1541,639,454,504,1171,1158,1246,1419,1133,663,530;45;F
42347;157,81,209,1104,288,1211,202,142;4;F
42374;103,1736,454,1133,1158,866,647,992,1246,1211,288,504;46;F
42387;209,1541;42;M
42391;1211,1138,1300,290,157,773,647,1133,103,35,156,454;36;F
42392;1198,81,290,209,1211,311,479,1023,647,473;9;M
42415;647,1099,992,1107,202,504,1736,1198,1138,252,1201,1158,1133,103,454;32;F
42418;1228,209,1107,252,1138,81,1736,1198,1201,1099,647,1158,103,1081,454;57;F
42425;209;42;M
42481;156,492,1201,468,1211,944;4;F
42490;288,468,504,1258,81,252,944,1246,1419,141,1740,1133,1158,103,530;33;F
42502;639,188,944,288,1138,209,1736,1198,1300,1211,647,156,1157,1081;39;M
42514;1171,1017,1260,530,775,647,454;35;M
42526;1258;27;F
42530;1211,944,293,1201,492,156,473;1;F
42539;35,1570,252,1246,843,647,663,866;50;F
42542;1138,647,864,454,1374,1158,1246,1419,103,311,141,1133,142,530;39;M
42554;1738;58;M
42562;1166,292,663,473,1017,35,1158,647,1023,1419,293,479,209,290,289;40;F
42563;530,141,647,1158,1014,1017,142,479,1133,103,473,866,1260,377,183;38;M
42573;1246,647,1158,311,1133,1014,377,1258,252,288,1207,141,103,142,530;29;M
42592;209;46;F
42593;1198,288,1171,1201,647,454;26;M
42595;252,288,1246,1201,1133,1158,103,1260,454,1166;28;F
42599;156,1014,1017,663,1138,1228,290,1258,1738,479,141,152,473,1166,530;39;F
42601;293,1023,1201,647,35,156,866,663,530,1211,1570,103,473,454,1541;37;F
42606;209;47;M
42611;209;67;M
42635;773,479,76,157,290,1207,202,1570,1014,1017;40;F
42648;76,1246,1107,479,1201,1740,1158,81,209,293,1171,1133,473,454,530;44;F
42694;1104,1158,473,866,1107,1004,288,311,1439,141,103,1014,377,142,530;27;F
42696;1166,311,1014,142,1258,76,1439,1419,141,647,1158,1133,454,866,530;29;F
42700;1104,141,530;40;M
42702;202,209;42;F
42720;289,479,293,292,209,473;43;F
42721;1258,1260,1246,1158,1133,1014,530,311,288,142,141,76,75;34;M
42723;1104,293,141,142,530;39;F
42739;1439,1171,157,1104,1738,1107,1419,1099,141,156,473,454,663,142,530;48;M
42751;209,1201,103,454,142,866,530;36;F
42756;252,1166,75,1300,1374,76,1246,311,479,1439,1419,647,1133,1014,1017;29;F
42799;1738,1104,157,209;5;F
42807;1158,1133,1570,479,1246,202,252,76,209,311,1419,647,141,530,142;36;M
42817;530,142,1158,647,1419,1439,311,76,288;23;M
42839;252,288,311,1171,1201,492,141,864,152,156,473,454,142,530;28;F
42840;1104,479,639,1738,76,1211,288,1138,289,1158,1201,1419,311,188,290;44;M
42841;142,530,1133,141,311,1246,1738,76,209,252,293,1419,1570,35,473;37;F
42842;1439,141,647,1570,1133,103,35,142,530,252,1374,76;47;M
42868;468,1138,504,1198,288,1246,639,843,1171,492,1158,1201,103,864,454;42;F
42881;479,1171,492,103,35,454,1211,202,639,293,647,1014,1017,473,663;38;F
42882;1133,530,1158;38;M
42900;504,252,1246,479,1201,1133,35,1260,1017,377,1157,454,530;38;F
42914;75,1258,504,76,1107,1201,141,377,454,530,81,311,1439,103,1014;45;M
42920;81,1138,468,1107,1201,492,864,454,1166;49;F
42936;141,76,1374,252,83,209,1258,1246,1419,1133,1158,103,377,142,530;29;F
42941;1374,252,76,311,141,1158,1260,183,142,1258,1246,1419,1133,1166,530;51;M
42944;288,1439,103,1260,377,142,209,252,76,1246,311,1419,647,1133,1158;29;M
42949;1081,1014,35,290,252,76,293,141,647,103,473,1157,663,142,530;48;F
42974;1419;44;F
42995;1211,202,188,293,647,35,156,1017,473,454,663;37;F
43015;843,1738,1207,290,289,1258,202,1171,141,647,1133,103,473,866,530;47;F
43038;209,468,252,1211,202,293,1419,1171,1201,773,492,864,473,663,454;41;F
43067;252,1207,76,1246,141,647,35,1260,1017,473,142,530;30;M
43088;156,1133,1171,252,76,202,1246,311,1004,864,35,1017,454,292,530;30;F
43101;1211,1246,293,1419,1171,647,1133,1158,1004,103,1017,473,1157,454,1166;48;F
43124;1419,1541;46;F
43139;1107,864,141,81,252,142,530,1133,1158,1258,1374,202,1246,1419,377;32;F
43151;1246,1260;65;M
43153;1138,252,288,202,1246,1201,647,454,209;42;F
43160;141,647,473,1107,1201,454,142,530,209;44;F
43183;1198,1201,647,454;63;M
43189;468,311,479,1166,209,252,1419,103;34;F
43216;1023,252,83,75,76,103;48;M
43224;530,209,473;38;F
43235;1738,1133,1166,1374,1023,647,35;33;F
43238;252,288,76,311,1260;65;M
43242;156,454,1419,1201,103,377,1166,142,530,1198,1246,773,141,647,1133;38;M
43245;75,252,1419,141,1133,1158,83,530;49;F
43283;103,1017,1157,663,142,292,1736,289,252,1171,639,1374,141,866,530;46;F
43317;157,1104,1107,1171,156;63;F
43325;141,1246,83,142,530;51;M
43327;1138,1107,1201,377,454;32;F
43329;843,1023,141,1017,473,479,293,1201,35,454,663,292,1737,252,103;57;M
43347;290,209,1211,944,188,293,647,1570,1133,103,35,152,156,473,454;32;F
43359;252,141,1133,1158,530;47;M
43399;157,1258,209,1104,1107,1419,1171,647,152,156,473,663,1166,142,530;40;F
43400;75,1258,209,1246,1439,1419,1133,1158,1014,142,288,76,311;39;F
43409;775,252,288,202,639,647,1570,1133,103,1260,1017,1157,1081,530,1541;34;F
43414;157,1258,76,1133,288,209,252;45;F
43418;1246,311,492,103,473,530,468,252,992,647,1570,1260,156,1166,866;42;M
43428;288,775,289,1736,1171,647,103,1166,530,76,1419,1158,142,209,252;42;M
43435;76,1258,209,1374,1246,1419,1158,1133,1014;40;M
43473;76,252,1157,142,530;43;F
43484;1258,75,294,83,76,311,1439,1023,141,647,1133,1158,1014,142,530;26;F
43490;1138,1736,1258,290,209,479,293,1419,1023,647,1570,103,35,473,454;44;F
43492;290,992,1740,156;40;F
43502;1201,473,864,293,468,1211,1246,492,454;37;F
43523;157,1258,209,1104,1107,1419,1171,647,152,156,473,663,1166,142,530;43;M
43527;157,1258,209,1104,1107,1419,1171,647,152,156,473,663,1166,142,530;9;F
43535;142,292,1198,81,1228,1211,944,202,1740,530,1570,1201,1419,311,76;58;F
43536;294,289,1258,1736,1198,479,1201,647,1158,103,454,663,202,1023,292;59;F
43546;157,1258,209,1104,1107,1419,1171,647,152,156,473,663,1166,142,530;8;F
43551;76,1228,1258,75,1300,252,288,1439,843,141,647,1133,1014,142,530;37;M
43562;1014,1133,1171,1419,1300,1228,1258,76,142,1570,1099,141,1740,1004,35;34;F
43598;944,202,76,639,1419,1171,1201,141,103,35,156,473,454,142,530;29;F
43622;35;46;F
43650;1211,1104,288,75,76,311,1439,1099,141,377,473,142,530;17;F
43654;944,188,1107,639,293,1171,1734,773,492,1099,141,103,35,152,156;36;F
43659;1107,1133,992,639,1138,1228,1258,252,202,1246,1419,1570,1740,454,663;42;F
43701;141,103,1439,1419,1158,1260,377;32;F
43716;647,188,311,992,377,183,866,209,1211,293,479,1017,473,142,530;37;M
43718;290,1300,1138,76,479,647,1570,1740,1158,864,454,1541,775,1201,103;77;M
43754;288,468,209,157,156,1570,773,944,188;42;M
43795;492,1198,288,944,1081,866,1201,647,454,1570;42;M
43805;311,1738,76,944,1374,288,252,209;35;F
43816;843,1171,1099,1014,292,75,83,288,76,141,103,1017,1157,142,530;30;F
43891;1738,1246,1004,454,866,209,1258,252,1419,1133,142,1260,1158,1166,530;40;M
43901;1201,76,1133,1260;50;M
43942;1104,530,866,454,1158,492,1171,1419,1258,1570,1133,103,35,156,473;41;F
43945;188,1246,492,473,1107,157,1104,156;35;F
43959;1258,504,1138,1738,1246,1419,1171,1158,1014,152,377,473,454,142,530;34;F
43967;293,492,1260,1198,1258,1300,944,1201,141,1133,1014,377,454,866,530;42;M
43969;293,1246,188,504,1258,1171,141,647,1133,1004,152,156,1166,142,530;51;F
43986;647,103,292,1017,35;65;F
43993;1201,1419,288,1211,188,492,647,103,1017,473,142,292,1541;37;F
44007;188,76,1211,81,289,157,290,311,1171,454,142,530;33;F
44008;209;42;M
44010;1570,1158,1004,103,1017,454,663,468,252,1246,479,1419,1099,473,209;42;F
44087;504,1439,141,479,311,76,83,663,142,530,1374,1246,639,1171,1419;39;F
44115;866,663,1017,35,1023,843,1258,775,76,292,1133,1158;44;F
44130;1171,141,530,209;39;F
44136;290,1228,1023,103,663;44;F
44174;157,1104,1211,188,293,1570,35,156,473;32;F
44207;1246,1439,647,103,377,1166,252,311,1419,141,1133,1014,142,530,1158;28;M
44238;1201,1300,1104,1246,1439,1419,1014,454,288,311,1133,1158;46;M
44270;1166,473,1133,1099,1171,1419,293,311,1246,209,1541;38;F
44297;1201,1004,377,1133,141,103,1014,142,530;45;F
44319;1099,1201,1246,1023,1374,288,141,647,1158,1014,1017,454,663,292,530;43;F
44359;1171,773,1099,1004,103,152,1017,454,663,292,530,775,35,156,473;42;F
44382;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;59;F
44434;479,290,288,76,141,1014,142,530;45;M
44448;209;45;F
44449;639,293,1171,1158,1133,188,1246,1419,1201,864,156,209,1211,473,454;37;F
44472;202,647;24;F
44479;530,75,1258,76,1246,311,639,1439,1419,1171,141,1133,1158,864,142;24;M
44483;157,209,1419,773,1570,864;29;F
44502;1439,76,75,311,1014,183,1228,504,1138,288,639,1419,1171,1201,454;53;F
44574;1211,157,468,76,188,1738,1246,1419,1171,1201,1133,1158,156,454,209;7;M
44579;292;33;M
44591;103,866,288,1570,1740;69;F
44603;157,1300,504,1211,944,76,141,473,663,292,530,1201,454;74;M
44662;944,775,504,1258,157,188,1171,492,647,1570,1133,156,473,454,1166;27;F
44671;1014,76,1246,1419,311,1201,992,141,647,1133,1158,103,454,142,530;31;M
44689;1570,1081,1228,775,35,1017,473,1541;33;M
44709;75,1104,1246,311,1419,1439,141,1014,377,530;24;M
44721;81,504,1138,468,775,944,1107,1201,864,454,866,1541,773,492;75;F
44747;311,479,1171,141,1158,1081,288,1374,76,647,1133,663,530;25;F
44758;252,202,1246,639,454,504,288,1004,142,530,1099,141,647,1570;53;M
44776;75,1419,141,1157,1171,639,1246,1738,202,775,468,290,288,1374,252;29;F
44825;1736,157,1198,1138,1201,647,1158,1004,1419,209,1374,1246,1133,864,454;57;F
44833;83,504,288,944,1201,866,1198,311,141,1014,454,142,530;36;M
44842;1228,202,188,209,1734,141,647,1570,1158,103,1014,156,377,142,530;36;F
44846;1246,1107,81,209,1228,76,1738,1570,142,1419,141,1133,377,1158,530;32;F
44854;1570;77;F
44868;1541,202,288,252,775,468,209,293,1419,773,1133,1158,473,1157,454;33;F
44874;152,1158,83,639,1419,1171,492,647,530,156,209,288,188;32;M
44892;992,35,1017,530,157,290,209,775,76,311,1439,103,152,473,663;33;F
44904;530,1171,75,157,1258,209,252,1738,1419,141,1133,1158,1157,1081,1166;33;M
44919;157,293,289,35,292,141;45;M
44936;1099,1198,1258,81,290,288,76,1246,1419,1133,1158,103,473,454,530;20;F
44960;530,252,1570,1133,1158,1081,1541;18;F
44980;479,639,311,188,944,1228,289,209,76,864,454,663,530,1246,1133;48;F
44982;468,1419,492,1570,1133,663,209,1211,1171,647,1158,35,473;37;F
44988;252,76,311,1419,647,142;35;M
45046;504,294,81,288,944,639,479,1171,1201,1099,141,1157,454,142,530;25;F
45056;1023,1004,1260,1157,1166,142,530,1541,76,479,141,1014,152,1017,473;42;F
45057;1004,377,294,209,252,288,1374,992,1740,647,1133,103,454,663,142;35;M
45068;1570,1158,1004,103,35,1014,156,1017,473,454,663,142,866,292,530;28;F
45076;188,209;43;M
45077;35,377,1158,1439,1738,1258,76,1246,311,1419,141,1133,1014,530,142;36;F
45090;647,468,504,1081,1246,1419,1133,1158,377,454,142,1374,1201,141,530;27;F
45096;639,1099,183,663,1736,81,479,1419,1740,1133,1158,103,377,1166,866;37;F
45131;156,663,1166,142,252,288,76,311,1419,1133,103,377,292,209,647;47;F
45133;293,479,311,1207,289,142,1099,1017,775,252,76,773,647,473,209;42;M
45143;1736,1198,289,294,1228,1138,1737,479,1419,1023,35,252,311,1201,530;46;F
45145;1419,1171,1734,1570,1133,1004,864,35,156,1017,473,454,663,1166,142;60;F
45148;1014,289,1736,75,1300,479,647,1133,103,1260,1017,377,454,1166,530;30;F
45151;773,504,1157,864,142,866,530,1198,288,1374,311,1171,1201,992,454;52;F
45166;377,157,1104,1107,1171,141,1260,156,142;75;M
45168;288,1374,1211,311,1419,1541,209,293,1201,647,35,473,454;40;F
45178;209,1374,1211,202,293,1099,35,1419,1171,1201,647,1570,473,454,1541;37;M
45180;81,209,1374,311,293,1419,1201,1099,647,1570,35,473,454,1541;12;F
45182;492,1734,1246,188,1138,473,530,142,454,141,1201,76,252,468,1738;44;F
45207;209,1736,530,142,1166,103,1158,1171,311,1738,76,252,1246,1419,1133;46;F
45236;1246,311,1439,492,1740,1158,1014,156,142,188,209,76,141,1133,530;33;M
45262;209;42;F
45273;479,530;29;M
45274;1158,1439,1374,1138,1104,1258,252,1419,1734,647,1133,103,1260,183,866;39;F
45283;1246,1439,1419,1171,1133,473,1157,1166;39;F
45310;454,142,530;45;F
45311;1228,504,468,202,1570,864;48;F
45315;1201,647,1570,1133,103,864,35,1014,156,1017,473,454,663,142,292;45;F
45359;209,530;41;F
45367;1133,864,1014,1017,663,142,292,530,1198,290,1228,1138,775,1201,454;61;F
45375;639,311,1246,1738,1207,944,468,1300,290,1258,1211,188,647,473,663;7;M
45421;504,1138,775,944,1201,773,492,864,454,1541;64;F
45452;504,294,1258,1099,141,1740,1004,152,1017,142,1246,1439,1133,530,1158;36;F
45454;75,81,83,252,76,103;31;M
45470;157,1107,156,152,866,1201,1171,1439,479,188,202,944,1211,252,1104;45;F
45472;289,290,209,76,479,293,1023,647,35,1017,473,663,1166,292,530;57;F
45489;1738,288;44;F
45511;157,1104,1107,1171,156,377;66;F
45553;473,156,152,103,1171,293,639,1211,468,188;3;F
45562;647,1004,663,864,103,311,468,1138,1228,1157,1541,1014,1133,1740,1099;22;F
45602;209;41;F
45622;639,1419,843,141,377,663,866,292,530,252,504;55;F
45638;1198,1258,290,209,1374,1211,76,1133,473,454;41;F
45645;209;7;M
45658;1246,311,103,1260,944,1198,81,1138,1107,1201,773,492,864,454,209;45;M
45679;775,530,252,311,1419,647;29;M
45681;209;54;M
45683;293,773,1570,252,1211,1738,1439,1419,141,1158,103,156,377,473,530;33;F
45689;81,157,1198,1738,156,473,454;47;M
45694;157,202,1738,1246,843,1171,647,35,1570;43;F
45700;202,252,76,1171,1099,647,1570,103,152,156,663,1081,1166,142,866;46;F
45724;454;68;F
45734;530,142,454,1260,1014,1004,141,1201,1419,1198,81,1246,76,288,1300;45;M
45762;1246,1014,156,1166,76,1737,1198,1736,294,290,293,1023,35,454,292;67;F
45780;209;38;F
45788;775,157,289,202,76,1171,992,647,1570,473,1157,663,1081,530,1541;19;F
45812;76,1419,1023,647,663,209,1138,252,288,1207,1201,992,1158,35,454;42;M
45825;141,1158,103,1260,1017,1081,142,76,252,1258,81,1246,647,454,530;24;M
45844;311,1201,141,103,454,142,530,252,209,76,1419,647,1133,1158,1166;37;M
45846;1004,1171,141,473,1017,152,647,1419,639,76,1228,530,142,1570,1201;51;M
45872;81,209,76,1246,1419,1171,141,647,1158,1133,103,864,142,530;42;M
45883;76,639,1171,647,183,1157,454,1228,252,1246,1419,1740,1133,1166,530;32;F
45899;1133,1158,209,292,252,1374,202,76,1419,647,103,1014,1166,866,530;46;F
45905;1300,1198,209,76,311,1439,1201,1133,377,473,530,1419,992,141,647;33;M
45922;202,468,290,1419,843,1171,992,1133,1158,156,252,479,293,1570,663;33;F
45969;1737,775,209,1258,1570,1014,454,1246,76,1138,252,647,1133,103,530;31;M
45976;1211,1246,311,639,1419,1171,1099,1004,35,1014,1157,1081,1166,142,1541;39;M
46012;1439,76,1258,1138,1246,1107,1419,1171,1201,1133,1158,1004,473,454,866;38;F
46027;1738,1374,468,294,252,76,1246,311,1570,647,1133,663,866,142,530;26;F
46099;1258,1104,311,141,1133,103,142,209;54;F
46113;454;56;F
46131;1201,1246,157,1104,1211,1439,1419,1171,773,492,1099,141,377,473,142;41;F
46143;866,468,1541,775,81,773;14;M
46146;292,1157,864,1158,647,492,1198,1258,504,1138,468,202,1246,1107,1419;47;F
46148;209;44;F
46158;944,188,76,1738,156,1198,864,152,468,293,1201,454,473,1211,492;45;F
46185;504,468,775,944,1201,773,492,864,454,866,1541;69;F
46195;1198,81,1138,504,775,944,1107,1201,773,492,864,454,866,1541;77;F
46202;1439,492,647,454,288,76,1246,141,1570,1133,1158,103,35,1260,142;10;F
46214;157,1104,188,1107,1171,156,292,81,1211,293,773,473,663;67;F
46224;1737,1246,479,1570,1081,202,647;24;F
46259;157,1258,1207,152,1157,1171,1201,103;42;M
46277;288,473,141,1201,1419,479,311,76,75,1133,1158,454,530,377,183;42;M
46282;504,944,1171,1133,156,454,1166;23;F
46284;1138,1201,773,1740,1004,1017,377;66;M
46286;142,530,1228,311,1439,141,1570;42;M
46291;209,141,142,530;45;M
46304;1258,1374,76,1246,1419,843,141,647,1133,1158,103,1198,252,142,530;50;F
46310;157,1104,1107,1171,156;38;F
46331;1014,152,377,142,1198,157,81,504,288,1158,103,864,454,866,530;27;M
46365;504,1207,479,293,1570,473,377,1734,1171,252,76,1201,647,103,454;54;M
46368;1258,83,252,647,103,1260,377,1166;18;F
46384;252,377,647,1133;36;F
46399;75,1258,1738,1246,311,1419,141,1133,1158,377,530;40;M
46444;75,504,311,1439,1419,288,76,1246,141,1570,1133,1158,103,1260,142;43;M
46482;157,1104,1738,1439,156,530;43;F
46498;1738;47;F
46501;35,1158,1246,504,1104,1419,141,1133,1014,1017,377,473,663,142,530;37;F
46514;288,1198,1246,1138,1258,377;47;M
46545;1258,289,294,290,775,1374,293,1023,35,1017,663,292;69;F
46572;75,83,1300,288,76,1419,1258,1246,311,1014,141,1133,1158,142,530;36;M
46592;83,504,1133,864,289,81,35,252,1246,1171,1258,75,76,1004,454;42;F
46634;1133,530,454;59;M
46669;1737,1246,1419,1133,473;57;F
46687;479,1419,1201,1133,1158,1004,1260,1017,1258,293,103,1014,473,454,530;41;F
46693;157,81,775,1419,377,1158,1246,1258,1201,647,1570,103,1157,454,530;37;M
46726;157,1198,289,1228,288,1246,1171,1099,1133,1004,103,1017,1157,663,292;20;F
46734;252,76,1246,311,479,1419,647,103,473,1171,292,1541,209,1158,1133;42;F
46760;1171,1738,76,1211,1138,1300,1258,1198,75,1374,1201,864,156,473,454;41;F
46809;157,1104,1107,1171,156;68;M
46828;252,1419,1201,1133,1004;28;F
46837;1258,290,252,1207,76,479,293,141,647,1133,35,1014,1017,473,530;40;F
46887;1207,252,1737,294,1198,1736,288,647,1740,1004,103,35,1014,1260,1017;26;M
46890;1166,1198,288,76,188,1439,1171,1201,647,141,156,473,454,142,530;43;F
46897;288,944,76,188,639,293,1439,1171,1201,141,1004,156,473,454,142;47;M
46937;1736,1737,1023,1099,454,866,252,1374,202,1246,1419,141,647,103,1260;41;F
47008;1198,1201,773,492,141,647,1570,1133,103,864,1157,454,663,1541,530;55;F
47024;504,468,252,288,202,76,75,1228,1246,1171,647,103,866,1374,639;33;F
47049;1258,1246,530;40;M
47062;1570;73;F
47090;1211,1201,1017,1138,1246,311,479,293,1419,141,377,473,454,142,530;40;F
47091;83,1138,288,1439,1734,492,647,311,866,76,1246,1201,1133,1158,454;33;M
47098;1014,1158,647,1201,1207,209,1211,76,1246,293,1419,1133,103,35,473;38;M
47101;103;34;M
47108;252,288,311,1201,141,1158,454,142,530;40;M
47119;156,1171,288,252,504,639,647,1133,1004,1017,454,142,530;31;F
47123;1260,1157,454,468,1201,377,311,1166,76,1246,1419,1158,647,530,1133;22;M
47150;1737,775,290,1258,1736,157,293,1171,252,479,647,35,1017,473,1081;23;F
47152;141,1419,1133,454,530;52;M
47159;1228,504,775,1246,1439,1419,1171,1734,1740,1133,1158,377,454,1166,1541;73;M
47231;141,1419,252,1439,1260,142,530;50;F
47280;454,81,157,1198,1258,504,288,1246,311,639,1171,773,492,1004,530;44;F
47281;156,866,1198,81,209,1138,252,288,1211,944,76,188,639,1171,454;39;F
47331;1104,504,1138,1107,1201,647,454,530;50;M
47338;188,293,1201,492,103,152,1166,1541,157,290,647,156,473,454,663;37;F
47392;1736,1258,1198,252,288,479,1201,1023,1099,647,1133,103,35,1017,1166;20;F
47398;288,1246,1439,647,1004,663,142,530,252,1166;24;F
47442;1419,1374,1138,1300,290,289,252,1107,647,377,1246,843,1570,1133,1158;67;F
47449;202,1738,103,454,663,1166,81,209,639,1171,647,1133,183,866,530;46;F
47460;293,141,35,473,142,289,81,290,209,1246,479,1133,1017,1166,530;46;F
47470;1258,1198,1104,1107,639,1201,1099,647,1133,454,292;47;F
47499;156,292,866,663,1157,454;77;F
47550;1439,1419,1014,1081,252,288,1201,141,647,1740,454,142,530;39;F
47556;83,1104,76,311,1419,1158,103,1014,377,473,1157,663,142,292,530;44;F
47578;294,1198,1228,1570,1740,1133,1158,1260,1419,944,1374,288,252,504,647;41;F
47611;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;71;F
47631;1419,1246,1738,75,1104,252,76,1439,141,1133,1158,377,142,530;48;F
47712;1246,1419,1439;36;F
47748;1023,530,202,209,290,1258,1570,103,35,454,663,142;26;F
47750;35,647,1738,76,288,209,1258,252,1211,1570,1260,473,1081,1166,530;35;M
47784;377;46;F
47796;1104,1107,377;67;M
47860;1736,454;57;F
47931;1737,1004,864,183,76,202,1374,252,1258,504,773,35,473,663,866;47;F
47961;252,156;33;F
47977;1198,252,1374,202,1246,639,1419,1171,647,1158,377,663,1081,1166,866;32;F
47981;1099,773,293,252,288,479,1439,1419,1201,141,647,473,454,142,530;39;F
47983;288,468,290,1246,1419,1171,35,1439,1211,504,377,663,292;39;F
48001;142,293,141,1198,75,504,1138,252,1207,1246,1201,1004,1014,454,530;43;M
48028;294,1258,83,1228,504,252,288,76,141,1570,1740,1133,142,530,1158;34;F
48037;75,252,647,1133,103,1017,473;17;F
48063;1258,252,288,639,1439,1171,1099,647,1133,1158,1004,1014,1017,1157,530;22;M
48097;81,83,1300,1246,1439,647,1133,1158,103,75,252,1211,76,473;31;M
48136;775,288,188,1419,1201,773,454,866;31;F
48165;76,479,1171,1099,647,103;23;F
48207;311,1439,1419,141,1133,1158,103,1260,377,183,473,1157,1166,142,530;20;M
48232;1439,1419,492,473,142;36;M
48258;1207,1211,775,1228,1198,1258,1246,1099,647,473;50;F
48262;209;7;M
48280;35,1014,1157,142,288,76,479,1439,1419,141,647,1017,473,530,209;44;M
48281;76,311,35,142,209,639,479,1171,647,1004,1014,1017,377,663,1166;28;F
48316;35,1201,1419,1246,1207,252,81,1374,141,647,103,454,663,142,530;42;M
48336;35,152,454,1081,142,81,1374,1738,1246,639,1133,473,663,1166,292;53;F
48337;1570,1171,1419,1246,188,202,252,1300,209,1211,293,1158,103,156,473;27;M
48367;1104,377,142,530;55;M
48378;1246,188,1374,288,81,75,83,1300,76,311,141,103,1014,152,530;12;M
48406;473,1157,454,142,530,292,141,1258,83,468,639,188,504,293,1023;44;F
48410;1738;42;F
48438;252,288,76,188,1246,311,1419,1171,647,1133,1158,103,473,1157,530;28;M
48482;292,530,142,663,183,377,1158,1133,1740,1570,141,1099,1419,1246,1138;34;F
48499;1133,647,76,1104,252;47;F
48512;252,1207,1246,311,1107,1023,1419,843,1201,647,1133,864,663,1158,454;39;F
48540;1258,81,209,1419,1734,1017,473,1570;42;F
48567;468,202,492,1570;29;F
48583;141,492,1201,1107,468,1228,81,454,142,530;43;M
48588;1246,1133,156,866;46;F
48627;1258,1198,1133,1158,103,377,454,530,944;37;M
48646;209,288,202,311,293,1439,1171,1099,647,473,663,142,292,1738;44;F
48657;81,1737,1246,1171,773,1740,292,1541,1374,1207,647,1570,1157,1081,1166;22;F
48667;1198,156,103,1158,1133,647,1099,1419,1439,1246,1738,188,288,252,1258;31;F
48684;479,1023,252;23;F
48695;209,1541;41;F
48708;1258,75,1198,311,1439,1419,141,1004,103,1014,1260,377,142,866,530;36;M
48713;1014,1211,288,473,293,209;39;F
48737;1004,1133,103,1017,454,288,81,1736,290,504,639,35,377,530,292;51;F
48740;1300,1258,141,252,75,83,288,76,1246,479,647,103,1014,142,530;45;M
48745;773,1004,1570,103;72;M
48781;209;41;M
48784;1198,1258,1246,1419,1133,454;43;F
48804;1198,81,944,188,1201,492,1570,864,156,1541;35;F
48851;1246,1258,311,1736,1158,81,288,944,76,1107,1439,1201,647,473,454;32;F
48946;1738;46;F
48991;76,1246,1419,1740,1133,1158,142;33;M
49021;75,504,647,866,1014,1246,103,288,202,76,311,1439,141,142,530;47;F
49025;1133,647,141,293,311,76,1300,75,83,1207,1246,103,1014;46;F
49027;1419,1201,454,311,141,209,530;37;M
49040;1374,252,75,1198,1439,647,1570,1133,1138,1246,1419,1158,377,454,866;71;M
49059;663,1570,639,76,1246,1419,1171,141,647,1133,1158,1014,1157,866,292;12;M
49079;75,209,1374,1419,647,1158,1133,103;24;F
49165;75,83,1246,639,1419,1171,1133,103,1260;23;M
49241;141,1158,1260,142,530;27;M
49262;1246,311,479,1419,1171,1201,141,647,1133,103,35,1014,377,454,1166;28;M
49272;1439,1171,1166,944,1211,288,252,75,142,1017,35,1133,647,141,530;29;F
49283;292,1737,252,1570,1740,663;63;F
49288;1738;50;F
49303;473,141,1439,1107,311,252,156,142,530,1104;43;F
49307;1246,311,141,1133,1158,1260,183,454,142,530,1258,288,1419,103,377;30;F
49343;141,1133,103,1166,530;73;M
49411;864,492,773,1201,1107,944,775,468,1138,504,81,1198,454,866,1541;63;F
49433;288,1374,1246,639,1171,1099,647,1133,103,1260,1014,1166,142,866,530;48;M
49478;1104,76,293,473,156,157;50;F
49513;1107,1171,156,157,1104;35;F
49539;157,1104,1107,1171,156;36;M
49558;75,76,773,1133,1157,1081,1166;18;F
49561;157,1104,1107,1171,156;7;F
49566;1738;44;F
49570;157,1104,1107,1171,156;7;F
49581;1138,468,1737,252,288,1738,1419,1171,1201,1099,647,1570,864,454,663;47;F
49593;75,1211,944,1738,1107,1419,1734,473,1166,81,1138,252,377,454,866;37;F
49621;1738;47;F
49622;1201,1570,156,377,530,81,775,76,639,1171,454;71;F
49635;311,188,1207,252,81,76,1738,1201,454,142,530;44;F
49681;35,156,1017,377,473,1166,1198,504,1138,468,775,1201,864,454,866;69;F
49697;1419,288,290,157,1211,202,76,188,293,1201,492,647,1570,473,454;35;F
49737;1198,1258,1246,1419,1099,1133,473,142,141,252,81,209,293,647,530;40;F
49741;1570,141,288,157,289,294,290,76,843,1023,103,35,663,866,292;73;F
49749;252,1211,944,76,639,141,647,1570,1017,377,473,454,663;45;M
49754;1374,75,1258,76,992,1201,647,1133,1158,864,1017,473,454,1166,530;18;F
49808;75,1104,1014,157,76,188,1201,1133,1004,156,377,473,454,292,530;41;F
49849;1099,157,775,188,639,479,293,1171,773,1133,103,473,1157,454,663;44;F
49859;663,454,1014,479,504,1133,293,1171,1201,1207,1211,252,103,76,35;30;F
49862;209,252,288,76,492,647,1133,103;33;F
49914;1133,492,188,944,1211,252,468,1228,157,1570;29;F
49944;76,1171,647,473,1166;38;F
49988;292,663,1017,35,1133,1740,1570,1099,1023,1419,311,1228,290,289,294;71;F
50066;103,1014,473,530,454,152,1158,1419,1738,1211,252,1104,209,1246,1133;40;F
50092;252,157,1736,468,1211,141,1570,473,142,530;44;F
50243;311,1419,1201,141,1158,454,530,81,252,1211,76,293,1133,103,473;37;F
50255;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;56;M
50259;775,81,1198,294,1228,252,288,1246,1419,1201,141,454,142,866,530;48;M
50273;1138,944,1107,479,1201,773,492,141,864,35,1017,473,454,530,866;50;F
50279;81,504,1138,944,1107,1201,773,1570,1740,1133,864,1017,454,866,1166;49;F
50289;252,1374,1157,1260,1171,1246;25;F
50342;454,1166,142,1211,1374,252,290,1736,76,293,1439,1171,141,103,1017;33;F
50411;468,1138,775,1107,1570,103,864,156,473,454,142,866,292,530,1541;44;M
50449;1419,504,1228,294,1737,288,1374,76,311,1023,1734,103,35,1017,663;63;F
50546;1198,81,1228,775,288,639,1439,1171,1023,1201,473,1157,454,663,530;37;F
50559;1246,1258,252;74;M
50589;157,209,775,152,156,142,530;39;M
50590;152;11;M
50600;530;33;M
50614;152;46;F
50666;1570,1201,209,252,1211,1023,156,103,1419,473,35,944,293,454,663;34;F
50687;103,473,663,1258,1419,647,1158,1157,1166,530;31;M
50714;1171,141,647,1570,1017,473,1198,290,293,992,35,663;35;F
50757;468,1104,81,157,252,288,202,188,1246,639,1171,492,773,473,142;43;F
50760;157,1104,1107,1171,156;41;F
50786;1207,293,1014,479,1017,473;39;F
50789;1439,293,1246,188,202,944,1211,288,252,209,157,1104,1107,1171,156;9;M
50793;1201,1541,866,454;78;F
50825;1201,773,141,103,35,530,142,473,209,157,1104,1107,1439,1171,156;47;M
50835;1246,288,468,252,188,1439,1171,1740,1004,377,473,1157,454,530,142;36;F
50840;473,293;47;M
50907;504,157,252,288,479,773,1099,1570,1004,775,1201,473,454,866,1541;38;F
50916;1133,142;45;F
50952;293,1246,775,468,81,1198,1374,202,639,479,1171,647,473,663,292;42;F
50953;530,290,1374,1211,1246,293,141,1014,152,473;38;F
50986;75,1300,76,141,1014;51;M
51013;504,1138,290,289,209,1017,142,530,75,81,311,1201,647,377,454;52;F
51015;1419,141,1133,530;24;M
51024;773,1099,1133,1158,530,1207,647,103,479,1023;38;F
51060;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;69;F
51147;1228,294,1736,289,81,290,252,202,1099,647,1570,103,1081,866,530;29;F
51166;504,1138,1374,1201,252,492,1004,1260,183,1081,1166,866;44;F
51213;1228,944,1738,639,1171,647,1740,103,377,1157,663,1081;38;F
51214;1157,1166,103,1133,1570,141,639,76,252,1300,83,81,1171,647,1017;15;M
51222;1228,492,202,992,647,864,454,1081,1541,866,504,209,944,1570,1166;44;F
51244;1228,294,289,1736,1198,504,1138,639,103,156,454,492,1099,209,1570;38;F
51253;290,468,252,288,76,188,293,1171,1734,773,492,156,1017,473,1541;28;F
51265;290,1138,1738,293,1246,141,1133,473,454,663,76,311,1099,1166,209;43;F
51267;377;72;M
51279;1104,1014,311,1133,142,141,76;37;M
51293;252,288,1171,647,103,1260,1017,377;26;M
51298;288,1246,1133,1158,454;22;M
51324;1246,377,1541;70;F
51360;647,75,1258,1246,311,1419,1158,1260,377,1166,141,1133,1014,142,530;70;F
51374;1258,209,468,775,76,311,843,1201,773,1133,1004,864,156,1017,454;35;M
51401;76,1419,1133,1158,103,1166,141,142,530;45;M
51405;81,290,1201,1099,1570;29;F
51462;292,142,1260,1439,252,1419;64;M
51496;1158,1133,1099,1171,1419,639,311,1246,1738,76,252,141,647,103,530;43;F
51548;81,76,311,1107,1201,492,141,1133,103,35,1014,473,454,142,530;37;F
51556;1004,152,454,1198,81,209,504,1138,252,1211,944,188,293,1201,473;35;F
51567;290,1138,252,944,1374,1570,1004,864,1017,377,473,1157,454,663,292;50;F
51568;1198,252,1246,1439,1419,454,142,530;36;F
51629;103,492,1201,1211,288,252,454,1166,1198,311,1133,76,1158,1171,1419;45;M
51653;1211,1439,1419;62;F
51665;530,292,454,1017,103,1158,647,141,1023,1246,288,290,1258,76,1133;51;F
51676;1439,1419,843,1171,1023,141,1158,35,1014,473,663,142,292,530,377;48;M
51678;1138,141,1570,1198,1738,1133,103,1017,530,1158,1201,1419,1439,1246,76;20;F
51731;252,1211,1207,76,479,293,1201,1133,1004,103,1014,1260,156,473,454;33;M
51738;75,76,141,1014,142,530,83;39;M
51763;142,864,1198,83,1138,944,1207,1246,1201,492,141,530,76,103,454;37;M
51780;1736,252,1211,76,188,479,293,647,1570,1133,103,1014,156,473,454;33;F
51792;1246,1133;44;M
51793;647,209,294,504,252,288,76,1246,1201,492,1133,1158,183,454,866;38;F
51835;1023,1570,1158,35,156,142,1133,1107,1246,76,1211,468,209,157,1198;42;F
51838;83,1138,775,252,1419,1014,142,75,1374,76,1246,141,1133,103,530;42;F
51884;252,1300,209,202,76,188,1419,1570,156,1017,377,473,663,530;47;F
51906;76,479,1439,1419,1171,1099,141,1740,1133,1158,156,1157,142,292,530;53;F
51907;1246,1211,311,1023,647,103,377,35,1260,1017,454,663,866,292,530;40;F
51964;1736,290,252,1107,479,843,1171,1099,647,1158,35,1017,663,292,530;50;F
51991;1258,209,1419,1570,1133,1158;35;F
52053;530,1081,1157,1017,647,141,1171,639,288,252,157,142,311,1198,1104;30;F
52126;1736,202,76,156,454,142,1570,292,35,1541;66;F
52128;377,1104,209,1258,1246,639,1158,530,468,288,76,1419,1171,1201,454;32;M
52152;209,1737,288,202,188,1246,647,492,1099,864,156,454,663,1166,1211;50;M
52211;293,141,103,1017,663,473,530;42;F
52245;1099,1014,663,866,1246,647,1570,1133,103,473,1157,454,142,292,530;49;F
52252;1158,1107,639,1201,647,1133,866,290,202,76,1246,1419,843,454,663;46;F
52282;202,76,1171,1099,647,103,156,454;26;F
52317;1738,454;45;F
52363;1246,76,504,290,81,294,1736,75,1198,1258,1419,454,142,292,530;35;M
52371;454,157,289,1104,468,647,1017,292,1107,843,1171,1099,103,473,663;46;F
52395;944,1107,1201,492,1570,864,1260,377,183,454,866,1166,1198,992,773;30;F
52402;202,1201,156,473,1157,454,468,1246,1171;45;F
52403;1198,209,252,1246,311,1419,1201,647,1133,103,864,530;37;F
52408;530;37;M
52439;1133,1099,1246,209,1258,252,1211,202,188,639,293,1419,1171,1201,647;37;F
52458;1171,75,1300,1246,141,1133,1158,1014,454,530;48;F
52497;209,288,311,479,1419,1201,141,1133,1158,1014,1017,473,454,142,530;44;M
52534;157,75,1198,81,209,311,1201,141,1133,1158,103,1014,454,142,530;31;F
52535;81,1300,1104,252,288,76,1246,647,1158,1260,454,1166,530;70;F
52543;473,1419,293,944,288,290,492,188,1211,1017;31;F
52586;294,1099,141,647,1133,103,1017,473,866,530,1023,663,292,289,290;47;F
52652;1104,1736,1258,252,76,293,1439,1419,992,1570,1158,1133,864,1017,454;69;F
52694;83,311,1419,1158,1133,1260,183,142,530,1104,76,1439,141,1014,377;40;M
52701;1138,290,294,1198,76,530,157,252,775,1201,35,1017,377,473,454;71;F
52708;75,1246,1158,1014,454,530;47;M
52732;1081,1198,81,1138,775,1737,288,202,1201,1099,647,864,454,866,530;48;F
52737;81,252,288,202,311,639,1099,141,647,1004,103,454,663,866,530;36;F
52739;83,1198,1138,468,1260,1017,1107,1201,141,647,473,183,377,454,866;17;F
52746;202,1570;36;F
52835;1017,377,75,252,1211,479,1439,1419,647,1004,103,156,473,454,530;39;F
52849;1133,292,530,1166,663,843,289,290,1228,252,639,479,647,1017,1570;50;F
52945;1014,141,377,142,530;34;M
52959;992,492,1740,1158,864,530,1198,1246,293,1419,1570,1004,103,473,454;37;F
52972;843,1246,1419,1171,1201,141,1017,75,76,647,1570,1158,1133,103,473;49;F
53007;75;32;F
53042;775,492,1740,1004,152,156,377;23;M
53052;866,1541,1198,1736,288,639,141,647,35,252,76,311,1166,142,530;39;M
53066;377,866,288,1138,1258,156,454,663,530,292,1570,504,468,76,944;44;M
53120;183,473,1166,142,530,1198,75,1104,1211,479,1246,1107,1171,141,1570;78;M
53139;290,83,141,142,1541;69;M
53149;293,1023,492,141,647,1570,1740,1133,35,1014,1017,473,454,1166,530;68;F
53161;209,1246,647,1133,103,663,530;39;F
53237;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;77;F
53245;290,76,293,1570,473,292,530;42;F
53255;377,1171,1107,81,76,1246,1740,454;73;M
53351;1541,1740,1260,377,183;40;M
53356;1099,1740,156,1157,157,1736,290,468,775,1737,288,1374,202,639,1171;34;F
53389;504,252,288,775,1738,311,1107,1201,992,1133,864,1014,454,1157,866;47;F
53399;83,775,252,76,1246,1201,647,1740,1133,377,183,454,292,530,1541;67;F
53401;152,1157,775,1138,81,1198,289,311,843,290,944,1023,1201,663,292;46;M
53421;775,209,530,311,1246,76,252,1300,83,1014,1133,141,1738,1207,75;45;F
53425;1300,311,141,647,1014,530,103,1017,76,83,252,1133,75;46;M
53443;1014,473,663,530;44;F
53476;864,1014,152,156,1017,1157,1081,866,504,76,647,1158,1133,1166,142;46;F
53484;1541,504,252,639,1201,992,492,647,1570,473,454,663,1081,142,530;43;F
53511;1198,1081,864,492,1201,1138,252,76,1246,141,1570,647,103,1017,454;25;M
53554;75,252,773,647,1133,103,152;44;F
53560;290,252,76,311,1017,289,288,1246,1419,141,1133,1158,103,142,530;33;F
53571;288,202,311,639,1439,1171,141,1133,1004,183,530;32;F
53606;83,141,142,75,252,1107,1171,1201,1014,454,530;48;M
53614;1258,1166,290,252,288,76,1246,311,1419,141,1133,1158,103,142,530;35;M
53704;75,1300,1246,35,530,76,83,81,252,103;45;M
53713;1198,1104,775,1211,1107,293,1439,1171,141,1570,1133,1158,156,183,1166;75;F
53745;1258,1104,76,1133,530;35;M
53772;377,292,1736,1258,209,1374,1246,1439,1419,1023,141,1158,663,142,530;51;F
53780;1198,479,1171,1133,103,454;36;F
53829;81,202,1258,252,1439,1107,141,530,142,1246,209,76,1419,1133,1158;46;F
53832;1166,1737,252,944,1246,639,1419,1201,1570,1158,1740,1133,864,454,530;35;F
53843;188;41;F
53868;141,1014,142,1258,1246,1419,1158,252,288,76,1201,647,1133,103,530;27;F
53882;1228,252,76,1246,293,1171,103,35,1017;37;F
53889;1541,292,1166,103,1211,252,76,1201,773,492,647,1570,1133,454;42;F
53905;1133;18;M
53922;775,473,1738;43;F
53933;647,1133,1158,103,663,142,292,1201,1419,76,1374,288,252,141,530;58;M
53934;1133,639,1734,1300,183,1258,1246;46;F
53964;1300,775,1738,1171,141,473,142,530;50;M
53990;75,252,288,202,76,639,1023,647,1570,1133,35,289,1017,663,1081;38;F
53998;293,202,83,1104,288,1211,76,311,773,141,1014,473,454,142,530;39;M
54023;1201,141,1133,35,1419;37;F
54024;473,454,663,157,1104,1107,1171,156;67;M
54073;75,1258,83,76,141,1133,1014,152,530;53;M
54086;75,252,288,1439,1419,141,647,1133,1158,1004,663,142,530;34;F
54088;252,1419,1171,1023,1099,1158,1004,103,35,152,156,663,142,292,530;58;F
54105;1198,75,83,252,479,1023,35,1014,1017,473,1157,454,663,530,292;43;F
54180;944,202,1023,647,468,1211,293,1419,992,492,1570,103,156,473,1300;36;F
54184;75,288,1419,1133,1158,1014,1260,1439;27;F
54185;294,81,1228,1300,944,311,647,1133,1004,103,156,454,663,1166,530;33;F
54187;663,866,103,1138,75,81,83,1099,1017,454;38;F
54224;290,252,866,1081,1570,103,454,288,311,141,1158,530;31;M
54264;141,156,1157,142,157,1171;43;F
54305;1258,647,75,288,1439,252,1133,377,183,76,311,141,1014,142,530;55;F
54346;1104,1107,183,377;62;F
54363;1300,1228,1171,1260,1211,504,468,252,202,1246,639,1133,377,183,530;28;F
54389;377,530,773,142,1171,866,1157,1419,639,311,1246,188,775,1258,157;44;M
54397;1260,103,1740,647,773,1201,311,76,1737,775,504,209,1258,866,292;46;F
54436;75,76,142,530;47;F
54449;209,468,1211,944,479,293,492,1570,103,156,473,454;35;M
54470;1198,35;71;F
54498;1201,773,454,1541,1166,157,290,468,775,293,1419,647,1570,1133,530;44;F
54504;202,1246,1107,479,35,377,292,1439,1133,103,1017,663,1166,866,1541;41;F
54506;468,1737,202,647,1570,1158;45;M
54510;1740,141,1228,252,1374,1246,1107,1133,1260,142;50;M
54538;1738,1419,1133,1198,1258,288,1246,311,1158,1260,454;41;M
54543;1099,103,35,1260,377,183,663,866,292;75;F
54571;35,1419,1740,864,1260,479,293,843,1201,141,866,1198,81,142,530;61;M
54597;1570,473,290,288,1211,944,188,1246,492,647,1133,103,35,156,292;38;F
54658;1374,1211,1201,103,76,1541;39;M
54669;75,76,311,1439,1419,141,1133,1158,473,663,1166,142,292,530;45;M
54715;1211,188,1201,492,647,1081,454,209;7;F
54736;209,1211,1201,492,647,1081;6;F
54738;157,289,288,1211,944,202,1734,647,156,473,1157,663;26;F
54755;209,647,454,1081;2;F
54758;76,1246,1419,1201,647,1740,1133,103,1260,473,454,1166;35;M
54863;35,773,1201,293,479,1246,202,1207,775,504,141,1017,663,142,1541;50;F
54887;294,290,1228,992,202,76,1171,1099,647,1570,1133,1017,454,866,292;64;F
54920;454,1201,293,1211,288,1258,81,530,473,1158,1133,1099,1419,76,944;33;F
54938;530,141,492,252,468,157,504,1201,773,1133,156,1157,454,1081,1166;36;M
54983;1570,473,454,1198,209,252,1107,639,293,1171,1201,773,492,141,647;12;M
55024;288,252,504,1104,81,157,1198,209,1107,1171,1201,647,1570,473,454;8;F
55040;1201,1014,209,83,75,1300,252,76,1246,1133,1004,103,377,142,530;45;M
55044;83,1374,1439,75,1300,76,1133,1541;16;M
55049;454,156,647,1099,492,992,1201,1171,293,639,1107,1738,288,252,209;3;M
55123;289,292,1104,775,252,1570,1017;35;F
55150;293,843,1023,1158,1004,103,156,530,639,1171,1099,1570,1017,473,663;37;F
55157;1099,1133,1017,530,1004,454,75,81,479,1201;52;F
55232;1246,1419,1133,35;45;M
55244;1736,1198,157,81,1374,1246,1171,1099,647,103,473,454,1166,142,530;38;F
55304;775,288,1211,76,188,639,479,293,1171,1201,492,1158,156,1157,454;37;M
55327;209,468,775,1211,76,188,639,293,1171,492,103,35,156,473,454;35;F
55328;289,290,252,202,1246,1419,843,1023,647,1570,1133,1260,454,663,292;43;F
55355;1736,1246,1198,290,1138,252,479,1201,35,1017,377,454,663,292;67;M
55425;1258,209,1246,1419,1133,1158,530;37;F
55460;1738,647,663,290,209,1138,866,1258,252,1246,1419,1201,1158,1014,454;35;F
55529;141,1201,504,81,209,76,1246,293,1171,1133;50;M
55549;1300,1419,1004,103,1014,156,663,1017,377,75,288,76,311,1439;67;F
55583;1374,1171,647,1158,663,75,290,252,76,639,141,1133,1166,142,530;35;F
55597;454,864,1099,1419,1246,1374,1198,1258,1201,1158,1133;39;F
55600;76,35,156,454,663;38;F
55621;1138,1737,252,76,1004,1017,454,663,1081,292;75;F
55645;152;65;F
55661;1171,1023,1734,773,1570,1740,103,864,35,156,1017,473,454,663,866;47;F
55674;1207,288,1737,775,76,252,1171,141,142,530;49;F
55720;1258,1246,1419,1158,103,1014,142,530;49;M
55745;530,479,288,1300,81,75,142,1166,454,377,1133,1439,311,76,1104;40;F
55755;209;47;M
55768;35,479,293,1107,1737,1228,202,647,1099,1023,1419,639,290,289,1201;30;F
55774;473,1017,141,492,1171,479,1246,1107,311,76,1198,81,1201,1133,454;46;M
55835;1014,1004,1099,1171,639,76,1211,288,775,468,1104,1258,209,454,142;43;F
55858;293,188,76,202,1138,468,288,1211,944,1246,1201,492,647,473,454;42;F
55902;1138,1201,1258,1099,141,647,1004,142,289,81,1374,202,663,292,530;53;F
55906;639,1246,1107,1171,1133;33;F
55925;157,1419,1158,1258,1211,76,293,1171,773,1099,1133,864,156,473,454;35;F
55954;292,1258,294,290,252,1211,1023,1201,492,1133,103,1017,473,454,663;74;F
55980;377;63;F
56014;1211,293,1419,647,1133,473,866;29;F
56023;1374,1246,1419,1133,1158;45;F
56038;1133,1419,1439,188,76,288,252,1258,141,142,530;38;M
56059;1258,141,647,103,183,142,530,157,1104,1107;42;F
56075;157,1300,468,944,188,1738;37;F
56091;157,81,944,202,1738,1107,293,843,1023,1099,864,35,473,454,663;34;F
56097;530;54;F
56105;1570,1099,1201,293,76,1207,288,157,290,209,775,1211,473,454,866;38;M
56117;944,1207,639,479,293,1171,1570,1740,1004,103,1166,81,252,1133,454;33;F
56157;530,663,35,647,141,773,843,639,202,479,1099,1570,1158,142,292;52;F
56166;142,1157,141,992,1246,1570,504,468,202,188,639,647,152,156,1541;37;M
56183;377,142,156,1014,103,1004,1133,647,209,1258,1374,311,1419,1158,1166;34;M
56192;377,1260,141,1201,1439,1107,1258,252,76,311,1158,183,454,1081,530;43;M
56208;1246,1439,1133,1158,1258,209,1419,377;33;M
56216;209,1541,252,1374,311,1419,843,141,647,103,864,1081,142,866,530;33;M
56245;377,1081,209,76,639,1734,103,1017,473;32;M
56261;1201,647,103,377,866,1738,944,775,209,252,1246,1133,1157,454,530;43;F
56267;1198,157,468,1374,1157,866,530,252,1207,1419,1171,1201,773,647,103;43;M
56276;252,76,1246,311,1171,647,1133,1017,142,530;29;M
56283;288,252,76,647,1133,1158,142,530;33;F
56309;141,76,1246,311,1419,1158,1133,1157,454;37;M
56319;141,1017,294,1228,775,288,1246,639,1171,1133,1004,156,1157,473,454;31;F
56376;1138,1133,1158,454,1198,866,252,843;59;M
56384;1198,1736,1228,504,944,76,1419,1201,647,454;60;F
56389;288,76,1107,479,293,1171,647,1570,1133,103,35,473,454,866,530;46;F
56401;252,1374,188,293,1171,1201,157,294,775,202,647,1017,473,663,454;31;F
56407;1138,288,202,639,479,454,142,1541,252,1099,141,647,103,663,530;35;F
56414;454,1738,1207,81,944,1201,141,1133,1570,103,377,1166,142,530,1541;42;F
56511;81,1211,1207,1738,1201,141,1570,1133,103,377,454,1166,142,530,1541;8;F
56529;468,1211,1207,1738,1201,141,1570,1133,103,377,454,1166,142,530,1541;7;M
56553;1104,1246,1740,141,530;44;M
56571;468,1374,1207,202,1738,1246,1171,1099,647,1570,1133,1158,864,35,1166;27;F
56606;1419,1133,1158,103,1260,1017,377,1081,473,1166,866,1541,1738,1207,1157;44;F
56608;1300,252,76,311,1419,1171,647,1158,103,473,142,530;40;F
56614;290,252,288,1419,647,377,183,454,1198,141,1133,103,663,866,530;39;F
56632;76,1419,1133,1158,454;46;F
56668;1198,252,1246,1419,1201,992,773,647,1260;42;M
56670;252,1246,1419,992,647,1133,103,1260;37;F
56710;1017,183,473,1081,866,209,252,1211,1419,647,1570,1133,663,530,1541;43;F
56739;473,156;42;F
56770;1570,152,156,1017,530,209,311,293,1171,773,647,1740,103,377,473;43;M
56771;1158,663,1133,35,473,530,1198,209,252,1207,1201,647,454;37;F
56773;1419,1201,647,1570,1133,1158,1017,454,1081,866,1541,202,473,663,1166;26;F
56776;209;36;M
56788;288,252,504,1300,83,294,1258,289,75,76,1201,1158,103,142,530;51;F
56886;1099,1570,454,1166,492,775,1737,468,288,639,1171,1740,1133,473,530;46;F
56956;142,530,1201,944,454,1133,1419,76,1570,209;65;F
56958;103;27;F
56968;75,1198,1246,1419,141,647,1158,1166,479,103,142,530;27;M
56971;209;49;F
57001;1541;61;F
57018;1246,76,1207,141,142,209;47;F
57046;83,1737,1419,1570,866,183,1171,639,1198,289,504,292,1201,1017,454;42;F
57109;157,1104,504,1107,1171,156;47;F
57120;252,1439,1734,1099,1158,1133,35,156,1017,473,454,663,1081,866,530;41;F
57165;293,1419,1201,492,141,1133,1158,103,864,35,156,1017,454,142,530;34;M
57175;1158,252,288,1246,639,1419,1171,141,647,1133,530;30;M
57185;530,142,1166,377,1014,647,141,1419,311,75,288,76,1246,1133;23;M
57226;1207,103,1014,1260,377;42;M
57260;1023,1099,1740,156,473,252,1374,1207,1419,647,1133,1158,1017,1166,530;33;F
57264;1104,75,35,81,290,209,76,293,1171,1570,1017,377,473,292,1541;40;F
57286;1017,473,289,290,1228,504,252,1107,1201,1570,35,454,663,292,530;63;F
57292;647,103,473,454;63;M
57294;157,1171,156,1736,1104,1737,288,1107,944,1201,1740,530,377;66;M
57300;647,1133,1158,864,377,1157,454,1081,530,1258,1419,183;23;M
57422;1198,1104,76,1246,311,639,1171,1734,492,647,1570,1133,454,142,530;40;F
57437;289,294,290,288,311,293,647,663,292;41;F
57476;311,1246,1260,142,252,288,1439,1419,773,377,141,1158,1133,647,473;40;F
57481;141,1439,1107,311,76,1138,252,288,1246,1201,1099,1158,454,142,866;39;F
57618;311,1099,1081;16;M
57628;252,1374,76,647,1133,103,663,1166,530;30;F
57642;289,290,288,202,293,1099,1570,103,35,1017,473,454,663,530;44;F
57725;1198,103,377,1133,1171,157;43;F
57749;75,1207,76,1246,1171,1570,35,454,1258,1738,492,647,103,864,1014;44;F
57762;103,454,663,866,1541,311,290,289,288,479,647,35,156,1017,530;36;F
57784;1107,1104,1171,1201,492,647,864,35,1260,1017,377,183,473,454,866;54;F
57800;647,103,1166,866,183,1258,76,1246,1419,141,1133,1158,1014,142,530;27;F
57814;1171,479,1246,311,1439,1201,141,1158,75,76,1419,1133,454,142,530;30;M
57836;209;23;M
57849;1104,83,209,1374,76,311,1439,1419,1171,141,1133,1158,1014,142,530;39;F
57857;81,944,1207,1738,1201,141,1570,1133,103,377,454,1166,142,530,1541;43;M
57883;75,1198,157,1104,252,76,311,1158,1133,103,377,454,142,1201,1107;15;M
57920;252,1099,1570,1133,1260,454,866;49;F
57925;141,1023,1171,1246,188,202,1207,468,1740,1133,156,473,454,663,530;34;F
57979;1201,454,252,83,76,103,75,530,1138,775;50;M
58032;1419,775,1211,944,76,188,479,293,647,1570,103,156,473,454,663;37;F
58153;289,294,290,479,293,1023,1099,647,1570,1017,663,1081,35;29;F
58180;1246,76,209,1258,1158,1419,1133;29;F
58230;288,1211,311,1439,992,141,142,76,293,1419,1201,1133,1004,454,530;41;F
58256;1258,1419,1133,103,252;42;F
58277;864,35,1017,663,292,1541,468,944,188,1201,1570,152,473,1157,454;8;F
58295;479,35,473;51;M
58301;1014,1138,252,142,103,866,35,1201,454,75,141,1158,530,1258,1246;36;F
58307;1541,81,294,289,157,1133,492,1171,1419,1246,1738,944,1258,290,1158;53;F
58316;1439,639,311,1246,188,76,288,252,1737,468,1300,1228,83,1258,75;48;F
58350;311,1014,252,1374,76,1246,1419,141,647,1158,103,377,142,530,1133;42;F
58366;1158,1133,1419,288,1138,81,1736,83,252,1374,76,639,1171,1099,1260;28;M
58385;288,293,1171,103,209,152,377,473,292;42;F
58438;1258,1736,157,289,290,252,202,1023,1570,35,1017,454,663,1166,292;47;F
58439;1158,1004,152,1166,103,1133,1740,1419,1246,76,202,1207,944,288,183;39;F
58462;1198,663,292,289,1228,252,288,76,1023,1201,141,1570,103,35,454;43;F
58482;75,252,76,530;54;F
58502;1211,1258,504,288,1246,1201,773,492,1099,141,1014,473,454,866,530;48;M
58519;1246,479,1734,492,1570,1133,1158,1004,864,103,156,1017,473,454;20;F
58587;1158,1133,75;34;M
58589;1138,252,944,1419,1171,492,647,1570,1133,103,156,473,530,1541,292;40;F
58624;252,647,1133,1260;21;M
58644;35;44;F
58671;866,1541,1419,468,1211,311,1734,647,864,35,473,454,1166,142,530;40;M
58672;1374,468,504,1198,663,188,202,290,1171,647,1017;35;F
58713;1570,1133,1157,866,530,468,1246,639,1171,1734,1158,864,183,377,1081;23;M
58734;293,142,454,866,75,81,1211,944,76,492,103,35,1014,473,530;45;F
58763;773,492,1541,1736,1207,866,1198,479,293,1133,1260,454,252,1201,1004;54;M
58788;209,1107,639,843,773,1133,1158,103,35,377,454,252,1419,1171,492;38;F
58804;530,142,454,103,141,1246,76,202,468,1374,1158,1133,1419;52;F
58890;1258,1133,252,1246,1439,1419,1158,142,1541;47;F
58895;209,202,1734,377,183,1081,142;36;F
58904;81,311,1133,647,103,454,142;56;F
58921;1017,663,944,1201,773,1570,1207,35,157,209,468,103,479,293,473;32;F
58924;1104,944,1107,1171,1158,156,454,142;39;F
59059;209;39;F
59081;1260,1099,773,209,76,202;9;M
59089;288,775,209;11;M
59094;209,202,1246,843,1171,864,152,377,183,1081,142;4;M
59105;209;9;M
59120;209;44;M
59132;479;50;M
59153;75,504,468,252,288,76,1246,639,1439,1419,492,473,454,663,142;37;F
59189;290,1211,293,1171,1133,156,473,454,663;31;F
59193;290,288,1171,1133,473,663,292,504,944,1201,773,492,454,1541;70;F
59197;492,473,1081,866,292,252,188,1171,1099,1570,1014,35,156,1017,454;38;F
59231;81,1104,1107,1171,141,473,454,142,530;51;M
59247;209,202,1171,647,473,454;37;F
59262;81,252,1211,188,1419,1171,1023,492,1570,1133,1158,35,156,473,454;30;F
59263;288,992,76,1419,1133,1158,1570,202,1541;59;F
59264;1570,202,992;54;F
59273;188,468,209,1198,157,81,504,1211,944,479,293,103,152,473,866;36;F
59293;209;9;F
59306;188;33;F
59307;293,639,1246,188,288,1138,81,468,252,1211,76,1023,473,454,530;4;F
59310;81,468,103,864,504,1246,1107,1198,454,1081,1541,866;70;M
59321;209,1541;46;F
59324;468,252,1246,1439,1419,773,492,141,103,1260,156,473,454,142,530;8;M
59373;454,76,530,142,1246,202,1211,252,209,141,639,1419,1201,1158,473;40;F
59383;290,1138,252,1211,944,639,1171,1201,492,647,35,473,454,663;39;F
59384;141,188,288,156,454,663,1166,142,530;30;F
59385;289,1198,75,1736,1258,1374,76,1439,1419,1171,1201,141,1133,663,142;29;F
59413;1198,289,1228,1211,1207,293,1201,647,1004,1017,473,292;9;F
59415;1211,1738,293,1419,1099,1570,1133,103,35,152,156,473,454,292,530;36;F
59416;1570,202;63;F
59418;1166,1133,1736,1258,252,1246,1419,1201,1158,454,530;31;M
59419;479,843,289,290,1023,141,35,1017,663,454,142,292,530,1374,1439;47;F
59428;188;24;M
59432;504,1138,775,1246,479,1023,1171,1017,663,1081,1541,292,1201,1014,454;49;F
59436;188;18;M
59443;1198,289,1228,1211,1207,293,1201,647,1004,1017,473,292;7;M
59447;944,188,773,492,1570,152,156;39;F
59461;188;49;F
59475;188,1107,1171,1201,1734,773,492,647,1570,864,156,1157,454,866,1541;28;F
59482;209,290,1258,1228,1104,775,288,639,293,843,647,1017,1157,663,292;42;F
59503;209,141,1158,142,530;48;F
59517;142,81,1014,1570,1419,1246,1207,288,209,83,76,311,141,377,530;65;M
59542;1023,843,1738,1207,1211,468,1099,647,103,1017,663,35;43;M
59543;639,1171,81,1198,202,1107,1419,1201,492,647,1570,377,864,454;68;F
59569;75,289,1228,1374,188,479,843,1171,1099,1004,103,663,292;39;F
59579;290,288,1099,103,473,1157;44;F
59611;293;46;M
59619;1133,35,252,290,209,1737,1439,454,530,1158,76,1419,647,663,292;44;F
59650;141,142,639,1211,1171,1133,530,209,473;40;F
59658;639,843,1171,1734,1099,1158,152,1166,157,76,1419,647,156,454,663;35;F
59673;252,1258,75,1300,1260,1166,142,311,1133,1158,103,1014,530,76,141;33;M
59746;1258,1211,1246,1419,1171,647,1133,473;33;M
59778;1211,492,647,473;32;M
59792;81,252,76,1419,141,647,473,142,530;39;M
59799;1198,81,504,1138,468,775,944,1107,1201,1734,773,864,454,866,1541;82;F
59803;992,864,156,866,530,152,35,1570,492,944,188,293,473,454,142;40;F
59812;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;41;F
59816;252,1374,1246,479,1133,1158,377;36;F
59826;1740,1228,1099,1258,1419,1570,252,1207,1738,1246,311,1201,647,1133,1158;43;F
59880;75,83,311,1439,141,1158,1014,156,377,142,530;41;M
59884;209,530;25;M
59886;188,1736,1198,290,202,492,647,1570,35,473,454,663,1166,866,292;30;F
59896;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;76;F
59923;252,311,1133,103,454,663,142,530;43;F
59952;1258,76,1171,992,647,866,1158,530;32;M
59975;1158;30;M
59977;639,1439,1023,647,141,103,1014,1157,142,454,663,152,75,1171,530;36;F
59985;103,454,1201,1138,290,75,1166,639,944,530,141,1439,76,288,1258;32;F
59987;1211,504,202,188,639,1439,1171,1099,141,156,663;36;F
60003;1104,288,76,1246,1171,1734,866,454,1133,647,252,1258,81,103,209;49;F
60006;1198,1258,1201,288,1104,504,188,1099,141,473,530,252,1439,1171,142;32;F
60048;76,1211,252,1171,1201,530;36;M
60067;1258,504,1211,188,1734,773,492,1099,1133,1004,864,156,454,663,292;40;F
60069;773,1004,1014,454,157,293,1171,473,530,76,1246,1419,1133,1158,35;11;F
60082;157,156;59;F
60109;1211,473,1258,252,1207,76,1246,1171,1201,141,1133,377,454,142,530;51;M
60137;1419,209,81,1258,141,1133,142,992,530,1211,76,1246,311,647,473;38;M
60141;83,530,1158,141,843,1419,288,1736,252,1246,311,647,1133,377,1166;32;M
60158;1138,468,944,1107,1201,773,492,864,454,866,1541;77;F
60182;311,290,294,1737,252,1374,76,1201,647,1198,1246,1419,1133,454,866;56;F
60187;293,1104,209,81,1258,252,76,1246,1171,1734,647,1133,103,454,866;10;M
60189;504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;84;M
60203;1228,1207,1023,1017,1374,1439,1260,1166,1258,209,76,1158,83,530,1133;29;F
60204;75,83,1300,252,647,1133,103,454;48;F
60234;288,647,1014,292,311,1133,377,142,530;38;M
60256;1258,75,1211,311,293,1419,1099,141,1570,103,156,1017,473,866,530;35;F
60270;290,202,76,639,1023,1570,103,35,1017,377,473,663,530;45;F
60311;209,252,35,1260,1246,479,1419,141,1133,1158,103,1017,473,142,530;44;M
60327;293,1419,288,1211,479,141,647,1133,35,142,530,1017,663,473;52;M
60363;1023,1158,864,1198,75,468,252,293,1171,773,647,1570,35,1014,454;25;F
60381;1201,492,647,103,141,1004,152,156,454,1166,530,639,1171,1133,1158;42;F
60397;157,1246,1201,773,1133,35,209,1211,76,293,492,647,1570,473,454;33;F
60402;141,290,76,293,530,473,103;24;F
60417;1570,1158,1004,103,1017,663,1081,1166,530,252,843,141,647,1133,1014;31;F
60443;1228,141,1158,377,473,454,142,530;48;M
60445;209,1228,1104,944,1133,1014,377,142,530,1258,1207,311,1439,454,1166;38;M
60449;252,76,1246,479,1104,103,473,157,209,1419,647,1158,1004,1157,142;8;F
60508;1228,1419,1004,1260,377,157,1104,1107,293,1439,1171,156,183,142,530;39;F
60509;252,647,1166,141,1133;32;F
60554;252,1246,1419,647,1133;30;M
60579;293,992,492,1099,647,156,473,454,1541;31;M
60637;290,252,288,639,1171,1099,1166,647;36;F
60648;1211,311,479,1419,1201,141,647,1133,103,1017,473,454,1166,142,530;37;F
60672;202,479,1419,1023,1570,1740,1133,1004,103,35,1017,663,142,292,530;52;F
60685;252,1246,1419,1201,992,647,1133,1158,156,81,288,1211,492,473,454;37;F
60700;75,1300,252,288,76,1246,647,103;35;M
60713;1258,81,209,504,1104,252,76,1246,1171,1734,647,1133,103,866,454;43;M
60733;142,1166,454,473,377,1158,1133,647,141,311,76,479,1439,1419,530;54;M
60741;288,141,1740,530;36;F
60742;1260,377,473,35,663,1081,142,141,773,1201,1171,209,454,292,530;47;M
60744;1374,468,504,1258,81,288,311,639,141,1133,1004,152,156,377,530;46;F
60767;75,289,1300,252,1207,76,103;32;F
60772;252,1570,663,530;33;F
60779;76,75,81,252,83,103;31;M
60786;289,294,290,288,311,293,647,663,292;47;F
60789;294,290,647,103,156,1017,292;58;F
60807;252,1211,76,1246,479,1171,1133,530,141,647;43;M
60810;1211,76,209,944,1738,293,1419,1201,1099,647,1133,103,864,663,866;37;F
60812;843,311,944,1211,157,1104,1107,1171,1439,156,377,454,1081,142,866;4;F
60820;209,1211,639,293,1419,1171,1201,773,492,1099,1133,35,473,454,530;42;F
60835;289,294,290,288,311,293,647,663,292;51;M
60848;647,1014,775,252,76,843,141,1133,35,75,103,663,1081,530;55;F
60865;289,294,290,288,311,293,647,663,292;75;M
60878;1738,252,1211,76,188,311,1419,141,647,1570,1133,156,454,1166,530;38;F
60884;1004,289,83,76,1133,1158,103,35,1014,663,1166,290,479,293,1017;38;F
60892;1138,944,76,1246,1201,992,1734,773,492,647,1133,103,473,454,1081;42;M
60896;289,294,290,288,311,293,647,663,292;69;F
60911;639,479,252,290;47;F
60913;1374,311,479,1133,142,530,1017;30;M
60939;1419,1201,1158;24;M
60945;1171,141,1004,183,1258,1198,81,1201,377,103,1014,454,142,866,530;48;F
60950;209;32;F
60963;289,294,290,288,311,293,647,663,292;47;F
61013;1419,1201,473,454;44;M
61022;1081,866,292,530,1198,289,1207,1201,103,454,1228,290,81,1570;28;M
61079;1211,1738,639,293,992,1158,864,1171,1099,647,1570,1133,473;29;F
61085;639,1133,103,252;31;F
61086;1211,156,152,188;41;F
61097;35,1246,188,202,252,209,157,1211,1419,1099,647,1570,473,1157,530;33;F
61101;1138,76,293,1201,492,1133,156,473,454,209;42;M
61116;35,1133,293,639,76,202,252,1246,479,1171,1570,377,473,1166,292;43;F
61144;252;1;F
61150;209,530,141,1133,1166;30;M
61154;288,76,141,647,1133,454,142,1166,530;27;M
61163;252;4;M
61171;292,530,289,75,157,1211,1201,647,1133,1004,103,156,1017,473,209;32;M
61172;1004,292,530,1198,81,504,252,288,76,1419,1201,1133,1158,1166,454;43;F
61175;866,1260,156,377,473,454,504,468,1211,1201,1570,944,843;36;F
61176;1736,1258,290,1138,288,639,1201,141,866,1104,504,1374,1246,1107,454;49;F
61197;1211,76,188,1246,311,293,1201,492,1133,1158,156,473,454,209;2;M
61198;75,83,775,1133,473;48;F
61225;530,288,142,1738;49;F
61284;504,1198,1374,183,473,1157,454,142,866,1541,292,530,75,103,76;33;F
61294;293,492,647,1570,864,1017,1541,289,290,1211,1023,1133,35,663,473;41;F
61322;288,311,1439,141,647,1158,103,1014,1166,142,530;45;M
61325;1300,1419,1158,75,1258,76,1246,1439,141,647,1133,473,454,142,530;47;F
61345;103,1439,1246,76,1300,75,141,647,1014;28;F
61384;1133,1158,142,530,1207,1004,103,377;34;M
61395;252,1246,479,293,1171,1201,492,141,1570,1133,103,35,1014,473,530;41;F
61401;75,252,76,639,479,141,1017,473,1157,142,530;52;M
61417;156,75,157,83,1300,252,944,293,1201,647,1570,103,473,454;28;F
61421;75,157,1300,252,944,76,1171,1201,492,103;42;M
61529;252,944,1419,647,1570,1133,377,454;34;F
61530;294,1258,75,775,76,311,1439,1023,141,647,103,1014,1017,142,530;46;F
61543;1228,468,202,639,1439,1419,1171,1740,103,1260,156,377,1541;45;F
61573;473,663,1081,530,75,288,1211,202,188,1246,293,1171,141,1014,156;47;F
61580;775,188,1419,1171,1099,152,156,1017,377,473,1157,1166,1081,530,866;40;F
61590;142,1014,1004,1570,75,83,1300,252,1246,479,141,647,103,530;46;M
61593;293,75,473,377,103,252;51;M
61594;1198,311,1419,1171,992,773,492,1099,1570,1133,103,156,473,1157,454;32;F
61597;75,83,76,141,454,142,530;31;M
61603;188;45;F
61612;289,290,202,479,843,1023,647,1570,35,1017,663,1081,866,292;42;F
61615;188;48;M
61616;202,1419,530,142,103;32;F
61622;1171,1201,156,473,663,1138,1374,1211,1133,209,1570,1419,188,454,492;35;F
61628;188;23;M
61638;188;22;F
61655;83,1300,1207,202,473,1133,1198,75,1258;41;M
61660;1258,252,1211,76,293,1419,1171,1023,1201,1133,103,473,1157,454,663;36;F
61664;75,1211,293,454,1201,156,473;40;F
61667;377,1439,1738,76,252,209,1198,75,83,1207,311,141,1014,142,530;50;F
61670;142,1258,1138,288,311,1439,1419,647,1133,377,866,75,76,1201,454;45;F
61672;1419,1171,1201,1734,647,1570,1158,1004,1260,1017,1157,1081,1166,1541,1133;52;F
61673;377,183,530,1260,103,1158,1246,76,252,75;41;M
61690;35,294,290,944,202,1107,1023,1201,1570,156,377,454,663,292,530;63;F
61692;1246,1738,1211,1198,1201,141,454,142,530;37;F
61698;290,209,76,1419,1023,647,1133,1017;28;F
61699;290,1211,479,293,1017,473;72;F
61744;1198,1138,1207,1014,1300,202,454,1258,75,83,103,76;52;F
61751;209;71;M
61776;1570;37;M
61795;75,83,504,252,1246,639,152;50;F
61797;103,156,290,1211,76,293,142,292,479,1419,1171,35,1017,473,530;49;M
61808;1736,944,188,156,142,1258,81,1738,843,1133,1158,141,1419,1439,1246;43;F
61830;75,1258,1211,473,1207,639,157,775,1738,1246,1171,141,1157,142,530;51;M
61836;252,76,1738,639,479,293,1439,843,1171,1023,1099,647,1570,1133,1004;58;M
61855;1138,157,252,1246,1419,1171,773,1099,141,647,1133,1158,156,454,142;27;M
61888;209,504,76,311,1419,1171,1081,142,866,530,141,1133;43;F
61896;1246,1107,1439,1419,1201,992,1260,454;52;M
61903;209,76,311,1023,103;40;M
61904;252,288,1246,1419,647,1133,530;38;F
61959;1258,290,103,1014,152,530;38;F
61974;1246,188,944,1736,1258,1738,1107,1201,141,81,1419,1439,1158,1133,156;43;M
61988;1138,252,1374,311,647,1166,1198,1201,454,530,1541;33;M
62003;157,252,1374,944,1201,773,1133,156,473,1157;45;F
62027;76,1246,293,1419,1171,1133,1158,103,156,473,454,663,142,866,530;35;F
62046;289,290,1023,141,647,1133,1004,35,1014,152,1017,1157,663,530,1541;36;F
62054;288,252,468,294,289,290,76,188,1133,156,473,1157,454,663,292;46;F
62108;1171,1133,1158,1157,1166;23;M
62149;454,142,81,252,311,479,1099,1133,377,866,76,141,647,103,530;36;F
62161;76,141,103,663,142,530;70;M
62244;1171,1099,647,1017,454,866,663,103,1133,1570,1201,1246,1374,288,252;29;F
62245;209,1374,944,1201,773,1133,473;9;F
62250;530,292,663,103,1133,1570,647,141,1246,76,252,1228,1736,75,1300;43;F
62255;1201,288,157,1104,1107,1171,156;41;M
62260;1023,647,1133,103,473,142,530,1158,992,377,141,35,1107,1419,1439;33;M
62280;454,1157,1260,1004,504,252,1374,76,1246,311,293,1171,141,1740,530;51;F
62303;492,468;44;M
62313;1198;39;F
62337;1207,76,479,1158,1017,1258,252,293,1171,647,1570,103,473,292,530;45;F
62356;76,1207,83,647,1258,1211,103,473;46;M
62361;290,1228,1374,1211,202,479,1171,843,647,1570,103,35,473,663,252;28;F
62371;76,294,289,290,288,311,293,1171,1023,647,35,473,663,292,530;45;F
62391;83,81,76,1439,1419,183,75,252,311,479,1133,1158,1014,377,454;20;F
62402;663,252,289,639,103,1133,1158,142,1419,1201,1099,183,454,866;37;F
62428;209,290,1104,76,1419,1171,866;42;F
62442;157,1198,81,294,289,1258,1736,75,311,1419,1099,141,1260,142,530;31;M
62445;81,252,76,311,1419,647,1017,454,292;44;M
62455;294,290,479,293,1570,103,35,1017,663,1081,1166,292;66;F
62486;75,83,1014;43;F
62487;1207,202,479,293,1171,1201,647,1004,103,35,156,1017,663,1166,530;31;F
62501;290,288,141,35,1260,152,1157,1166,142,530;38;F
62537;1211,944,1201,992,492,141,1570,647,1133,1158,103,864,454,866,530;39;M
62549;454,647,1439,1246,1207,83,1104,252,76,141,473,142,530,75,1300;47;M
62572;1171,141,647,1133,142,1198,1138,252,1107,1439,1419,1201,992,492,1158;33;F
62587;209,311,479,293,1171,1099,1570,103,35,156,1017,473,454,663,292;43;F
62595;1439,1133,1260,183,75,252,76,1419,141,1158,103,377,142,530;29;M
62598;1158,504,1138,1107,1201,141,647,103,454,1541;34;M
62608;75,377,1158,1133,76,252,209,1419,647;34;M
62613;1419,1171,1246,1207,944,288,1104,1300,1198,1258,1211,202,188,311,1439;32;F
62632;1419,141,377,142,530;33;F
62649;1570,1099,479,944,290,252,293,1171,1201,454;37;F
62652;1211,1107,293,1171,1201,492,141,1133,103,864,473,454,142,866,530;35;F
62690;1198,1419,141,647,35,454,142,530;60;M
62701;1736,289,1374,290,202,479,1023,1570,103,35,1017,473,454,663,292;41;F
62706;1023,141,1133,1158,663,530,157,944,639,293,1171,1201,156,35,454;31;F
62736;1300,1258,75,83,288,76,311,1439,1419,141,647,103,1014,377,142;25;M
62740;290,1228,252,293,141,1014,142,530;73;M
62755;83,1300,76,1246,1107,479,1419,292,141,103,1017,473,454,142,530;48;M
62773;290,202,479,1419,843,1023,647,1004,103,35,1017,663,142;31;F
62787;1211,1374,288,252,504,1104,1107,1171,157,81,142,141,156,377,183;40;F
62789;530,1300,252,76,188,1246,1419,1171,1201,992,1133,1158,156,454,1166;67;F
62790;1258,288,1419,1201,773,492,141,647,1004,1260,1017,103,530,252,479;23;M
62819;647,103,35,156,1017,473,292,252,1171,1099,1570,454,1211,944,188;37;F
62841;103,647,1246,81,76,1171,1133,454,1541;43;M
62854;864,454,188,468,81,473,663,290,252,944,1419,647,1570,103,156;37;F
62855;252,288,76,1246,311,1419,1737,1740,1734,1133,1158,454,1166,142,530;46;F
62862;504,252,1419,1198,1736,81,1246,1201,647,454,866;37;M
62881;288,311;56;F
62911;311,188,76,1419,1171,141,152,156,473,1157,1166,530;40;M
62916;773,141,1017,1104,1107,156,473,142,157,775,479,1201,35,454,292;10;M
62947;1439,1419,647;51;F
62964;202,142,81,1138,252,1158,454,866;36;F
62965;75,202,639,1171,530,1014;34;F
62968;252,1246,1419,992,141,1133,103,35,152,156,1017,473,663,142,530;32;M
62976;202,76,1246,1419,1171,1023,647,1570,1133,103,35,663,1081,292;42;F
62977;530,290,252,639,647,1133,35,663;33;F
62980;289,1228,252,202,76,1017,142,530;54;F
62984;311,141,1014,288,76,1439,647,1133,1158,377,142;35;M
62997;504,1740,1570,141,76,157,1228,1014,1260,473,1157,663,142,530;51;M
62999;1171,252,1207,76,479,1570,1133,152;58;M
63031;157,1228,1104,468,1374,76,1171,141,156,142,530;59;F
63038;288,76,1246,141,647,1158,454,142;43;M
63068;293,639,311,188,202,1211,1737,468,504,290,252,76,141,647,530;44;F
63070;1439,1023,773,647,1570,35,1014,152,156,1017,290,293,1099,473,663;39;F
63109;288,639,1201,1133,1004,152,377,454,1104,1211,188,1246,1419,1171,156;43;M
63117;252,76,1246,1419,647,454;57;F
63133;1738,188,76,1211,288,252,468,83,1736,1258,209,647,1133,35,473;33;M
63136;288,209,75,530,1419,1439,311,76,252;30;M
63138;1228,1138,468,775,252,944,1734,647,1570,35,1260,663,1081;39;F
63158;76,1246,293,1099,1260,1017,183,473,377;21;M
63160;1258,1374,1419,647,1133,864;18;F
63170;1258,1734,1166,1081,1157,1260,1133,1570,1419,76,1374,504,209;48;M
63173;944,504,1300,75,288,1211,76,293,141,103,156,473,1166,142,530;35;M
63203;647,76,1133,1158,1014,377,1166,142,530,1258,83,311,1419,141,1260;37;M
63224;103,76,479,1133,141,1246,252,647,377,1166,1014,530,1198,81,454;30;M
63239;202,141,103,663,252,1374,311,639,843,1099,647,1081,866,530,1541;29;F
63272;1198,157,504,775,1737,1211,76,311,773,141,1133,142,530,288,647;28;M
63295;1258,209,76,1419,1104,1439,83,311,75,1158,1004,1014,377,142,530;35;M
63317;188,639,1099,647,1570,1157,454,292,1541,1104,1171,141,156,142,530;32;M
63321;1023,1211,1300,479,1099,35,290,293,103,156,1017,473,454,142,530;31;F
63327;75,252,1211,1246,311,103,1014,142,530;33;M
63337;1104,288,1439,1171,1023,1201,141,647,156,142,530;34;F
63346;377,75,1133;21;M
63377;473,289,290,157,1736,1258,75,639,479,1023,1570,35,152,156,1017;42;M
63395;468,775,252,639,1419,1171,1099,647,1570,1133,103,473,663,454,1081;58;F
63408;292,1738,663,454,1740,1570,492,1734,1201,1171,202,252,1737,775,1228;36;F
63416;1171,75,76,141,103,142,530;45;M
63427;290,479,293,1023,647,1570,1133,103,1014,1017,473,663,1081,292,1541;46;F
63429;468,1211,188,639,1171,1734,1570,1004,35,1017,530,1157,454,1081,288;35;F
63447;1081,292,944,1133,1198,1158,1570,1171,1201,454,639,775,1211,1017,473;52;F
63490;290,1737,252,76,103,35,1246,293,1419,647,1260,377,663;63;F
63530;1107,1201,1570,1133,183,454,1541,81,1138,76,1246;30;M
63571;1570,944,468,81,1198,188,1246,1419,1201,992,492,156,377,454,1081;33;F
63587;75,1258,83,1300,1104,288,1374,479,1439,1419,141,76,1133,1158,1017;24;F
63588;289,1736,1198,81,252,1211,944,202,76,188,639,647,1133,1081,530;32;F
63604;290,288,311,479,1023,1201,647,1570,103,35,1017,454,663,866,530;38;M
63621;1738;20;M
63629;530,289,294,290,288,311,35,293,647,1017,663,292;24;M
63667;81,1258,1198,202,76,1419,1171,1023,1201,647,1570,1133,1158,1157,454;32;F
63678;75,81,1138,1107,311,1439,1201,141,454,142,530;25;F
63693;81,1419,1201,141,1133,454,1166,142,530;35;F
63735;183,1158,647,290,75,157,1104,1107,479,293;61;F
63737;188;36;M
63742;188;62;M
63745;252,1374,1419,1171,1023,1099,647,1570,473,663,1081,530,292;51;F
63757;1258,1158;48;F
63761;468,293,1419,1171,1570;32;F
63765;468,252,1211,944,1207,188,293,1419,773,492,1570,156,377,530;39;F
63777;1207,252,1228,209,1736,289,294,479,293,1023,103,35,1017,663,292;66;F
63815;252,1198,1258,1104,1138,944,188,1738,1171,773,1570,1133,864,866,1541;42;F
63858;1198,504,1138,1201,454,1211,202,1570;39;F
63863;76,141,1158,473,142,209,252,530;38;F
63909;1171,1260,1166,1258,288,639,1439,1419,1201,141,647,1133,377,142,530;46;F
63924;504,1198,288,1211,76,188,1171,1201,492,156,473,1166,142,866,530;45;M
63956;76,1737,209,1104,1228,504,252,1246,479,293,866,377,152,1004,1570;33;F
63990;294,290,1228,479,1023,1014,1017,473,454,663,1081,1166,866,1541,292;73;F
64020;209,1201,492,647,454;39;M
64041;1738,639,1158,864,530,1081,1570,944,468,157,188,1171,156,1157,504;55;M
64050;530,156,492,1201,1171,76,188,1246,1419,647,1570,1158,103,454,944;37;M
64058;1738,288,1138,1198,1246,1419,1171,1133,454,473;38;F
64061;75,83,1300,252,1374,1246,76,141,103,1014,530;50;M
64064;76,1419,647,1158,1260,142,292,530;44;M
64082;479,293,1171,141,1133,35,530,76,103,663,292,1419,1570,156,1157;42;F
64103;1258,252,141,647,142,530;32;F
64131;992,1734,647,1570,1133,377,142,252,288,76,1171,156,473,454,530;33;F
64133;209,252,288,311,141,1158,454,530;38;M
64162;142,1570,775,75,252,311,1201,647,1133,377,454,1166,530;47;F
64182;1166,1738,1198,209,504,1211,492,647,1133,1158,864,183,454,866,530;72;F
64211;504,81,289,1258,647,1570,473,454,663,292,530;40;F
64213;252,183,1374,76,1246,479,141,377,663;20;M
64219;1023,1099,141,647,1004,35,1014,1017,473,1157,454,663,142,292,530;44;F
64225;1198,468,288,1201,1740,1133,1004,1157,454,1166,530;41;F
64228;1211,293,1419,1201,103,473,454;36;M
64232;188;40;M
64239;1260,473,142,530,209,288,76,479,293,1419,141,647,1570,1133,1158;35;F
64251;252,479,1419,1023,141,647,1570,1133,103,35,1017,454,663,1081,530;26;F
64272;76,1014,152,530,75,252,103,156,454;43;M
64279;1017,156,35,103,1133,1570,647,141,1099,492,252,1211,479,293,1171;35;M
64285;1738,1246,311,209,202,1419,1734,647,1570,1133,103,473,1157;35;F
64311;288,76,188,647,183;2;F
64329;81,290,1211,1207,76,479,293,843,103,1014,1017;42;F
64369;647,103,530;22;M
64384;1737,35,1158,1570,141,530,1246,1171,1736,1419,76,1133,288,202,311;41;M
64399;1138,1198,1107,639,479,1171,1201,1734,647,1740,1158,1133,864,377,454;16;F
64409;142,454,1158,944,157,1104,1107,1171,156;11;F
64435;1171,1419,76,1138,504,1104,209,1198,311,1201,103,454,530;45;F
64466;83,1736,75,1198,311,1439,1419,141,1133,1158,103,152,473,454,142;43;M
64480;142,866,530,1246,141,647,1158,454;41;M
64481;1004,1258,209,468,944,188,1738,1246,479,1099,1158,103,152,156,1081;8;F
64489;1737,1228,468,639,1171,492,141,647,1570,1740,1004,864,156,454,530;38;F
64495;1017,473,454,1198,1211,1738,152,1258,647,377,81,252,1246,141,530;47;M
64500;157,1104,944,1107,1171,1158,156,454,142;7;M
64503;209,492,1133,377,454;52;M
64511;468,252,479,773,1099,141,1133,103,35,152,142,1300,1260,1258,1246;32;M
64517;647,1201,843,1246,1737,1258,775,252,1740,1133,1014,1081,75,83,76;54;F
64520;1198,209,81,1211,944,202,293,1201,492,647,1570,103,156,473,454;37;F
64522;647,1099,1171,1419,1439,293,479,639,76,288,252,311,141,1133,142;30;M
64530;504,1246,141,142,76,293,1201,1099,1133,1004,103,454,530;47;F
64531;157,1104,944,1171,156,454,142;5;M
64532;1157,1258,290,775,252,1246,1171,773,141,1570,377,473,454,142,530;39;F
64541;1171,103,1258,294,290,252,1211,293,1201,35,156,473,454,663,292;40;F
64570;1099,647,1017,1166,530,1541;29;F
64587;157,289,479,1133,1004,156,473,663,1541,141;48;F
64614;1736,1207,1258,944,81,1300,1246,530,76,141,647,1158,35,473,454;29;M
64633;1738,1158,311,1419,1171,492,1570,103,156,377,473,1258,290,1211,944;29;F
64652;311,1133,1014,142,530,1171,1201,773,1158,156,1541,252,1419,141,103;36;M
64681;202,1738,1419,492,141,647,1158,454,1541,252,1211,1246,1133,473,530;36;F
64691;1158,663,468,1374,188,1738,1246,639,1419,1171,647,1133,156,1157,1541;27;F
64718;1260,1198,1104,504,1211,1246,1107,1201,1734,141,647,1570,454,142,530;37;F
64729;202,843,663,292,252,81,289,294,479,1023,1740,103,35,156,1017;68;F
64730;290,252,1211,479,293,1023,1570,35,1017,377,473;35;F
64749;1258,1198,209,468,202,639,479,647,1570,1158,103,156,473,454,663;37;F
64766;290,252,479,1171,1004,103,156,1017,473,454,663,1081,866,292,530;54;F
64787;76,293,866,75,103;44;F
64802;864,454,473,647,1023,81,1138,252,1211,944,188,492,1570,156,35;22;F
64805;1738,311,1439,663,209,468,775,76,293,1171,1099,141,1017,473,530;32;M
64810;1207,479,293,103,1017;30;M
64823;252,1207,1246,639,1419,1171,647,1158,1133,103,1014,156,473,454,142;31;F
64867;492,647,377,157,1138,252,76,1439,141,103,473,142,866,530;36;M
64886;647,992,1419,311,1738,944,188,293,1570,1158,103,156,377,473,663;40;F
64893;1570,1099,773,1201,311,76,468,1300,1736,1207,293,1419,1171,1734,473;40;F
64897;288,1246,311,866;45;F
64898;1736,1198,647,103,530;28;M
64902;1171,843,1439,76,75,290,83,1300,504,252,647,1157;49;M
64921;311,103,142,1246,1419,141,1166,530;32;M
64925;252,775,1138,1104,1228,1207,202,76,639,1419,1171,647,1570,473,1157;43;F
64930;1228,1158,1017,1258,252,202,1246,639,1419,1201,1740,1133,530,454,663;36;F
64939;1258,209,1246,311,1419,1133,1260,1017,473;41;M
64968;504,1228,209,81,252,288,202,1171,773,647,1133,1260,454,1166,866;39;F
65029;188;33;F
65045;1737,202,1570;39;F
65055;530,1419,311,1738,1300,1258,1736,75,76,1439,141,647,1158,1260,142;48;F
65066;288,1246,1133,1260;24;M
65093;992,773,1740,454,1166,209,252,202,647,103,1260,473,663,866,292;73;F
65154;142,530,252,288,1246,1419,1133,1158;35;M
65179;202,639,293,1171,1023,992,773,1570,1133,35,473,663,866,292,530;46;F
65184;76,293,1171,647,156,454,142,530;72;F
65209;775,202,1023,454,1014,103,647,1246,252,1207,479,293,1017,473,1166;42;F
65251;1737,1246,1419,992,647,1740,1133,103,35,473,663,1081,866,1541,1736;36;F
65252;157,188,1738,639,293,1419,1171,1099,1133,103,156,1017,473,1157,292;40;F
65311;1439,294,775,1737,288,311,1201,1099,141,647,1740,103,454,142,530;61;F
65343;294,1737,1211,1207,1107,1201,1734,1099,647,1570,1740,1017,454,1081,1166;44;M
65351;81,252,311,639,1171,647,1133,864,1158,103,454,530;31;F
65369;141,1158,530;32;M
65381;252,1246,1419,1133,1158;28;F
65388;252,311,479,1419,647,1570,1133,103,35,1017,377,454,663,1081,866;28;F
65428;1570,1133,1158,152,292,663,647,479,1211,294,290,156,1017,377,473;59;F
65451;454,1260,103,647,992,1734,1246,188,944,1211,252,468,1138,1300,1258;4;F
65454;504,288,76,1246,1201,103,454;48;F
65458;992,141,1570,35,1017,663,530,290,252,202,479,1201,647,103,866;36;F
65474;1246,1734,647,1740,1133,1158;54;F
65480;288,141,103,142;48;M
65491;252,1300,1258,1374,1246,311,639,1419,1734,141,1133,1158,454,142,530;34;F
65529;209,1246,1419,103,1198,252,1201,141,647,454,142,530;46;F
65530;252,293,530,1258,1374,1211,311,1419,492,647,1133,156,473,454,663;30;F
65547;311,1419,1023,1099,1017,1157,866;26;M
65574;75,83,103;37;F
65580;1258,252,76,1246,311,479,1171,647,1570,35,1260,156,1017,663,530;35;F
65661;76,1211,1374,252,290,293,1419,1171,647,1570,1133,103,35,473,1157;34;F
65696;75,866,76,157,504,1138,288,639,1171,1201,209,252,1246,1133,1439;36;F
65714;252,288,311,1419,141,142,530;71;M
65724;142,530;41;M
65727;1258,1246;62;F
65739;530,142,1014,1158,1133,141,1419,311,76,1300,83,290,1258,663,473;36;F
65744;188;34;M
65755;1081,530,775,468,1138,504,81,157,1201,209,152,1099,944,492,454;5;M
65757;1207,1133,1260,530,1014,103,1158,1246,81,1258,75,83,1300,252,76;23;M
65785;1300,504,468,454,1166,142,530,83,944,293,1171,141;45;M
65805;468,288,1211,188,1246,1107,843,1201,492,293,1419,1158,103,530,252;30;F
65899;1081,1171,843,293,479,1207,775,504,290,289,454,1541,202,663,1133;46;F
65945;454,1107,864,1570,1104,1138,775,252,1201,647;38;F
65978;1374,639,1419,1201,141,1004,103,1260,152,156,377,183,454,142,530;51;F
65987;1158,76,252,468,294,1258,289,290,1228,202,293,1570,473,663,292;74;F
65998;252,1374,647,1133;25;F
66030;1260,288,76,1246,311,1439,1419,141,1133,1158,103,1014,473,142,530;45;M
66037;504,1211,1171,1133,156,473,1198,468,944,1107,1201,492,1570,864,454;35;F
66097;647,1201,252,775,1104,1138,1570,864,1107,454;11;F
66100;142,1166,454,377,156,1133,1201,1171,1419,288,76,1246,141,1570;39;F
66104;157,1104,775,1107,639,1439,1419,1171;39;F
66176;157,504,468,288,1211,944,188,1107,293,1201,492,152,156,473,454;3;F
66180;76,141,142,1133,530;34;M
66182;1211,1246,293,843,1171,492,647,1570,1133,103,1017,473,454;69;F
66192;209,1138,1738,1246,773,1570,103,81,252,202,1419,1201,647,35,473;40;F
66198;1258,81,209,1104,252,288,76,1246,1171,1734,647,1133,103,454,866;7;F
66229;530,1260,76,1300,75;52;M
66236;142,1166,1014,1201,1419,76,75,1198,1258,1246,1107,639,1439,1133,454;45;M
66272;1171;33;F
66278;252,157,1104,76,1107,479,293,1171,141,1570,1133,1158,156,530,183;34;M
66318;530,866,454,152,1004,1171,1104,157,1258,188,1107,492,141,156,473;61;F
66320;1374,252,479,1439,1419,647,1133,1017,473;21;F
66342;1228,468,1737,944,76,1246,1734,1740,1419,1201,492,156,454,1081,866;32;F
66351;1419,1258,1133,1246;45;M
66353;1439,1246,1211,1374,468,1419,1171,1734,647,1740,1004,152,156,1258,1736;61;F
66391;75,209,775,252,288,1246,311,142,530,647,1133,377,454;31;F
66420;1258,76,252,1374,1300,83,311,1419,141,103,377,530;57;M
66431;1081,1541,1166,866,1258,209,76,1419,1133,1158,1171,647,311,292,252;40;F
66454;1198,289,290,775,252,639,1171,1023,1201,992,1133,103,35,454,866;47;F
66476;75,157,81,252,1419,1201,773,1734,647,1133,103,35,454,1166,209;9;M
66509;647,103,35,473,663,289,1198,504,290,202,1099,1201,454,1541,1570;45;F
66526;1171,454,1166,142,75,83,252,76,1246,311,141,103,1014,152,530;10;M
66536;1374,1246,1419,141,647,1740,1133,1158,864,35,454,1166,142,292,530;65;F
66562;1738,202,1737,75,1258,290,209,1104,288,76,311,1419,1133,1014,530;35;F
66566;103,454,1157,1570,1171,1738,188,289,1198,81,1300,1138,468,1201,152;38;F
66574;1201,311,209,647,1158,35,473,454;44;M
66583;311,1738,76,504,1228,157,209,252,202,188,1171,1201,492,1570,454;39;F
66595;157,1104,288,1107,1439,1419,1171,156;36;M
66610;504,252,944,202,1246,1107,1419,1201,1734,1570,1133,1158,1004,156,454;35;F
66612;288,639,1171,1158,1419,76,1258,1133;30;M
66627;639,1738,76,468,504,1198,1258,1246,311,1107,1419,141,454,142,530;45;F
66638;1014,454,663,530,289,290,479,293,1023,141,1004,35,1017,473,142;63;F
66668;1107,157,1104,288,188,639,1439,1419,1171;8;F
66672;1207,76,293,1171,1201,647,1570,377,1004,152,473,454,292,1166,530;41;F
66707;1198,290,209,1104,76,639,293,1439,1419,1171,35,473,1157,454,663;44;M
66733;492,1207,1211,188,293,1171,1201,141,1004,152,454,142,530;46;M
66749;157,1104,288,1107,639,1439,1419,1171,156;5;M
66752;1570,377,504,252,1246,293,1439,1419,473;44;F
66774;1374,504,775,288,76,1246,1419,1734,1099,647,1133,103,35,292,663;52;F
66778;479,1419,647;26;M
66779;83,1104,1374,479,141,530,473,1570,647,1419,1439,293,76,288,1228;44;F
66782;152,141,1004,156,142,202,473,1419,103,1211,663,293,1171,1014,292;40;F
66813;81,103,142,75,1258,209,1738,1246,141,1133,1158,377,1166,1419,530;30;F
66833;1133,454,1158,647,209,76,1419,1201,377,530;38;M
66864;76,311,103,35,142,290,294,289,479,1017,473,663,292;42;F
66877;1158,530,81,294,1258,75,1228,288,1374,1246,1439,1419,1099,1740,1133;38;F
66891;311,1201,141,454,530;36;F
66905;157,1201,1171;45;M
66906;1300,1246,311,479,141,1158,1004,1014,1166,293,103,35,1017,473,530;34;M
66924;1738,504,1228,183,1158,1419,288,252,1374,76,1246,1133,1004,377,1081;54;M
66980;1258,76,141,1133;41;F
67000;209;46;F
67007;252,1207,311,1419,1171,1099,1014,1017,1211,1439,647,1570,473,1157,530;25;F
67083;454,1081,1734,1201,1419,1207,1374,647,1570,1740,103,252,141,142,530;29;M
67096;209,1228,775,288,1211,188,1246,141,1133,1158,1004,156,473,142,530;40;M
67104;1439,1419,1158,530,1014,75,1258,1246,1133,1166,647;22;M
67131;1246,157,1736,76,1107,293,1419,1201,1158,35,454,1133,647,530,141;32;M
67150;377,183,1157,663;36;F
67164;1157,183,1260,1133,1246,1171,1201,1734,103,377,454,292,202,1081,1541;41;F
67190;188;39;F
67206;1258,209,1138,944,76,1738,1246,311,1107,1419,843,1171,1201,1133,1158;45;F
67229;454,290,775,202,188,1023,1099,1133,1541,1228,252,647,1017,473,292;60;F
67233;188;15;F
67250;188;39;M
67252;75,252,76,83,103;60;M
67267;311,639,479,1419,1023,992,647,1570,1133,1158,103,35,1017,663,252;26;F
67270;188;42;F
67290;530,142,1166,1133,141,311,1246,76;47;M
67291;504,252,202,293,1439,1171,141,647,1133,103,1541,377,473,454,292;43;F
67292;288,1246,1419,1201,454;37;M
67299;188;36;F
67340;188;7;M
67368;188;4;M
67388;76,639,1171,1570,1158,1133,1004,103,156,1157,663,1166,142,866,530;31;M
67394;152,1541,157,289,504,188,1738,639,290,202,1570,156,377,1171,209;43;F
67413;1099,647,1570,1133,103,377,1157,1260,183,142,866,530,252,1246,1419;46;F
67470;76,1246,1133,1004,103,1260,1014,473,1157,1166,530;19;M
67495;377,156,1014,35,1133,141,81,1198,290,252,944,1201,103,663,530;33;F
67504;252,775,1736,1198,504,1138,468,866,1541,864,1201,454;83;F
67532;188;32;F
67559;530,1133,473,454,289,252,288,76,311,1419,647,1158,103,35,663;37;F
67591;1171,473,288,1004,1207,202,293,647,1740,1158,1157,142,454,530,377;23;M
67598;142,1419,1107,1246,76,468,1023,141,647,1570,156,183,377,292,530;38;F
67614;1158,647,775,468,504,1258,1246,1439,1419,141,1133,1260,377,142,530;56;F
67624;202;56;M
67632;775,289,157,468,188,639,1171,1023,773,1570,156,473,663,1081,292;41;F
67640;1158,1419,76,311,141,1133;31;M
67692;843,639,1246,76,288,775,1228,289,294,290,252,1419,1570,1133,1157;41;F
67712;1439,1260,183,530,75,83,639,1099,1171,1246,76,647,1133,1158,377;20;M
67724;1300,1138,252,76,479,1201,141,647,1570,1133,103,35,530,454,142;37;M
67761;377,454,866,530,1419,103,292,156,775,294,288,1171,1740,1004,1260;32;F
67859;288,1246,639,1439,530,1258,290,1374,1419,1133,35,1260,1017,377,663;38;F
67862;76,311,1439,1419,1133,142;50;M
67865;1570,35,1133,1158,454,866,292,1014,647,202,290,76,1300,75,1198;66;F
67868;76,311,1439,1419,1133,142;13;F
67884;76,311,141,647,1133,1158,1004,103,156,1017,663;25;F
67912;252,288,76,1419,647,1740,103;33;M
67945;209;35;M
67977;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;74;F
68035;288,76,1260,1166,1541,377;36;M
68093;1228,1300,252,1211,944,293,1419,492,647,1570,1004,103,473,454,1166;30;F
68115;1198,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;35;M
68148;289,479,1023,1099,35,1017,473,663,292;45;F
68154;141,530,1166,473,377,156,202,1211,252,1138,209,1198,944,639,454;33;F
68156;103,1081,1133,1158,647,1201,288,76,1246,1419,183,377,454,866,1541;37;M
68251;530,142,141,1099,1201,76,288,209,1211,311,1171,1004,473,1157,454;32;F
68255;1374,188,647,288,1734,1081,1541,1198,504,479,1201,492,1260,454,866;46;M
68261;152,1570,1419,293,639,188,1211,288,290,209,76,1171,103,473,663;41;F
68272;1158,35,473,663,292,290,294,1198,209,252,141,103,1166,142,530;41;M
68335;188;34;F
68341;35,663,81,530,1419,454,252,1198,76,1201,141,647,1570,1133,103;59;F
68367;1258,1171,141,647,103,1017,473,142,530;43;M
68375;252,647,1570,454,141,157,468,202,1738,1171,1201,377,1419,76,1133;37;F
68388;293,1133,76,188;3;F
68400;76,1738,1107,639,293,1171,773,647,1570,1133,377,473,454,1081,1541;40;F
68414;76,188,1133,156,1017,377,473;1;M
68429;141,1157,142,530,1258,468,252,288,202,76,639,1419,1133,454;34;F
68447;530,1166,141,1439,83,75;58;M
68480;1104,1300,75,1258,83,288,76,311,1439,1419,141,103,142,530,1014;40;M
68485;1198,504,1138,775,944,1201,773,866,454;76;F
68497;1258,252,76,311,1419,647,103,377,473,1166,530;30;F
68510;1198,252,1138,76,1246,1419,1133,1158,103,1014,454,663,142,292,530;47;F
68563;1171,293,81,252,1211,944,76,1246,639,647,1133,103,156,454,530;37;F
68577;775,288,202,1246,1419,1740,866,252,843,647;54;F
68582;1023,1017,454,866;74;F
68618;1158,293,1198,1138,1207,76,1246,1107,1419,1201,35,473,454,141,530;34;M
68639;75,1374,76,1246,311,479,1439,1419,141,647,1133,103,1017,473,530;28;M
68669;377,663,142,252,75,1198,1201,141,647,1133,157,81,76,293,473;31;M
68708;76,293,1419,141,647,1570,1158,473,142;33;F
68741;1738,639,1171,1201,1734,1099,1133,1004,103,1166;12;F
68747;202,76,1246,1419,1201,647,1570,1133,1158,864,35,1017,454,663,866;25;F
68769;75,81,83,252,103;29;M
68809;1211,293,1201,454,311,1439,103,188,1107,152,156,75,141,142,530;37;F
68853;1166,1157,1004,1201,1374,252,1246,141,1258;45;M
68884;289,290,1228,252,1211,1207,479,293,1023,1004,1017,473,454,663,292;35;F
68886;252,76,479,492,473,1228,311,293,1201,992,1133,1004,454,530,1570;38;M
68908;1198,294,209,252,944,1207,1171,1158,1166,1211,76,479,647,530,1133;30;M
68913;1374,1211,1738,1419,1171,1099,647,1570,1740,1133,1157,1166,1258,1246,1734;36;F
68934;1133,1260,992,1023,81,1138,944,1107,1439,1419,1201,454,866,142,530;32;M
68975;81,290,504,468,944,76,1246,479,293,1439,1201,103,1740,473,1014;39;F
69004;1734,1133,141,152,1211,1107,1004,35,944,188,1246,773,83,473,454;52;M
69102;775,773,81,209,1260,1017,473,454;18;M
69131;75,288,1246,1419,1158,142,1104,76,141,1133,530;65;F
69183;290,288,1246,1133,1260,454,1166,377,183;70;F
69194;1260,1246;46;M
69196;530,142,76,288,252,209;36;M
69249;76,1258,209,504,1738,311,141,1158,1014,454,1104,1419,1439,142,530;43;M
69368;81,202,377,454,866,530,647,141,311,288,775,76,1107;38;F
69381;1439,141,1158,1014,1166,530,142,183,377,1260,1133,1419,311,288,1258;35;F
69399;1246,157,1198,81,209,775,76,1419,1201,647,1133,1017,473,454,1541;63;F
69413;1198,775,252,288,1246,1201,773,1260,454;38;M
69433;1171,1570,1133,1104,1439,1419,103,35,156,377,183,473,454,663,866;36;F
69502;1133,1004;45;M
69540;81,1138,1374,1246,639,1171,1570,647,1133,103,473,1157,454,292,866;44;F
69567;1228,377,663,83,1207,103,1104,1211,311,142,530,141,75,1133,1014;43;M
69606;1138,202,1419,1099,141,647,292,530;51;F
69607;252,83,76,1014,530,1157,1166,292,473,377,103;54;M
69619;1207,647,103,35,473,454,530,75,1014,1017,663;46;F
69633;1374,1734,773,1570,647,1133,103,1017,473,1157,454,663,1166,866,1541;18;F
69634;81,1228,1138,76,639,1171,1099,1570,103,252,202,1107,1201,647,454;35;F
69643;1258,775,252,288,1419,1133,103,454,142,530,1374;36;F
69656;1738,1419,992,647,1570,103,1017,377,1258,1246,479,1133,1158,454,866;55;F
69662;1133,1171,293,479,252,1228,209,1570,530,473;42;F
69670;843,1138,76,202,1201,1099,647,1133,454,1081;38;F
69723;103,1133,647,1171,1246,202,944,252,157,141,142,292,530;43;M
69742;1198,83,288,1133,103,1260,454;35;F
69775;288,1246,1158,1133,103,473,1166;37;M
69781;289,1228,1211,1207,293,944,479,1570;21;M
69796;288,141,1133,1158,75,83,252,76,103;33;F
69828;1138,252,1246,311,1419,647,1133,1158,157,1198,1570,1017,454,81,288;47;F
69852;504,290,289,35;46;F
69872;288,311,1099,141,1081,377,530,1419,1133,1104,1246,1260,183,142,1158;26;M
70003;1246,1419,1171,1201,647,1570,1133,103,183,454,866,1138,202,663,252;28;F
70006;1198,81,504,1138,468,775,1107,639,773,492,647,1570,454,866,1541;47;F
70046;141,647,35,1570,1004,663,289,290,288,639,479,1023,1133,1158,1017;29;F
70085;1419,202,663,35,1099,843,1198,1138,252,647,1570,103,454,292,530;46;F
70142;1228,252,76,1171,141,647,1570,1740,1133,1017,377,183,473,1166,1541;68;M
70180;468,944,1004,1246,1107,639,1171,1201,492,1133,156,377,183,454,866;36;F
70214;76,454,1734,1198,1201,202,252,944,1419,492,1570;32;M
70225;76,311,1439,141,1158,1014,377,142,530;27;M
70291;647,76,1570,252,1419,492,454,1198,1734,202;31;F
70409;1171,157,156;33;F
70420;1133,152,1171,293,639,944,1211,290,294,202,473,1157,454,663,292;35;F
70422;252,647,141,142,1738,1419,293,311,1258,479,773,1133,1017,156,473;5;F
70495;1439,647,183,76,1419,103,1157,1158,1246,1171,141,1133,1166,142,530;46;F
70502;202,1099,647,1133,103,454,663;43;F
70532;504,468,288,647,530,252,944,202,188,639,1419,1171,152,156,454;29;F
70540;1198,479,1171,647,1570,35,473,1541;39;F
70575;292,473,293,1104,1419;48;M
70602;157,1107,1171,156;36;F
70692;1171,647,35,1017,473,663,1166;45;F
70739;944,1738,843,1099,1570,1004,1198,1258,290,288,202,1201,1171,639,1246;40;F
70762;209,252,76,1419,647;3;M
70819;209,252,76,156;;F
70891;81,1228,1258,83,1211,76,311,479,1201,1133,1158,473,454,530,1014;37;F
70913;1736,1258,1138,76,1201,992,647,1158,103,35,377,454,663,866,292;57;F
70981;288,76,1419,141,647,1570,35,1017,473,663,142,530;46;M
70993;1260,530,377,1133,639,1246,202,252,468,504,1211,183,1171,1228,1300;26;M
71007;1419,1166,142,530,76,1246,311,1158,377;37;M
71056;292,1374,209,504,288,1171,1201,647,1004,377,1157,454,663,530;26;F
71062;252,311,1419,1171,1014,142,1211,76,1201,141,647,1133,473,530,454;37;F
71070;1258,775,479,141,1158,1014,1017,473,142,530,1541,252,103;45;M
71094;141,156,468,1211,944,188,293,1201,992,492,1570,864,35,473,454;6;F
71123;288,202,76,1738,1419,647,1570,864,35,1017,473,81,252,1023,663;35;M
71157;377,454;49;F
71170;293,1419,1570,252,76,1738,141,647,1133,1158,103,377,454,142,530;33;M
71213;468,944,843,1171,1201,1570,1260,156,377,473;4;F
71218;183,209,1198,1246,492,1133,83,1260,377,454,1166,76,1258,1158,1419;49;M
71251;288,1737,775,1138,83,1258,75,1439,1419,141,1570,1133,1014,1166,530;26;F
71310;1198,530,504,1138,76,1201,1133,454,311;48;F
71324;468,252,288,1211,1246,293,1419,1201,492,864,156,473,454,663,1541;31;F
71377;290,289,1736,1138,252,1246,479,1099,647,35,1017,454,866,530,663;26;F
71422;290,202,293,1201,647,1158,103,473,454,866,530;38;F
71463;1133,492,773,1734,468,81,157,1198,1138,504,76,1107,1201,647,454;38;F
71480;288,1260,377,183,1166;42;M
71486;1211,1246,1419,1260,76,1158,311,1133;24;M
71512;1439,1419,773,1246,76,75,1300,479,1171,141,103,1260,183,142,866;25;M
71516;1374,843,1099,1260,1246,1419,1171,1734,647,1570;52;M
71604;1246,1738,188,468,75,83,252,1211,76,1171,1133,1014,152,454,530;42;M
71616;1201,1246,1207,81,1300,639,1171,1158,103;45;F
71617;293,1023,1099,647,103,1017,473;37;F
71656;252,944,76,1246,1419,1171,992,492,1099,141,1133,1158,454,866,188;36;M
71696;1258,1211,76,311,1171,1201,103,156,473;45;F
71756;1158,252,1211,944,103,156,1157,1541;32;F
71801;1246,647,454,866;42;F
71864;1014,1017,142,530,81,1104,1138,311,1107,479,293,1201,1734,473,454;37;M
71872;142,103,141,1734,1246,76,252,468,1228,81,157,1104,1107,1171,156;9;F
71894;76,311,1439,992,1099,647,103,1157,530,775,252,1158,1133;39;F
71904;1260,142,647,141,1734,1246,76,252,1258,530,157,1104,1107,1171,156;41;M
71923;1133,647,866,76,1158;38;M
71946;76,1246,1419,1023,492,1133,1158,864,35,1017,473,454,663,866,1541;64;F
71970;647,142,454,530;41;F
72018;1107,311,1201,647,1014,81,288,1211,1419,1171,1133,156,454,1166,866;27;F
72040;156,1734,843,1138,81,1171,468,1211,202,188,1738,944,1201,492,454;38;F
72059;311,1439,141;36;M
72091;76,188,311,639,293,1419,1171,1201,492,1570,152,156,454,473,1157;21;F
72117;1439,311,504,454,142,1246,1133;57;F
72150;311,76,775,1419,1201,141,1133,1158,454,1166,142,530;37;M
72200;75,1207,647;47;F
72257;1541,530,292,663,454,35,1570,141,1023,1107,1246,76,1138,81,289;74;F
72273;1157;27;F
72308;289,294,290,288,311,293,647,663,292;45;F
72343;775,157,1258,209,1246,1419,1171,492,141,1133,1158,103,152,156,142;37;M
72376;103,864,1017,866,1081,311,141,142,530,377,1258,1246,1419,1133,1158;34;M
72453;293,479,252,1138,1439,1171,492,530,81,76,1260,473,1198,1201,454;41;M
72465;1104,75,252,288,76,1246,311,1439,1419,1201,1133,1158,377,454,1166;56;F
72467;1419,647,1004,1158,663,1166,530,142,76,1246,141,1133;46;F
72508;1258,83,76,1419,141,647,1133,1014,1017,75,252,103,142,530;24;F
72529;1014,663,866,1104,76,1171,141,142,530;46;F
72531;1419,843,35,663,1133,252;36;F
72539;1541;68;M
72549;288,1004,530,1211,944,76,188,293,1201,992,647,103,152,156,473;37;F
72621;377,639,311,76,288,81,1246,252,1228,1419,141,103,1166,530,1133;33;F
72649;76,311,141,103,1014,142,530;34;M
72657;288,252,1246,1439,1419,141,1133,1158,103,142,530,1541,473;50;F
72687;311,141,35,377,1166,142,1198,290,252,1246,1133,473,1081,292,530;40;M
72689;473,864,492,504,1198,468,775,1201,773,1570,35,663,454,866,1541;47;M
72722;504,1228,1138,468,1171,492,647,1570,103,35,156,454,663,142,292;39;F
72760;289,294,290,288,311,293,647,663,292;46;F
72766;1258,288,1246,1419,1158,142,1166,530,252,76,311,647,1260,377,454;31;F
72782;1104,1211,188,1439,492,141,103,156,183,377,473,1157,454,142,530;33;F
72811;311,1207,288,252,289,290,76,292,663,1017,35,103,843,639,202;42;F
72816;1171,76,1138,1300,209,1258,468,202,141,1133,377,1166,1246,1419,142;35;F
72829;83,1300,468,1737,202,76,1738,639,293,1171,1734,773,864,1570;45;F
72857;81,1736,1198,1258,294,1228,1138,252,76,1201,647,1133,454;62;F
72953;81,468,252,288,1738,1246,1201,647,1133,103,864,473,663,1541,530;38;F
73002;156,866,530,157,504,1138,468,288,944,188,1246,1171,1201,773,103;39;M
73055;1133,142;47;F
73063;775,1207,1201,647,142,1738;47;F
73068;290,289,252,1211,479,1201,141,647,103,1014,1017,454,292,530;51;F
73131;209,1138,76,1419,103,864,35,473,454,142,530;43;F
73144;1104,290,81,157,252,288,1439,1419,1171,141,1158,156,1017,142,530;31;F
73150;288,76,1246,1133,183,454,292,1201,843,1107;76;F
73172;663,1166,377,103,1158,1133,647,1099,1419,311,1246,76,944,288,530;26;F
73180;864,1017,663,1166,292,530,1157,377,1158,1570,1258,1374,76,1133,1260;48;F
73195;294,288,311,1439,1099,141,647,1133,1158,1004,1014,454,142,292,530;31;F
73258;1099,1246,289,504,468,1138,252,944,1171,1201,773,492,454,663,866;32;F
73268;504,864,156,1157,454,1166,866,468,252,1419,1171,639;39;F
73280;775,1737,252,288,479,1201,141,1017,663,142,292;53;F
73331;83,252,288,76,992,647;44;F
73333;1211,1258,252,288,311,293,1419,992,773,1158;28;M
73340;1258,1211,76,1246,1439,1419,1570,103,454,473,252,1166,1133,1158;43;F
73447;188,479,293,1419,1171,1201,1734,492,141,647,1133,156,473,454,530;46;M
73549;1211,1419,1734,142,530,1017,473,292,479,1023,647,1570,103,35,663;43;M
73552;992,1734,492,1099,647,1570,1740,864,156,473,1157,454,663,292,1541;41;F
73568;103,1133,141,647,1099,1207,288,252,479;30;F
73620;209;37;F
73652;188,479,141,663,1081,289,157,290,775,639,1171,992,35,142,530;37;F
73654;157,775,252,288,1246,1201,773,1260,454,1081,142,866;38;F
73668;1211,944,188,479,293,1419,1171,992,492,141,1017,156,473,142,530;4;M
73679;209,1419,473;11;F
73696;289,294,290,288,311,293,647,663,292;20;M
73698;209;9;M
73723;311,141,1014,454,142,530;43;F
73726;377,1014,647,76;27;M
73727;1374,1211,293,473,142;43;F
73736;209;7;F
73738;288,76,1171,1201,1734,1099,647,663,292,479,293,1133,103,473;46;F
73749;76,1246,1419,1158,530,142,83,141,1014,75,311,1439,1133,103,1166;23;F
73775;1246,152,156,1541,1198,292,188,843,1171,492,1099,1157,663,473,992;45;F
73787;289,294,290,288,311,293,647,663,292;20;F
73806;775,202,188,311,479,1419,1023,1158,35,1014,156,1017,473,663,292;44;F
73808;473,454,1133;48;F
73843;479,1419,639,1198,290,252,1374,202,1246,1171,1099,647,1004,183,530;31;F
73864;1171,1439,188,76,1211,1258,944,311,479,1419,141,647,1158,1017,454;28;F
73878;1570;45;F
73912;157,252,288,76,1133,1158,864,35,454,663,292;65;M
73932;290,83,252,647,103;29;F
73935;311,1014,454,141,142,530;11;M
73950;1570,1004,377,1166,1258,1104,252,311,454,76,1419,1201,141,142,530;32;F
73951;1133,103,647,1099,1734,1201,1171,639,1246,202,288,252,775,504,1736;25;F
73985;1198,81,504,1138,468,775,944,1107,773,492,454,866,1541;85;F
73996;1133,492,76,202,288,209,1736,157,504,311,293,1419,843,1201,188;36;F
74026;157,289,81,209,775,202,293,1201,773,141,103,1017,473,454,866;9;F
74067;1138,492,530,1258,209,76,1246,1419,1201,1133,1158,103,454;41;M
74109;864,1260,377,473,1198,75,209,468,76,311,492,647,1014,156,454;32;F
74126;293,1738,188,76,252,843,1419,202,290,289,81,209,944,1201,454;8;M
74172;1138,1737,252,1211,311,639,293,492,1133,156,103,1570,473,454,530;35;F
74179;1023,992,1734,492,1570,156,473,663,142,288,1211,944,1201,647,454;35;F
74182;188;3;F
74203;1211,188,1738,293,1171,1201,492,1099,1570,1740,1133,1158,1004,35,1541;68;M
74247;141,1207,944,290,289,1258,504,288,293,1734,773,103,1017,473,530;18;F
74257;294,290,252,992,1570,1260,377,183;62;F
74269;188;39;M
74272;141,530,775,76,1246,311,1107,1439,1419,1201,1133,1158,103,1260,454;18;F
74274;1228,1737,252,1171,473,292,663,1017,1740,1570,479,76,290,293,1260;60;F
74294;639,1439,1201,1157;26;M
74327;1198,209,81,944,76,1107,479,1419,1201,1734,773,492,1133,454,866;37;F
74339;209;9;M
74389;209;9;M
74420;209;6;M
74434;75,288,647,103;34;M
74444;83,252,1246,479,647,103,377,75;24;M
74480;81,252,76,479,1201,1099,141,103,1014,454;59;F
74488;866,864,773,1107,775,504,1198,81,468,944,1201,492,454,1541;62;F
74497;188;60;F
74523;1171,1158,1014,142,81,76,1246,311,1201,141,1133,1004,454,530,188;36;F
74535;188;49;F
74558;1419,1300,252,76,311,141,647,103,1014,152,377,473,454,1166,142;39;M
74593;944,1207,1374,479,293,1023,1570,1158,103,35,1014,156,1017,473,663;27;F
74683;202,288,290,289,1736,35,1133,75,81,252,647;31;F
74756;157,1228,775,866;76;F
74832;157,1104,775,76,1246,311,1171,141,1133,1158,377,530,1419,252,647;36;F
74907;76,288,1158,1014,1166,1081,1246,647,1133,35,1017,454;19;F
74968;76,75,1138,468,479,293,1201,1099,103,1014,473,454,866,292;5;F
74970;1207,290,288,202,311,293,141,647,1570,1133,1014,377,663,142,530;37;F
75195;866,663,1570,1099,1207,157,1138,468,775,992,773,492,35;41;F
75238;1419,647,103,35,1260,1157,1166,142,530,157,288,773,1133,1374,1246;44;M
75370;530,866,1014,141,76,75,1258,1419,1246,1158,1133,1157,1166,1171;20;M
75376;1198,1138,252,1201,864,1166,454,1157,152,1158,1258,288,1246,1419,1133;38;F
75435;288,76,1246,1023,1099,647,103,1017,75,289,83,252,479,1419,843;37;F
75468;1374,1104,289,75,504,468,252,492,1133,377,454,530,639,1171,1541;27;F
75532;1211,944,188,1133,156,473,454;33;F
75538;647,1133,35,1166,142,530,288,1104,81,157,252,639,1419,141,103;29;F
75584;202,252,775,1736,1258,1138,468,1419,1171,1201,1099,1570,1158,473,454;42;F
75660;1258,1736,843,293,944,468,81,290,1211,202,479,1023,1201,473,454;42;F
75663;293,1017,473,76,647,103,209,1419,1570,311,1133;22;M
75677;1158,156,1157,1198,504,288,1439,1171,1201,492,1133,864,663,530,454;26;F
75709;1017;24;F
75737;75,76,1419,647,1260,530,142,103,1158,1133,141,311,1246,288,1570;56;F
75738;639,293,1171,1099,1133,103,35,473;36;F
75753;311,202,1258,252,944,76,992,647,1570,377,1166;32;F
75791;992,141,1133,142,530,1246,76,288,252,209;9;M
75794;75,157,83,775,311,479,1439,1023,141,1014,1157,663,142,530;46;M
75818;83,252,76,1246,1133,473,454,292,530;72;M
75842;1570,202;48;F
75857;188;2;M
75860;141,202,290,252,1374,1246,1419,1099,647,1570,1133,1158,103,142,530;26;F
75865;647,35,156,454,663,866,530,1541,75,289,290,1246,1570,1133,103;26;F
75885;252,141,142,530;25;M
75897;1246,1201,1099,1133,292,289,479,1570,1017,290,1023,103,35,454,663;50;F
75927;992,1570,1014,473,142,76,1246,1419,81,252,1201,1158,1133,454,1166;9;F
75970;1419,843,141,1260,183,530,290,252,944,76,1246,293,1133,1158,1166;32;F
75979;1198,1258,288,1246,377,1133,1158,75,142,141,183,530;27;F
75999;156,76,647,252,1104;37;M
76017;202,1570,1133,663,292,75,1228,252,1211,76,293,647,103,473,866;68;F
76058;152,473,1099,156,290,504,775,288,1211,1107,773,1004,183,1017,377;31;F
76109;288,76,311,141,647,1133,103,142,530;72;M
76126;289,294,1228,1211,1207,479,293,1023,1201,647,1004,1017,473,663,292;43;F
76127;76,83,75,473,1017,1014,103,293,1300,479;38;M
76128;1198,81,1104,1207,76,188,1107,639,156,142,1541;10;F
76130;252,141,103,1017,377,473,454,1166,142,866,292,530,1541;52;F
76149;1198,1246,311,1570,454;54;M
76186;202,1570;74;F
76188;1228,468,775,1211,639,293,1439,1171,1099,1004,35,156,377,473,663;35;F
76204;152,1198,1736,1228,504,252,1207,293,1201,773,1570,103,864,454,663;8;F
76245;1198,289,1228,1211,1207,479,293,1023,1201,647,1004,1017,473,663,292;21;M
76253;202,1570;67;F
76273;1158,1419,1133;46;M
76278;1198,81,1201,492,454;68;F
76323;1198,81,504,468,775,773,492,864,866,1541,1138,944,1201,454;40;F
76328;202,1570;74;F
76374;252,1166,209,202,293,647,1570,1158,35,473;41;F
76377;1166,454,473,1017,1570,1099,773,1734,1201,479,1246,76,775,209;11;M
76378;209;41;M
76382;1258,479,1439,1419,1099,647,1133,103,377,142;24;F
76392;202,1570;64;F
76469;202,1570;67;F
76479;209,288,311,639,1419,1171,141,647,1570,1133,1166,530;14;F
76561;1570;48;F
76585;1201,35,454,289,290,202,293,773,1099,647,1570,103,473,663,1541;19;F
76598;293,492,773,1099,1570,35,473,81,1198,1138,1201,864,454,504,1541;17;F
76618;1570,1004,1014,75,1300,1374,76,311,639,479,1171,141,142,530,103;30;F
76629;1171,992,1099,647,1740,252,1023,1260,454,663;27;F
76727;1258,83,288,76,311,1133;47;F
76736;289,479,647,103,1017;21;F
76757;81,504,252,1207,293,1201,773,492,1570,103,35,1014,152,454,663;10;M
76788;647,141,1099,1211,1374,288,75,76,1171,1133,103,473,292;45;F
76820;142,252,1246,141,1017,530;54;F
76840;377,183,1258,76,1246,311,141,647,1133,1158,1014,454,1166,142,530;35;F
76869;1570,1158,454;30;M
76928;492,1158,864,1198,1133,468,252,1211,202,141,1570,103,454,530,1166;39;F
76939;81,202,479,1099,1570,1017,454,663;28;F
76942;647,141,76,1207,288,157,775,479,773,1133,1158,103,35,1260,473;12;M
76943;1211,188,293,492,647,103,156,473,1166,530;38;F
76961;1258,1133,479,1439,75,288,311,103,1014,454,866,1201,141,142,530;52;F
77008;75,252,1374,1738,1246,639,1171,1099,647,1570,1133,473,663,1081,292;19;F
77025;75,83,1207,76,1017;50;M
77040;76,1201,1158,454,530;49;M
77041;1166,1014,1158,75,1419,1171,1017,1157,252,202,76,311,639,647,103;31;F
77060;293,141,103,1260,377,142;51;F
77084;103,647,141,1099,76,288,75;42;M
77088;1258,311,293,1419,1201,141,1158,103,1014,156,473,454,530;37;F
77146;209,1138,252,1374,202,1107,639,1201,647,1570,377,454,1081,866,1541;42;F
77159;468,944,639,1171,1734,647,292,35,156,473,454;36;F
77192;76,639,1419,647,1740,1133,103,1017,1166;26;F
77195;311,647,76,1246,1133,530;26;M
77271;1300,1004,141,202,290,288,944,76,188,293,1201,156,473,454;29;F
77276;1439,1158,864,866,75,1258,81,252,1374,1246,1419,1133,377,454,1166;58;M
77304;1133,1258,75,288,311,479,1439,1201,141,103,1014,454,142,866,530;53;M
77307;157,1104,504,288,188,1107,1201,1171,35,647,1570,473,103,156,454;46;M
77322;944,1570,1004,454,1246,1211,1439,647,1099,1157,866;36;F
77333;152;40;F
77358;1419,1133;32;M
77384;1734,188,76,1211,468,1138,504,75,1300,944,1439,1201,773,1099,454;35;F
77397;75,209,1374,76,1439,377,1258,252,1246,1419,1133,1158,183,454,1166;59;F
77408;294,289,1228,1211,1207,479,293,1023,1201,647,1004,1017,473,663,292;51;M
77423;103,156,75,1138,252,1211,479,1023,1201,1570,1014,1017,473,454,663;35;F
77447;1211,944,188,1171,492,103,152,156,473;1;F
77451;492,1570,377,81,209,1300,288,944,1738,188,1419,1201,864,156,866;33;F
77513;1211,188,293,492,103,152,156,473;37;M
77555;775,252,288,1211,76,311,1419,1201,992,1740,1158,473,454;68;M
77573;1374,647,1133,377;62;M
77591;209,1541;48;F
77601;647,103,663,1570,1171,492,944,1211,468,209,1198,864,473,454,1166;40;F
77611;288,1171,1158,1133,311;22;M
77687;76,1246,311,293,1439,1419,141,1133,1004,1158,1014,473,454,142,530;13;M
77691;76,479,1133,1158,103,35,1017,454,663,1138,252,866,292,294,290;63;F
77749;75,1138,252,1211,479,1023,1201,492,1570,103,1014,1017,473,454,663;6;M
77787;1258,76,1246,311,293,1419,141,647,1133,1158,1004,1014,473,142,530;11;M
77804;75,1138,252,1211,479,1419,1201,647,1570,103,1014,156,1017,454,663;69;F
77812;639,293,1201,1734,1099,647,1158,152,76,1171,1570,1740,35,156,473;39;F
77820;141,647,1133,103,35,1017,473,454,142,157,1171,1104,1107,156,530;36;M
77851;252,202,76,1246,311,1439,1419,141,647,1570,1133,1158,103,142,530;30;F
77863;252,290,479,293,1541;62;F
77872;294,290,252,479,293,1023,1133,103,1017;64;M
77903;157,1300,468,1737,252,1738,492,454,530;40;F
77944;1246,75,288,1211,311,1439,1419,1171,1099,141,647,1014,473,142,530;27;M
77965;81,1258,1104,76,1246,311,1419,141,1133,1158,35,1014,473,142,530;41;M
77972;157,1419,1171,1201,647,377,473,454;34;F
77977;639,1246,141,1158,377,530,288,479,1439,1419,1099,647,1133,473,1258;24;F
77995;252,76,1439,1171,141,647,1570,1133,1158,103,1260,377,663,1166,142;31;M
78013;209,152,156,377,454,1158,1133,141,1201,1171,1419,288,188,1246,103;38;F
78032;1166,142,530,1014,141,1419,1439,311,1246,76,1104,1300,209,1258,75;27;M
78123;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;37;M
78140;142,530;42;M
78153;289,209;37;F
78158;1570,647,639,188,252,468,504,1246,311,1171,1133,377,1166,142,530;26;F
78173;1138,1104,157,1198,1107,639,1171,1201,773,492,141,647,1570,142,454;41;M
78247;1198,289,290,252,292,75,81,1138,76,35,1023,1201,103,454;49;F
78283;1104,504,1138,468,1107,1201,1734,773,492,141,647,1133,1158,1157,454;2;M
78284;1207,1138,1198,1201,504,1300,288,1014,377,142,530,157,1104,1107,1171;40;M
78316;35;37;F
78326;76,141,103,377,142,530;42;M
78363;83,209,289,1258,311,479,1439,1419,1133,1158,1014,1017,377,142,292;21;F
78395;1198,1736,81,188,1246,1107,1201,492,141,647,1570,1133,156,454,142;82;M
78438;188;34;F
78472;504,76,1133,1158,377,1211,188,1738,479,293,1419,35,156,473,454;43;M
78507;1734,492,647,1158,473,454,866,530,141,142,157,1104,1107,1171,156;43;F
78514;202,1570;48;F
78537;157,1104,1107,639,1171,773,141,1570,1133,1158,156,1017,454,142,530;9;M
78551;75,1258,83,1207,1133,1014,142,866,530;44;F
78587;1104,1258,252,288,76,1246,1419,141,647,1133,1158,1014,377,142,530;17;M
78588;775,252,288,1374,1211,944,141,647,1133,1004,1014,1157,1081,142,530;44;M
78610;157,1300,252,1211,202,1107,1171,1201,1734,492,1133,103,156,473,454;38;F
78617;1228;45;M
78630;647,1099,1171,639,1107,1246,1211,288,1258,1198,252,202,843,156,377;38;F
78663;1211,188,1439,647,473,142,530,157,209,252,288,1171,152,156,866;39;F
78667;311,1014,1198,157,1104,1246,1107,1171,1201,141,647,35,377,142,530;11;F
78684;75,76,377,639,866,1158,1419,530;40;F
78698;152,157,209,288,202,76,1246,311,1171,141,647,81,1157,663,530;31;F
78702;76,209;42;M
78709;290,468,1419,1201,492,1570,156,188;33;M
78727;454,292,663,35,1099,1207,1228,294,1736,289,479,293,843,1017,473;45;M
78735;202,1570;9;M
78813;1246,1171,1201,773,492,647,1740,1133,1004,103,1017,473,454,1166,1541;42;F
78824;83,252,1014,866;67;F
78828;157,504,639,479,293,843,1171,992,1099,773,1570,1133,156,152,663;50;F
78842;866,1166,663,188,1211,1099,1133,103,864,454,1138,81,1198,1107,492;39;F
78883;504,1211,76,188,1738,479,293,1419,1133,1158,35,156,377,473,454;9;M
78905;75,1374,311,1246,1419,141,647,1158,1133,142,530;24;M
78940;152,188,156,377,183,1081,142,157,1104,1246,1107,1419,141,1158,530;63;F
78944;76,1207,288,504,290,252,202,479,1099,647,103,454,663,1166,142;36;F
78947;663,1081,866,1541,157,81,1107,479,773,492,1099,35,1017,454,1166;33;M
78978;479,639,1207,252,209,75,1198,288,1246,311,1439,1171,647,1133,103;22;M
78982;843,293,639,1246,1228,81,289,157,209,1138,468,775,188,1171,1570;36;M
79021;288,311,479,1419,1133,103,1017,530;24;F
79033;479,293,1439,773,1099,647,1133,103,454,663;30;F
79040;1736,252,202,479,1023,1099,1570,1133,103,1017,663,1081,1541,290,289;32;F
79066;293,1570,1014,454,142,530,252,311,1419,647,1133;41;F
79098;504,288,76,311,103,1260,142,866,530,252,1374,647,141,1171,639;33;F
79125;157,81,252,188,1246,1201,492,141,1570,1133,156,473,454,142,866;35;M
79141;152,157,290,1104,468,775,1737,202,639,1171,1570,1157,1081,1166,292;20;F
79145;293,1419,843,1171,1201,773,1133,35,156,377,473,454,663,866,292;42;F
79147;290,202,76,1171,141,647,1133,1158,103,35,1017,473,1157,663,292;43;F
79165;1246,1201,1166,76,1439,1419,141,1133,1158,188,183;68;F
79206;1133,1107,1246,252,1374,843,141,647,377,183,142,530;53;F
79276;75,1246,311,1439,1419,992,141,647,1740,103,1158,1133,1014,142,530;36;M
79423;479,1439,1171,1099,103,1081,473,1017;19;F
79475;530,75,293,252,1211,479,141,103,473,454;42;F
79511;454,1081,1166,1541,377,1133,141,1201,252,1198,647,103,866;23;M
79678;252,1374,647,1570,1158,377;23;F
79756;639,479,1171,1201,647,864,473,1157,454,1258,76,1246,1419,1133,1158;20;M
79774;468,188,1171,1201,773,492,1570,35,152,156,1017,473,1157,454,663;34;F
79826;1228,647,864,1570,1740,1133,473,1157,454,663,142,292,530,468,1201;47;F
79860;1004,1541,866,1166,1081,639,1374,1228,1419,1099,1570,1133,1158,1260,1017;34;F
79878;290,663,288,1211,311,639,1171,1201,1017,454,142,530,141,647,473;41;F
79893;183,1258,81,76,1246,1107,647,1133,1158,103,530,152,1419,1201,454;52;F
79899;492,292,289,76,1246,1023,1570,1133,864,35,152,156,473,454,663;38;F
79910;1300,1419,1171,647,1133,473,1166,1541,377,183,1260,103,252,1138,866;37;M
79935;289,775,479,293,1133,35,1017,473,663,1166,530;28;F
79973;83,454,81,647,103,1198,1300;38;M
79998;188,156,152;29;F
80006;188;36;M
80045;1736,81,1138,288,1246,1107,492,1099,1740,1158,35,152,183,454,663;59;F
80079;1207,188,1738,1246,311,1107,479,293,647,473,454,530,1541,288,1211;37;M
80093;1081,473,647,83,289,75,81,76,103,252;38;F
80113;76,1107,1004,1419,1099,290,202,1246,479,647,1740,1133,1017,454,530;51;F
80131;1158,1419,1198,1138,202,1201,864,1166,1541,866,209,76,1133,1081,292;46;F
80138;81,504,1374,76,311,293,1419,1201,647,1133,1158,1004,35,142,530;76;M
80152;252,103,76,81,75,289,83,647,473,1081;16;F
80162;290,209,468,202,76,639,293,1419,1171,1570,1133,156,142,866,530;12;M
80175;479;30;M
80200;1541;49;F
80201;252,103,76,81,75,289,83,647,473,1081;10;F
80209;1246,639,1171;37;F
80222;288;13;M
80225;141,473,142,35,647,311,209,76,639,1171,1201,1158,103,454,530;12;F
80303;1228,504,1738,1246,1171,1201,647,1570,1158,103,152,473,1157,454,663;36;F
80332;639,1171,252,76,1133,103,1201,647,454,141,311,530,209,1419,1158;14;F
80354;1738,1246,76,1419,647,1158,1133;72;F
80366;1171,142,866,1258,290,504,202,1246,1439,1201,141,1570,103,454,530;32;F
80407;530,292,1166,473,377,1419,1258,1138,252,76,639,293,647;45;F
80408;1201,141,103,1133,1258,252,1211,1246,293,1014,530;42;F
80430;188;2;F
80450;142;23;M
80464;188;34;M
80500;35,454,663,292,294,81,289,290,1228,1207,479,293,1004,1017,473;40;F
80501;647,35,454,142,1133,1158,103,1260,530,288,1246,311,1419,141,1570;39;F
80509;1211,1207,188,639,479,293,647,103,156,1017,473,454,530,292,1541;40;F
80512;1201,1157,454,1171;31;M
80524;294,290,775,479,293,141,35,1017,377,663,142,292,1023;72;F
80557;293,1419,473,454,663,866,252,76,188,647,1133,1158,103,156,1166;30;F
80566;141,530,142,1198,81,1107,1201,773,647,454,1419,1104,1258,1133,1246;40;M
80575;289,294,290,1228,252,1211,1207,479,293,1004,1017,473,454,663,292;58;F
80695;76,141;28;M
80697;81,290,209,1211,202,293,1023,1570,1158,103,35,1017,473,454,663;34;F
80721;1198,1258,252,188,1246,479,1419,1171,1201,141,647,1570,156,1017,454;30;F
80742;639,1171,1570,473,1157,663,1081;41;F
80799;103,1158,1133,293,76,1104,468,479,1419,1201,773,1099,141,647,1570;11;M
80808;83,311,1014,1207,76,1246,1439,1419,142,141,75,1300,252,103,530;58;F
80815;454,103;36;M
80844;188,944,288,1374,775,1138,289,1198,81,290,1300,157,1107,1171,156;26;F
80888;1228,504,311,1201,992,492,647,1133,1158,1014,473,454,663,142,530;1;M
80911;1374,1207,311,1171,1133,1158,1014,1017,663,142,530;26;F
80915;202,1570;48;M
80917;479,293,1201,992,1099,141,647,1133,1570,103,473,454,1166,142,530;10;M
80942;141,1158,1014,377,530,209,76,1246,1419,1171,647,1133,473,454,142;40;M
80949;188;47;F
80991;773,311,76,944,1211,1300,209,1258,141,103,35,156,473,142,530;31;F
81003;1374,209,288,1207,1201,1099,647,1158,454,775,293,35,1017,1157,473;37;F
81035;992,1570,1133,1158,292,647,103;46;F
81075;1138,83,75,76,1439,103;46;M
81107;504,209,75,290,288,202,311,639,1439,1099,141,647,103,1014,292;50;F
81143;1260,377,183,1166,142,530;48;F
81149;1138,252,647,473;43;F
81181;1133;39;M
81193;1171,492,1099,1158,1133,864,35,292,663,156,504,1138,944,1201,454;67;F
81204;647,1158,1014,156,1258,252,311,1419,1133;24;F
81212;157,288,1171,773,141,1740,35,1260,1017,473,530,209;13;M
81283;103,1258,81,76,1246,1107,1419,1201,141,1133,377,454,142,866,530;48;F
81308;76,311,293,1171,647,1133,1158,103,35,1014,1017,473,663,142,530;33;M
81363;288,1734,1004,1736,843,1158,377,1300,1246,141,183,142,866,530;27;F
81404;202,639,1419,454,292,1158,1133,1099,1201,1439,1246,1738,188,1374,1258;39;F
81407;1258,81,775,1737,76,1246,773,141,1133,1004,1014,1166;55;M
81437;1246,311,454,1166,866,1258,294,209,1228,76,639,647,1740,1133,292;77;F
81465;76,1246,1439,1014,663,141,1133,152,142,1419,1201,492,647,103,454;42;F
81470;209,479,992;18;F
81486;1104,75,1258,209,252,288,1246,311,1439,1419,647,1133,103,473,530;20;M
81507;1198,1258,81,504,1138,252,288,1201,1099,156,454,530;43;F
81525;377,1133,1738,1258,1246,639,1419,103,1171,252,288,76,142,141,530;33;M
81593;1166,775,252,288,1738,311,1439,1171,773,141,647,1133,103,377,473;45;F
81652;252,288,473,647,1570;65;F
81663;1541,1138,288,639,1171,141,1157,1736,76,252,1201,647,1158,454,866;44;M
81742;311,1201,992,647,103,864,454,142,530,1158,473,1419;41;F
81743;294,1258,76,1419,1133,156;32;M
81772;288,293,141,1133,473,1157,142,530,1198,639,1171,647,35,454,292;47;M
81774;1419,1171,1158,202,1133,1570,1099,1201,639,1738,864,35,454,663,1246;29;F
81788;83,252,288,1374,188,479,1439,1171,1133,1017,142,647,530,103,76;35;M
81806;775,639,454,1541;72;F
81830;81,1300,252,1211,1439,1419,1133,1158,83,775,288,76,1246,1014,454;41;F
81840;294,1374,1211,1207,1740,473,454,290,843,1023,103,35,1017,663,292;54;F
81849;1300,252,311,1419,454;25;M
81861;1258,1228,1133,1158,944,1201,492,864,663,1081,1166,454,866,292,1541;69;F
81873;81,209;46;F
81878;1541;22;F
81886;81,252,288,1171,1201,647,1004,152,156,1017,473,454,663,1166,142;38;F
81894;1300,252,1211,202,188,293,492,1570,1158,103,864,156,473,1157,454;33;F
81909;141,142,530;51;M
81924;152,156,35,1419,454,530,75,1246,1133,1158,1439,141,103,1166,142;35;F
82005;454,1439,647,1158,530,76,1133,1004,156,1419;52;F
82012;1737,864,663,157,202,1246,1419,473,454,1201,773,1099,209;37;F
82013;76,288,1198,289,1138,1737,252,202,647,1740,454,663,292;48;F
82030;142,252,202,76,311,141,639,1419,1171,647,1004,1133,1158,103,530;29;M
82067;289,290,1228,252,1211,1207,479,293,1023,1004,1017,473,454,663,292;41;F
82072;530,311,142,377,1014,1004,1158,1133,141,1419,1246,76,1207,288,75;61;M
82136;1171,866,1246,83,1014,294,290,293,1004,1211,35,473,1017,75,479;26;F
82169;1198,1258,81,76,1246,1419,1099,1133,454,530;20;F
82179;289,290,1228,252,1211,1207,479,293,1023,1004,1017,473,454,663,292;40;F
82189;530;53;F
82208;468,75,157,504,1138,775,252,311,1246,492,647,103,454,142,530;36;F
82212;1260,454,866,530,209;43;M
82243;530,188,141,103,156,377;34;M
82265;311,141,1014,454,142,530;14;M
82290;468,504,1198,663,292,289,1138,944,1201,773,492,864,454,866,1541;67;F
82304;1107,81,1246,1171,1201,377,183,1157,454,142,530,1541,504,141;23;F
82308;103,663,209,468,252,288,1211,202,1171,492,647,156,473,1157,454;4;F
82334;290,83,1374,202,76,1419,843,647,1570,1133,1158,35,663,292,1541;41;F
82371;1740,1017,473,1258,944,1246,639,1439,647,1570,1158,1133,864,1166,530;33;F
82391;1260,377,183;40;F
82468;311,141,454,142,530,1198,1258,81,209,76,1246,1419,647,35,866;29;F
82475;944,1246,1439,1419,141,1133,1158,103,35,152,156,454,1166,142,530;34;M
82485;188,288,1736,289,294,290,479,293,1023,1133,35,1017,663,292,1099;38;F
82509;311,1211,288,294,290,1737,76,1246,1419,843,1133,103,1017;32;F
82526;290,1737,288,1017,663,530;62;F
82548;663,292,289,81,1023,293,479,1207,252,1228,290,294,1004,35,1017;19;M
82658;1260,157,1246,1300,1258,76,202,209,377,183,288,1171,773,1570,1157;39;M
82662;142,1166,1246,1419,647;54;F
82719;1228,1107,639,1439,1171,1201,141,1158,1260,1017,473,1157,454;39;F
82722;252,647;42;F
82774;1004,1228,1737,188,1171,1099,1570,1740,103,473,454,290,639,293,156;32;F
82842;1736,81,1138,252,288,1246,1201,141,1570,1133,530,1541,1198,1099,647;29;F
82867;252,468,1138,202,76,1419,843,1171,1734,1570,1158,473,663,1081,1541;19;F
82895;1439,142,1171,141,103,1014,152,1017,473,288,76,1419,1246,1133,530;30;F
82915;311,76,1138,504,468,288,944,188,639,1570,492,156,473,1157,454;20;F
82925;1198,81,504,1138,468,775,944,1107,1201,773,492,864,866,1541,454;18;M
83020;1736,289,290,843,1099,103,35,1017,663,292;66;F
83028;1246,1023,1099,141,647,1133,103,35,1260,1017,454,663,142,292,530;42;F
83035;944,1171,1023,773,647,1570,35,156,1211,188,479,293,1017,473,103;39;F
83040;75,1107,1171,492,454,35,992,1439,252,1246,141,1158,663,142,530;33;F
83043;663,290,209;34;F
83050;504,1138,1107,1201,141,647,1740,103,864,183,454,663,1081,866,1541;70;M
83078;1133,377,141,142,530;37;M
83096;209,188;5;M
83104;76,1246,647,1133;46;F
83109;290,1374,944,202,1246,1419,141,1133,1158,103,1081,530;33;F
83120;202,288,468,1228,1258,1198,75,1736,81,83,1300,252,1133,103,530;38;F
83145;252;46;F
83147;1166,454,1246,775,504,1228,83,311,1419,1171,1201,1570,1740,377,866;63;F
83156;81,83,504,1198,1201,454;65;F
83196;1300,1133,454,530,103,377;29;M
83279;1211,209,188;7;M
83293;1570,1374,1166,1541,142,1017,35,103,1133,1740,647,1258,1246,479,141;29;M
83313;1419,1133,1158,530,75,1300,76,141,103,473;45;F
83476;311,1246,252,1138,81,202,76,479,1419,1099,647,377,473,663,1166;17;F
83555;473,866,504,468,944,1246,639,1419,1171,1201,992,647,1570,1133,103;42;F
83564;377,1246,252,504,1138,639,1107,1419,1171,1201,492,1158,864,454,866;46;F
83573;76,1198,290,1138,252,288,202,1246,1099,647,1740,103,473,1201,454;44;F
83607;76,311,293,492,103,156,1201,35,530,209,647,1133,1004,454,142;42;F
83668;944,1211,252,468,289,1104,76,1738,1171,156,473,292,530;48;F
83700;944,504,290,289,663,156;42;F
83703;1570,156,473,992;26;F
83719;252,864,866,530,76,75,81,83,293,1201,103,473,454;35;F
83753;1133,864,1014,1138,775,773,492,1201,1017,473,1166,454,866,292,1541;77;F
83766;35,1017,377,454,663,142,252,202,76,1246,311,1419,1133,103,530;25;F
83769;473,142,530;48;M
83773;142,530,1541,289,252,1171,141,647,1570,1017;29;F
83795;81,290,252,1374,1207,1107,293,479,1201,1734,647,1017,473,1166,209;11;F
83798;468,1138,81,1246,1107,479,1201,773,492,1133,103,864,1017,473,454;11;F
83809;479,843,1023,1570,1158,103,35,294,289,1736,1017,1541,773,1171,1737;32;M
83813;473,992;36;F
83925;1133;52;F
83968;202,81,1198,1138,252,288,76,1246,1201,1099,647,1133,103,473,454;14;F
83979;1166,1541,294,81,1737,252,1374,202,1171,1099,1740,1133,292,866,1081;31;F
83985;1260,156,473,1157,1258,157,775,1211,647,103,292,1017,454,663,866;72;M
83987;209;48;M
83996;1570,1171,1737,504,1107,293,1201,647,1133,864,103,473,183,454,866;15;F
84005;209;38;F
84016;775,639,473,1081,530;19;F
84024;209,775,252,1207,202,1419,647,1570,1133,1158,103,473,663,292,866;46;F
84052;454,1201,492;44;M
84075;1258,1736,1138,775,202,639,843,1099,141,1133,864,142,454,530;64;F
84119;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;70;F
84130;188,492,35,473,1107,1201,293,1211,468,288,1099,1570,103,156,454;40;M
84140;775,639,157,1374,1246,1171,647;32;F
84149;992;49;F
84204;1439,1171,773,1099,1133,1158,1004,103,1014,1017,1157,454,663,142,1166;28;F
84240;288,202,76,479,1171,492,1570,1740,1133,156,1017,473,454,663,292;43;F
84252;1004,473,1158,1260,1374,76,1246,1439,1419,141,1133,377,183,1166,530;21;F
84253;1419,1171,773,1740,152,454,530,209,288,76,311,639,1439,141,142;38;M
84263;252,1374,76,1133,1158;52;M
84288;1099,504,1138,1737,530,288,1246,639,1171,1201,992,1133,864,454,866;27;F
84300;1207,1104,1300,209,75,1258,83,76,1439,141,103,1014,377,142,530;46;F
84340;202,479,1439,530,1104,1211,76,1133,1158,103,1260,473,1737,1734,1740;46;M
84354;492,1171,639,1107,1138,209,1198,152,156,866;40;F
84376;530,1737,1541;54;M
84384;1004,1014,142,75,76,1201,152,1246,1738,1419,288,454,1158,1133,1258;34;F
84395;209,1738,1246,293,1734,141,1570,292,775,1439,454,1104,1258,639,1014;20;M
84448;775,479,1439,141,1133,1740,647,1201,1107,76,1246,294,288,103,663;24;F
84464;1736,1570,1133,1004,1260,1081,1258,1138,1201,1158,1014,1157,454,1166,530;36;F
84477;293,188,290,504,1211,944,639,1171,492,647,1570,1158,156,454,292;41;F
84479;209,647;74;F
84487;377,35,141,479,639,1738,1207,288,289;26;M
84602;530,454,377,156,1158,141,1439,1246,188,504,1198,1258,1419,1171,1133;23;F
84604;289,468,1017,504,188,639,293,1439,1171,773,1570,35,152,473,663;37;F
84655;289,290,1228,252,1211,1207,479,293,1023,1004,1017,473,454,663,292;5;M
84693;288,647;29;F
84725;647,1107,1014,141,293,479,81,1138,288,1171,1201,454,142,530,473;46;F
84734;202,639,1734,647,1570,1740,663,292,1541,1374,1246,1133,864;46;F
84739;289,290,1228,252,1211,1207,479,293,1023,1004,1017,473,454,663,292;3;M
84753;1157,1736,1740,35,1138,294,377,292,866,663,1734,1023,843,1419,1570;78;F
84757;75,81,288,76,311,639,1171,1158,1166,142,530,1246,1419,1133;44;F
84758;252,76,479,1419,647,1541,1133,1158,103,1260,1017,183,1166,142,530;29;M
84800;76,202,288,252,775,1138,75,1198,290,639,1419,1171,647,473,454;48;F
84812;479,293,1439,492,647,1133,1158,103,1260,156,1017,377,473,1081,1166;38;M
84824;75,290,1300,252,288,1211,479,293,103,156,473;42;F
84831;504,1138,1737,1374,843,1171,1734,492,864,866,1201,1740,1260,454,1541;39;F
84839;775,252,1211,76,188,1246,1419,492,647,103,35,156,1017,473;28;F
84863;1439,843,1570,1133,473,663,1166,1736,290,1374,944,1171,454,866,292;61;F
84892;1228,1211,773,156,473,530,1207,202,188,479,293,1171,492,103,152;38;F
84928;1246,1374,252,775,209,76,293,311,479,773,1133,35,1166,142;12;M
84944;454,142,1138,530,1198,209,202,188,639,1419,1171,492,1570,1158,156;37;F
84952;288,1374,202,866,504,1570,1541,252,1138,81,1198,1107,639,647,454;36;F
84959;1300,1258,479,293,1171,1099,1133,103,1014,152,156,1017,473,1157,454;34;F
84974;1734,1737,1740,1541;47;F
85006;1158,1570,1740,647,1099,1107,944,288,252,1138,81,1541;16;F
85038;1211;33;F
85041;188,1198,1258,504,1158,1738,1246,1419,1099,141,1133,1004,864,530,142;33;F
85043;141,1004,1014,142,75,83,311,1171,103,454;45;M
85062;157,1198,1736,81,504,76,188,1419,1171,141,647,1133,183,473,454;23;M
85068;1017,1738,1211,1228,1258,209,293,1419,141,35,377,473,454,142,530;40;M
85080;1133,530;23;M
85085;76,647,663,866,530;20;F
85113;83,1014;36;M
85136;81,202,76,639,530,1023,1201,1099,1570,103,1014,1260,1017,1157,1166;41;F
85183;1017,1157,1081,1198,1736,1258,1737,1738,1246,479,843,1171,1023,1734,1133;41;F
85190;202,209;46;F
85191;156,473,454,1081,1166,142,292,530,775,202,188,293,1023,492,1570;40;F
85229;83,1014;35;F
85236;83,1014;9;M
85239;1570,202;42;F
85286;1228,504,288,1211,1207,479,1439,1158,1004,252,1374,1419,1171,647,1133;29;M
85296;156,473,454;39;F
85324;289,81,209,504,1246,293,1419,773,647,1158,103,864,35,473;7;F
85330;1138,76,639,647,663,142,292,992,775,1737,1734,1570,1740,103,454;64;F
85341;479,1201,773,141,1570,1260,183,530,473,81,1419,1439,377,142,1541;35;F
85360;290,1104,288,76,311,479,293,1201,1004,35,473,454,1166,530,1541;70;F
85370;252,530,992,202,209;15;F
85403;864,1157,454,103,647,1107,288,252,1737,775,1258,1246,639,1419,1201;32;M
85470;209;9;F
85505;188,1419;3;M
85506;289,1228,1207,479,293,1004,1017,473,663;27;M
85536;1166,530,103,1133,647,1099,1419,76,1374,1737,775,1138,1228,294,157;29;F
85591;1207,288,1737,1138,1300,81,1198,157,1211,76,1107,1201,647,454,1166;43;M
85592;1541;72;M
85596;1736,1023,1017,663,530,775,1570,639,141;45;F
85613;289,473;54;F
85629;1211,1246,293,1171,1201,773,647,1133,103,454,1541,1258,209,473,1081;48;M
85668;1023,76,775,1736,75,289,294,290,1228,202,1099,1570,35,454,292;69;F
85685;252,1246,311,639,1171,1099,647,1570,1133,103,35,1017,1166,530,1541;33;F
85687;468,1211,944,202,76,188,293,1201,492,647,1570,103,156,473,454;3;F
85693;1014,1260,156,454,663,294,288,293,1570,1740,1004,35,473,292,1541;41;M
85695;1198,1023,1734,1158,454,290,1570,663,294,1228,504,775,1737,864,292;64;M
85708;454,103,1158,1099,1734,992,1201,1171,843,1419,1246,1207,944,289,157;35;F
85732;530,141,311,1104,156,209,1171,454,1541;39;F
85792;530,289,473,35,293,479,76,252,75,290,103,1017,1023,663,1211;31;F
85799;157,1258,288,1246,311,293,141,647,1570,103,35,473,1157,530,454;35;F
85801;288,252,775,1138,1104,209,290,1736,202,76,639,647,103,663,866;48;F
85812;83,639,1171,492,1133,1158,103,35,152,156,1017,473,1157,454,530;42;F
85866;1201,141,35,1157,530,209,1738,1171,647,1570,1133,103,156,473,1541;46;F
85895;157,1374,202,1246,1171,1099,647,1081,1541;26;F
85942;492,141,1133,1004,156,1017,530,292,473,1014,479,76,1211,152,1541;49;F
85969;479,647,1133,1260,1017,530,1138,252,288,1207,76,311,1439,1419,992;31;M
85975;1419,773,1099,492,141,1570,1133,1158,1260,152,156,142,866,292,530;44;M
85986;1374,311,639,1439,1201,141,647,1570,1133,1004,377,473,1157,454,530;25;F
85992;1004,76,479,293,1201,141,647,1570,103,1014,1017,473,454,142,530;34;F
86023;775,202,76,1171,1201,1099,1570,1017,473,454,663,1166,292,530,1541;65;F
86054;288,1211,944,188,1171,492,1133,103,156,377,473,1157,454,663,530;34;F
86149;1419,1201,492,141,1133,142,1258,1211,944,188,293,1171,156,473,454;2;M
86163;1258,1246,311,1419,647,142,530;30;F
86179;647,1133,103,866,530;30;F
86198;209;69;F
86229;252,639,293,1171,647,473,454;40;F
86246;1133;44;M
86248;944,1258,504,288,1374,76,639,1439,492,647,1570,1133,1158,473,142;68;F
86313;141,35,1017,142,530,209,1104,288,1211,944,188,293,647,156,473;33;M
86314;209,252,1211,188,639,1419,1171,1023,647,1158,473,454,530,663;39;F
86320;1740,1014,866,290,81,775,1737,288,1246,1171,647,1133,103,1166,530;42;F
86321;1017,377,183,473,866,530,1228,252,288,639,1171,647,103,156,663;37;M
86329;1374,202,1099,1570,647;27;F
86336;1017,183,454,1081,1166,866,1737,76,311,1419,647,103,663,142,530;24;F
86340;1570,1740,1081,663,473,1211,1171,1099,647,103,492,1201,944,454,209;36;M
86344;75,81,83,76,252,103;29;F
86383;76,1228,530,1736,1258,504,288,1738,1099,647,1158,1004,103,1260,1157;44;F
86405;1198,294,290,1228,504,775,1737,1023,1734,1570,1158,864,454,663,292;59;F
86408;292,1374,1104,289,663,141,1133,142,530;48;F
86464;1738,188,76,1737,1736,252,288,1211,944,202,293,1201,473,663,1081;33;F
86481;142,289,1023,103,1017,1736,290,479,293,843,1099,647,35,663,292;48;F
86498;1023,1081,1260,76,647,103,1541;41;M
86513;1198,81,944,1107,773,492,864,775,1138,504,468,1201,454,866,1541;16;M
86517;156,1541,468,188,152,1198,1107,639,492,504,1138,1201,1004,454,866;43;F
86521;1374,202,252,1004,992,1570,35,1198,647,290,504,1138,454,1081,866;38;F
86534;1198,294,290,1228,504,775,1737,1023,1734,1570,1158,864,454,663,292;38;F
86548;1246,1104,83,75,81,76,479,1439,141,1158,103,377,454,142,530;31;M
86566;1736,294,76,1023,1099,141,1740,1133,1158,103,35,454,663,292,530;67;F
86642;492,1138,157,504,252,1211,293,103,152,530,1201,454;40;M
86723;1258,290,252,1246,1419,1099,647,1133,35,1017,473,663,142,866,292;51;F
86744;454,473,1017,103,1158,1133,293,479,1246,76,1207,1211,252,290,75;38;F
86759;1081,1158,773,639,1207,209,1138,775,76,188,1439,1419,1570,156,454;43;F
86798;1004,864,866,157,1419,1201,773,454,944,1246,103,183,473,142,530;37;F
86802;188;36;M
86848;1258,288,1374,1246,156,473;45;F
86868;1258,1104,454,1201,530,152,293,252,504,157,1138,492,103,473;6;M
86899;76,75,81,83,252,103;48;F
86931;773,1133,1570,288,1228,252,209,157,81,454,152,1107,103;36;F
86965;142,292,75,83,1201,141,530,1258,76,1246,311,1439,1419,1158,1014;33;M
86987;504,290,81,289,1736,157,1198,775,647,1004,377,473,454,142,530;41;F
87035;1419,1439,1246,1211,504,290,294,1258,288,293,141,473,1166,142,530;29;F
87081;454,1107,75,83,288,76,311,1439,1419,141,1014,1260,183,142,530;35;M
87084;289,202,639,1419,1171,773,1570,1133,1157,1166;33;F
87110;288,944,76,188,1023,1201,35,663,454,866,1198,290,1419,843,1099;35;F
87137;289,290,1104,288,1374,76,479,1171,1023,1133,1017,473,1157,1166;54;F
87152;76,639,1419,1133,1166,647;21;F
87180;1419,530;45;M
87187;1207,202,479,293,1201,773,141,1570,35,473,1157,663,142,530,1541;15;M
87210;288,1736,1198,81,290,252,202,76,639,103,35,454,1166,292,530;42;F
87234;81,864,183,1260,866,530,142,1246,1107,1439,1419,1201,141,1133,454;41;F
87244;157,209,252,1374,944,1738,1201,773,492,1099,1133;74;F
87283;209,202,1570,843,773,473,454,142;34;F
87295;1736,1228,288,202,1099,530,81,639,1171,1004,1017,1157,1246,1158,377;40;F
87301;292,1158,454,479,35,1017,1570,992,1201,289,290,1374,639,663,1246;33;F
87441;103,76,75,81,252,83;47;M
87500;1004,473,1211,504,1736,468,288,639,156,1081,292,1157,1570,1201,1171;39;F
87513;1014,1157,663,454,530,81,83,252,76,152,1166,75,1300,1133,103;45;F
87517;1738,1207,944,209,454,473,156,1258,289,76,1211,252,468,1171,1017;41;M
87541;1419,1099,647,103,1081,142,252,1374,1211,76,1133,1158,1017,473,530;41;F
87546;1258,252,1738,1246,1201,1099,647,1570,1133,1158,103,35,1017,454,663;34;F
87553;293,141,156,454,75,202,1246,639,1439,1201,992,1014,1157,292,530;31;F
87558;156,473,663;47;F
87600;1201,864,35,377,1198,157,252,1211,188,293,492,156,473,454,1541;29;F
87644;1570,1099,188,639,288,468,504,1201,454;38;F
87658;75,289,83,1300,202,293,647,1570,35,156,473;31;F
87660;775,1099,647,866,1570,864,1133,1166,35,188,944,454,492,1171,209;46;M
87662;377;72;M
87671;1158,1133,1166,142,530,377,1258,288,76,1246,311,1419,1201,141,647;33;M
87679;1246;33;F
87687;75,1258,288,76,1246,311,1439,1419,647,103,663,1166,142,530;23;M
87712;252,1201,103;51;M
87719;290,252,1374,202,76,1419,1171,647,1158,103,473,663,530;41;F
87721;1166,1158,202,252,1171,1201,992,1099,1570,1017,473,663,1081;43;F
87741;152,76,530;48;M
87744;1133,1419,1246,76,252,1158;30;M
87769;1133,1260,377,183,473,1107,142,530,1198,81,252,188,639,103,156;27;F
87770;530,142,1166,377,1158,647,1419,1246;32;F
87794;75,83,775,76,1246,141,1014,454,142,530;56;M
87804;252,1374,1211,76,1419,1099,647,1133,1158,103,1017,473,1081,142,530;37;M
87814;1198,1258,81,202,1738,1246,1107,141,864,1260,183,142,530,1133,454;47;F
87819;1198,1228,76,1570;69;M
87821;76,188,1246,311,1107,1439,1419,1201,992,492,1570,864,156,454,377;40;F
87838;252,1211,293,992,1570,103,35,156,473,454;30;F
87864;1246,530,103,1004,1158,843,76,202,1207,1374,252,1300,1228,83,75;43;F
87884;76,311,141,35,473,142;39;M
87885;944,202,76,1246,479,1439,1419,1171,1023,1099,647,1570,1133,103,156;31;F
87903;1570,202;68;F
87966;1133,1740,1228,1737,288,1374,1107,639,1099,647,1158,1004,103,1260,183;24;F
88000;1201,1099,663,252,141,1133,103,292,530;44;F
88016;1158,1004,504,252,288,202,639,293,1419,1171,647,1133,473,454,663;46;F
88029;157,1258,288,1207,76,1419,1171,647,1133,1004,1158,864,35,377,1157;20;M
88040;311,468,1138,1198,775,1737,288,639,293,1171,647,1133,377,473,866;68;F
88053;1198,1023,1201,492,141,647,1570,1133,103,35,1157,454,1166,142,530;50;F
88066;1107,141,647,454,377,1166,530;28;F
88102;83,1570;70;F
88135;377,1419,1158;40;F
88155;209,468,1211,188,639,454;3;M
88163;188,479,1419,1171,492,647,1570,156,473;36;F
88227;35;22;F
88253;1439,639,1738,944,252,1104,1300,209,290,289,1171,1734,1570,35,202;33;F
88266;530,209,1104,1374,1738,1419,1570,1133,1158,377,183,1258,76,1246;33;F
88267;76,188,1419,843,1171,773,1133,1158,866,292,289,202,1570,35,663;57;F
88287;1737,252,293,1439,1419,141,647,1570,103,377,473,866,292,530,209;38;F
88322;468,992,1260,183,1157;41;F
88346;35,377,1138,468,775,1211,944,311,1419,1201,492,141,454,142,530;36;M
88395;289,1736,1198,294,290,1138,202,639,293,1201,647,35,1017,663,292;60;F
88400;1736,1228,1211,76,647,1570,1133,35,473,866;72;F
88401;1737,843,1023,1017,289,290,1374,1246,639,479,1201,1158,35,454,663;73;M
88479;1198,76,1419,141,103,1014,377,142,1246,1201,530;35;M
88500;293,647,473,866,530;39;M
88547;157,1099,473,1166,775,252,1246,311,639,647,1740,1133,103,454,530;21;F
88603;142,647,1198,288,639,1171,1201,530;42;M
88652;75,252,1211,479,293,141,103,473,454,530;43;M
88657;1081,454,35,1419,157,468,252,1211,944,202,188,1171,492,1570,156;34;F
88757;1104,1107,293,1171,183,454,202,479,843,141,1017,377,473,663,530;46;F
88780;81,209,288,1166,1738,639,1419,1570,35,530,1258,1246,1133,1158;48;F
88805;1207,647,639,1246,76,75;46;F
88840;1201,454,866,75,311,1014;52;F
88880;202,76,311,639,843,1099,647,1740,1158,1004,103,35,1017,292,663;50;F
88912;142,292,530,1157,377,1014,103,1158,141,1439,311,1246,76,288,1738;43;M
88918;141,647,103,209;41;M
88975;103,35,1014,473,454,142,530,492,1300,1138,1201,141,864,75,866;46;M
88988;288,1439,1419,1201,141,1158,377,530;44;M
88992;1017,1133,1158,1166,530,473,377,103,1419,293,479,188,76,1211,157;34;M
89000;1201,1133,1014,156,81,209,252,76,1246,647,1260,1157,454,1166,530;40;M
89009;1017,152,647,1171,252,1211,639,479,293,141,103,35,473,454,530;74;M
89036;1023,141,492,292,290,504,775,468,1171,773,864,35,152,473,454;40;F
89090;1258,1374,1099,1133,1017,377,663;57;F
89115;1014,141,142,530;37;M
89119;289,290,1138,76,639,293,1201,141,103,35,1017,454,663,292,530;64;M
89162;1419,473,141,1099,1246,290,81,288,311,1439,1171,1158,1133,1017,530;18;F
89195;530;27;M
89200;1133,35,639,864,454,663,1166,866,1541,294,1138,468,288,944,103;36;F
89236;252,76,1439,141,1014,152,530,1419,311,1201,647,1157,454,663,866;33;F
89259;83,103,864,377,142,530,1258,1246,479,1419,141,1158,1133,1014,473;49;M
89260;209,289,294,290,1211,479,293,843,1023,103,35,1017,473,663,292;43;F
89292;1004,152,156,142,292,288,252,1198,311,1419,1201,141,1017,454,530;40;M
89293;293,76,1258,75,1736,1228,1300,202,1171,1201,1133,1157,156,454,530;37;M
89346;75,311,141,647,103,530,252,479;31;F
89362;639,288,202,1099,141,647,1081,142,866,292,530,1737,1740,1734,992;47;F
89394;202,639,1023,1201,647,1570,1740,1133,103,156,377,183,454,663,866;33;F
89406;377,1738,773,492,1133,530,290,1374,1246,293,1004,103,35,473,663;41;F
89413;530,1211,293,141,142;44;M
89428;377,454,1198,504,252,479,293,1171,1201,103,1260,152,156,473,866;43;M
89440;76,1439;36;M
89441;479,103,1260,1017,1166,530;27;M
89446;1246,76,647,454,530,292,1198,157,289,1138,290,209,202,1201,1570;40;M
89467;1419,992,647,1570,663,473,1736,775,103,35,1017,1081,292,530,1541;59;F
89542;1207,1023,1201,141,1541,1738,530,292;47;F
89552;188;34;F
89588;75,141,1171,156,530,479,504,293,288,1738,1158,454,377,183,157;33;M
89603;1158,35,1017,1133,75,142,530,1099,1014,454;27;M
89607;454,1138,504,1201,1133,530,1260,183,866,1166;31;F
89621;290,294,289,1258,75,83,1300,188,76,1246,141,1133,1158,103,183;68;M
89623;252,1201,1099,647,1017,473,1157,454;14;F
89625;1246,141,866,1198,252,1374,1419,1201,647,1158,1260,183,454,1166,530;40;M
89654;1138,289,294,290,1207,202,479,843,1023,103,35,1017,473,663,292;67;F
89664;1138,289,1211,202,479,293,1099,647,1570,35,1017,473,292,663;45;F
89686;292,663,1017,35,1133,1023,293,479,290,294,289,1736,288,188,1099;36;M
89694;311,454,142,866,530,141,1260,1258,81,209,76,1246,1419,1201,647;31;M
89726;1374,1246,311,1201,141,1740,1133,454,142;40;F
89738;1198,157,289,290,209,1138,202,76,1246,1201,647,1570,454,292,530;40;F
89794;468,252,1246,311,293,1419,1171,1734,647,1133,1017,473,1104,1201,1570;34;F
89797;209,76,1258,1738,1104,1374,1166,252,1246,1419,1099,1570,1133,1158,156;27;F
89808;252,288,202,479,1023,1158,1017,1541;27;F
89809;290,293,1023,1201,992,35,1570,473,454,647,1017,1541,530,866,663;35;F
89869;1211,157,504,1138,944,1107,864,1198,81,468,775,1246,1201,773,454;47;F
89904;1171,1023,492,1099,647,1570,1133,103,35,156,473,454,663,292,530;34;F
89908;81,1374,311,1133,1260,530,1246,647,1158;31;M
89936;1736,289,1107,293,1023,1201,103,35,156,1017,473,454,663,866,530;38;F
89959;377,454,1158,647,1439,76,142,75,1258,1246,1419,141,1133,103,530;41;M
89969;75,252,1207,1246,1171,1014,454,1541;45;M
90002;81,209,454;37;F
90032;504,152,1157,75,157,944,639,1171,141,647,1004,103,1166,142,530;42;F
90051;1570,944,843,1171,1740,156,377,473,866;2;M
90080;1246,141,1014,1260,377,866,75,76,311,1439,1419,1133,1158,183,530;34;M
90114;75,83,1300,76,152;39;M
90136;157,1014,156,1157,1166;30;F
90205;468,944,76,293,1419,1171,1201,647,1570,1133,1158,103,156,473,454;32;F
90212;1201,647,454,530;29;M
90218;141,1260,1138,492,504,1201,647,1004,866,454,944,1107;35;F
90237;1246,1171,183,1133,83,1258,1198,75,1201,141,1158,103,1014,454;50;F
90249;81,252,202,76,1201,454,142,944,1570,530;41;F
90263;156,1198,81,504,1138,468,775,1211,944,1246,1107,1201,773,492,454;44;M
90397;1570,103,35,289,290,202,76,639,479,293,1133,1004,530,663,292;42;F
90404;1081,775,1133,1017,289,1258,1736,294,290,1023,1099,1570,35,663,292;62;F
90431;530,35,864,103,1158,1133,141,479,188,76,1207,944,1211,1246,293;39;F
90467;1246,1738,1207,157,288,944,202,479,293,647,1570,103,35,473,663;29;F
90470;288,1541,142,1081,473,1570,209,1258,252,639,202,141,647,1157,530;43;F
90506;1737,775,468,290,294,1736,157,289,1228,76,1023,647,1570,663,292;71;F
90507;290,293,473,103,647,1211,1246,252;43;F
90513;1158,1570,1374,209,1419,1258,1246,183,1133;40;F
90516;103,1014,377,1081,1166,142,530,252,1374,311,1419,141,647,1133,1158;33;F
90611;157,311,1419,773,1133,103,1014,142,141,530;31;M
90613;76,290,1228,647,35,1017,639,479,1570,663,292;68;F
90735;1736,157,75,1198,288,1158,103,1017,1157,530,141,1133,377,142,183;25;F
90808;252,1138,1198,81,76,311,142,141,454;44;M
90849;454,103,1570,773,1201,1171,1246,1300,81,1211,647,1260,156,377,473;37;M
90911;252,1246,1419,1133,530;37;F
90936;775,288,76,1246,311,1439,647,1133,103;42;M
90961;209,252,1419,647,103,454,663,866;34;M
90989;293,479,639,76,202,252,468,1138,1104,290,157,944,473,1081,1541;47;F
91010;157,1198,75,1300,76,479,293,1419,1171,141,1133,1158,103,156,530;46;M
91013;1228,775,1374,1246,1201,1099,647,1570,1017,1157,1081;40;F
91062;35,1158,1133,843,1198,1138,76,311,1107,1419,1201,141,1014,142,530;47;M
91064;775,504,1104,209,81,1198,1258,288,1207,1246,1107,1419,647,103,1017;33;M
91076;252,76,1419,1201,647,473,454,209;43;F
91273;292,1138,944,1211,288,289,293,1201,492,1099,1570,156,473,454,35;46;F
91346;1736,1734,1570,1740,1081,1541,103,647;29;F
91356;288,468,157,209;44;F
91366;1171,1017,530,142,663,454,473,1740,311,1228,157,293,1201,141,1541;45;M
91379;504,1211,944,639,293,1439,1419,1171,647,1004,156,377,473,454,530;35;F
91400;292,530,1246,1419,1570,1740,1133,76,202,288,209,81,1099,141,1014;41;F
91413;1419,141,1133,1158,103,142,530,1246,76,288;59;F
91421;289,290,1246,479,843,1023,1570,35,663,866,292;54;F
91452;377,1171,288,76,1258,1246,1419,1133,1158,311,141,142,530;43;M
91460;1171,377,454,188,775,468,81,76,1419,1158,1081,530,1541,639,647;31;F
91475;1246,639,1419,1099,141,647,1158,1133,473,454,530;43;F
91504;35;34;F
91519;473,454,292,530,1419,293,639,311,288,775,289,202,1023,35,663;43;F
91525;81,290,288,76,1246,639,1419,647,1133,377,454;34;F
91610;1198,468,311,293,1171,1201,1099,141,1004,864,473,1157,454,142,530;42;F
91646;35,1017,530,1211,293,1570,1158,103,473,454,142,866;58;F
91677;1211,152,156;43;F
91693;1211,639,1171,492,35,156,473;37;F
91706;75,81,1207,76,1246,479,293,1201,141,1133,103,473,454,142,530;28;F
91721;864,647,492,1734,1738,76,202,252,1258,1300,1246,1099,1133,103,1260;38;F
91733;252,288,76,311,1133,1158,1157,1166,530;29;F
91734;289,294,290,202,311,1419,1023,35,1017,473,663,292;73;F
91751;1198,75,81,1138,1211,1107,1740,1133,473,454,1166,141,103,142,530;50;M
91763;647,492,1738,252,1300,1157,1171,639,76,1374,468,1246,1104,377,142;36;M
91777;1104,1198,311,142,157,252,288,639,1171,141,647,1017,1157,1081,530;37;M
91778;202,639,1171,141,1570,152,156,1017,1157,454,663,142,292,1541,530;47;F
91817;492,252,288,1211,944,188,293,1439,1419,992,1570,35,156,473,1541;2;F
91960;1107,202,468,1138,294,157,252,1207,492,141,1014,156,152,454,663;37;F
91962;1570,202;20;M
91965;141,992,1171,1207,288,81,1258,775,1211,103,35,183,1157,1081,1541;35;M
91998;157,1258,288,1246,311,1419,141,1133,1014,152,156,377,183,530,142;40;F
92001;1201,288,479,1133,864,81,290,202,76,639,1570,103,663,1081,530;25;F
92004;290,288,202,76,1246,1419,1201,1099,1570,1740,1133,1158,864,454,1081;46;F
92009;1419;19;F
92019;1740,142,81,1374,1158,1014,530,1258,290,288,202,76,647,377,454;33;F
92022;468,492;10;M
92072;288,1211,1439,473;40;M
92107;252,1374,76,1439,773,1133,103,1014,1260,156,377,473,454,142,530;21;M
92123;290,202,1570;50;F
92161;1201,843,202,1258,1228,864,290,504,252,1246,1133,377,454;50;F
92178;290,75,1374,1738,1246,293,773,492,141,1133,103,35,377,473,530;8;M
92185;76,1246,311,1439,1419,141,1133,1158,35,1014,473,1201,288,454,1166;45;M
92270;1246,1738,1374,252,468,1138,1300,209,1211,293,1419,473;33;M
92290;1246,141,530;38;F
92303;209;58;M
92304;479,1023,157,289,775,288,1211,1207,992,35,1017,473,663,530;27;M
92306;843,1419,288,1258,775,1207,202,1246,1133,35,473,1157,454,1166,530;43;F
92317;209;54;F
92339;1246,1736,468,1738,157,1419,647,1133,1158,103,1014,377,454,1541,1258;32;F
92347;1211,1246,103,1157,1081,142,530,473;40;M
92361;647,1014,142,866,1258,209,252,1419,141,1133,1158,377,454,1166,530;63;F
92370;1133,1014,142,530,75,1258,202,1246;32;M
92378;157,1246,311,1439,1419,773,141,647,1133,1158,103,1014,1017,142,530;29;M
92394;141,142,530;44;M
92408;252,1374,311,1419,1099,647,35,663;29;F
92418;473,156,35,1104,944,188;35;F
92425;289,843,1171,773,157,209,1300,293,1201,492,1570,141,35,473,454;36;F
92428;288,311,1419,141,647,1740,1014,142,530;29;M
92439;1138,1201,492,1099,1570,1004,103,864,35,156,1017,454,663,292,530;39;F
92458;1419,188,1570,76,81,290,209,293,1734,141,1158,35,156,454,530;32;F
92461;188;43;F
92480;1258,252,76,1246,479,1133,142;64;F
92499;1541,142,1166,663,81,290,252,1211,1207,188,293,141,1570,156,454;33;F
92531;252,76,1246,773,647,1158,479,1171,141,1133,103,1017,473,142,530;41;F
92544;1374,1246,141,183,1107;48;M
92584;530;42;M
92614;647,1133,663,292,468,76,639,479,1419,1570,103,1017,473,454,252;53;M
92622;252,1158,647;34;F
92643;81,468,188,293,1171,647,1133,1004,156,1017,473;37;F
92651;492,252,944,188,293,1171,1201,647,1570,1133,156,473,454,1166,530;33;F
92657;188,152,288,1198,1258,209,504,1419,843,1171,1201,492,454,866,292;49;F
92658;188,76,1207,944,1211,252,81,1004,1201,492,647,1570,156,473,454;32;F
92666;288,1246,530;29;M
92669;647,103,454,142,530;39;F
92676;202,252,1300,1228,1258,75,1198,76,1246,1419,1171,647,103,454,288;40;F
92678;944,202,639,479,1419,1171,773,1133,103,156,1017,473,454,142,1541;38;F
92682;1258,311,1419,1201,141,1133,103,1014,377,454,142,530;35;M
92693;202,1737,209,289,639,293,1171,992,1570,103,473,663;42;F
92706;290,639,992,1133,473,663,292,202,1211,944;36;F
92717;292,209,647;43;F
92736;1138,209,81,76,252,1211,944,1419,1201,492,1570,1133,864,156,454;29;F
92763;252,288,1207,1246,639,293,103,35,1166,290,76,311,1260,473,292;48;F
92772;1246,35,377,142;36;M
92798;775,1258,290,209,188,293,1419,1171,647,1570,35,156,1017,377,473;35;F
92820;290,252,1374,1211,1207,479,1099,141,1133,35;30;F
92829;252,202,188,639,1419,1171,492,647,1570,1133,103,35,156;36;F
92833;288,202,479,293,1023,1201,1099,1133,35,156,1017,473,663,292,530;39;F
92849;103,1158,1133,1738,1246,188,76,202,468,1258,157,1736,35,1014,1541;32;M
92851;75,1198,468,775,252,288,1211,944,202,76,188,1081;29;F
92887;142,864,492,1201,1107,944,81,530,866,1133,141,773,775,1138,454;43;M
92893;202,35,156;65;F
92894;1133,141,1738,1207,209,76,1246,1419,492,647,1158,377,454,142,530;6;F
92895;1133,1158,141,1419,311,76;30;M
92910;1201,1258,530,311,454,202,1133,141,1439,1419,1158,252,35,468;43;F
92922;81,252,76,1201,1099,141,1133,103,377,454,530;35;F
92948;152,454,468,252,288,1211,76,1246,1107,293,1419,1171,1158,103,473;34;M
92969;252,1211,944,188,293,1419,1201,773,492,1570,1133,864,156,473,454;4;F
92979;1004,1228,1736,289,209,1246,479,1023,1017,504,202,639;47;F
92980;1099,141,647,1133,1158,1004,864,35,152,156,1017,377,473,142,530;35;F
92986;75,209,76,188,311,1439,1201,141,647,1133,103,1014,156,142,530;2;M
93015;289,252,1419,647,1017,473,663,1541,292;58;F
93017;530,468,1207,202,76,1246,293,1419,1023,647,1133,103,473,663,142;41;M
93030;468,1104,1300,1258,1198,209,252,1246,1419,1171,1734,141,1133,142,530;45;F
93042;35,289,290,1138,76,188,479,1171,1201,103,156,1017,473,663,293;40;F
93043;1419,479,1207,1138,252,1738,1246,311,647,1004,103,473,1157,663,530;35;M
93069;75;44;M
93090;1258,377,1023,1014,866,1201,454;43;M
93102;1201,479,252,1198,1258,289,81,76,1246,1419,647,103,1017,1166,1541;35;M
93137;76,311,479,293,992,141,473,530,944,202,1246,1419,1133,1158,156;32;F
93146;1740,1133,1158,35,473,1419,293,188,76,252,1258,209,202,1246,156;37;F
93176;157,209,202,1419,1171,1734,1099,1133,35,454,663;43;F
93188;944,1099,647,1014,83,76,1246,1201,141,1133,1158,156,454,142,530;34;F
93192;775,288,1738,311,639,1201,141,1570,1133,1014,1017,454,663,142,530;21;F
93203;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;70;F
93232;183,1207,1439,1166,142,76,1246,311,1419,141,1133,1158,377,530;36;M
93251;1439,1419,35,775,944,1207,311,1201,141,647,1133,103,454,142,530;37;M
93254;1734,1171,293,1211,468,209,252,944,1207,188,1201,492,156,473,454;34;M
93260;81,1246,311,864,1014,141,1570,454,142,530;41;F
93265;103,290,1207,1201,866,81,252,311,1419,141,1133,1158,454,142,530;27;F
93269;292,504,1228,1207,639,1439,1419,773,1570,103,1157,142,530,141,1171;34;F
93270;142,103,1133,647,141,311,76,288,252,530;49;M
93272;81,252,1374,1207,1171,773,1099,647,1570,1740,1133,1004,103,35,663;22;F
93280;83,1300,944,1207,76,188,293,1023,141,103,1014,156,1017,142,866;35;F
93350;773,141,1201,76,1207,75,1158,1017,454,530;38;M
93370;252,639,773,647,1158,377,454,530;31;M
93389;479,1198,252,1246,1439,1419,311,76,1374,288,75,1133,183,454,663;41;F
93391;75,209,76,188,311,1439,1201,141,647,1133,103,1014,156,142,530;5;M
93404;1017,530,1211,188,1201,156,454;40;F
93440;252,1419,141,864,142,530;31;F
93467;75,252,1439,1419,647,1133,377,142,866;38;M
93469;252,202,479,1099,647,1158,663;41;F
93471;663,1201,252,290,775,1211,293,1734,1570,1740,377,183,473,866,294;65;F
93509;35,1099,1201,1171,843,288,289,293,156,1017,473,292,663,103;40;M
93539;1260,639,1158,1014,1300,252,1207,76,1246,479,1171,141,1133,1157,530;36;M
93546;1198,75,1374,76,311,1419,141,1133,1014,152,377,183,1166,142,530;31;F
93569;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;22;F
93585;1207,288,1228,209,294,289,290,202,479,1570,35,1017,473,663,292;22;F
93588;1207,647,1133,1198,1107,1201,454,75,103,76,1228,35,377,83,1260;42;M
93631;639,1258,843,1171,1023,1158,492,35,152,156,473,454,663,1166,292;3;M
93651;1258,290,83,775,1211,76,311,293,377,1300,252,141,1133,1260,530;40;M
93673;76,1439,647,1158,1260,1166,530,142,183,377,1014,1133,141,75,311;34;F
93738;1419,944,209,468,1211,252,1207,188,293,1201,1734,492,35,473,454;4;F
93740;454,866,1419,843,76,1258,1198,1736,1138,1374,1211,311,1201,647,1166;57;M
93791;76,289,294,1228,202,1570,866,292;62;F
93811;1736,1258,775,141,142,866,530;41;M
93812;479,1171,103,156,473,454,663,530;39;F
93818;141,530,142,473,1570;74;M
93819;75,1198,81,209,504,1138,944,1171,1201,492,1570,103,864,454;36;F
93839;864,1099,773,1734,992,1023,1207,1211,775,1104,188,202;37;F
93841;504,1300,1198,1258,288,1211,76,639,1439,1419,1171,647,1133,1158,1166;30;M
93844;1017,1158,1419,289,290,209,1104,76,1171,35,183,142;13;F
93852;157,288,202,1260,866,1258,252,1246,1419,1099,647,1570,1133,1158,663;29;F
93864;202,76,1246,479,1023,35,454,1260,1017,377,183,473,663,866,292;49;F
93867;209,1736,1439,1171,377,1258,252,1246,639,1419,647,1133,1158,663,530;29;F
93875;1017,663,1166,142,292,530,141,1419,639,311,1246,76,202,252,775;45;F
93880;252,288,202,76,1419,647,454,1166;46;F
93890;530,141,647,103,1014,1017,473,142;39;M
93906;76,188,647,152,156,473,1157,454,663,1081,209;51;F
93907;1104,1300,1228,290,1258,157,1198,775,1211,1207,293,1014,473,1157,530;35;F
93922;252,76,1246,1107,639,1171,1201,454,530,290,202,1570,647,663,292;46;F
93924;252,1374,202,639,647,1570,1133,156,663;21;F
93926;76,479,1419,1171,1201,492,1099,1740,473,454,202,1246,1158,1166,866;43;F
93930;473,663,142,252,288,1211,202,1439,1419,992,1099,1570,1133,1158,377;37;F
93935;1017,1201,293,188,1246,1737,775,289,1198,252,1211,202,473,454,663;35;F
93941;1138,468,1133,1014,1260,152,183,1157,75,81,83,1300,252,103,1541;46;F
93946;311,639,293,1171,1023,1201,773,1099,1133,1158,35,1017,473,454,663;37;F
93948;647,1133,103,35,1014,1017,473,1157,663,1081,1166;31;F
93951;1133,1740,311,141,647,639,1246,76,252,1158,103,35,377,142,530;32;M
93952;75,81,252,1211,76,479,293,1201,1133,473,454;36;M
93960;289,492,1099;30;F
93976;290,202,1171,1133,1158,1017,157,1541,775,1207,479,1570,663,1081,292;24;F
93992;76,639,1023,473,663,289,252,202;46;F
94023;188;24;M
94033;202,188,1246,311,293,1201,992,1133,103,864,156,473,454,663,292;45;F
94036;1246,1419,141,647,1133,1158,142,530;45;M
94057;202,76,289,1228,1138,468,639,1419,647,1570,1133,530;55;F
94060;202,76,647,1133,103,1017,1157,1081;23;F
94062;209;46;M
94081;1198,1258,1201,377,290,288,76,1419,647,473,1133,1158;28;F
94116;103,35,377,473,454;61;F
94142;157,468,1211,202,76,188,479,293,1171,773,492,152,156,1017,473;36;F
94167;1171,492,1133,1740,1158,103,35,156,1017,473,663,530,1099,647,1570;37;F
94172;647,1570,1158,35,663,1081,530,289,290,252,202,76,1246,1419,1133;28;F
94180;639,293,1171,1023,1099,647,1570,103,156,1017,663,1211,479,473,1166;34;F
94192;1157,663,530,1541,1104,1211,1207,293,1201,992,1570,103,35,473,142;38;F
94212;188,1107,156;43;M
94214;1158,843,1246,1737,1258,294,81,209,1228,504,288,188,492,1133,864;36;F
94224;209,473,81,1258,252,202,1246,1419,141,647,1133,1158,103,663,530;35;F
94237;75,83,252,76,103;41;M
94238;141,75,290,83,252,76,647,1133,103;43;F
94241;1023,492,647,1740,1081,1736,1198,530,1541,103,35,1157,663,866,292;55;F
94284;188,1738,1246,311,293,1201,992,1133,1158,103,864,156,473,454,663;5;F
94291;209,252,76,188,1419,1201,141,103,454,142,530;34;F
94296;468,252,76,647,1158,454,1211,1419,1171,141,1133,1004,103,142,530;44;F
94303;209;15;M
94308;1133,142;49;M
94311;1081,530,252,479,647;28;M
94323;81,252,76,1246,311,1171,647,1570,1133,103,35,377,454,1541;50;F
94345;1736,289,252,202,843,1099,647,1133,103,35,663,1541;33;F
94351;530;50;M
94353;290,202,1246,479,992,141,647,1158,103,35,1017,473,1081,292,530;55;F
94358;1228,288,1246,1099,1133,1158,1260,473,292;47;F
94359;202,1207,775,468,81,290,209,76,1419,1171,1158,1157,454,292;10;M
94367;1246,1207,504,1300,1198,293,1419,1201,992,1133,1158,103,1260,473,1166;44;F
94373;1736,209,1258,479,141,1740,1570,1017,473,75,1014,454,530;43;F
94379;944,1737,775,1228,294,290,252,1211,76,188,103,35,156,1017,473;31;F
94404;288,1198,81,504,1138,468,775,944,1439,76,1201,1246,454,142,530;40;F
94423;504,1258,1138,252,76,479,1439,1419,647,1133,1158,103,377,454,530;32;M
94441;252,202,76,1246,639,1439,1419,1171,1734,492,1133,864,156,142,866;38;F
94462;1017,377,1541,157,639,1201,773,1099,141,647,103,156,1081,530,1104;28;F
94476;468,252,944,188,992,1570,103,156,1541;31;F
94489;479,639,311,1211,289,1736,1258,290,76,141,1570,663,1081,142,292;42;F
94507;1138,252,76,1099,647,1158,1133;26;M
94525;152,142,81,252,288,202,76,1201,141,647,103,473,454,663,530;35;F
94533;202,639,479,293,843,1171,1099,647,1570,156,1017,377,473,1157,663;41;F
94560;1541,1258,1736,1198,773,992,843,1107,1166,866,1201,1419,1439,639,76;46;F
94572;288,141,1211,944,202,311,293,1419,1201,103,156,473,454,663,530;27;F
94580;1246,1258,1419,1133;20;M
94584;75,293,1171,1133,1014,152,1017,1166,1258,83,76,1246,473,1004,103;35;F
94617;290,252,1246,1099,647,1570,35,1017,454,663,1081,866,292,530,1541;41;F
94625;377,530,1014,141,1439,311,188,1207,288,142,1419,76,157,252,209;42;M
94662;504,1138,252,1207,202,1246,639,293,1171,1099,1158,473,866,292,530;45;F
94670;492,773,992,1201,293,311,1246,188,202,1211,775,468,209,290,1198;10;F
94690;775,288,1570,1133,1158,1014,1541,1228,1138,1737,202,76;69;F
94706;75,1258,1300,1104,202,76,188,293,647,1570,103,35,1017,473,454;38;F
94743;252,1246,1171,1133,530;30;M
94748;1258;33;M
94776;311,141,1133;59;F
94791;1014,75,1258,288,76,1246,311,1439,1419,141,1133,1158,103,142,530;21;F
94793;141,1133,1158,142,530,866;44;M
94797;311;20;M
94834;1166,1081,35,1158,1133,1419,639,311,1246,468,1138,252,76,1171,292;44;F
94850;293,1439,75,1133,1158,1014,142,1258,209,76,1246,1419,141,647,188;34;M
94879;1104,209,290,1258,1198,1570,1017,1211,1201,492,1158,473,454;33;F
94887;76,311,1133,473,1166,1211,1107,1734,1004,530,1374,1246,1171,454,142;20;F
94889;1737,944,1207,1107,1258,288,1246,639,1419,1201,1133,1158,1260,1017,866;27;F
94899;1246,311,293,1023,1201,992,773,1158,1133,103,864,156,473,454,663;8;F
94902;492,1419,252,468,1104,775,288,1374,142,1157,1099,1171,639,1246,76;35;F
94918;293,1171,1201,492,141,647,1158,1014,156,1017,377,473,454,142,530;39;F
94920;992,1201,252,1300,1198,1258,81,775,288,76,1246,1107,1133,864,454;72;F
94951;775,1211,944,639,1158,1017,479,293,1171,1099,647,1570,156,663,1081;29;F
94959;1258,289,252,311,479,293,647,473;13;M
94963;1158,647,377,288,141,156,142,530,188;52;M
94970;1211,1207,202,188,293,1171,492,1570,473,156,75,1300,944,103,1017;29;F
94999;468,1211,992,202,76,1023,1201,1734,492,1570,1158,103,864,35,156;36;F
95006;290,209,1211,76,1246,479,293,1171,492,1133,473,454,663;33;F
95020;156,289,157,290,252,202,293,1201,492,1570,1133,473,454,663,292;48;F
95041;209,1104,468,252,1211,202,1171,1023,992,647,1570,1133,156,473,663;32;F
95053;473,76,35,141,1133,142,530;36;F
95066;142,1158,1260,1246,288,76,1419,1201,141,1133,1004,454,530,377,183;49;F
95068;288,75,1014,1133,1158,647,1171,1419,1246,1228,1211,311,141,142,530;46;M
95075;1201,530,76,1258,1738,1246,1419,1133,1158;34;M
95080;1171,1158,75,83,1300,1138,76,188,1004,103,1014,152,473,454,1541;48;M
95101;1570,454,866,252,944,202,188,1246,1419,1171,992,647,1133,1158,156;33;F
95115;252,663;28;F
95138;188;37;F
95144;1201,103,663,1736,1228,1246,1734,504,992,1133,647,1419,479,944,252;34;F
95183;468,1107,1374,252,639,479,1171,103,35,292,866,454,1017,156,1260;43;M
95211;157,1740,1158,1004,35,156,1017,473,1157,454,663,1081,292,530,1541;24;F
95231;252,944,76,1738,311,639,1419,773,492,1570,1133,864,103,1157,1166;41;F
95285;944,188,639,479,293,1171,1734,773,1099,141,1014,152,156,1017,473;40;F
95314;188;3;M
95315;468,1211,202,188,639,1171,1570,152,156,377,473,1157,663,292,530;44;F
95345;35,152,157,288,1374,639,1419,1171,1201,141,1133,156,1017,142,530;29;M
95352;639,1099,647,103,1157;22;F
95367;1246,35,1099,252,202,647,1570,1133,454,530;44;F
95372;202,209,289,1736,252,76,1419,1201,35,663,866,292;54;F
95376;1228,81,1258,468,1737,252,1374,1207,1246,479,1419,1171,647,1133,1158;27;F
95398;202,252,468,1138,1246,1419,141,1570,103,156,454,530;33;F
95406;76,1014,530,288,1201,141,454,142;14;M
95415;188;2;F
95430;1166,1099,1419,639,504,1138,288,1374,1246,1171,1133,1004,1260,1017,183;24;M
95434;202;53;F
95450;157,775,1374,639,1171,141,1570,1740,1004,103,35,1014,1157,142,530;28;F
95478;188;33;M
95479;1198,1228,252,288,202,76,141,1158,1014,156,454,1166,142,292,530;57;F
95480;1211,468,81,209,252,288,202,1246,1171,647,156,473,1157,454,663;3;M
95481;1107,1138,1104,81,1198,289,1228,76,1023,141,35,377,454,663,292;58;M
95483;288,76,1738,311,1419,1201,1133,1158,1014,454,142,1258,1439,141,530;34;F
95486;1104,1138,775,288,1107,1201,1734,103,1157,454;46;M
95489;1419,1246,1211,252,1104,75,647,1570,1133,103,1260,473,1157,454,202;46;F
95505;81,288,209,202,293,141,454,142,530;7;F
95507;1419,1171,1201,492,1740,1570,35,152,1017,647,1004,156,377,1157,454;34;M
95525;142,1198,1258,81,311,1171,141,473,454,1201,530;43;F
95526;1258,209,1166,1133,1738,252;45;F
95540;311,1246,1738,76,1211,1104,1736,252,202,1419,647,1017,663,292,1541;48;M
95575;530,1158,647,1171,1246,288,209,252,76,311,141,103,202,1166,142;46;M
95595;647,1570,1081,1738,1099,1419,1246,1258,479,1158,1133,35,530,141,1207;28;F
95616;252,1570,141,1099,992,293,479,311,1374,103,1014,663,866,142,530;24;F
95618;142,252,288,76,141;54;M
95634;81,252,202,639,1419,843,1099,647,1570,1133,103,454,866,1081,663;30;F
95639;288,1198,81,1138,639,293,1419,1099,647,35,1260,1017,473,454,663;19;F
95643;479,1570,103,292,252,1023,663;53;M
95658;1211,188,992,1734,773,492,1570,1740,864,156,377,473,454,1166,530;37;M
95720;202,76,311,293,1419,1099,647,1740,1133,1158,1004,103,152,377,473;40;F
95721;252,76,202,1419,647,1133,103;26;F
95753;294,1258,1736,202,639,1439,1201,1570,454;57;F
95757;1439,1246,1023,35,473,454,292,76,1374,293,1171,1099,647,1570,103;49;F
95840;202,473,1157,866,292;42;F
95862;1246,454,142,866,530;69;F
95864;1211,288,289,81,209,468,252,202,1246,293,1171,647,103,156,292;48;M
95877;775,1201,142,454,377,141,293,311,202,288,209;9;F
95921;1246,1099,141,1133,1158,35,1014,1017,473,663,530,289,290,479,103;32;F
95948;1246,1419,1133,1158,479,293,1023,1004,1017,292,663,290,294,289,1099;63;M
95959;289,252,1374,202,639,1099,647,1570,1158,103;20;F
95974;290,479,293,1099,141,1133,1158,103,35,1014,1017,473,663,530,1246;59;M
95977;468,209,76,188,639,1419,1171,35,454;42;F
95985;504,1138,775,76,1246,293,1201,1734,773,492,864,473,454,866,1541;73;M
96002;1081,454,81,1201,530;48;M
96034;103,35,1014,377,209,76,252,311,1419,141,1133,1158,156,473;33;F
96063;1300,252,288,1211,944,1246,639,1419,1171,1201,492,647,1017,454,1166;30;F
96087;468,293,843,1138,1211,944,773,1570,35,1017,454,473,663,1081,292;40;F
96155;202,288,1737,81,75,1258,311,1439,1099,647,1133,454,663,530,142;44;F
96171;290,775,252,202,76,639,1419,843,1171,647,103,473,530;47;F
96189;289,294,1017,473,454,866,468,504,1104,290,639,1023,1201,1541;48;F
96225;1138;30;F
96236;773,492,1740,1081,454,468,775,288,639,1171,1201,647,156,1166,1541;36;M
96263;1260,1374,1300,252,1246,1541;58;F
96269;1014,377,76,1374,288,252,504,1228,209,1258,1198,141,1133,156,454;27;F
96294;289,288,639,1570,1133,1157,252,76,1023,647,103,35,473,663,292;49;F
96295;479,141,1133,647,1246,252,1138,209,290,1258,1158,103,454,1166,530;31;M
96345;944,311,156,377,1081,1166,142,866,1258,209,141,647,103,1260,530;46;M
96386;188,209,468,1211,1207,76,479,293,1419,1171,492,152,156,473,454;35;M
96401;290,252,1211,202,479,293,1171,156,1017,473;46;F
96420;81,288,1158,103,1260,1258,1246,141,1133,183;33;M
96422;252;13;M
96465;188,1737,504,944,1107,639,293,1201,103,864,866;53;F
96471;209;57;M
96498;944,1419,1171,1201,1734,492,1570,1133,1158,1004,864,454,663,1166,530;3;F
96558;202,944,75,1258,504,1737,76,1246,1439,1171,141,1740,1004,156,530;42;F
96573;289,1228,1138,479,1201,1570,290,202,1740,35,1017,454,663,292,530;47;F
96592;944,468,1258,1246,1107,1419,1734,1133,1158,152,156,377,1166;65;F
96596;479,311,76,647,103,1017,473,1157;18;M
96618;75,252,103,152;38;F
96665;1570,156,289,157,639,663,81,1104,468,252,1374,202,1738,1439,1166;36;F
96672;1211,944,492,773,35,156,292,1228,252,1570,647,103,1017,473,663;42;F
96676;1738,293,647,1017,1157,663,1166,292,530;54;F
96712;288,1374,530,142,1166,1081,1260,1158,1133,647,76,1439,141,377,183;23;M
96723;157,1198,142,866,288,1246,1133,530;31;M
96725;209,504,288,76,188,473,1211,1246,1201,1171,647,944,454;39;F
96728;1419,843,1171,1023,492,647,1570,1158,864,35,156,1017,473,1081,663;35;F
96764;209,75,35,1081,866,530,1541,252,288,202,76,1439,647,1570,103;26;F
96779;252,647;28;M
96796;288,35,473,530,992,1419,1171,1570,156,252,311,141,142;35;F
96807;1300,252,1246,1419,1570,1133,377,866,157,1104,1171,156;38;F
96880;152,663,530,1104,468,1211,188,1107,1171,647,141,473,142,156;42;F
96906;1207,1374,1300,81,75,1258,209,252,1246,1419,1133,103,1260,377,530;25;F
96919;1374,289,81,290,252,1099,35,377,1246,1023,663;34;F
96930;81,83,1300,1374,252,76,1246,479,1171,1158,103,1260,530,1133,75;23;F
97002;1246,944,288,202,1737,1228,1736,454,992;27;F
97004;647,1419,1374,76,1246,141,103;52;F
97012;1211,1246,35;39;M
97028;81,1228,1207,311,479,293,1201,1017,1081;47;M
97033;156,252,288,1211,1439,1419,1171,1201,647,1740,103,152,377,1157,454;26;M
97061;1004,103,473,377,1166,530,81,944,1107,1439,1419,1133,156,454,142;36;F
97085;292,663,1017,76,289,294,290,35;60;F
97091;103,1133,1740,647,141,1099,1201,479,1107,1246,202,1374,504,1104,35;59;F
97109;1198,209,1736,157,468,252,1211,1171,1734,1099,647,1570,103,35,663;36;F
97111;1374,76,1439,75,81,1300,1099,141,647,1133,103,473,1166,142,530;35;M
97136;1201,454,1419;43;M
97175;157,188,1246,293,479,843,647,1004,152,156,1017,377,473,663,530;36;F
97207;663,1570,1099,288,1198,1158,294,290,76,311,293,1419,1201,454,866;57;M
97208;76,1246,311,492,141,647,1570,1133;41;F
97228;663,473,1017,103,647,1570,252,1228,292,156,35,773,492,944,1211;5;F
97257;252,1246,1419,1158,103,663,866;33;M
97276;639,1419,1171,647,530,1258,1374,1246,141,1133;43;F
97291;1246,377;63;M
97294;1171,1023,1099,141,647,1570,1133,1158,103,35,1014,1017,473,663,292;44;F
97307;1138,252,1570,35,1017,292,864,289,454;46;F
97310;530,35,1570,1158,639,1374,1246,1419,843,1171,992,647,252,1099,1133;25;F
97316;1738;26;F
97336;290,1570,1201;54;F
97349;468,81,141,1198,1258,252,288,202,992,311,647,1017,866,530,1541;57;F
97350;188,1419,1201,773,492,1570,1004,864,152,1166,142,530,1541,775,647;53;M
97359;188,639,1133,103,864,454,1099,647,1570,156,1017,473,663,1166,866;36;F
97368;1198,81,504,1138,468,775,944,1107,1201,773,492,864,454,866,1541;36;F
97373;1246,639,1439,843,1171,1201,141,1133,1014,152,377,1157,663,292,454;34;M
97389;188,157,775,944,1439,1419,1171,992,1734,141,1133,103,156,473,1157;33;F
97406;468,288,202,1738,1107,639,1419,1171,647,864,530,35,663,866,292;49;F
97409;454,663,292,289,209,76,103,35,530,473,293,141,647,377,142;43;F
97410;292,1166,1228,252,288,944,1570,156,377,454;41;F
97417;103,1104,1228,1258,1374,252,202,1738,1246,1419,647,1133,1158,454,663;54;F
97423;773,1023,1171,843,1419,293,1738,76,202,1207,288,468,1228,289,157;32;F
97455;202,773,1099,141,1570,1158,103,156,183,1157,473,663,1166,142,530;51;F
97534;639,311,1419,1260,866,142,183,377,647,141,1246,288,1228,209,530;22;F
97536;1166,103,647,1171,1419,1107,1246,1211,1374,1258,1133,454;28;M
97541;530,141,1201,311,290,639,1004,504,288,1246,454,1419,1171,1740,1133;51;F
97570;183,663,142,75,81,252,288,1246,1419,647,1570,1133,1158,454,530;24;F
97591;775,1246,639,252,1374,202,1419,1171,1158,103,864,454,1157,292,530;44;F
97597;843,75,76,311,1439,1171,773,141,1570,1133,1158,35,1014,1157,530;30;M
97601;103,530,1014,1198,1228,252,311,639,1439,1419,1171,1201,647,141,1133;27;F
97612;81,157,289,775,252,1211,202,1246,293,1023,1099,647,1570,156,473;33;F
97614;76,188,311,1419,1171,1201,492,103,156,454,530;34;F
97652;209;40;F
97655;504,1014,454,1258,944,152,156;57;F
97660;639,1171,311,1158,1014,1166,1258,288,1246,1439,1419,141,152,142,530;38;M
97674;1171,1201,141,1158,1014,377,1157,454,1166,142,530,76,311,992,1133;40;F
97675;1738;54;M
97710;1211,1171,141,647,1133,864,156,377,1166,142,530;43;M
97713;864,377,1157,530,81,252,1246,639,1171,141,647,454,663,866,292;42;F
97738;209,1419,1171,141,1740,1133,1158,103,1014,156,377,473,1157,663,142;38;F
97749;290,1738,252,76,1419,773,141,647,1133,1158,1017,663,1081,142,530;25;M
97770;1198,944,202,843,1023,1099,35,454,663,1081,103;32;F
97776;311,1419,1201,647,1570,103,35,1017,473,1157,454,663,142,292,530;45;F
97797;290,209,775,1737,202,76,1171,1201,773,492,35,1014,156,454,663;64;F
97826;773,1740,1157,454,1081,35,103,209;41;F
97850;530,142,152,141,1419,1439,1246,288,1258,1166,1014,1158,311,1171,639;9;M
97861;1014,1260,377,142,530,1133,83,1211,1207,311,479,293,473,288,209;42;M
97864;81,454,1246,288,141,142,530;73;M
97876;530,454,103,1158,647,479,76,202,290,1374,1207,1246,639,1133,1419;23;F
97877;1300;48;F
97882;288,775,468,75,530,1133,81,504,1374,202,76,188,639,1201,1740;55;F
97937;76,81,290,1246,1201,141,1133,1158,103,1014,454,530;46;F
97948;35,1014,1374,202,76,1246,1171,1099,1133,530,311,1201,141,1158,142;32;F
97981;1300,288,639,1171,141,103,75,252,1246,479,1419,1099,647,1133,1017;31;M
97986;156,103,492,1198,1138,1201,454,473,35;46;M
98023;311,152,1258,288,1246,639,1419,1171,141,1133,1158,1014,1166,142,530;6;F
98041;1198,504,252,1211,944,76,188,639,1419,1171,141,1570,35,156,293;37;F
98056;209;38;M
98084;1158,1133,1166,1157;56;M
98106;1374,1419,843,992,530,142,1014,1736,1258,1246,1570,1133,103;30;F
98116;141,156,1166,142,530;37;M
98127;663,1157,473,1017,35,103,1004,1570,647,1099,773,775,468,290,209;45;F
98147;311,1198,1138,1439,1201,454;49;M
98196;1258,288,530;25;F
98199;156,377,1419,1171,866,530,1258,944,1201,492,141,454,142;65;M
98218;1198,1258,81,504,1138,252,944,202,1107,1201,773,492,1260,454,866;35;F
98225;473,1133,288,1198,504,1138,944,1201,492,1004,1014,152,454,866,530;38;F
98241;377,663,1166,1419,843,1099,1158,454,292,76,639,293,1201,1570,1740;70;F
98288;83,1300,252,188,479,293,1171,492,647,1570,1158,156,1017,663,473;40;F
98292;76,639,1171,992,103,377,142;44;F
98300;1300,1419,530,209,468,944,188,311,773,492,1570,156;33;F
98303;1198,75,1736,1258,81,252,83,1228,1300,468,288,202,1133,103,530;9;M
98338;252,76,1419,992,141,647,1158,530;40;F
98353;1133,142,292,530;40;M
98355;290,76,992,103,473,1157,454;38;F
98363;1004,1081,866,1198,530,252,1374,76,311,1246,141,647,1133,103,377;32;F
98387;1246,944,468,504,290,252,202,188,639,1171,1099,1004,103,156,292;48;F
98399;473,142;43;F
98401;1246,1439,647,1158,1014,377,142,866,530,1737,252,1374,202,1419,1133;30;F
98404;35;39;M
98416;377;82;M
98431;156,1166,142,530,473,1133,1570,1171,1246,76,1211,209,252,1419,454;67;F
98439;1246,293,479,1107,311,1738,202,288,468,290,289,473,866,141;39;F
98512;1419,183,1171,1004,156,1738,188,311,141,1158,377,1157,1166,142,530;32;F
98518;1738;44;M
98526;944,1570;5;F
98551;202,504,288,1211,1171,1201,773,492,647,103,152,156,473,1157,454;36;F
98560;479,1171,647,1014,1198,81,288,252,293,1201,1017,473,454,142,530;47;M
98561;294,1258,1198,75,1736,289,81,1138,252,202,76,311,1023,454,663;32;F
98566;1158,202,468,1104,252,1738,639,1439,141,647,1570,473,142,292,530;48;F
98567;1017,377,183,473,1157,454,663,1081,1166,142,866,292,1541,530;40;M
98595;504,1198,1374,76,1246,479,1419,1201,647,1133,1004,454,142,866,530;30;F
98615;1738;19;M
98621;944,1570;2;M
98672;1738;16;M
98678;504,1138,468,152,530,1541,81,202,639,1171,1201,647,1570,103,454;25;F
98691;1258,1736,1207,1246,311,1419,141,647,454,530;35;M
98693;293,647,1158,103,473,1166,142,530,209,76,1246,1419,992,1133,454;72;F
98703;293,473,142,141,944,843,311,1133,1258,1014,1260,1300,76,103,75;42;M
98715;35,103,1133,252,479,1099,647;47;F
98730;142,377,103,141,1300,1158,1104,209,1258;45;M
98757;775,76,311,1419,492,1099,1133,1004,103,1014,156,377,183,1157,454;24;F
98758;775,288,773,647,156,473,1157,188;28;M
98790;1133,504,35,1211,311,293,1201,492,141,1004,103,1017,454,142,530;4;F
98798;1570,944;39;M
98852;1198,81,252,1107,293,1740,1004,103,864,156,454,1258,1419,1201,647;31;F
98856;1300,157,1201,492,1570,473,1157,454,1738,293,1419,156,1017,377,530;40;F
98899;76,530,1166,1133,1138,1211,944,188,311,293,1201,492,1570,473,454;29;F
98970;293,1171,1201,103,1017,473,454,530,1014,944,311,1439,1133,377,183;13;F
99012;252,1198,75,1736,1258,81,83,1228,1300,468,288,202,1133,103,530;5;M
99022;288,1737,1228,639,1419,843,1171,1099,141,1004,35,663,142,292,530;55;F
99027;76,311,293,1419,1201,773,1133,473;12;M
99038;1738,639,1419,1099,141,1158,530,1246,1171,103,1133;28;F
99041;202,647,103,473,866,530;25;F
99084;157,775,288,1246,1439,1419,773,647,1133,156,183,454,1166,530,1541;30;F
99093;647,1158,1166,530,290,252,1374,76,639,1570,103;47;F
99101;639,1171,1138,252,1198,202,76,293,1158,1133,103,473,454;38;F
99172;311,1246,288,663,454,103,1158,647,1201,252,479,1133,141,1017,530;33;F
99185;290,504,1138,775,252,944,188,479,293,1570,1081,530,473,152,1017;43;F
99193;75,142,1166,1570,35,663,530,1374,639,479,1419,1171,141;29;F
99260;252,1246,1158,530;38;F
99291;209,1374,311,647,1133,1158,103,1104,252,76,1246,1439,141,377,142;13;M
99299;1166,1570,141,1099,252,1104,1258,288,76,1246,311,479,293,773,530;12;M
99308;290,252,76,311,1419,141,647,1133,1017,142,530;37;F
99371;157,1104,76,639,479,293,1171,492,1570,1133,1158,156,454,866,530;5;M
99392;288,252,1246,311,1017,81,1201,647,473,1171,1107,1104,492,157,156;41;M
99442;311,1201,141,454,530;35;M
99451;377,473,292,1541,157,288,311,1171,992,1570,1158,454,1081,142,530;43;F
99480;1104,288,202,1246,1419,1439,1158,1133,377,473,311,141,1014,142,530;48;M
99503;454,663,1081,1166,292,530,1541,1228,288,311,647,1570,1133,1158,103;54;F
99508;1198,81,1138,1570,202,1201,647,103,454,142,530;52;M
99517;1201,141,647,1133,1017,663,142,292,530,290,293,1171,103,35,473;39;F
99519;1171;43;F
99569;1736,157,1104,76,1107,479,293,1171,141,1570,1158,1133,152,156,530;9;F
99588;290,83,639,1171,773,141,468,647,473,454;40;F
99613;252,1201,311,530,1419,1133,76,141,647,1158,454,142;38;M
99614;479,647,377,1541;24;M
99621;202,76,311,992,1734,1099,647,1158,377,1157,454,663;31;F
99634;252,76,1738,639,1171,1570,1133,103,864,1081,1166,530;37;F
99643;252,293,141,647,1158,103,1014,1260,156,1017,377,473,142,1166,530;39;M
99658;454,252,1207,1201,141,103,1014,142,530;38;M
99662;202,188,1439,1023,1099,647,1570,1133,103,35,1017,473,663,292,1541;42;F
99690;1211,188,1738,1201,1158,103,473,1157,454,663,1081,530,152,377,183;48;F
99739;252,1207,1133;32;M
99814;473,156,157,81,1104,1107,492,1171,1201,647,1017,1246,311,252,288;6;M
99831;289,1211,293,1570,35,473,663,1541;36;F
99885;252,75,83,76,311,1439,1419,141,1133,1158,1014,1260,156,377,183;54;M
99916;76,1104,504,1419,1201,103,1157,454,530,75,1439,311,141,1014,142;21;F
99932;289,252,288,1570,530,76,647,1158,35,663,292;46;F
99944;1211,1207,639,479,293,843,1171,1023,141,35,1017,473,663,1166,292;39;F
99950;1133,1158,1004,1014,1166,142,866,83,1171,103,1260,1157,454,530,1541;39;M
100021;1104,290,289,252,1023,141,1570,1004,156,1017,473,454,663,142,530;40;F
100070;202,76,492,1099,141,1133,1004,103,864,1260,156,454,1166,142,866;41;F
100110;1133,1158,1004,1014,152,1017,663,866,530,1258,290,504,468,843,492;40;F
100149;103,377,1158,1258,288,1211,944,76,293,1171,992,1133,35,473,1166;33;F
100184;209,35,1570,1081,866,1419,252,647,1207;35;M
100213;252,944,188,1738,311,293,1419,492,1570,1158,103,864,156,473,454;1;M
100218;1017,103,141,1023,293,188,1207,944,1211,1138,1300,1228,83,157,75;7;F
100311;1158,1439,1171,1201,1014,454,1081,142,1246,141,647,103,1017,1166,530;40;F
100321;1374,202,1738,1246,293,1201,1734,1099,1570,156,1017,1166,142,866,530;62;F
100351;202,1198,288,76,311,639,1419,1171,1201,1740,1158,473,454,142,530;34;F
100366;1104,76,1158,1260;25;M
100386;76,141,1133,1014,1260,377,530;25;M
100402;103,1099,1201,1023,293,188,1207,944,1211,1300,1228,83,290,1258,75;4;F
100421;1228,252,1374,311,293,1439,1099,1133,1004,103,473,866;39;M
100465;468,1211,76,188,1738,1246,1107,479,647,1133,103,1014,156,473,454;34;F
100484;992,492,647,1133,103,663,292,290,288,944,76,293,1419,1158,473;76;F
100491;663,1157,1570,492,773,76,288,1736,157,1374,202,639,1171,1099,292;48;F
100498;479,639,1246,252,1419,1133,1017,377,663,530,1541;28;F
100525;1201,1158,142,530,76,1198,81,1228,504,1138,141,1133,454,288,252;32;F
100588;252,1211,944,1207,202,188,293,843,1171,992,492,1099,647,1570,156;33;F
100592;292,142,454,1260,647,1099,202,1374,1138,468,288,1246,1171,992,530;43;F
100671;1017,647,1570,773,492,1198,81,504,1138,1107,1201,454,530,866,1541;48;F
100702;1570,1740,1004,103,1258,1228,504,1138,1737,288,202,1107,639,1171,1734;25;F
100737;1133;37;F
100769;1246,188,1374,1104,1228,209,75,252,76,311,1419,647,454;36;M
100815;288,468,290,81,157,252,1374,639,1171,1099,103,35,1014,454,530;41;F
100852;1198,311,1439,1419,1171,647,1133,864,1014,454,663;30;M
100854;1158,1166,142,866,141,647,530,76,252,1198,81,479,1201,1133,454;28;F
100873;1419,1158,1138,252,1201,647,103,377,142,530,454;42;M
100886;202,1246,1419,1158,473,530;38;F
100890;1300,1207,1133,1158,1166,1258,293,843,647,142,209,252,1246,141,530;35;M
100913;1198,843,473,1081,1166,142,292,1541;43;F
100916;1738;24;M
100939;1258,288,1374,188,1246,1133;36;F
100985;1138,468,252,944,1246,1107,639,1171,1734,492,1570,103,377,1157,1541;37;F
100991;202,1023,1570,647,1740,1133,1158,35,1157,663,1081,866,292,530,1541;56;M
101049;76,141,454,142,530,209;36;M
101055;1138,288,1374,76,293,1419,479,1439,1201,1570,103,35,156,454,530;25;F
101109;639,103,81,1258,1736,252,1246,1439,1419,1171,647,1133,1158,377,530;28;F
101130;311,1198,76,1201,1133,454,142;55;F
101159;209,1107,252,1419,647,141,473,142,530,1104;40;F
101164;1171,1014,1107,454,288,252,1374,647,1157,142,866;39;M
101190;290,1138,468,202,1107,479,293,1171,1201,1023,1099,35,1017,454,663;32;F
101205;290,252,479,1419,141,647,1133,1158,103,35,1014,377,454,142,530;26;F
101214;1570,1099,1201,1023,1738,1138,1300,1198,103,209,252,76;39;F
101218;188;38;M
101256;866,252,944,76,1419,103,1166,311;31;M
101279;209,81,294,1736,1198,504,252,1211,188,293,492,647,1570,454,663;36;F
101285;288,1171,1133,1166,479,1439,1419,647,377,183,142,530;26;F
101305;209,1107,1201,647,454,1166,1541;11;M
101309;1198,1133,141,1201,1439,76,1211,83,75,1246,103,1017,473,454,292;32;F
101313;202,1419,1171,992,473,142;43;F
101320;1014,1166,142,530,81,252,288,76,639,1439,1419,1171,1133,103,377;39;F
101328;1133,473,454,1107,311,1738,188,288,1736,1198,252,1541,81,141,530;48;M
101420;141,1158,864,35,1014,1260,152,156,377,473,663,292,1246,103,454;35;M
101442;1736,1211,1570,1004,1017,663;27;F
101446;157,252,76,1246,311,1201,141,647,1133,103,473,454,530;34;M
101452;1246,157,1198,775,288,1201,1133,1158,864,1014,454,1081,1166,866,1541;36;M
101464;288,76,1171,1099,647,1570,1133,103,35,473;26;F
101472;1246,141,454,530;35;M
101481;647,377,252,183,202;20;F
101501;75,81,83,252,76,103;37;M
101520;1258,252,639,1171,292,530;56;F
101524;81;24;F
101584;1171,1166,1246,639,1439,1419,992,103,156,454;42;M
101588;83,1738,293,1099,647,1133,103,152,156,1017,473,454,663,1166,866;68;F
101628;76,141,1017,530;31;M
101658;1198,1171,647,1158,103,1260,454,142,81,252,76,141,1133,183,530;29;F
101681;81,252,76,647,1570,1133,454,1166;33;F
101694;156,1017,473,1081,1166,530,290,209,468,1158,1133,35,663;49;M
101703;75,1737,252,1374,202,76,1738,1246,1419,1201,141,1570,103,1017,454;28;F
101736;157,288,1374,1211,1246,103,1014,1157,83,1171,141,142,530;29;M
101793;1419,141,1260,183,473,142,1541,1166,252,311,647,1133,103,377,530;36;M
101828;454,1133,1738,944,83,1736,75,252,76,1246,103,530;25;F
101861;76,647,1133,142,1260,454,530,1198,288;45;M
101936;1439,1419,141,1158,1014,142,75,83,1300,76,1246,1133,103,1260,530;26;M
101995;468,1201,252,76,1738,1246,311,639,1419,1171,647,1133,1158,454,866;42;F
102005;1570,1099,1419,1246,1198,1201,530,454,141,288,252,775,1171,647,1014;27;M
102011;1260,183,1104,252,1246,1419,1439,1201,141,1133,530,292,142,454,377;44;F
102052;294,1736,157,75,289,290,1228,202,76,647,35,1260,156,1017,663;43;F
102061;252,288,202,311,1439,1099,647,1133,103,35,663,1081,866,292,530;51;F
102076;1211,288,468,157,1198,81,252,1419,773,141,1570,1133,1158,103,864;38;F
102092;1198,1736,1374,1738,1107,1171,1201,141,103,1017,454,1081,530,252,76;31;M
102108;1419,1570,35,454,1166,1198,157,252,1171,1201,141,647,1133,103,142;41;M
102120;252,1246,479,1419,1171,141,647,1570,1133,1158,1004,864,1017,377,473;30;F
102125;290,252,1374,202,639,479,1419,843,647,1570,1133,663,1081,1166,866;31;F
102132;454,866,142,1166,1201,311,288,252,530,76,1246,1158,103,1419,141;71;M
102161;1300,1017,1081,1541,1211,1201,1734,103,1260,473,1157,454,1166;45;M
102207;202,293,35,156,1133,1104,1211,1419,1171,1099,647,1570,1017,473,1166;41;F
102228;289,1004,504,103,866,1246,992,1198,454,1201,1570,1158,377,142,530;69;F
102247;1258,209,83,1104,76,1246,311,1419,141,1133,1158,1014,142,530,1541;37;F
102265;639,1207,504,209,294,252,1171,530;36;F
102289;288,76,311,1419,103,1260,377,183,1166,142,866,1439,141,647,530;27;M
102292;1138,1211,188,639,1419,1171,1201,492,647,1570,156,473,454,663,530;33;F
102296;1133,142,75,1258,1104,76,311,1439,1419,141,1014,1260,377,183,530;44;M
102316;1004,864,473,454,1300,468,252,288,1211,1738,311,1419,1570,1158,103;40;M
102317;468,1419,492,1158,1260,156,377,1439,1201,141,1133,183,454,142,530;43;M
102336;944,1228,293,1201,1099,103,156,1017,473,454,1133,1246,1419,1171,1158;31;F
102355;288,1201,647,454;36;M
102367;288,290,294,1736,289,1374,843,1023,1099,141,1017,1157,663,142,292;43;F
102372;1228,252,288,1201,647,1570,1133,103,1166,866,292,530;34;M
102382;75,141,1014,1017,142;48;M
102398;1017,103,1099,76,252,1207,479;29;M
102420;1570;7;M
102451;1198,81,288,1211,479,1439,1419,141,1017,473,454,142;68;M
102452;252,288,1246,311,639,1439,1419,1023,647,1133,1158,454,663,142,292;32;F
102459;468,252,76,1738,1246,311,639,1419,1171,647,1133,1158,663,866;42;M
102467;289,290,252,76,311,479,1419,141,1158,35,1014,1017,663,142,530;33;F
102488;1570;36;F
102497;639,1171,773,647,1004,103,1157,1374,252;34;F
102560;468,252,76,1738,1246,311,639,1419,1171,1201,647,1133,1158,454,866;10;F
102580;252,76,1246,311,647,530,142,1166,377,1014,1158,1133,141,1419,1439;36;F
102647;75,81,76,311,1419,647,454,252,1201,141,103,1014,142,530;44;F
102658;530,1736,289,290,209,1228,504,311,639,1419,1171,1133,1158,35,103;34;F
102738;1171,1570,103,1081,1258,1439,1419,141,647,1158,1133,1014,1166,142,530;20;M
102770;188,311,1171,647,252,1211,202,1570,1133,156,473,1166,530;29;F
102772;1207,311,1419,647,454,663,1541;33;M
102799;1228,1246,311,1201,1734,1099,647,1570,1133,103,1260,454,663,1166,866;32;F
102801;290,252,288,1211,202,188,479,492,647,663,454,473,156,103,1570;34;F
102811;294,1737,288,311,1004,35,663,1541,843;63;M
102873;1171,1419,1228,209,75,1211,188,311,293,1439,492,1570,1004,156,473;42;F
102886;141,1198,1157,866,530,252,1133,1158,156,152,504,81,1107,1201,454;67;M
102905;252,1246,311,639,1419,1171,1201,1133,103,35,1017,377;26;M
102919;76,311,1419,1171,35,1017,473,1166,142,1541,1023,1099,141,1133,530;43;F
102942;209;42;F
102950;157,1171,1133,473,454,1081;34;F
102979;252,479,647,103,35,473,663,292,1023,1017;22;F
103016;252,1738,1246,1171,647,1570,1133,103,864,156,183,1157,663,1166,866;30;F
103017;1300,290,1258,1736,1198,76,1023,1017,473,1166,292,252,202,992,647;35;F
103022;1207,1570,663,530,75,83,1300,76,1246,843,141,647,1133,1014,1541;44;F
103034;288,1258,1228,252,944,1419,1171,647,1740,1133,1158,1004,103,156,1157;28;F
103074;209,81,289,1258,1736,157,1198,290,647,1570,103,1017,377,454,1081;25;F
103121;293,639,1738,188,202,252,1300,290,75,1211,1014,152,473,530;33;F
103124;1736,293,1171,141,103,156,1017,530,1157,1740,639,647,1570,1158,454;30;F
103135;454,866,1228,83,75,1570,1158,1014,142,530,1258,288,311,1439,647;35;F
103171;473,479,1419,1023,141,35,1017,142,530,663,1158,1133,647,1246,1099;48;F
103173;1171,141,183,377,454,530;44;M
103189;992,1198,1228,775,1374,1738,1171,1201,1099,1740,1133,1158,1004,1017,1157;34;F
103232;311,1439,647,1166,1246,1419,479,377,473,1258,1228,76,1133,103,35;42;M
103288;1099,1570,103,35,1017,1374,76,311,479,1439,1419,1201,647,1133,530;24;F
103291;1198,1439,1419,1023,1201,311,76,1374,1734,647,1570,1740,663,1081,866;25;F
103297;289,209,1374,1207,647,1157,292,1099,473;46;M
103317;141,1246,1198,290,1138,76,1201,1158,454,1166;71;F
103318;1374,157,1258,1228,288,1211,76,1246,1419,1171,1201,1158,1260,473,530;28;M
103398;76,1738,479,864,530,639,293,1171,1570,1133,1158,35,1017,473,663;52;F
103438;377,183;54;F
103490;252,288,1570,1133,1158,663,1081,142,866,292,1541;56;F
103501;1138,202,252,288,76,1246,311,1439,1201,141,647,1133,454,1166,866;40;F
103538;1198,504,1138,311,1107,639,843,1171,1201,1099,1133,103,864,454,866;38;F
103540;468,504,1104,294,289,1258,288,1374,311,639,141,647,152,473,663;47;F
103563;1198,647,530,83,944,202,76,293,1570,1133,473,252,454,75,103;38;F
103621;1439,377,142;37;M
103626;1138,288,944,866,454,1133,647,1201,1246,252,1258,1198,141,142,530;36;F
103641;530,142,252,1374,76,1258,1246,479,1439,1419,141,1133,1158,103,377;35;F
103700;775,252,293,1419,1439,647,103,1260,473;44;M
103710;992,773,492,1570,1740,1133,1017,530,468,83,252,1099,647,1158,103;43;F
103753;504,202,188,1738,1246,1439,1419,1099,1133,1158,1004,864,152,156,530;36;M
103754;289,1023,1099,1133,35,663,1081,292;50;F
103771;202,1738,1570,1158,864,1157,663,1374,1246,639,479,1171,992,647,1133;23;F
103779;76,479,1419,141,647,1133,1158,103,35,1014,156,1017,663,1166,530;29;F
103791;292,35,843,1374,1736,209,1211,76,188,639,1570,1158,1099,647,1133;44;F
103813;75,1211,1260,156,473,454,1081,1541,141,142,530;47;M
103815;75,81,83,252,76,103;44;F
103828;773,288,504,157,209;41;M
103829;1198,81,647,1260,1246,1419,1133,1158;16;M
103837;377,183;53;M
103857;1228,504,188,1439,1171,1570,156,530,209,252,76,639,1419,1133,1158;31;F
103865;775,76,479,1439,1419,1740,1133,103,35,1017,1157,473,142,530,1541;67;M
103870;252,202,76,479,141,1017,473,454,142,530;43;F
103892;1207,479,103,454,83,1300,1246,1260,75,530;39;M
103913;1133;35;M
103915;1201,1734,647,1570,1133,103,1166,288,311,1419,1171,141,377,142,530;41;F
103942;1207,1374,252,209,492,141,1133,103,647;27;M
103958;775,75,83,1300,288,76,311,1439,1419,1171,141,647,1158,103,1541;44;F
103968;1198,479,639,1246,1738,252,775,81,76,293,1201,1014,103,473,454;35;M
103970;1198,1258,1211,293,1201,492,141,647,1570,103,1014,1017,473,454,530;33;F
103976;81,252,288,202,1419,647,1570,1133,103,35,377,142,530;32;F
104000;1246,944,1228,1138,288,1374,1171,1099,1133,377,473,454,142,292,530;38;F
104086;864,1419,202,1158,35,663,142,252,288,1374,1099,141,1133,1081,530;33;F
104095;83;46;F
104152;1099,864,156,1157,1166,1541,1198,1439,1419,992,1734,647,1133,1158,530;37;M
104200;103,1260,183,377,1157,530,944,468,1300,75,288,1099,647,1570,156;35;F
104225;81,1138,252,202,76,479,1201,141,1133,473,142,530;6;F
104254;1081,1541,454,293,773,183,1171,1023,1201,492,647,1570,864,1017,292;59;F
104259;639,311,1198,468,288,76,1246,293,1133,1158,103,156,454,142,530;29;F
104282;157,1104,1107,530,1171,156;73;M
104292;663,473,152,647,141,639,311,1374,288,1258,289,294,1104,504,468;48;M
104313;1737,1258,288,944,1207,1246,1107,1419,141,1133,1158,1260,454,530;58;F
104318;1211,479,293,647,1133,103,377,1017;36;F
104341;639,288,289,663,473,152,647,141,311,1374,1258,294,1104,504,468;19;M
104354;1171,1099,1419,142,377,1258,81,479,1201,141,288,1158,1017,454,530;37;M
104374;289,775,1023;37;F
104377;209;39;M
104504;1736,157,1104,1107,1171,156,530;73;F
104520;1736,1738,188,202,252,468,209,1166;41;F
104548;1258,1198,289,81,290,1138,775,288,76,1107,1201,647,1570,454,1081;40;F
104554;75,1374;46;F
104575;1541,1081,1004,1201,1211,76,1107,293,1171,773,1099,647,103,1017,473;29;M
104579;81,202,76,1201,141,454,142,530;12;M
104603;454,1133,1201,1419,1171,293,311,1738,76,1207,252,81,1198,157,209;51;F
104609;81,1246,311,1570,1158,142,252,1419,647,1133;26;F
104621;290,252,992,492,647,1158,1133,103,864,35,156,473,454,663;28;F
104628;1171,1246,293,473;35;M
104638;76,1439,1419,1171,152,183,1166,530,1104,252,141,1133,1004,377,142;39;F
104642;1374,202,639,1171,1133,1158,1157;20;F
104661;504,639,454,1201,35,1570,1740,1004,866,1374,1439,377,183;52;F
104664;454,530,1541,1570,1419,1133,647,311,252,141,142,76,1246,1158,377;34;F
104666;1104,252,1207,773,141,647,1133,103,152,377,473,1157,1166,142,530;16;F
104671;479,293,992,773,647,1570,1158,103,864,35,156,473,454,530,1541;41;F
104678;1023,1201,1099,647,1570,35,156,1017,377,454,663,1081,1166,292,530;36;F
104695;530;34;M
104697;83,1570,35,1419,843,647,1014;41;M
104710;289,290,843,1133,103,663,141,142,530;35;F
104727;377;74;F
104734;1260,142,292,75,83,76,1246,1171,647,1133,103,1014,454,866,530;39;F
104735;647,1133;45;F
104772;141,1017,454,142,530;52;M
104807;663,473,152,141,647,639,311,1374,288,1258,289,294,1104,504,468;14;M
104836;252,1246,639,647,1133,103,377,473,1081,1166,530;48;F
104906;1419,1246,1133,252;25;M
104925;288,1738,1246,479,1419,1133,1158,1017,377,530,252;25;F
104962;311,639,1023,1099,141,1570,103,35,156,1017,663,288,647,142,530;36;F
104981;1736,1198,252,76,1246,479,1419,1099,1133,292,1201,773,492,1570,647;51;F
104988;202,1228,294,289,663;60;F
105011;289,1099,647,35,663,292;50;F
105065;35,290,209,252,992,492,156,454,292;74;F
105076;81,1138,252,202,76,479,1201,141,473,454,142,530;43;M
105100;252,1198,289,1138,468,1211,944,188,492,1099,1570,156,473,454,663;3;F
105109;468,1419,1439,1171,141,1133,35,156,183,473,663,530;10;F
105110;1246,1171,1736,1374,202,1439,1419,1099,1133,377;49;F
105124;252,1374,1246,311,647,1133,1158,864,1541;33;F
105152;1133,473,188,492,468,252,288,1211,944,311,1439,1419,647,156,377;35;F
105209;944,775,1138,1104,1258,188,1246,1171,1201,647,103,156,377,454,866;38;M
105211;202,1107,1171,992,1158,156,377,1166,530,1258,1439,1419,1133,473,142;43;F
105294;288,83,75,289,290,209,76,1439,1419,647,1133,1158,103,1014,377;57;F
105334;530,141,1099,1439,1374,1104,775,288,1246,311,479,1419,1158,377,142;23;M
105363;647;58;M
105375;775,252,1246,639,293,1419,843,1171,1099,1133,35,1017,1157,663,1166;20;F
105394;454;13;F
105398;252,1211,1207,76,311,479,1133,1158,103,1260,1017,473,454,1166;34;M
105431;289,202,1107,843,141,647,1740,1133,864,454,663,142;50;F
105508;1207,76,1023,647,103,1166,866;33;M
105559;75,290,83,288,76,311,479,141,1004,1014,377,530;30;F
105579;377,183,1541;48;F
105651;142,1258,1198,81,1138,252,76,1246,311,1419,492,141,1158,454,530;45;M
105652;103,1419,479,311,1246,76,1207,1737,1228,1198,81,288,647,454,1166;43;M
105678;1258,83,1201,141,492,1158,1133,103,1014,377,866,454,1419,1570,1260;39;M
105686;1439,1419,1133,1158,377,141,142,530;39;F
105687;209;9;F
105729;1260,773,1138,1157,1099,292,1246,103,866,1133,1107,1228,1104,1439,647;51;F
105761;1171,1734,492,647,1158,1133,864,35,152,156,1017,473,663,1166,292;59;F
105783;1570;44;F
105798;1171,647,1570,103,35,152,377,1081,866,530,157,293,156,1017,473;29;F
105847;209,252,76,311,1419,1439,141,647,1570,1133,1158,530;24;M
105862;1198,75,81,83,252,76,1246,1133,103,663,292,1541;52;F
105883;294,289,290,1228,479,1201,647,103,35,1017,454,663,142,292,530;59;F
105892;1258,75,1737,252,288,76,202,1246,311,1419,1133,1158,103,156,530;32;F
105905;157,1104,468,944,76,1738,639,1734,647,1099,1133,1158,377,156,1166;11;F
105969;866,663,1419,492,1158,454,468,864;76;F
105993;252,76,311,1419,1133,377,454;32;M
106006;1570;87;M
106078;468,1211,293,1419,1570,1133,35,156,473;38;F
106085;530,647,141,992,1419,1439,293,479,1107,311,1246,1738,76,1207,288;42;M
106154;1004,1099,773,843,293,468,1258,290,1171,1023,1570,156,473,454,663;48;F
106162;473,1171,1133,1158,1157,1166;61;M
106198;292,1228,1138,647,866,1023,773,1099,1104,1738,775,1107,1439,1419,1157;56;M
106207;202,1201,141,1014,454;39;F
106227;1158,75,252,1246,141,1133,103,1260,530,142,663;43;F
106315;1300,252,1374,639,1171,141,1570,454,866,377;53;M
106353;504,1107,1201,454,1133,311,1246;27;F
106377;468,504,1300,157,1228,1737,188,1738,1246,479,1419,1201,1133,1017,377;26;F
106397;81,202,1201,141,1014,454,530;43;M
106403;1004,288,1737,76,1099,1133,35,292,530,289,290,202,1740,1017,1158;55;F
106427;294,290,1228,252,1374,311,647,1570,35,1017,377,454;73;F
106475;81,202,1201,1014,454,530;11;M
106486;252,209,288,1211,944,202,76,1246,311,1419,141,1158,1133,473,530;33;F
106522;377,183,1541;47;F
106525;290,1138,647,1740,864,35,1017,663,292,1166,866,252,1201,1133,454;68;F
106527;288,639,479,1419,1171,156,1017,473,454,663,35,141,377,1246,142;31;M
106541;76,1107,1419,1171,1201,141,1133,1158,1004,103,1157,454,1166,142,530;42;F
106543;81,202,1201,141,1014,454,530;8;F
106562;76,1419,1201,647,1158,103;34;F
106650;1570,773,1258,290,1104,468,1737,252,202,76,1099,141,1133,530,1157;42;F
106652;81,252,1201,141,473,454;39;M
106662;1419,1158,1258,775,311,141,1133,103,1014,1157;19;M
106714;288,293,1201,1158,1133,1439,75,157,76,1419,141,1014,1081,1541,311;29;M
106722;35,1260,156,1166,866,1258,290,1211,76,1246,992,1099,103,473,454;36;F
106727;75,288,311,1570,1740,1133,103,35,292,530,775,1737,1439,773,647;28;F
106728;289,202,479,1099,1133,1740,103,864,35,1014,1017,663,1081,292,530;47;F
106750;1211,1374,288,156,152,377,473,454,866,292,530,294,1228,944,252;62;F
106764;252,76,1246,311,479,293,1419,1201,141,1133,103,142,530;32;M
106797;188,639,1419,1734,647,1158,1014,1017,473,1228,1246,152,1157,1166,1133;28;F
106845;1258,1300,1737,1374,1246,1439,1171,202,479,1419,141,1133,1158,142,530;42;F
106862;157,294,843,1099,289,252,76,1023,647,1570,35,1017,663,292,530;70;F
106869;843,377,454,1541,1004,1158,647,992,1107,188,1737,157,252,1211,202;30;M
106873;1166,1133,647,141,1099,479,504,75,252,311,103,1260,377,183,142;38;M
106885;1570,492,1201,479,1246,202,288,252,468,1138,504,141,1014,454,530;43;F
106899;76,1258,1246,1541;39;F
106944;1300,288,76,1439,1158,1014,377,1166,142,530,311,1419,141,103,1260;28;M
106958;1201,1099,1570,1133,1158,103,35,152,156,1017,473,454,663,1081,292;43;F
107011;1198,294,1228,504,202,76,639,1201,1734,1570,1004,1017,1157,454,530;41;F
107019;288,1246,1201,141,454,530;41;M
107034;1258,1198,157,209,504,1419,1171,1201,992,492,1570,156,473,1157,454;35;M
107111;1104,1737,288,377,142,530;69;F
107126;252;29;F
107127;141,1014,454,866,142,183,377,1260,103,1439,293,1246,76,75,530;37;F
107175;1419,1171,992,1099,647,1570,1133,1158,35,1017,1157,1081,1166,142,530;35;F
107199;1374,377,183;39;F
107216;76,1419,311,141,142,530;32;M
107236;294,775,1737,504,76,1738,1570,1133,1228,1246,639,1171,647,1740,1157;24;F
107238;35,454,209,479,103;31;F
107271;639,468,1228,1258,1736,1198,504,944,1738,1171,1570,156,454,663,1081;5;F
107297;141,1133,103,35,1014,1017,377,473,1157,292,663,1439,1419,530,142;31;F
107298;1198,288,1099,1166,663,866,530,183,103,81,311,1107,1171,1201,454;19;F
107309;288,252,1198,81,76,293,1171,1201,492,141,103,473,454,142,530;1;M
107329;1104,1258,1736,157,530,1166,252,288,76,311,1439,773,1014,377,1541;35;M
107373;1374,468,75,290,944,202,1246,1171,1734,1099,1133,103,864,473,663;36;F
107380;1166,1133,1201,1023,479,1374,202,76,1246,311,639,1439,1419,141,647;33;F
107391;252,944,202,1201,1133,454;39;F
107395;639,1439,992,1740,103,1014,152,377,454,142,530,288,76,311,1133;40;F
107398;1211,76,1738,1246,1419,773,647,1133,1017,473,663,209;35;F
107400;252,288,1211,76,188,311,293,1419,1171,647,1570,1133,1158,156,473;35;F
107411;209,183,1133,1158,1258,479,103,76,1439,141,1419,647,530,142,311;27;M
107448;76,944,1211,288,252,290,1419,492,647,1133,156,1017,473,530,1541;35;F
107461;1107,639,1171,1023,1201,992,492,141,1570,35,156,473,454,252,647;30;F
107499;141,75,81,288,1201,454,530;26;F
107505;1246,188,1258,504,468,288,944,1738,1107,639,1171,1201,1734,1570,1740;3;F
107522;35,1014,152,663,504,202,311,639,1439,1171,141,1004,377,142,530;29;F
107526;1166,504,1138,288,1738,639,1171,1133,1004,103,1260,183,142,530,1541;25;F
107548;76,479,473;59;M
107572;183,377,141,76,1439,1260,1166,142,530;42;M
107606;76,1439,141,1133,1014,454,142,530;20;M
107609;1198,76,1738,1246,454,1374,202,293,647,103,473,209,1211,1419,1133;35;F
107669;1258,288,209,290,843,1201,141,647,1570,1740,1133,1158,35,142,530;76;M
107690;289,290,209,1228,252,288,1374,76,311,843,141,663,142,866,530;53;F
107729;1166,252,311,647,1260,530,188;46;M
107744;1171,252,288,1133,1246,647,1201,1260,156,454,530;43;M
107753;81,468,288,1211,944,293,1171,1201,492,103,864,1014,473,454,530;4;M
107779;288,468,1104,289,1258,504,944,188,639,1171,1201,1734,1570,156,454;34;M
107815;293,1419,773,492,141,647,1570,473,454,1166,530,157,252,76,156;36;F
107841;1246,1017,454,663;57;F
107848;288,944,1246,639,479,1171,141,35,156,1017,377,473,454,663,142;31;F
107892;1570;5;M
107893;1374,1104,1736,290,1228,639,1439,1171,1099,647,156,1166;42;F
107935;1171,843,639,1207,1374,775,504,294,1258,1736,157,663,156,866,292;45;M
107951;75,76,1246,479,1439,1419,141,1133,103,377,473,454,663,142,530;37;F
107954;1211,311,1099,1014,157,1171,1104,293,1133,1158,1201,141,473,454,530;59;F
107977;479,864,35,156,1017,473,663,252,1211,293,1419;32;F
108001;504,1107,183,473,663,292,1541,944,288,294,1246,639,1171,1201,647;31;F
108004;289,775,1737,202,1439,1171,1023,1201,1099,647,1570,103,35,663;31;F
108019;1258,209,288,944,311,293,1171,156,468,252,76,1419,1570,1133,1081;26;F
108093;1246,1158,1133,1419,76,647,188;40;F
108147;1107,141,1258,81,1211,1246,1439,1419,1201,1133,1014,473,454,142,530;47;M
108212;157,209,468,775,252,1211,479,293,1419,1171,647,473,454,663,1166;34;F
108217;473,142,377,1260,1158,1133,290,1104,252,1207,639,293,141,647,1570;35;F
108231;75;44;F
108232;1374,188,639,1171,1201,1157;44;F
108243;1736,142,1017,156,1014,1570,209;10;F
108257;1258,252,1374,76,1246,1419,1171,1734,1133,156,1017,473,454,663,530;36;F
108293;1171,152,156,473,1541,289,311,454,504,647,775,1570,1099,202,188;24;F
108324;454,663,142,292,1570,81,141,1099,1017,1166,76,202,1201,647,530;26;F
108327;1419,1201,1258,1228,1738,1246,992,1734,647,377,473,454,1570,1740;51;F
108339;83,288,311,1439,1004,152,1258,76,1738,1246,454,1201,1419,1133,1158;5;F
108342;103,1014,1419,1439,252,76;33;F
108369;288,252,1211,944,76,188,1246,311,647,1158,103;33;M
108373;209,35,156;38;F
108386;1171,1133,156,454;37;F
108411;76,944,504,290,311,1419,1171,1157,454,142,530;39;F
108440;76,311,1166,142,866,530;51;F
108447;530,473,156,103,1570,1734,1201,1171,293,311,1246,188,1207,944,1211;38;F
108485;1166,944,479,1439,1419,141,647,1133,1158,103,1014,1260,377,142,530;33;M
108517;1246,468,530,157,504,1138,252,293,1201,492,103,152,473,454;40;F
108546;252,1374,1246,1419,1171,1099,647,103,156,663,1166,530;23;F
108555;209,1138,1201;36;F
108592;479,1246,944,252,75,81,1300,288,1211,76,293,1439,647,103,473;29;F
108625;76,1138,294,81,1228,1107,1439,1171,1099,141,103,473,1157,454,142;37;F
108658;1258,83,1300,775,1211,1738,639,1171,1133,1158,530,75;9;M
108664;1246,479,293,1171,141,1133,1158,103,1166,142,530;39;M
108719;252,1246,1201,1158,35,530;45;F
108737;75,83,311,1439,152,288,1258,76,1738,1246,1419,1201,1133,1158,454;33;M
108747;1207,1107,647,1133,377,1157,454;25;F
108752;1014,473,292,83,775,1023,1017,663,530,1300,76,141,103,142,75;45;F
108830;377,183;29;F
108865;454,473,1260,864,647,1734,1201,1246,468,504,209,294,1258;72;F
108949;76,1133,142,530,1258,1207,141,454,1014;44;M
108963;142,473,1158,1133,1570,492,773,1171,1419,1246,188,252,775,1104,1211;40;M
108969;1419,1004,1260,377,1201,1570,1133,1158,454,142,1171,141,311,1014,530;39;F
108992;289,1138;39;F
109004;1133,141,492,773,1734,1419,188,944,75,1260,1228,252,1211,1004,1017;42;F
109032;1211,202,188,293,843,1201,992,1099,1570,103,35,473,454,1081,663;34;F
109039;530;44;M
109052;1258,504,1246,311,1439,1419,1171,773,141,647,1133,1158,1014,1260,530;20;F
109073;1104,252,288,311,639,1171,647,1570,103,35,156,1017,473,1157,454;37;F
109117;35,156,473,454;36;F
109148;141,1570,1133,1004,152,473,454,142,866,530,1104,1107,1171,157,156;41;F
109195;1198,1258,1734,1171,1740,293,1439,1419,1201,1133,1158,1014,1260,377,454;36;F
109210;1419,454,530,1198,1138,1211,76,1246,639,1171,647,1133,1158,1004,103;35;M
109222;377,183;46;M
109230;1374,76,311,1439,1419,1171,1099,141,1133,1014,377,473,454,142,530;39;F
109252;1570,1133,1014,156,1017,377,473,142,530,1258,252,1211,76,293,1419;29;M
109291;775,1023,103,663,866,454,1260,1570;55;F
109297;81,775,288,252,76,188,311,293,1419,647,1570,1133,1158,103,156;33;M
109304;1004,294,1737,1228,290,252,288,1374,76,1201,1014,454,142,292,866;52;M
109309;1258,81,1211,1246,293,1419,1201,141,647,1133,103,473,454,142,530;35;M
109315;1374,1207,76,639,1171,1201,1099,647,1570,152,1157,454,663,292,1541;46;F
109334;864,473,530,1138,76,639,1133,663,1166,252,1419,1171,1201,492,454;31;F
109362;75,209,252,288,76,311,479,1439,1419,141,1133,1158,1014,473,530;11;M
109387;81,1107,1171,156,866;73;F
109409;103,156,183,1258,252,288,944,1246,1201,1133,1158,377,454,866,530;36;F
109411;944,188,639,1171,773,492,152,156,473;37;F
109413;1300,1228,1736,1133,1260,292,530,252,311,1419,141,647,142;45;M
109422;1201,141,1740,1133,1014,152,156,1017,473,1081,142,866,292,530,1541;43;M
109432;288,103,156,473,454,663,209;45;M
109450;1258,252,288,202,76,1246,1419,1133,1158;49;F
109522;377;36;M
109528;1736,252,76,454,1258,1201,141,647,1133,1158,103,864,1014,473,530;46;F
109596;252,141,1133,103,142,530;41;M
109655;252,141,293,1211,639,1017,202,1439,1419,1171,647,1570,152,473,663;35;F
109722;773,1541,202,76,188,1738,639,1419,473;41;F
109736;468,944,1246,479,293,1419,492,1570,1133,103,864,35,156,473,454;35;F
109748;530,142,1258,1207,76,141,1133,1014,454;41;F
109823;1198,944,1419,1171,1201,141,1740,1133,103,1260,1157,454,142,866,530;39;M
109835;1738;21;M
109836;1419,1023,647,1570,1133,103,35,152,156,1017,473,1157,454,663,1541;27;F
109860;647,76,1133,454,141,530,1198,1138,1201;32;M
109869;35,1017,377,183,142,292,530,1258,1228,1107,1201,992,141,473,454;40;F
109872;183,377,288,1246,1419,1201,141,1133,1158,103,1260,454,1166,142,530;38;M
109878;1260,294,1104,1737,1374,188,1246,639,1439,141,1570,35,377,142,1541;70;F
109897;156,292,252,1246,1419,1171,1004,183,202,1107,141,377,454,1081,530;43;F
109911;1133,1246,35,1017,479;65;M
109922;1570,1740,1133,103,864,35,530,1166,866,454,1104,1107,1171,157,156;73;F
109932;866,1570,1171,1419,1439,639,1246,202,468,81,1198,76,1099,1157,1541;43;F
109965;944,1738,1246,492,141,1133,1158,103,864,152,156,183,473,1157,142;35;M
109982;157,81,1104,1107,1201,454;44;F
110025;209;46;M
110036;1138,81,639,647,1570,1166,76,504,1198,188,1171,1133,1158,473,454;42;F
110050;1246,1738,188,468,290,81,1374,1211,1171,1133,1158,473,1157,454,1166;41;M
110069;75,252,141,103,142;46;M
110094;141;48;M
110134;1246,293,1419,1570,377,473,663,292,252,1201,103,454,142,866,530;40;F
110137;1104,1737,288,1246,843,1171,141,156,142,530;61;F
110165;1198,1104,775,1207,1246,479,1201,1017,473,454,141,647,1570,1228,1107;60;F
110227;252,1419,141,1133,142,530;35;F
110288;530,454,35,468,1211,188,1734,773,492,1570,103,156,473,663,142;34;F
110297;1419,647,1133,252,1541;38;F
110326;1207,76,1246,1419,141,1014,183,454,142,252,1133,1158,103,377,530;40;F
110329;311,76,202,289,290,1246,479,1439,647,1158,103,209,377,1133,1419;26;F
110347;252,1738,1246,1734,492,1099,141,1570,142,866,1104,1107,1171,157,156;73;M
110374;1258,75,1300,1104,288,1211,202,311,1439,141,103,473,663,142,530;34;F
110394;377,142,530;38;M
110396;1246,647,1133,377,288,1158,530,252,141,103,83,76,142;48;M
110426;1138,468,1211,944,188,639,293,479,843,1201,1099,156,1017,454,663;42;F
110427;103,76,1374,1138,209,530,473,1017,1133,1570,647,293,479,311,252;14;M
110433;639,209,468,252,1211,188,311,1419,1171,492,647,1570,152,156,473;38;F
110448;468,76,1419,293,473,530,1201,1138,252,639,1171,492,1133,454,1166;35;M
110452;289,1258,1736,157,1198,1228,775,288,1246,141,647,1570,1133,142,530;30;M
110466;75,1738,156,454,663,1081,290,468,76,1099,1570,1133,103,530,1260;50;F
110493;1198,81,76,1246,311,639,1171,1201,1133,1158,35,473,454,1166,530;38;F
110602;1541,1157,647,773,639,1246,293,1171,156,377;45;F
110603;288,1374,944,76,188,141,1133,103,1014,156,377,1157,663,142,530;36;F
110608;647,1171,479,639,188,76,288,83,75,252,1541;34;F
110630;76,311,1439,1419,141,1570,1133,1158,377,647,103,454,1081,142,530;43;F
110655;141,142,530;31;M
110670;81,252,1246,311,293,1419,647,1158,103,142,530,1258,1439;39;F
110691;1258,142,1014,141,530,289,504,202,75,288,76,1419,1133,311;33;M
110753;188,1419,1171,1734,1158,156,1157;21;F
110771;1246,944,202,1207,252,468,504,1258,81,142,1104,1107,157,1171,156;12;F
110782;288,1201;39;F
110838;288,1246,1017,530,866,1133,252,1419;26;M
110855;141;47;F
110894;1198,157,1211,639,1171,1201,1133,1004,473,454,530,663;40;F
110903;252,288,1738,1107,1737,1246,1740,530;58;F
110916;1246,1439,454,377,103,1133,1158,1419,293,76,944,252,83,1258,530;41;M
111017;647,1419,1374;30;F
111020;75,81,83,252,76,103;28;M
111030;1246,639,1201,141,35,1211,1107,1004,1171,1157,530,188,156,1017,473;40;M
111033;252,1246,1107,141,103,377;36;F
111051;141,1133,142,530;64;F
111093;293,1570,1133,35,473,454;38;M
111101;1107,1419,1201,454,530,1198,76,1258,1246;34;M
111138;252,76,311,639,866,290,202,479,1023,647,1570,103,663,142,530;32;F
111171;377,1211,1081,775,157,473,35,293,141,81,864,530,311,773,1201;46;M
111208;468,504,1736,1258,1300,1740,1133,1158,454,142,1171,1104,157,1107,156;6;F
111214;647,1133,864,663,530,1734,1171,639,1246,202,1374,288,1737,81,1258;28;F
111224;81,1300,1211,944,202,639,479,647,1158,103,473,663,290,1570,293;29;F
111232;202,1171,141,663,142,530,1198,252,76,843,1201,1099,647,1133,454;27;F
111255;454,81,1374,1107,1419,1734,773,1099,647,1004,1260,1541,1166,866,1198;36;M
111314;188,202,468,1258,76,1246,1419,1171,141,1133,377,473,454,142,530;37;M
111317;1201,288,1439,1419,1171,141,1158,377,142;33;M
111334;209,188,81,944,1171,142,1260,311,1158,1201,76,454,1246,1419,1133;39;M
111353;252,288,76,866,1133,377,473,142;47;F
111382;209,1211,1207,76,141,1004,35,473,142,530;35;M
111402;1246,647,663,157,209,1737,288,202,188,492,1099,864,156,454,1166;44;F
111413;1211,288,209;70;F
111420;209;44;M
111444;252,1737,288,1738,1246,1107,1740,530;59;M
111452;188,1201,1734,473,454,1211,944,1171,492,156;35;M
111506;1736,1198,81,468,288,1211,188,1246,293,492,141,156,454,142,1541;36;F
111520;1017,663,530,504,1171,152,156,1246,1133,1258,944,202,76,188;30;F
111547;1198,202,1246,639,1201,454;38;F
111551;209,1211,76,1246,293,1099,141,473,530;32;M
111563;288,1198,81,76,479,1374,141,530,1258,1419,1171,1133,1166,1158,1157;22;M
111584;468,944,202,639,1023,492,1099,647,1570,152,156,377,663;30;F
111640;157,468,1211,188,639,1171,1734,773,492,1570,103,156,454,142,530;36;M
111644;843,1099,103,35,1017,663,866,252,639,1419,1171,1201,647,1570,864;29;F
111708;83,479,293,492,141,1570,1133,103,1014,156,473,454,142,530,289;35;F
111731;1133,866,1570,647,252,1171,1246,183,944,1439,76,1419;34;F
111766;252,188,479,1439,1419,1171,492,1099,647,1570,103,156,473,454,1081;36;F
111777;141,647,152,156,142,292,530,1541,1211,944,479,293,1201,103,473;45;M
111786;252,1211,944,188,479,1014,492,141,647,103,156,377,1166,142,530;35;F
111789;1419,1439,479,311,1246,1374,141,1133;25;M
111820;1258,290,294,1228,504,1737,252,1246,639,1171,1734,1133,1004,156,292;30;F
111838;1171,1570,663,288,76,311,1439,992,141,142,530;64;M
111841;647,157,209,1138,252,288,1374,293,479,1570,35,1017,473,663,866;42;M
111852;639,1171,1023,492,1570,35,1017,454,663,530;39;F
111868;252,1211,202,76,188,293,1201,141,35,156,473,454,530;33;F
111886;1228,1258,252,288,202,1246,1419,1133,1158,1166,1541;36;F
111978;1138,252,944,1211,188,76,492,141,1570,1133,103,864,156,473,454;38;M
111985;81,311,1133,1158,1004,142,1099,1171,1439,639,1246,76,288,141,530;35;F
111996;290,76,157,289,1138,468,252,1734,492,647,1570,454,663,209;38;F
111999;775,468,1138,504,294,289,157,1228,1211,647,1570,1004,103,473,663;33;F
112005;866,1738,76,1207,1258,75,288,252,1246,639,1740,141,1133,103,142;40;M
112011;1570,843,639,468,504,81,1198,157,289,944,188,1107,1201,492,156;39;F
112017;1107,773,492,775,454,468,1201;45;M
112022;1419,1201,663,866,1541,864,1246,1138,1736,1107,1171,1104,141,156,454;42;F
112030;141,311,202,944,252,1198,76,1201,1099,647,1570,1133,103,454,530;31;F
112100;311,647,1133,1260,292;39;M
112122;1201,492,188,1419,1133,1246,252,288,311,1158,864,152,454,142,530;35;M
112124;1300,252,103,530,76;34;M
112127;290,252,479,293,1023,1734,647,866,1166,663,473,183,377,156,35;40;M
112140;1166,1198,81,209,76,1246,311,1107,1171,1201,1133,1158,473,454,530;8;F
112149;103,1133,311,141,530;23;M
112200;530;43;F
112234;1211,288,1138,1228,157,294,504,252,492,647,1570,1014,156,377,1157;34;F
112242;252,293,647,103,473,1157,663,1166,530,773,1171,775,1570,1133,944;31;F
112258;1258,209;40;M
112265;209,504,992,647,103,473,292,530;44;F
112274;1258,1107,1419,647,1736,1246,141,1133,377,530;15;F
112305;209;11;M
112309;1738,1228,866,663,473,1017,35,1570,293,479,1374,288,252,209,1736;41;F
112352;290,288,1211,202,1246,1439,1419,1099,647,1133,454,142,866,530;29;F
112362;866,377,1017,103,1004,1133,647,311,252,290,1374,202,1419,1171,1099;32;F
112375;209;8;M
112416;1133,141,142,530;53;M
112425;1104,468,202,1738,639,1419,1171,1099,647,1570,1158,103,1157,663,1166;25;F
112435;75,83,252,288,76,1246,1439,1419,1171,1133,103,530;4;F
112541;1198,252,1246,1419,141,1133,1017,377;28;M
112547;647,76,75,1158,377,142,1260,1133,141,1419,1246,288,252,1258,530;22;F
112615;1419,288,294,468,1246,1439,1171,103,377,473;43;F
112617;76,1211,188,311,639,1439,1023,773,1099,141,1004,1014,156,663,142;43;F
112622;1246,639,1570,864,1017,377,75,1300,252,202,311,103,1157,83,1014;39;M
112635;252,775,1138,1736,293,647,1570,35,377,473,454,209,76,290;42;M
112652;377,183;;M
112656;1246,1104,202,1107,293,479,843,141,1017,377,183,473,454,663,530;74;M
112697;157,775,252,944,76,479,1419,773,647,1740,1133,103,473,1157,1541;27;M
112714;188;40;F
112716;209,202,1738,843,1570,1004,35,1017,473,663,292,1099,1419,1158,76;42;F
112744;81,1246,1107,1133,1419,377;28;F
112800;1246,1014,103,76,1138,1198,81,1211,311,1158,473,454,663,142,530;27;M
112823;209;18;M
112838;1740,1738,530,152,1133,141,1439,1258,1246,864,1157,1099,156,504,288;18;F
112871;1419,311,775,209,293,1171,773,1158;42;M
112884;1171,1104,647,1211,293,1734,492,35,1014,473,454,292,944,1107,1201;40;M
112885;775,639,141,1570,1081,142,292,530,188,75,103,35,1017,1157,663;50;F
112905;76,866,530,1158,142,252,141,647;47;M
112909;530,1260,1246,1211,504,1228,209,1198,1107,1419,454,1133,1201;44;M
112938;468,1107,1201,773,492,454;4;F
112966;152,1017,377,866,294,1211,1246,663,156,639,944,288,504,1439,1419;37;F
112981;81,252,288,1246,311,1439,1419,1201,647,1133,1158,1004,1014,454,530;33;F
113023;1570;38;F
113030;1158,864,468,252,1374,639,479,293,1171,492,1570,1133,156,1017,473;27;F
113141;864,1171,1107,157,156,1104;41;M
113185;530,156,293,944,290,292,663,1099,639,188,289,209,1171,35;41;F
113214;1014,1260,663,75,83,1300,1211,944,202,76,843,1171,103,1017;38;F
113221;290,1201,1004,35,454,866;35;F
113231;479,1198,1099,288,1419,1260,1158,377;26;M
113239;1258,1374,1246;37;F
113241;157,76,1133,864,1014,1157,530,311,1419,1171,1201,1158,377,473,454;35;M
113248;377,866,103,1158,1740,647,492,1419,639,202,209,1258,504,252,1201;35;F
113260;647,992,1260,1166,81,1107,1201,454,1246,1133,183,1158,1258,1419,377;22;F
113265;504,1138,468,202,1246,1171,1023,1201,1734,773,647,1740,152,454,1541;13;F
113347;292,293,479,1107,504,1198,289,81,209,103,156,1017,454,530,1541;8;F
113435;209;12;F
113452;141,647,473,292,1439,639,188,944,1158,142,530,992,202,76,1570;41;F
113506;252,1736,289,294,290,1228,202,76,479,1740,103,35,1017,292,530;60;F
113527;454,1014,1258,1207,76,293,479,1419,141,647,1133,1158,103,473,530;15;M
113547;252,141,377;38;M
113551;468,647,141,103,1258,81,1211,944,202,479,293,1201,1158,473,454;47;M
113559;75,1258,83,866,1138,1260,1419;34;M
113581;1017,156,1158,1133,647,141,188,289,157,81,504,1171,1201,1570,454;41;F
113604;142,530,1081,663,377,479,639,1246,202,252,141;34;F
113609;492,1201,944;42;M
113619;468,1104,209,1198,81,1138,76,311,1419,1133,1158,103,864,1260,473;45;M
113632;252,141,479,1419,1017,530,1736;27;M
113641;1004;33;M
113647;1207,183,530,866,294,1228,288,202,76,1099,1570,1158,103,1260,377;34;F
113652;866,1198,75,294,290,504,468,202,311,1171,1158,103,663,530,35;66;F
113685;530;27;M
113694;75,1258,83,76,103,530,1246,647,252,1439,1419,141,377,183,142;37;M
113769;202,1107,1570,103,1081,1166,1541,1198,1138,252,647,1133,183,454;18;F
113820;1198,1258,252,288,202,76,311,1107,639,647,1570,1133,377,183,1166;51;F
113847;454;29;M
113876;202,288,209,252,76,1246,1419,141,647,1158,103,377,454,142,530;55;M
113942;1133,1158,1004,1541,647,479,639,76,1736,252,1737,202,1260,1017,663;61;F
113967;504,1014,209,288,1211,944,188,293,1201,1260,152,473,454,866;46;F
114005;209;40;F
114017;288,76,639,1171,647,103,864,1014,530;34;F
114034;75,1171,1734,1099,1004,1014,1017,473,1157,454;21;F
114041;252,1374;27;F
114059;1138,468,75,1736,293,1171,492,141,1570,103,1014,152,473,454;51;F
114088;289,209,202;42;F
114160;1541,1258,1104,1246,1158,1133,1419,1014,866,288,76,639,1171,773,1099;43;M
114186;141,647,454,288,866,76,1246,311,293,1171,1201,473,1157,530,663;47;F
114202;1157,1300,468,1737,76,639,1158,152,1171,530,75,103,141,142,1133;28;F
114267;311,1419,188;37;M
114281;35,1133,141,1258,81,290,1211,202,479,1201,647,1158,103,473,454;7;M
114282;141,252,1374,76,1246,647,1740,1133,103,454,142,866;42;F
114299;81,1300,1107,1201,454;65;M
114321;81,1198,454;61;F
114327;1207,252,1138,1104,75,83,1300,1374,1171,647,103,1014,1017,454;46;F
114384;288,202,1171,156,1133,1419,1570,1158,76,252,311,141,647,103,530;25;F
114394;75,1004,1439,1419,141,1158,1133,288,311,1171,1201,1014,454,142,530;19;F
114400;1133;40;F
114476;1104,76,1439,1419,1260,377;42;M
114493;252,1374,1099,647,1570,1004,103,35,152,156,1017,663,1081,1166,142;35;F
114507;1166,103,1158,1133,1439,76,252,209,311;36;M
114556;1107,188,1104,75,1300,468,252,1374,311,1246,293,1171,141,647,530;32;F
114557;290,504,468,775,1171,1023,773,492,141,864,35,152,473,454,292;10;M
114559;293,1258,81,290,1207,202,479,1201,141,647,1158,103,473,454,530;2;M
114566;944,639,293,1133,1570,1158,1201,992,492,141,864,288,252,530;31;F
114651;1734,1570,1740,1228,1736,202,1201,252,1738,1419,1158,864,454,663,530;38;F
114661;293,647,1158,1166,530,252,944,311,1419,1570,103,156,1017,473,454;30;F
114679;1300,1138,293,1419,492,1201,647,1133,473,454,75,1211,843,1014;48;F
114686;1104,209;45;F
114692;1133,530;41;M
114699;1198,75,83,1300,252,293,1201,647,1570,103,1017,473,454,142,530;48;F
114700;141,142,530,209;42;M
114723;1198,504,468,1211,944,188,1246,311,293,1201,492,1570,156,473,454;4;F
114745;1158,1133,647,1419,639;27;F
114768;290,76,293,141,103,473,142,530;54;F
114780;1374,1081,866,1541,76,775,504,81,288,1201,1740,454;43;M
114818;290,504,468,775,1171,1023,773,492,141,864,35,152,473,454,292;8;M
114887;1258,1300,1736,252,1246,103,866,1133,202,288;41;F
114971;866,157,1198,1258,81,1737,252,202,1738,1419,843,156,454,1166,1541;20;F
114976;81,252,1374,202,76,311,1419,647,1570,1133,1158,35;29;F
114982;81,294,157,1201,76,311,1439,1014,141,103,35,473,454,292,530;45;M
114991;1737,1734,1740;40;F
115010;311,202,1737,504,294,1228,288,76,1246,647,1133,103,377,183,530;38;F
115033;288,1228,1300,294,1258,252,1211,202,1738,141,647,1133,1158,473,530;33;F
115044;1198,1228,1104,775,1207,1246,479,1107,1201,141,1570,647,1017,473,454;61;M
115125;492,156,663,252,289,944,76,639,1171,1201,1099,1017,473,454,530;32;F
115138;1374,141,1014,142,866,530;31;M
115139;156,473,288,1246,311,639,1201,1734,492,141,647,103,454,142,530;41;M
115170;76,75,81,83,103;56;M
115171;1158,1133;21;M
115190;103,1014,142,530,141,1099,1171,1419,479,76,1207,288,468,1736,75;28;M
115194;639,1171,492,1004,864,1157,530,81,76,311,1099,103,1017,156,1133;16;F
115195;76,288,504,1300,75,1258,81,141,1133,1014,1017,473,454,530;41;F
115211;76,479,293,141,647,1004,35,1198,209,311,1419,473,663,292,530;38;M
115215;1138,1104,290,81,294,289,1198,1736,252,202,1246,1419,647,1133,209;41;F
115223;468,1246,1171,647,1081,1211,288,1198,1300,252,1740,156,473,454,530;47;M
115228;1246,311,141,1171,1258,1228,1419,1201,1133,1158,377,183,473,454,530;25;F
115230;1133,647,492,293,1246,76,288,504,209;42;F
115319;76,288,289,1737,775,1300,1258,157,75,83,252,1439,1133,1014,1541;47;F
115349;1133,647,141,773,1211,1138,290,1258,288,944,311,1419,1201,992,1734;39;M
115422;1198,1158,1133,647,141,1201,1171,1419,1439,639,1374,1300,1258,209;13;F
115423;75,81,83,76,1201,647,103,35,454,530;51;F
115426;288,1737,775,504,1104,1258,141,1158,75,83,1246,1419,1133,1014,530;19;F
115470;1099,141,647,1133,103,156,292,530,866,142,1081,663,454,473,1017;37;F
115477;775,188,492,141,647,1570,1133,103,864,156,183,1157,1166,142,530;38;F
115492;157,775,252,1738,1246,1419,1171,647,1740,1133,1158,103,1157;28;M
115510;311,141,1133,1158,142,530;36;M
115589;1017,530,647,1014,1207,76,141,103,142;39;M
115593;293,479,639,311,468,75,157,83,252,1171,141,1014,473,142,530;43;M
115599;188;4;M
115613;775,252,76,1738,1107,1004,1014,152,156,1157,663,1081,1166,142,530;39;M
115628;1246,1419,141,103,454,252;33;M
115635;1738,288,209;9;M
115701;479,293,1171,1201,647,1133,377,454,530,473;36;F
115722;311,1171,1158,1014,142,81,76,1419,1099,141,1570,1133,1017,454,530;26;F
115750;775,103,183;50;F
115759;1439,1171,1014,1201,141,1740,1158,252,76,311,1419,773,454,142,530;33;M
115793;188;2;F
115864;76,202,1211,252,209,188,1246,1107,1099,1133,156,473,454,663;39;F
115894;1158,1246,1133;33;M
115902;843,992,1740,1017,1736,252,1374,202,647,1570,1158,103,866,1081,1541;30;F
116061;377,1541;35;F
116124;1740,1737,1017,1107,866,775,1198,504,454,292,290,76;76;M
116125;1740,1737,1017,1107,866,775,1198,504,454,292,290,76;78;F
116126;1737,1734,1198,1228,639,504,183,1260,76,288;75;F
116128;1138,1246,294,663,290,252,1133,76,35;71;F
116129;1740,1734,1570,775,473,468,454,202,1246,157,1171,1133,1260,76,35;78;F
116130;1081,1017,1004,866,773,252,1158,1166,103,83,75,81,530,35,647;51;M
116131;1740,1734,1570,775,473,468,454,202,1246,157,1171,1133,1260,76,35;77;M
116133;1736,1570,1198,252,1158,1166,1133,76,103,83,75,81,1419,530,647;14;M
116134;1737,1570,1138,1081,1201,1228,504,454,289,202,1246,156,290,288,35;42;F
116135;1014,1104,142,1258,141,1158,311,76,103,75,1419,1439,530;13;M
116136;1740,866,1211,468,293,156,142,1157,141,1260;76;M
116137;1107;71;F
116138;1737,1017,992,1228,473,468,289,292,294,663,252,1171,1133,1260,35;69;F
116139;1014,1104,209,142,1258,141,1158,311,76,103,75,1419,1439,530;44;M
116140;377;83;F
116141;1570,479,293,183,157,156,141,1158,1171,1133,76,103,83,75,530;67;F
116142;1570,479,293,183,157,156,141,1158,1171,1133,76,103,83,75,530;70;M
116145;1570,1541,1201,209;72;M
116147;1570,1541,468,454,209,35;69;F
116154;1570,454,647;75;M
116158;1014,252,76,103,83,75,81,1439;73;M
116164;1014,252,76,103,83,75,81,1439;74;F
99999929482;35;47;F